/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JToolBar;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.ControllerEvent;
import oracle.dss.dataView.UIDataview;
import oracle.dss.dataView.gui.DataviewTool;
import oracle.dss.dataView.gui.ToolBar;
import oracle.dss.graph.UIGraphFontAttribute;
import oracle.dss.graph.gui.NewColorChoice;

public class FontColorTool
extends JToolBar
implements DataviewTool,
PropertyChangeListener {
    Object m_selectedObject;
    protected NewColorChoice m_fontColor = new NewColorChoice();
    private ResourceBundle rBundle;
    protected boolean m_enable = true;

    public FontColorTool() {
        Icon icon = this.m_fontColor.getColorIcon();
        this.m_fontColor.setIcon(icon);
        this.m_fontColor.setDisabledIcon(icon);
        ImageIcon imageIcon = this.makeImage("images/l_fontcolorwitharrow.gif");
        this.m_fontColor.setRolloverIcon(imageIcon);
        this.m_fontColor.setRolloverSelectedIcon(imageIcon);
        this.m_fontColor.setSelectedColor(new Color(153, 153, 153));
        this.m_fontColor.addPropertyChangeListener(this);
        this.m_fontColor.setEnabled(false);
        this.add((Component)((Object)this.m_fontColor));
        this.setBorder(null);
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.updateResourceBundle(locale);
        this.m_fontColor.setToolTipText(this.rBundle.getString("FontColor"));
    }

    public void selectedAction(ControllerEvent controllerEvent, UIDataview uIDataview, ToolBar toolBar) {
        Object object = null;
        boolean bl = false;
        if (controllerEvent == null) {
            return;
        }
        ComponentHandle componentHandle = controllerEvent.getComponentHandle();
        if (componentHandle == null) {
            this.m_selectedObject = null;
            this.setEnabled(false);
            return;
        }
        object = componentHandle.getComponent();
        if (object == null || object == this.m_selectedObject) {
            return;
        }
        this.m_enable = false;
        if (object instanceof UIGraphFontAttribute) {
            this.m_selectedObject = object;
            this.m_fontColor.setEnabled(true);
            Color color = ((UIGraphFontAttribute)this.m_selectedObject).getUIGraphFont().getGraphFontColor();
            this.m_fontColor.setSelectedColor(this.m_fontColor.getClosestColor(color));
            this.m_fontColor.updateIconColor();
        } else {
            this.m_fontColor.setEnabled(false);
            this.m_selectedObject = null;
        }
        this.m_enable = true;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent == null || !this.m_enable) {
            return;
        }
        if (!propertyChangeEvent.getSource().equals((Object)this.m_fontColor) || !propertyChangeEvent.getPropertyName().equals("selectedColor")) {
            return;
        }
        if (this.m_selectedObject == null) {
            return;
        }
        ((UIGraphFontAttribute)this.m_selectedObject).getUIGraphFont().setGraphFontColor(this.m_fontColor.getSelectedColor());
        this.m_fontColor.updateIconColor();
    }

    public void update() {
    }

    private ImageIcon makeImage(String string) {
        return new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.dataView.gui.ToolBar"), (String)string));
    }

    private void updateResourceBundle(Locale locale) {
        this.rBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", locale) : ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
    }

    public void cleanUp() {
        this.m_fontColor.removePropertyChangeListener(this);
        this.remove((Component)((Object)this.m_fontColor));
        this.m_fontColor._filter = null;
        this.m_fontColor = null;
        this.rBundle = null;
    }
}

