/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.graph.BaseMajorTick;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;

public class X1MajorTick
extends BaseMajorTick {
    public X1MajorTick(Graph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getX1MajorGrid();
        this.initDefaultValues();
    }

    private void initDefaultValues() {
        this.visible = GraphDefaultValues.isX1MajorTickVisible();
        this.lineColor = GraphDefaultValues.getX1MajorTickLineColor();
        this.lineWidth = GraphDefaultValues.getX1MajorTickLineWidth();
        this.lineStyle = GraphDefaultValues.getX1MajorTickLineStyle();
        this.tickStyle = GraphDefaultValues.getX1MajorTickStyle();
    }

    public boolean selectObject(int n, int n2) {
        this.m_pfj.setSelection(this.m_identObj);
        return this.m_identObj.equals(this.m_pfj.getSelectionID());
    }

    public int getTickStyle() {
        return this.m_pfj.getX1MajorGridStyle();
    }

    public void setTickStyle(int n) {
        if (n < 0 || n > 4) {
            this.m_graph.getErrorHandler().log("invalid style", "oracle.dss.graph.X1MajorTick", "setTickStyle(int style)");
        } else {
            this.m_pfj.setX1MajorGridStyle(n);
            this.setPropertyOverrideFlags(4);
        }
    }

    public boolean isVisible() {
        return this.m_pfj.getX1MajorGridDisplay();
    }

    public void setVisible(boolean bl) {
        this.m_pfj.setX1MajorGridDisplay(bl);
        this.setPropertyOverrideFlags(2);
    }

    protected String getComponentName() {
        return "X1MajorTick";
    }
}

