/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.dss.graph.Graph;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.CubeDataAccess;
import oracle.dss.util.CubeDataDirector;
import oracle.dss.util.DataAccessAdapter;
import oracle.dss.util.DataAvailableEvent;
import oracle.dss.util.DataChangedEvent;
import oracle.dss.util.DataDirectorException;
import oracle.dss.util.DataDirectorListener;
import oracle.dss.util.DataException;
import oracle.dss.util.DataMap;
import oracle.dss.util.DataSource;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerMetadataMap;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.MetadataMap;
import oracle.dss.util.QDR;
import oracle.dss.util.RelationalDataAccess;
import oracle.dss.util.RelationalDataDirector;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;

public class SampleDataSource
extends DataAccessAdapter
implements CubeDataDirector,
CubeDataAccess,
RelationalDataDirector,
RelationalDataAccess,
DataSource {
    protected double[][] defaultData1 = new double[][]{{42.0, 34.0}, {55.0, 30.0}, {36.0, 50.0}, {22.0, 46.0}, {25.0, 18.0}};
    protected double[][] highLowCloseData = new double[][]{{75.0, 45.0, 55.0, 80.0, 60.0, 68.0, 58.0, 38.0, 48.0, 65.0, 50.0, 55.0, 25.0, 10.0, 18.0}};
    protected double[][] highLowCloseVolumeData = new double[][]{{65.0, 45.0, 40.0, 15000.0, 70.0, 50.0, 53.0, 14000.0, 63.0, 35.0, 45.0, 13000.0, 75.0, 53.0, 60.0, 16000.0, 25.0, 10.0, 15.0, 17000.0}};
    protected double[][] openHiLoCloseData = new double[][]{{47.0, 65.0, 43.0, 51.0, 65.0, 80.0, 55.0, 60.0, 45.0, 45.0, 30.0, 34.0, 75.0, 77.0, 45.0, 71.0, 85.0, 85.0, 65.0, 76.0}};
    protected double[][] openHiLoCloseVolumeData = new double[][]{{37.0, 55.0, 33.0, 53.0, 13000.0, 55.0, 77.0, 45.0, 75.0, 14000.0, 25.0, 50.0, 23.0, 45.0, 15000.0, 65.0, 87.0, 55.0, 85.0, 11000.0, 45.0, 75.0, 43.0, 66.0, 10000.0}};
    protected double[][] openCloseData = new double[][]{{52.0, 70.0, 60.0, 80.0, 65.0, 85.0, 55.0, 70.0, 58.0, 70.0}};
    protected double[][] openCloseVolumeData = new double[][]{{32.0, 60.0, 13000.0, 40.0, 60.0, 11000.0, 45.0, 65.0, 14000.0, 35.0, 55.0, 15000.0, 38.0, 58.0, 9000.0}};
    protected double[][] bubbleData = new double[][]{{15.0, 25.0, 5.0, 25.0, 30.0, 12.0, 25.0, 45.0, 12.0}, {15.0, 15.0, 8.0, 20.0, 35.0, 14.0, 40.0, 55.0, 35.0}, {10.0, 10.0, 8.0, 18.0, 55.0, 10.0, 40.0, 50.0, 18.0}, {8.0, 20.0, 6.0, 11.0, 30.0, 8.0, 30.0, 40.0, 15.0}};
    protected double[][] scatterPolarData = new double[][]{{15.0, 15.0, 25.0, 43.0, 25.0, 25.0}, {25.0, 15.0, 55.0, 45.0, 57.0, 47.0}, {17.0, 36.0, 32.0, 52.0, 26.0, 28.0}, {38.0, 22.0, 43.0, 43.0, 58.0, 36.0}};
    protected double[][] paretoData = new double[][]{{55.0, 43.0, 32.0, 21.0, 9.0}};
    protected double[][] threedSurfaceData = new double[][]{{42.0, 50.0, 38.0, 46.0, 55.0, 35.0, 32.0, 45.0}, {26.0, 34.0, 22.0, 30.0, 38.0, 40.0, 25.0, 30.0}, {10.0, 18.0, 6.0, 14.0, 18.0, 9.0, 19.0, 20.0}};
    protected double[][] threedAreaRibbonData = new double[][]{{42.0, 50.0, 38.0, 46.0, 55.0, 40.0}, {26.0, 34.0, 22.0, 30.0, 40.0, 28.0}, {10.0, 18.0, 6.0, 14.0, 20.0, 13.0}};
    protected double[][] lineData = new double[][]{{74.0, 62.0, 70.0, 76.0, 66.0}, {50.0, 38.0, 46.0, 54.0, 42.0}, {34.0, 22.0, 30.0, 32.0, 26.0}, {18.0, 6.0, 14.0, 22.0, 10.0}, {3.0, 2.0, 3.0, 3.0, 2.0}};
    protected double[][] defaultData2 = new double[][]{{42.0, 50.0, 38.0, 46.0}, {26.0, 34.0, 22.0, 30.0}, {10.0, 18.0, 6.0, 14.0}};
    protected DataDirectorListener listener;
    protected int rowCount;
    protected int columnCount;
    protected int pageCount;
    protected int currentPage;
    private Object[][] cellData;
    protected String[] rowLabels;
    protected String[] columnLabels;
    protected String[] pageLabels;
    private Locale loc;
    protected ResourceBundle rBundle;
    protected ResourceBundle rBundle1;
    protected Graph m_graph;
    protected int m_graphType = -1;
    protected double[][] defaultDataCommon;
    protected String[] strGroupArray = new String[25];
    protected String[] strSeriesArray = new String[5];
    private String baseEdgeDim;
    private String baseDim;
    private String basePageMem;
    private String strPage;
    private boolean localeChanged;

    public SampleDataSource(Graph graph) {
        this.updateResourceBundle(graph.getLocale());
        this.m_graph = graph;
        this.strPage = this.rBundle1.getString("Page");
        this.baseEdgeDim = this.rBundle1.getString("LDSEdgeDim");
        this.baseDim = this.rBundle1.getString("LDSDim");
        this.basePageMem = this.rBundle1.getString("LDSPageMem");
        this.pageCount = 2;
        this.currentPage = 0;
        this.pageLabels = new String[this.pageCount];
        int n = 0;
        while (n < this.pageCount) {
            Integer n2 = new Integer(n + 1);
            this.pageLabels[n] = String.valueOf(this.strPage) + " " + n2.toString();
            ++n;
        }
        this.setSampleDataSource();
    }

    public void setLocale(Locale locale) {
        this.loc = locale;
        this.updateResourceBundle(locale);
        this.localeChanged = true;
        this.setSampleDataSource();
    }

    public Locale getLocale() {
        return this.loc;
    }

    protected void updateResourceBundle(Locale locale) {
        if (locale != null) {
            this.rBundle = ResourceBundle.getBundle("oracle.dss.graph.resource.GraphBundle", locale);
            this.rBundle1 = ResourceBundle.getBundle("oracle.dss.dataView.resource.DataviewBundle", locale);
        } else {
            this.rBundle = ResourceBundle.getBundle("oracle.dss.graph.resource.GraphBundle");
            this.rBundle1 = ResourceBundle.getBundle("oracle.dss.dataView.resource.DataviewBundle");
        }
    }

    public void populateCellData(int n, int n2, double[][] dArray) {
        this.cellData = new Object[n2][n];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                this.cellData[n3][n4] = new Double(dArray[n3][n4]);
                ++n4;
            }
            ++n3;
        }
    }

    protected void populateRowLabels(int n) {
        this.rowLabels = new String[n];
        int n2 = 0;
        while (n2 < n) {
            this.rowLabels[n2] = this.strSeriesArray[n2];
            ++n2;
        }
    }

    protected void populateColumnLabels(int n) {
        this.columnLabels = new String[n];
        int n2 = 0;
        while (n2 < n) {
            this.columnLabels[n2] = this.strGroupArray[n2];
            ++n2;
        }
    }

    public CubeDataDirector createCubeDataDirector() {
        return this;
    }

    public RelationalDataDirector createRelationalDataDirector() {
        return this;
    }

    public void addDataDirectorListener(DataDirectorListener dataDirectorListener) {
        this.listener = dataDirectorListener;
        this.listener.viewDataAvailable(new DataAvailableEvent(this, this));
    }

    public void removeDataDirectorListener(DataDirectorListener dataDirectorListener) {
        if (this.listener == dataDirectorListener) {
            this.listener = null;
        }
    }

    public boolean changeEdgeCurrentSlice(int n, int n2) throws DataDirectorException, SliceOutOfRangeException, EdgeOutOfRangeException {
        if (n2 == 1) {
            this.currentPage = 1;
            this.listener.viewDataChanged(new DataChangedEvent(this, this, true, true, true, true));
        } else if (n2 == 0) {
            this.currentPage = 0;
            this.listener.viewDataChanged(new DataChangedEvent(this, this, true, false, false, true));
        }
        return true;
    }

    public boolean changeEdgeCurrentHPos(int n, int[] nArray, int n2) throws DataDirectorException, SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        try {
            boolean bl = this.changeEdgeCurrentSlice(n, nArray[n2]);
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
    }

    public int getEdgeExtent(int n) throws EdgeOutOfRangeException {
        this.setSampleDataSource();
        switch (n) {
            case 0: {
                return this.columnCount;
            }
            case 1: {
                return this.rowCount;
            }
            case 2: {
                return this.pageCount;
            }
        }
        return 0;
    }

    public int getEdgeCount() {
        return 3;
    }

    public Object getValue(int n, int n2, String string) throws ColumnOutOfRangeException, RowOutOfRangeException {
        if (n < 0 || n >= this.rowCount) {
            throw new RowOutOfRangeException(n, this.rowCount);
        }
        if (n2 < 0 || n2 >= this.columnCount) {
            throw new ColumnOutOfRangeException(n2, this.columnCount);
        }
        if (string.equals("dataRatio")) {
            return new Integer(0);
        }
        if (string.equals("dataGroupSort")) {
            return new Integer(0);
        }
        if (string.equals("dataViewFormat") || string.equals("dataViewStyle") || string.equals("dataFormatted") || string.equals("dataAnnotation")) {
            return null;
        }
        Object object = null;
        object = this.currentPage == 1 ? new Double((Double)this.cellData[n][n2] + (double)10) : this.cellData[n][n2];
        return object;
    }

    public boolean setValue(Object object, int n, int n2, String string) throws ColumnOutOfRangeException, RowOutOfRangeException {
        if (n < 0 || n >= this.rowCount) {
            throw new RowOutOfRangeException(n, this.rowCount);
        }
        if (n2 < 0 || n2 >= this.columnCount) {
            throw new ColumnOutOfRangeException(n2, this.columnCount);
        }
        Object object2 = this.getValue(n, n2, string);
        Object object3 = object;
        try {
            object3 = object2.getClass().getMethod("valueOf", Class.forName("java.lang.String")).invoke(null, object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cellData[n][n2] = object3;
        return true;
    }

    public Object getSliceLabel(int n, int n2, String string) throws SliceOutOfRangeException, EdgeOutOfRangeException {
        switch (n) {
            case 0: {
                if (n2 < 0 || n2 >= this.columnCount) {
                    throw new SliceOutOfRangeException(n2, this.columnCount);
                }
                return this.columnLabels[n2];
            }
            case 1: {
                if (n2 < 0 || n2 >= this.rowCount) {
                    throw new SliceOutOfRangeException(n2, this.rowCount);
                }
                return this.rowLabels[n2];
            }
            case 2: {
                if (n2 < 0 || n2 >= this.pageCount) {
                    throw new SliceOutOfRangeException(n2, this.pageCount);
                }
                return this.pageLabels[n2];
            }
        }
        return null;
    }

    public int getEdgeCurrentSlice(int n, int n2) throws SliceOutOfRangeException, EdgeOutOfRangeException {
        if (n == 2) {
            return this.currentPage;
        }
        return 0;
    }

    public void setCurrentPage(long l) {
        if (l < (long)0 || l >= (long)this.pageCount) {
            return;
        }
        this.currentPage = (int)l;
    }

    public int getLayerCount(int n) throws EdgeOutOfRangeException {
        return 1;
    }

    public int getSliceMemberCount(int n, int n2) throws SliceOutOfRangeException, EdgeOutOfRangeException {
        return 1;
    }

    public Object getLayerMetadata(int n, int n2, String string) throws LayerOutOfRangeException, EdgeOutOfRangeException {
        if (string.equals("dimCanPivot")) {
            return new Integer(1);
        }
        if (string.equals("viewStyle")) {
            return null;
        }
        if (n == 2) {
            return MessageFormat.format(this.baseEdgeDim, this.strPage, "1");
        }
        return MessageFormat.format(this.baseDim, String.valueOf(n2 + 1));
    }

    public Object getMemberMetadata(int n, int n2, int n3, String string) throws SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        if (string.equals("hierLevel") || string.equals("relIndent")) {
            return new Integer(n3);
        }
        if (string.equals("value") || string.equals("displayName") || string.equals("longName") || string.equals("mediumName") || string.equals("shortName")) {
            String string2 = null;
            switch (n) {
                case 0: {
                    string2 = this.columnLabels[n3];
                    break;
                }
                case 1: {
                    string2 = this.rowLabels[n3];
                    break;
                }
                case 2: {
                    string2 = this.pageLabels[n3];
                }
            }
            return string2;
        }
        return null;
    }

    public int getMemberExtent(int n, int n2, int n3) {
        return 1;
    }

    public int getMemberDepth(int n, int n2, int n3) throws SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        return 1;
    }

    public int getMemberStartSlice(int n, int n2, int n3) throws SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        return n3;
    }

    public void setOutline(boolean bl) throws DataDirectorException {
        this.listener.viewDataChanged(new DataChangedEvent(this, this, true, true, true, true));
    }

    public boolean isOutline() {
        return false;
    }

    public int getMemberSiblingCount(int n, int[] nArray, int n2) throws SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        return 2;
    }

    public Object getMemberMetadata(int n, int[] nArray, int n2, int n3, String string) throws SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        if (n2 == 0 || nArray == null) {
            return MessageFormat.format(this.basePageMem, String.valueOf(n3 + 1));
        }
        return String.valueOf(nArray[0]) + " # " + n3;
    }

    public int[] getEdgeCurrentHPos(int n) throws EdgeOutOfRangeException {
        return new int[]{this.currentPage};
    }

    public int[] getMemberHPos(int n, int n2, int n3) throws SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        return new int[]{this.currentPage};
    }

    public int[] getNextHPos(int n, int[] nArray) throws SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        if (n == 2 && this.currentPage == 0) {
            return new int[]{1};
        }
        return null;
    }

    public int[] getPrevHPos(int n, int[] nArray) throws SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        if (n == 2 && this.currentPage == 1) {
            return new int[]{0};
        }
        return null;
    }

    public int[] getFirstHPos(int n) throws EdgeOutOfRangeException {
        if (n == 2) {
            return new int[]{0};
        }
        return null;
    }

    public int[] getLastHPos(int n) throws EdgeOutOfRangeException {
        if (n == 2) {
            return new int[]{1};
        }
        return null;
    }

    public DataMap getDataMap() {
        return new DataMap();
    }

    public DataMap getSupportedDataMap() {
        String[] stringArray = new String[]{"dataUnformatted", "dataFormatted", "dataRatio", "dataViewFormat", "dataViewStyle", "dataGroupSort", "dataAnnotation", "value"};
        return new DataMap(stringArray);
    }

    public MetadataMap getSupportedMetadataMap() {
        String[] stringArray = new String[]{"longName", "mediumName", "shortName", "drillState", "viewStyle", "value", "hierLevel", "relIndent", "date"};
        return new MetadataMap(stringArray);
    }

    public LayerMetadataMap getSupportedLayerMetadataMap() {
        String[] stringArray = new String[]{"dimLongName", "dimMediumName", "dimShortName", "dimName", "dimCanPivot", "viewStyle"};
        return new LayerMetadataMap(stringArray);
    }

    public QDR getLayerQDR(int n, int n2, int n3) throws LayerOutOfRangeException, EdgeOutOfRangeException {
        String string = this.getLayerMetadata(n, n2, "dimLongName").toString();
        return new QDR(null, string, null);
    }

    public QDR getSliceQDR(int n, int n2, int n3) throws SliceOutOfRangeException, EdgeOutOfRangeException {
        return this.constructSliceQDR(n, n2);
    }

    protected QDR constructSliceQDR(int n, int n2) {
        String string = null;
        String string2 = null;
        String string3 = "";
        int n3 = 0;
        try {
            n3 = this.getLayerCount(n);
        }
        catch (DataException dataException) {
            // empty catch block
        }
        int n4 = 0;
        while (n4 < n3) {
            try {
                string = this.getLayerMetadata(n, n4, "dimLongName").toString();
            }
            catch (DataException dataException) {
                string = "";
            }
            try {
                string2 = this.getMemberMetadata(n, n4, n2, "longName").toString();
            }
            catch (DataException dataException) {
                string2 = "";
            }
            string3 = String.valueOf(string3) + ";" + string.toString() + ":" + string2.toString();
            ++n4;
        }
        QDR qDR = new QDR(null, string3);
        return qDR;
    }

    public void setSampleDataSource() {
        if (this.m_graphType != this.m_graph.getGraphType()) {
            this.m_graphType = this.m_graph.getGraphType();
        } else if (!this.localeChanged) {
            return;
        }
        switch (this.m_graphType) {
            case 76: {
                this.initGroups5_3();
                this.rowCount = 1;
                this.columnCount = 15;
                this.defaultDataCommon = this.highLowCloseData;
                break;
            }
            case 88: {
                this.initGroups5_4();
                this.rowCount = 1;
                this.columnCount = 20;
                this.defaultDataCommon = this.highLowCloseVolumeData;
                break;
            }
            case 72: {
                this.initGroups5_2();
                this.rowCount = 1;
                this.columnCount = 10;
                this.defaultDataCommon = this.openCloseData;
                break;
            }
            case 84: {
                this.initGroups5_3();
                this.rowCount = 1;
                this.columnCount = 15;
                this.defaultDataCommon = this.openCloseVolumeData;
                break;
            }
            case 70: 
            case 79: {
                this.initGroups5_4();
                this.rowCount = 1;
                this.columnCount = 20;
                this.defaultDataCommon = this.openHiLoCloseData;
                break;
            }
            case 71: 
            case 83: {
                this.initGroups5_5();
                this.rowCount = 1;
                this.columnCount = 25;
                this.defaultDataCommon = this.openHiLoCloseVolumeData;
                break;
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: {
                this.initGroupAndSeriesArrays();
                this.rowCount = 4;
                this.columnCount = 9;
                this.defaultDataCommon = this.bubbleData;
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                this.initGroupAndSeriesArrays();
                this.rowCount = 4;
                this.columnCount = 6;
                this.defaultDataCommon = this.scatterPolarData;
                break;
            }
            case 21: 
            case 22: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 38: 
            case 39: {
                this.initGroupAndSeriesArrays();
                this.rowCount = 2;
                this.columnCount = 4;
                this.defaultDataCommon = this.defaultData2;
                break;
            }
            case 31: 
            case 32: 
            case 35: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 67: {
                this.initGroupAndSeriesArrays();
                this.rowCount = 5;
                this.columnCount = 5;
                this.defaultDataCommon = this.lineData;
                break;
            }
            case 45: 
            case 46: 
            case 52: 
            case 53: {
                this.initGroupAndSeriesArrays();
                this.rowCount = 2;
                this.columnCount = 4;
                this.defaultDataCommon = this.lineData;
                break;
            }
            case 102: {
                this.initGroupAndSeriesArrays();
                this.rowCount = 1;
                this.columnCount = 5;
                this.defaultDataCommon = this.paretoData;
                break;
            }
            case 12: {
                this.initGroupAndSeriesArrays();
                this.rowCount = 3;
                this.columnCount = 5;
                this.defaultDataCommon = this.threedSurfaceData;
                break;
            }
            case 6: 
            case 7: {
                this.initGroupAndSeriesArrays();
                this.rowCount = 3;
                this.columnCount = 4;
                this.defaultDataCommon = this.threedAreaRibbonData;
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                this.initGroupAndSeriesArrays();
                this.rowCount = 5;
                this.columnCount = 2;
                this.defaultDataCommon = this.defaultData1;
                break;
            }
            default: {
                this.initGroupAndSeriesArrays();
                this.rowCount = 3;
                this.columnCount = 4;
                this.defaultDataCommon = this.defaultData2;
            }
        }
        this.populateCellData(this.columnCount, this.rowCount, this.defaultDataCommon);
        this.populateRowLabels(this.rowCount);
        this.populateColumnLabels(this.columnCount);
        if (this.localeChanged) {
            this.listener.viewDataChanged(new DataChangedEvent(this, this, true, true, true, true));
            this.localeChanged = false;
        } else if (this.m_graph.getDataSource() == this) {
            this.m_graph.saveDrillState();
        }
    }

    protected void initGroups5_2() {
        this.strGroupArray[0] = this.rBundle.getString("Group A");
        this.strGroupArray[1] = this.rBundle.getString("Group A");
        this.strGroupArray[2] = this.rBundle.getString("Group B");
        this.strGroupArray[3] = this.rBundle.getString("Group B");
        this.strGroupArray[4] = this.rBundle.getString("Group C");
        this.strGroupArray[5] = this.rBundle.getString("Group C");
        this.strGroupArray[6] = this.rBundle.getString("Group D");
        this.strGroupArray[7] = this.rBundle.getString("Group D");
        this.strGroupArray[8] = this.rBundle.getString("Group E");
        this.strGroupArray[9] = this.rBundle.getString("Group E");
    }

    protected void initGroups5_3() {
        this.strGroupArray[0] = this.rBundle.getString("Group A");
        this.strGroupArray[1] = this.rBundle.getString("Group A");
        this.strGroupArray[2] = this.rBundle.getString("Group A");
        this.strGroupArray[3] = this.rBundle.getString("Group B");
        this.strGroupArray[4] = this.rBundle.getString("Group B");
        this.strGroupArray[5] = this.rBundle.getString("Group B");
        this.strGroupArray[6] = this.rBundle.getString("Group C");
        this.strGroupArray[7] = this.rBundle.getString("Group C");
        this.strGroupArray[8] = this.rBundle.getString("Group C");
        this.strGroupArray[9] = this.rBundle.getString("Group D");
        this.strGroupArray[10] = this.rBundle.getString("Group D");
        this.strGroupArray[11] = this.rBundle.getString("Group D");
        this.strGroupArray[12] = this.rBundle.getString("Group E");
        this.strGroupArray[13] = this.rBundle.getString("Group E");
        this.strGroupArray[14] = this.rBundle.getString("Group E");
    }

    protected void initGroups5_4() {
        this.strGroupArray[0] = this.rBundle.getString("Group A");
        this.strGroupArray[1] = this.rBundle.getString("Group A");
        this.strGroupArray[2] = this.rBundle.getString("Group A");
        this.strGroupArray[3] = this.rBundle.getString("Group A");
        this.strGroupArray[4] = this.rBundle.getString("Group B");
        this.strGroupArray[5] = this.rBundle.getString("Group B");
        this.strGroupArray[6] = this.rBundle.getString("Group B");
        this.strGroupArray[7] = this.rBundle.getString("Group B");
        this.strGroupArray[8] = this.rBundle.getString("Group C");
        this.strGroupArray[9] = this.rBundle.getString("Group C");
        this.strGroupArray[10] = this.rBundle.getString("Group C");
        this.strGroupArray[11] = this.rBundle.getString("Group C");
        this.strGroupArray[12] = this.rBundle.getString("Group D");
        this.strGroupArray[13] = this.rBundle.getString("Group D");
        this.strGroupArray[14] = this.rBundle.getString("Group D");
        this.strGroupArray[15] = this.rBundle.getString("Group D");
        this.strGroupArray[16] = this.rBundle.getString("Group E");
        this.strGroupArray[17] = this.rBundle.getString("Group E");
        this.strGroupArray[18] = this.rBundle.getString("Group E");
        this.strGroupArray[19] = this.rBundle.getString("Group E");
    }

    protected void initGroups5_5() {
        this.strGroupArray[0] = this.rBundle.getString("Group A");
        this.strGroupArray[1] = this.rBundle.getString("Group A");
        this.strGroupArray[2] = this.rBundle.getString("Group A");
        this.strGroupArray[3] = this.rBundle.getString("Group A");
        this.strGroupArray[4] = this.rBundle.getString("Group A");
        this.strGroupArray[5] = this.rBundle.getString("Group B");
        this.strGroupArray[6] = this.rBundle.getString("Group B");
        this.strGroupArray[7] = this.rBundle.getString("Group B");
        this.strGroupArray[8] = this.rBundle.getString("Group B");
        this.strGroupArray[9] = this.rBundle.getString("Group B");
        this.strGroupArray[10] = this.rBundle.getString("Group C");
        this.strGroupArray[11] = this.rBundle.getString("Group C");
        this.strGroupArray[12] = this.rBundle.getString("Group C");
        this.strGroupArray[13] = this.rBundle.getString("Group C");
        this.strGroupArray[14] = this.rBundle.getString("Group C");
        this.strGroupArray[15] = this.rBundle.getString("Group D");
        this.strGroupArray[16] = this.rBundle.getString("Group D");
        this.strGroupArray[17] = this.rBundle.getString("Group D");
        this.strGroupArray[18] = this.rBundle.getString("Group D");
        this.strGroupArray[19] = this.rBundle.getString("Group D");
        this.strGroupArray[20] = this.rBundle.getString("Group E");
        this.strGroupArray[21] = this.rBundle.getString("Group E");
        this.strGroupArray[22] = this.rBundle.getString("Group E");
        this.strGroupArray[23] = this.rBundle.getString("Group E");
        this.strGroupArray[24] = this.rBundle.getString("Group E");
    }

    protected void initGroupAndSeriesArrays() {
        this.strGroupArray[0] = this.rBundle.getString("Group A");
        this.strGroupArray[1] = this.rBundle.getString("Group B");
        this.strGroupArray[2] = this.rBundle.getString("Group C");
        this.strGroupArray[3] = this.rBundle.getString("Group D");
        this.strGroupArray[4] = this.rBundle.getString("Group E");
        this.strGroupArray[5] = this.rBundle.getString("Group AA");
        this.strGroupArray[6] = this.rBundle.getString("Group BB");
        this.strGroupArray[7] = this.rBundle.getString("Group CC");
        this.strGroupArray[8] = this.rBundle.getString("Group DD");
        this.strGroupArray[9] = this.rBundle.getString("Group EE");
        this.strGroupArray[10] = this.rBundle.getString("Group A");
        this.strGroupArray[11] = this.rBundle.getString("Group B");
        this.strGroupArray[12] = this.rBundle.getString("Group C");
        this.strGroupArray[13] = this.rBundle.getString("Group D");
        this.strGroupArray[14] = this.rBundle.getString("Group E");
        this.strGroupArray[15] = this.rBundle.getString("Group AA");
        this.strGroupArray[16] = this.rBundle.getString("Group BB");
        this.strGroupArray[17] = this.rBundle.getString("Group CC");
        this.strGroupArray[18] = this.rBundle.getString("Group DD");
        this.strGroupArray[19] = this.rBundle.getString("Group EE");
        this.strGroupArray[20] = this.rBundle.getString("Group A");
        this.strGroupArray[21] = this.rBundle.getString("Group B");
        this.strGroupArray[22] = this.rBundle.getString("Group C");
        this.strGroupArray[23] = this.rBundle.getString("Group D");
        this.strGroupArray[24] = this.rBundle.getString("Group E");
        this.strSeriesArray[0] = this.rBundle.getString("Series 1");
        this.strSeriesArray[1] = this.rBundle.getString("Series 2");
        this.strSeriesArray[2] = this.rBundle.getString("Series 3");
        this.strSeriesArray[3] = this.rBundle.getString("Series 4");
        this.strSeriesArray[4] = this.rBundle.getString("Series 5");
    }
}

