/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import oracle.dss.dataView.UIFillColor;
import oracle.dss.dataView.UITransparentFillColor;
import oracle.dss.graph.BaseFrame;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.graph.UIBaseFrame;
import oracle.dss.graph.pfj.draw.IdentObj;

public class PieFrame
extends BaseFrame
implements UIBaseFrame,
UIFillColor,
UITransparentFillColor {
    protected static int rect_Height = 21742;
    protected static int rect_Width = 25251;
    protected static int rect_X = -15393;
    protected static int rect_Y = 12378;

    public PieFrame(Graph graph, IdentObj identObj) {
        super(graph, identObj);
        this.initDefaultValues();
    }

    private void initDefaultValues() {
        this.fillColor = GraphDefaultValues.getPieFillColor().getRGB();
        this.fillTransparent = GraphDefaultValues.isPieFillTransparent();
        this.borderColor = GraphDefaultValues.getPieBorderColor();
        this.borderTransparent = GraphDefaultValues.isPieBorderTransparent();
    }

    public void setFillColor(Color color) {
        if (color == null) {
            this.m_graph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setFillColor( Color newColor)");
            return;
        }
        if (this.m_graph.m_settingXML) {
            this.m_pfj.setFillColor(this.m_identObj, color);
        } else {
            super.setFillColor(color);
        }
    }

    public void setFillTransparent(boolean bl) {
        if (this.m_graph.m_settingXML) {
            this.m_pfj.setTransparentFillColor(this.m_identObj, bl);
        } else {
            super.setFillTransparent(bl);
        }
    }

    protected String getComponentName() {
        return "PieFrame";
    }

    protected void resetStyle() {
        if (this.m_graph.isFrameSizeAutomatic()) {
            this.m_graph.setFrameSize(this.m_graph.getGraphType());
        }
        super.resetStyle();
    }
}

