/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.graph.BaseDataComponent;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class DataMarker
extends BaseDataComponent {
    protected static final int ATTR_MARKERSIZE = 0;
    protected static final int ATTR_STYLE_MAXID = 1;
    protected int markerSize = GraphDefaultValues.getDataMarkerSize();

    public DataMarker(Graph graph, IdentObj identObj) {
        super(graph, identObj);
    }

    public int getMarkerSize() {
        return this.m_pfj.getMarkerSizeDefault();
    }

    public void setMarkerSize(int n) {
        if (n < 0 || n > 100) {
            this.m_graph.getErrorHandler().log("invalid size", "oracle.dss.graph.DataMarker", "setMarkerSize(int size)");
        } else {
            this.m_pfj.setMarkerSizeDefault(n);
            this.setPropertyOverrideFlags(0);
        }
    }

    protected String getComponentName() {
        return "DataMarker";
    }

    protected int getStylePropertyCount() {
        return 1;
    }

    protected boolean getStyleXML(boolean bl, ObjectNode objectNode) {
        boolean bl2 = super.getStyleXML(bl, objectNode);
        if (bl || this.isUserOverrideFlag(0)) {
            objectNode.addProperty("markerSize", this.getMarkerSize());
            bl2 = true;
        }
        return bl2;
    }

    protected void setStyleXML(ObjectNode objectNode) {
        super.setStyleXML(objectNode);
        PropertyNode propertyNode = objectNode.getProperty("markerSize");
        if (propertyNode != null) {
            this.setMarkerSize(propertyNode.getValueAsInteger());
        }
    }

    protected void resetStyle() {
        this.setMarkerSize(this.markerSize);
        super.resetStyle();
    }
}

