/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.sql.Date;
import java.util.StringTokenizer;
import oracle.dss.graph.DataFilterImpl;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.graph.GraphModel;
import oracle.dss.graph.pfj.data.TDGDataGrid;
import oracle.dss.graph.pfj.data.TDGDataGridPieBar;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataException;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.WaitData;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class DataCallback
extends DataFilterImpl
implements TDGDataGrid,
TDGDataGridPieBar {
    protected GraphModel m_graphModel;
    protected boolean m_stringType;
    protected static final String name = "DataFilter";
    protected static final String a_totalMeasures = "totalMeasures";
    protected static final String a_scatterMeasures = "scatterMeasures";
    protected static final String a_scatterLabelsMeasures = "scatterLabelsMeasures";
    protected static final String a_bubbleMeasures = "bubbleMeasures";
    protected static final String a_bubbleLabelsMeasures = "bubbleLabelsMeasures";
    protected static final String a_OHLCVMeasures = "OHLCVMeasures";
    protected static final String a_OHLCMeasures = "OHLCMeasures";
    protected static final String a_HLVMeasures = "HLVMeasures";
    protected static final String a_OCVMeasures = "OCVMeasures";
    protected static final String a_OCMeasures = "OCMeasures";
    protected static final String a_HLMeasures = "HLMeasures";
    protected static final String a_HLCMeasures = "HLCMeasures";
    protected static final String a_HLCVMeasures = "HLCVMeasures";

    public DataCallback(GraphModel graphModel) {
        this.m_graphModel = graphModel;
        this.m_isDirtyFlag = true;
        this.d_totalMeasures = GraphDefaultValues.getTotalMeasures();
    }

    public Object columnLabel(int n) {
        if (this.isExcelOrDeskTop()) {
            if (this.m_scatterDataModel == 1) {
                if (!this.m_seriesAreRows) {
                    return this._getLabelForExcelOrDesktop(0, this.getDataAccessColumn(n + 1));
                }
                return this._getLabelForExcelOrDesktop(0, this.getDataAccessColumn(n));
            }
            if (!this.m_seriesAreRows) {
                return String.valueOf(String.valueOf(this._getLabelForExcelOrDesktop(0, this.getDataAccessColumn(n * 2)))) + ", " + this._getLabelForExcelOrDesktop(0, this.getDataAccessColumn(n * 2 + 1));
            }
            return this._getLabelForExcelOrDesktop(0, this.getDataAccessColumn(n));
        }
        return this._getLabel(0, n);
    }

    public Object rowLabel(int n) {
        if (this.isExcelOrDeskTop()) {
            if (this.m_scatterDataModel == 1) {
                if (!this.m_seriesAreRows) {
                    return this._getLabelForExcelOrDesktop(1, this.getDataAccessRow(n));
                }
                return this._getLabelForExcelOrDesktop(1, this.getDataAccessRow(n + 1));
            }
            if (!this.m_seriesAreRows) {
                return this._getLabelForExcelOrDesktop(1, this.getDataAccessRow(n));
            }
            return String.valueOf(String.valueOf(this._getLabelForExcelOrDesktop(1, this.getDataAccessRow(n * 2)))) + ", " + this._getLabelForExcelOrDesktop(1, this.getDataAccessRow(n * 2 + 1));
        }
        return this._getLabel(1, n);
    }

    public void setGroupLabelType(boolean bl) {
        this.m_stringType = bl;
    }

    public Object getParentDate() {
        try {
            if (this.m_graphModel.getGraphView().isMetadataDrillParentDateSupported()) {
                int n = this.m_seriesAreRows ? 0 : 1;
                Object object = this.getDataAccess().getMemberMetadata(n, 0, 0, "drillParentDate");
                return object;
            }
            Object var1_2 = null;
            return var1_2;
        }
        catch (DataException dataException) {
            Object var2_5 = null;
            return var2_5;
        }
    }

    public Object getParentDateSpan() {
        try {
            if (this.m_graphModel.getGraphView().isMetadataDrillParentDateSpanSupported()) {
                int n = this.m_seriesAreRows ? 0 : 1;
                Object object = this.getDataAccess().getMemberMetadata(n, 0, 0, "drillParentDateSpan");
                return object;
            }
            Object var1_2 = null;
            return var1_2;
        }
        catch (DataException dataException) {
            Object var2_5 = null;
            return var2_5;
        }
    }

    public Object getDateSpan() {
        try {
            if (this.m_graphModel.getGraphView().isMetadataDateSpanSupported()) {
                int n = this.m_seriesAreRows ? 0 : 1;
                Object object = this.getDataAccess().getMemberMetadata(n, 0, 0, "dateSpan");
                return object;
            }
            Object var1_2 = null;
            return var1_2;
        }
        catch (DataException dataException) {
            Object var2_5 = null;
            return var2_5;
        }
    }

    public int getDataAccessRow(int n, int n2) {
        int n3 = n;
        if (this.isExcelOrDeskTop()) {
            n3 = this.m_scatterDataModel == 1 ? (!this.m_seriesAreRows ? n / 2 : (n2 % 2 == 0 ? 0 : n + 1)) : (!this.m_seriesAreRows ? n / 2 : n * 2 + n2 % 2);
        }
        return this.getDataAccessRow(n3);
    }

    public int getDataAccessColumn(int n, int n2) {
        int n3 = n2;
        if (this.isExcelOrDeskTop()) {
            n3 = this.m_scatterDataModel == 1 ? (!this.m_seriesAreRows ? (n % 2 == 0 ? 0 : n2 + 1) : n2 / 2) : (!this.m_seriesAreRows ? n2 * 2 + n % 2 : n2 / 2);
        }
        return this.getDataAccessColumn(n3);
    }

    public Object getValue(int n, int n2) {
        int n3 = this.getDataAccessRow(n, n2);
        int n4 = this.getDataAccessColumn(n, n2);
        try {
            Object object = null;
            if (this.m_graphModel.getGraphView().isDataUnformattedSupported()) {
                if (this.m_graphModel.getGraphView().getWaitDataForRow(n3) != null) {
                    WaitData waitData = this.m_graphModel.getGraphView().getWaitDataForRow(n3);
                    this.m_graphModel.getGraphView().getPFJ().setLazyDataFetchMessage(waitData.getCellMessage());
                    this.m_graphModel.getGraphView().repaint();
                    Object var7_11 = null;
                    return var7_11;
                }
                object = this.getDataAccess().getValue(n3, n4, "dataUnformatted");
                if (object instanceof WaitData) {
                    WaitData waitData = (WaitData)object;
                    this.m_graphModel.getGraphView().setWaitDataForRow(n3, waitData);
                    this.m_graphModel.getGraphView().getPFJ().setLazyDataFetchMessage(waitData.getCellMessage());
                    this.m_graphModel.getGraphView().repaint();
                    Object var7_12 = null;
                    return var7_12;
                }
            }
            if (object instanceof Double && (((Double)object).isNaN() || ((Double)object).isInfinite()) || object instanceof Float && (((Float)object).isNaN() || ((Float)object).isInfinite()) || !(object instanceof Number)) {
                Object var6_9 = null;
                return var6_9;
            }
            Object object2 = object;
            return object2;
        }
        catch (DataException dataException) {
            this.getErrorHandler().error(dataException, this.getClass().getName(), "getValue");
            Object var6_10 = null;
            return var6_10;
        }
    }

    public void setValue(int n, int n2, Object object) {
        try {
            this.getDataAccess().setValue(object, this.getDataAccessRow(n, n2), this.getDataAccessColumn(n, n2), "dataUnformatted");
        }
        catch (DataException dataException) {
            this.getErrorHandler().error(dataException, this.getClass().getName(), "setValue");
            return;
        }
    }

    public String getY1AxisTitle() {
        return this.m_graphModel.getGraphView().getY1Title().getText();
    }

    public String getY2AxisTitle() {
        return this.m_graphModel.getGraphView().getY2Title().getText();
    }

    public String getO1AxisTitle() {
        return this.m_graphModel.getGraphView().getO1Title().getText();
    }

    public String getO2AxisTitle() {
        return this.m_graphModel.getGraphView().getZTitle().getText();
    }

    public String getX1AxisTitle() {
        return this.m_graphModel.getGraphView().getX1Title().getText();
    }

    public String getFootnote() {
        return this.m_graphModel.getGraphView().getFootnote().getText();
    }

    public String getTitle() {
        return this.m_graphModel.getGraphView().getTitle().getText();
    }

    public String getSubtitle() {
        return this.m_graphModel.getGraphView().getSubtitle().getText();
    }

    public void setGraphModel(GraphModel graphModel) {
        this.m_graphModel = graphModel;
    }

    public String getPieBarLabel() {
        return this.m_graphModel.getGraphView().getPieLabel().getText();
    }

    protected void needRec() {
        this.m_graphModel.getGraphView().getPFJ().needRecalc();
    }

    protected DataAccess getDataAccess() {
        return this.m_graphModel.getDataAccess();
    }

    protected ErrorHandler getErrorHandler() {
        return this.m_graphModel.getErrorHandler();
    }

    private Object _getLabelForExcelOrDesktop(int n, int n2) {
        String string = null;
        try {
            int n3 = this.getDataAccess().getEdgeExtent(n);
            if (n2 >= n3) {
                String string2 = "";
                return string2;
            }
            String string3 = this.m_graphModel.getGraphView().getMemberMetadataLabelType(n);
            if (this.m_graphModel.getGraphView().isMemberMetadataLabelTypeSupported(string3)) {
                Object object = this.getDataAccess().getSliceLabel(n, n2, string3);
                string = object.toString();
            }
        }
        catch (DataException dataException) {
            this.getErrorHandler().error(dataException, this.getClass().getName(), "_getLabelForExcelOrDesktop");
            string = null;
        }
        if (string != null) {
            return string;
        }
        return "";
    }

    private Object _getLabel(int n, int n2) {
        String string = null;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = n == 0 && this.m_seriesAreRows || n == 1 && !this.m_seriesAreRows;
        try {
            int n3;
            int n4;
            if (bl3 && (n4 = this.m_graphModel.getGraphView().getPFJ().getNumColumnsInGroup()) > 1) {
                bl2 = true;
                n3 = 0;
                n3 = n == 0 ? this.getColumns() - 1 : this.getRows() - 1;
                if ((n2 *= n4) > n3) {
                    bl = false;
                }
            }
            if (bl) {
                n2 = n == 0 ? this.getDataAccessColumn(n2) : this.getDataAccessRow(n2);
                String string2 = this.m_graphModel.getGraphView().getMemberMetadataLabelType(n);
                if (this.m_graphModel.getGraphView().isMemberMetadataLabelTypeSupported(string2)) {
                    string = "";
                    n3 = this.getDataAccess().getLayerCount(n);
                    if (bl3 && n3 > 1) {
                        int n5 = n3 - 1;
                        if (bl2) {
                            n5 = n3 - 2;
                        }
                        int n6 = 0;
                        while (n6 <= n5) {
                            String string3 = null;
                            Object object = null;
                            if (!this.m_oneGrpLabel && !this.m_stringType && this.m_graphModel.getGraphView().isMetadataDateSupported() && n5 == 0) {
                                object = this.getDataAccess().getMemberMetadata(n, n6, n2, "date");
                                if (object == null) {
                                    object = this.getDataAccess().getMemberMetadata(n, n6, n2, string2);
                                }
                            } else {
                                object = this.getDataAccess().getMemberMetadata(n, n6, n2, string2);
                            }
                            if (object != null && object instanceof Date && n5 == 0) {
                                Object object2 = object;
                                return object2;
                            }
                            if (object != null) {
                                string3 = object.toString();
                            }
                            if (string3 != null && string3.length() > 0) {
                                string = string.length() > 0 ? String.valueOf(string) + " " + string3 : String.valueOf(string) + string3;
                            }
                            int n7 = this.getDataAccess().getMemberDepth(n, n6, n2);
                            n6 += n7;
                        }
                    } else {
                        Object object;
                        if (bl3 && !this.m_oneGrpLabel && !this.m_stringType && this.m_graphModel.getGraphView().isMetadataDateSupported()) {
                            object = this.getDataAccess().getMemberMetadata(n, 0, n2, "date");
                            if (object == null) {
                                object = this.getDataAccess().getSliceLabel(n, n2, string2);
                            }
                        } else {
                            object = this.getDataAccess().getSliceLabel(n, n2, string2);
                        }
                        if (object != null && object instanceof Date) {
                            Object object3 = object;
                            return object3;
                        }
                        if (object != null) {
                            string = object.toString();
                        }
                    }
                }
            }
        }
        catch (DataException dataException) {
            this.getErrorHandler().error(dataException, this.getClass().getName(), "_getLabel");
            string = null;
        }
        if (string != null) {
            return string;
        }
        return "";
    }

    protected void setXML(ObjectNode objectNode) {
        PropertyNode propertyNode = objectNode.getProperty(a_totalMeasures);
        if (propertyNode != null) {
            this.m_totalMeasures = propertyNode.getValueAsInteger();
        }
        if ((propertyNode = objectNode.getProperty(a_scatterMeasures)) != null) {
            this.convertStringtoArray(propertyNode, 0);
        }
        if ((propertyNode = objectNode.getProperty(a_scatterLabelsMeasures)) != null) {
            this.convertStringtoArray(propertyNode, 1);
        }
        if ((propertyNode = objectNode.getProperty(a_bubbleMeasures)) != null) {
            this.convertStringtoArray(propertyNode, 2);
        }
        if ((propertyNode = objectNode.getProperty(a_bubbleLabelsMeasures)) != null) {
            this.convertStringtoArray(propertyNode, 3);
        }
        if ((propertyNode = objectNode.getProperty(a_OHLCVMeasures)) != null) {
            this.convertStringtoArray(propertyNode, 4);
        }
        if ((propertyNode = objectNode.getProperty(a_OHLCMeasures)) != null) {
            this.convertStringtoArray(propertyNode, 5);
        }
        if ((propertyNode = objectNode.getProperty(a_HLVMeasures)) != null) {
            this.convertStringtoArray(propertyNode, 6);
        }
        if ((propertyNode = objectNode.getProperty(a_OCVMeasures)) != null) {
            this.convertStringtoArray(propertyNode, 7);
        }
        if ((propertyNode = objectNode.getProperty(a_OCMeasures)) != null) {
            this.convertStringtoArray(propertyNode, 8);
        }
        if ((propertyNode = objectNode.getProperty(a_HLMeasures)) != null) {
            this.convertStringtoArray(propertyNode, 9);
        }
        if ((propertyNode = objectNode.getProperty(a_HLCMeasures)) != null) {
            this.convertStringtoArray(propertyNode, 10);
        }
        if ((propertyNode = objectNode.getProperty(a_HLCVMeasures)) != null) {
            this.convertStringtoArray(propertyNode, 11);
        }
    }

    protected ObjectNode getXML(boolean bl) {
        ObjectNode objectNode = new ObjectNode(name);
        boolean bl2 = false;
        if (bl || this.m_totalMeasures != this.d_totalMeasures) {
            objectNode.addProperty(a_totalMeasures, this.m_totalMeasures);
            bl2 = true;
        }
        if (bl || this.m_measuresArrays[0] != null) {
            objectNode.addProperty(a_scatterMeasures, this.convertArrayToStr(this.m_measuresArrays[0]));
            bl2 = true;
        }
        if (bl || this.m_measuresArrays[1] != null) {
            objectNode.addProperty(a_scatterLabelsMeasures, this.convertArrayToStr(this.m_measuresArrays[1]));
            bl2 = true;
        }
        if (bl || this.m_measuresArrays[2] != null) {
            objectNode.addProperty(a_bubbleMeasures, this.convertArrayToStr(this.m_measuresArrays[2]));
            bl2 = true;
        }
        if (bl || this.m_measuresArrays[3] != null) {
            objectNode.addProperty(a_bubbleLabelsMeasures, this.convertArrayToStr(this.m_measuresArrays[3]));
            bl2 = true;
        }
        if (bl || this.m_measuresArrays[4] != null) {
            objectNode.addProperty(a_OHLCVMeasures, this.convertArrayToStr(this.m_measuresArrays[4]));
            bl2 = true;
        }
        if (bl || this.m_measuresArrays[5] != null) {
            objectNode.addProperty(a_OHLCMeasures, this.convertArrayToStr(this.m_measuresArrays[5]));
            bl2 = true;
        }
        if (bl || this.m_measuresArrays[6] != null) {
            objectNode.addProperty(a_HLVMeasures, this.convertArrayToStr(this.m_measuresArrays[6]));
            bl2 = true;
        }
        if (bl || this.m_measuresArrays[7] != null) {
            objectNode.addProperty(a_OCVMeasures, this.convertArrayToStr(this.m_measuresArrays[7]));
            bl2 = true;
        }
        if (bl || this.m_measuresArrays[8] != null) {
            objectNode.addProperty(a_OCMeasures, this.convertArrayToStr(this.m_measuresArrays[8]));
            bl2 = true;
        }
        if (bl || this.m_measuresArrays[9] != null) {
            objectNode.addProperty(a_HLMeasures, this.convertArrayToStr(this.m_measuresArrays[9]));
            bl2 = true;
        }
        if (bl || this.m_measuresArrays[10] != null) {
            objectNode.addProperty(a_HLCMeasures, this.convertArrayToStr(this.m_measuresArrays[10]));
            bl2 = true;
        }
        if (bl || this.m_measuresArrays[11] != null) {
            objectNode.addProperty(a_HLCVMeasures, this.convertArrayToStr(this.m_measuresArrays[11]));
            bl2 = true;
        }
        if (bl2) {
            return objectNode;
        }
        return null;
    }

    private String convertArrayToStr(int[] nArray) {
        if (nArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < nArray.length) {
            stringBuffer.append(nArray[n]);
            if (nArray.length - 1 != n) {
                stringBuffer.append(" ");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private void convertStringtoArray(PropertyNode propertyNode, int n) {
        String string = propertyNode.getValueAsString();
        int n2 = this.getGroupSize(n);
        if (string == null) {
            return;
        }
        if (string.equals("")) {
            this.m_measuresArrays[n] = null;
            if (this.m_graphCategory == n) {
                this.m_currentArray = null;
                this.m_filterOn = false;
            }
            return;
        }
        int[] nArray = new int[n2];
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ", false);
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            nArray[n3] = Integer.parseInt(string2);
            ++n3;
        }
        if (n3 != n2) {
            this.getErrorHandler().log("array size is not equal to the Group size", this.getClass().getName(), "setXML(ObjectNode node)");
        } else if (n3 > this.m_totalMeasures) {
            this.getErrorHandler().log("measure array size is greater than the total number of measures", this.getClass().getName(), "setXML(ObjectNode node)");
        } else {
            this.m_measuresArrays[n] = nArray;
            if (this.m_graphCategory == n) {
                this.m_currentArray = this.m_measuresArrays[this.m_graphCategory];
                this.m_filterOn = true;
            }
        }
    }
}

