/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.graph.BaseBorderLine;
import oracle.dss.graph.Graph;
import oracle.dss.graph.MajorTick;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public abstract class BaseMajorTick
extends BaseBorderLine
implements MajorTick {
    protected static final int ATTR_TICKSTYLE = 4;
    protected static final int ATTR_BASEMAJORTICK_LASTID = 4;
    protected static final int ATTR_STYLE_MAXID = 5;
    protected int tickStyle;

    public BaseMajorTick(Graph graph) {
        super(graph);
    }

    public abstract int getTickStyle();

    public abstract void setTickStyle(int var1);

    protected int getStylePropertyCount() {
        return 5;
    }

    protected boolean getStyleXML(boolean bl, ObjectNode objectNode) {
        boolean bl2 = super.getStyleXML(bl, objectNode);
        if (bl || this.isUserOverrideFlag(4)) {
            int n = this.getTickStyle();
            if (n == 0) {
                objectNode.addProperty("tickStyle", "GS_GRID");
            } else if (n == 1) {
                objectNode.addProperty("tickStyle", "GS_EXTENDED");
            } else if (n == 2) {
                objectNode.addProperty("tickStyle", "GS_IN");
            } else if (n == 3) {
                objectNode.addProperty("tickStyle", "GS_OUT");
            } else {
                objectNode.addProperty("tickStyle", "GS_SPAN");
            }
            bl2 = true;
        }
        return bl2;
    }

    protected void setStyleXML(ObjectNode objectNode) {
        super.setStyleXML(objectNode);
        PropertyNode propertyNode = objectNode.getProperty("tickStyle");
        if (propertyNode != null) {
            String string = propertyNode.getValueAsString();
            if (string.equals("GS_GRID")) {
                this.setTickStyle(0);
            } else if (string.equals("GS_EXTENDED")) {
                this.setTickStyle(1);
            } else if (string.equals("GS_IN")) {
                this.setTickStyle(2);
            } else if (string.equals("GS_OUT")) {
                this.setTickStyle(3);
            } else {
                this.setTickStyle(4);
            }
        }
    }

    protected void resetStyle() {
        this.setTickStyle(this.tickStyle);
        super.resetStyle();
    }
}

