/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.export;

import java.io.PrintWriter;
import java.util.Vector;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.util.CubeDataAccess;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataAvailableEvent;
import oracle.dss.util.DataChangedEvent;
import oracle.dss.util.DataDirector;
import oracle.dss.util.DataDirectorListener;
import oracle.dss.util.RelationalDataAccess;
import oracle.dss.util.WaitDataAvailableEvent;

public class TextExport
implements DataDirectorListener {
    public static final String EXPORT_FORMAT_CSV = "csv";
    public static final String EXPORT_FORMAT_TAB_DELIMITED = "tabdelimited";
    public static final String EXPORT_PAGEDIM_ALL = "pagedim_all";
    public static final String EXPORT_PAGEDIM_CURRENT = "pagedim_current";
    public static final String EXPORT_PAGEDIM_SELECTED = "pagedim_selected";
    protected DataAccess m_dataAccess;
    protected DataDirector m_dataDirector;
    protected PrintWriter m_output;
    protected String m_dataType = "dataUnformatted";
    protected String m_exportFormat = "csv";
    protected String m_exportRange = "pagedim_current";
    protected String[] m_layerMetadataLabelTypes;
    protected String[] m_memberMetadataLabelTypes;
    protected Vector m_listExportQDRs;
    protected ViewFormat m_viewFormat;
    protected Vector m_listExportHPos;
    protected String m_exportTitle;
    protected String m_exportSubtitle;
    protected String m_exportFootnote;

    public TextExport(DataAccess dataAccess, DataDirector dataDirector, PrintWriter printWriter) throws IllegalArgumentException {
        this.setDataAccess(dataAccess);
        this.setDataDirector(dataDirector);
        this.setOutput(printWriter);
        this.m_layerMetadataLabelTypes = new String[3];
        this.m_memberMetadataLabelTypes = new String[3];
        int n = 0;
        while (n < 3) {
            this.m_layerMetadataLabelTypes[n] = "dimLongName";
            this.m_memberMetadataLabelTypes[n] = "longName";
            ++n;
        }
    }

    public TextExport(DataAccess dataAccess, DataDirector dataDirector, PrintWriter printWriter, String string, String string2) throws IllegalArgumentException {
        this.setDataAccess(dataAccess);
        this.setDataDirector(dataDirector);
        this.setOutput(printWriter);
        this.setExportFormat(string);
        this.setExportRange(string2);
        this.m_layerMetadataLabelTypes = new String[3];
        this.m_memberMetadataLabelTypes = new String[3];
        int n = 0;
        while (n < 3) {
            this.m_layerMetadataLabelTypes[n] = "dimLongName";
            this.m_memberMetadataLabelTypes[n] = "longName";
            ++n;
        }
    }

    public void export() throws Exception {
        int n = -1;
        int n2 = -1;
        int[] nArray = null;
        int[] nArray2 = null;
        this.m_dataDirector.addDataDirectorListener(this);
        if (this.m_exportRange.equals(EXPORT_PAGEDIM_CURRENT)) {
            this.exportPage();
        } else if (this.m_exportRange.equals(EXPORT_PAGEDIM_ALL)) {
            nArray = this.m_dataAccess.getEdgeCurrentHPos(2);
            n = this.m_dataAccess.getEdgeExtent(2);
            int n3 = this.m_dataAccess.getLayerCount(2);
            nArray2 = this.m_dataAccess.getFirstHPos(2);
            n2 = 0;
            while (n2 < n) {
                this.m_dataDirector.changeEdgeCurrentHPos(2, nArray2, n3 - 1);
                this.exportPage();
                this.m_output.println(" ");
                nArray2 = this.m_dataAccess.getNextHPos(2, nArray2);
                ++n2;
            }
            this.m_dataDirector.changeEdgeCurrentHPos(2, nArray, nArray.length - 1);
        } else if (this.m_exportRange.equals(EXPORT_PAGEDIM_SELECTED)) {
            nArray = this.m_dataAccess.getEdgeCurrentHPos(2);
            n = this.m_listExportHPos.size();
            n2 = 0;
            while (n2 < n) {
                int[] nArray3 = (int[])this.m_listExportHPos.elementAt(n2);
                this.m_dataDirector.changeEdgeCurrentHPos(2, nArray3, nArray3.length - 1);
                this.exportPage();
                this.m_output.println(" ");
                ++n2;
            }
            this.m_dataDirector.changeEdgeCurrentHPos(2, nArray, nArray.length - 1);
        }
        this.m_dataDirector.removeDataDirectorListener(this);
    }

    public DataAccess getDataAccess() {
        return this.m_dataAccess;
    }

    public DataDirector getDataDirector() {
        return this.m_dataDirector;
    }

    public String getDataType() {
        return this.m_dataType;
    }

    public String getExportFormat() {
        return this.m_exportFormat;
    }

    public String getExportRange() {
        return this.m_exportRange;
    }

    public String getLayerMetadataLabelType() {
        String string = this.m_layerMetadataLabelTypes[0];
        int n = 1;
        while (n < this.m_layerMetadataLabelTypes.length) {
            if (!string.equals(this.m_layerMetadataLabelTypes[n])) {
                return null;
            }
            ++n;
        }
        return string;
    }

    public String getMemberMetadataLabelType() {
        String string = this.m_memberMetadataLabelTypes[0];
        int n = 1;
        while (n < this.m_memberMetadataLabelTypes.length) {
            if (!string.equals(this.m_memberMetadataLabelTypes[n])) {
                return null;
            }
            ++n;
        }
        return string;
    }

    public PrintWriter getOutput() {
        return this.m_output;
    }

    public ViewFormat getViewFormat() {
        return this.m_viewFormat;
    }

    public String getExportTitle() {
        return this.m_exportTitle;
    }

    public String getExportSubtitle() {
        return this.m_exportSubtitle;
    }

    public String getExportFootnote() {
        return this.m_exportFootnote;
    }

    public static boolean isSupportedDataType(String string) {
        if (null == string) {
            return false;
        }
        return string.equals("dataFormatted") || string.equals("dataUnformatted");
    }

    public static boolean isSupportedExportFormat(String string) {
        if (null == string) {
            return false;
        }
        return string.equals(EXPORT_FORMAT_CSV) || string.equals(EXPORT_FORMAT_TAB_DELIMITED);
    }

    public static boolean isSupportedExportRange(String string) {
        if (null == string) {
            return false;
        }
        return string.equals(EXPORT_PAGEDIM_ALL) || string.equals(EXPORT_PAGEDIM_CURRENT) || string.equals(EXPORT_PAGEDIM_SELECTED);
    }

    public static boolean isSupportedLayerMetadataLabelType(String string) {
        if (null == string) {
            return false;
        }
        return string.equals("dimShortName") || string.equals("dimMediumName") || string.equals("dimLongName");
    }

    public static boolean isSupportedMemberMetadataLabelType(String string) {
        if (null == string) {
            return false;
        }
        return string.equals("shortName") || string.equals("mediumName") || string.equals("longName");
    }

    public void setDataAccess(DataAccess dataAccess) throws IllegalArgumentException {
        if (null == dataAccess) {
            throw new IllegalArgumentException("Invalid data access object specified");
        }
        this.m_dataAccess = dataAccess;
    }

    public void setDataDirector(DataDirector dataDirector) throws IllegalArgumentException {
        if (null == dataDirector) {
            throw new IllegalArgumentException("Invalid data director object specified");
        }
        this.m_dataDirector = dataDirector;
    }

    public void setExportFormat(String string) throws IllegalArgumentException {
        if (!TextExport.isSupportedExportFormat(string)) {
            throw new IllegalArgumentException("Unsupported export format specified");
        }
        this.m_exportFormat = string;
    }

    public void setExportQDRs(Vector vector) {
        this.m_listExportQDRs = vector;
    }

    public void setExportHPos(Vector vector) {
        this.m_listExportHPos = vector;
    }

    public void setExportRange(String string) throws IllegalArgumentException {
        if (!TextExport.isSupportedExportRange(string)) {
            throw new IllegalArgumentException("Unsupported export range specified");
        }
        this.m_exportRange = string;
    }

    public void setLayerMetadataLabelType(String string) throws IllegalArgumentException {
        if (!TextExport.isSupportedLayerMetadataLabelType(string)) {
            throw new IllegalArgumentException("Unsupported layer metadata label type specified");
        }
        int n = 0;
        while (n < this.m_layerMetadataLabelTypes.length) {
            this.m_layerMetadataLabelTypes[n] = string;
            ++n;
        }
    }

    public void setMemberMetadataLabelType(String string) throws IllegalArgumentException {
        if (!TextExport.isSupportedMemberMetadataLabelType(string)) {
            throw new IllegalArgumentException("Unsupported member metadata label type specified");
        }
        int n = 0;
        while (n < this.m_memberMetadataLabelTypes.length) {
            this.m_memberMetadataLabelTypes[n] = string;
            ++n;
        }
    }

    public void setMemberMetadataLabelType(int n, String string) throws IllegalArgumentException {
        if (!this._isEdgeValid(n)) {
            throw new IllegalArgumentException("Invalid edge for member metadata label type");
        }
        if (!TextExport.isSupportedMemberMetadataLabelType(string)) {
            throw new IllegalArgumentException("Unsupported member metadata label type specified");
        }
        this.m_memberMetadataLabelTypes[n] = string;
    }

    public String getMemberMetadataLabelType(int n) throws IllegalArgumentException {
        if (!this._isEdgeValid(n)) {
            throw new IllegalArgumentException("Invalid edge for member metadata label type");
        }
        return this.m_memberMetadataLabelTypes[n];
    }

    public void setLayerMetadataLabelType(int n, String string) throws IllegalArgumentException {
        if (!this._isEdgeValid(n)) {
            throw new IllegalArgumentException("Invalid edge for layer metadata label type");
        }
        if (!TextExport.isSupportedLayerMetadataLabelType(string)) {
            throw new IllegalArgumentException("Unsupported layer metadata label type specified");
        }
        this.m_layerMetadataLabelTypes[n] = string;
    }

    public String getLayerMetadataLabelType(int n) throws IllegalArgumentException {
        if (!this._isEdgeValid(n)) {
            throw new IllegalArgumentException("Invalid edge for member metadata label type");
        }
        return this.m_layerMetadataLabelTypes[n];
    }

    public void setOutput(PrintWriter printWriter) throws IllegalArgumentException {
        if (null == printWriter) {
            throw new IllegalArgumentException("Invalid output object specified");
        }
        this.m_output = printWriter;
    }

    public void setViewFormat(ViewFormat viewFormat) {
        this.m_viewFormat = viewFormat;
    }

    public void setExportTitle(String string) {
        this.m_exportTitle = string;
    }

    public void setExportSubtitle(String string) {
        this.m_exportSubtitle = string;
    }

    public void setExportFootnote(String string) {
        this.m_exportFootnote = string;
    }

    protected void exportCubeDataAccess() throws Exception {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        String string = null;
        String string2 = null;
        n = this.m_dataAccess.getEdgeExtent(0);
        n2 = this.m_dataAccess.getEdgeExtent(1);
        n5 = this.m_dataAccess.getLayerCount(0);
        n6 = this.m_dataAccess.getLayerCount(1);
        n7 = 0;
        while (n7 < n5) {
            string = new String();
            n8 = 0;
            while (n8 < n6) {
                string = this.appendOutputData(string, "", true);
                ++n8;
            }
            n3 = 0;
            while (n3 < n) {
                string2 = this.getHeaderCellData(0, n7, n3);
                if (string2 != null) {
                    string = this.appendOutputData(string, string2, n3 != n - 1);
                }
                ++n3;
            }
            this.m_output.println(string);
            ++n7;
        }
        n4 = 0;
        while (n4 < n2) {
            string = new String();
            n8 = 0;
            while (n8 < n6) {
                string2 = this.getHeaderCellData(1, n8, n4);
                if (string2 != null) {
                    string = this.appendOutputData(string, string2, true);
                }
                ++n8;
            }
            n3 = 0;
            while (n3 < n) {
                string2 = this.getDataBodyCellData(n4, n3);
                if (string2 != null) {
                    string = this.appendOutputData(string, string2, n3 != n - 1);
                }
                ++n3;
            }
            this.m_output.println(string);
            ++n4;
        }
    }

    protected void exportTitle() {
        String string = null;
        string = this.getExportTitle();
        if (string != null && string.length() > 0) {
            if (this.m_exportFormat.equals(EXPORT_FORMAT_CSV)) {
                string = String.valueOf(string) + ",";
            } else if (this.m_exportFormat.equals(EXPORT_FORMAT_TAB_DELIMITED)) {
                string = String.valueOf(string) + "\t";
            }
            this.m_output.println(string);
        }
    }

    protected void exportSubtitle() {
        String string = null;
        string = this.getExportSubtitle();
        if (string != null && string.length() > 0) {
            if (this.m_exportFormat.equals(EXPORT_FORMAT_CSV)) {
                string = String.valueOf(string) + ",";
            } else if (this.m_exportFormat.equals(EXPORT_FORMAT_TAB_DELIMITED)) {
                string = String.valueOf(string) + "\t";
            }
            this.m_output.println(string);
        }
    }

    protected void exportFootnote() {
        String string = null;
        string = this.getExportFootnote();
        if (string != null && string.length() > 0) {
            if (this.m_exportFormat.equals(EXPORT_FORMAT_CSV)) {
                string = String.valueOf(string) + ",";
            } else if (this.m_exportFormat.equals(EXPORT_FORMAT_TAB_DELIMITED)) {
                string = String.valueOf(string) + "\t";
            }
            this.m_output.println(" ");
            this.m_output.println(string);
        }
    }

    protected void exportPage() throws Exception {
        this.exportTitle();
        this.exportSubtitle();
        this.exportPagingControlInfo();
        if (this.m_dataAccess instanceof CubeDataAccess) {
            this.exportCubeDataAccess();
            this.exportFootnote();
            return;
        }
        if (this.m_dataAccess instanceof RelationalDataAccess) {
            this.exportRelationalDataAccess();
            this.exportFootnote();
            return;
        }
        throw new IllegalArgumentException("Invalid data access specified. Expected CubeDataAccess or RelationalDataAccess");
    }

    protected void exportPagingControlInfo() throws Exception {
        int n = -1;
        int[] nArray = null;
        String string = null;
        String string2 = null;
        string = new String();
        int n2 = this.m_dataAccess.getLayerCount(2);
        if (n2 == 0) {
            return;
        }
        nArray = this.m_dataAccess.getEdgeCurrentHPos(2);
        n = 0;
        while (n < nArray.length) {
            string2 = (String)this.m_dataAccess.getLayerMetadata(2, n, this.m_layerMetadataLabelTypes[2]);
            if (string2 != null) {
                string = this.appendOutputData(string, string2, true);
                string2 = (String)this.m_dataAccess.getMemberMetadata(2, nArray, n, nArray[n], this.m_memberMetadataLabelTypes[2]);
                if (string2 != null) {
                    string = this.appendOutputData(string, string2, true);
                }
                string = this.appendOutputData(string, " ", n != nArray.length - 1);
            }
            ++n;
        }
        this.m_output.println(string);
    }

    protected void exportRelationalDataAccess() throws Exception {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        String string = null;
        String string2 = null;
        n = this.m_dataAccess.getEdgeExtent(0);
        n2 = this.m_dataAccess.getEdgeExtent(1);
        n5 = this.m_dataAccess.getLayerCount(0);
        n6 = this.m_dataAccess.getLayerCount(1);
        string = new String();
        string = this.appendOutputData(string, "", true);
        n3 = 0;
        while (n3 < n) {
            string2 = this.getHeaderCellData(0, n3, 0);
            if (string2 != null) {
                string = this.appendOutputData(string, string2, n3 != n - 1);
            }
            ++n3;
        }
        this.m_output.println(string);
        n4 = 0;
        while (n4 < n2) {
            string = new String();
            string2 = this.getHeaderCellData(1, n4, 0);
            if (string2 != null) {
                string = this.appendOutputData(string, string2, true);
            }
            n3 = 0;
            while (n3 < n) {
                string2 = this.getDataBodyCellData(n4, n3);
                if (string2 != null) {
                    string = this.appendOutputData(string, string2, n3 != n - 1);
                }
                ++n3;
            }
            this.m_output.println(string);
            ++n4;
        }
    }

    private String appendOutputData(String string, String string2, boolean bl) {
        if (null == string) {
            return null;
        }
        if (null == string2) {
            string2 = "ERROR";
        }
        string = 0 == string.length() ? this.encodeCellData(string2) : String.valueOf(string) + this.encodeCellData(string2);
        if (bl) {
            if (this.m_exportFormat.equals(EXPORT_FORMAT_CSV)) {
                string = String.valueOf(string) + ",";
            } else if (this.m_exportFormat.equals(EXPORT_FORMAT_TAB_DELIMITED)) {
                string = String.valueOf(string) + "\t";
            }
        }
        return string;
    }

    private String encodeCellData(String string) {
        return String.valueOf(String.valueOf("\"")) + string + "\"";
    }

    private String getHeaderCellData(int n, int n2, int n3) throws Exception {
        Object object = null;
        object = this.m_dataAccess.getMemberMetadata(n, n2, n3, this.m_memberMetadataLabelTypes[n]);
        if (null == object) {
            object = new String("ERROR");
        }
        return object.toString();
    }

    private String getDataBodyCellData(int n, int n2) throws Exception {
        Object object = null;
        String string = null;
        object = this.m_dataAccess.getValue(n, n2, this.m_dataType);
        if (null == object) {
            object = new String("");
        }
        string = this.m_viewFormat != null ? (object instanceof String ? object.toString() : this.m_viewFormat.ObjectToString(object)) : object.toString();
        return string;
    }

    private boolean _isEdgeValid(int n) {
        return n == 0 || n == 1 || n == 2;
    }

    public void viewDataChanged(DataChangedEvent dataChangedEvent) {
        this.setDataAccess(dataChangedEvent.getDataAccess());
    }

    public void viewDataAvailable(DataAvailableEvent dataAvailableEvent) {
    }

    public void waitDataAvailable(WaitDataAvailableEvent waitDataAvailableEvent) {
    }
}

