/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.border.GrayPane;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.button.PushButton;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.dataView.UIViewPrinter;
import oracle.dss.dataView.ViewPrinter;
import oracle.dss.dataView.gui.DataviewDialogBarLayout;
import oracle.dss.dataView.gui.PreviewPanel;
import oracle.dss.dataView.gui.PrintDialogsProvider;
import oracle.dss.util.help.HelpContext;

public class PreviewDialog
extends JDialog
implements ActionListener,
HelpContext {
    private PrintDialogsProvider m_pdp;
    private PreviewPanel m_previewPanel;
    private UIViewPrinter[] m_printers;
    protected PushButton pgButton;
    private boolean m_entireWkbkSelected;
    protected PushButton printButton;
    protected PushButton closeButton;
    protected PushButton helpButton;
    private final int _BORDER_INSET = 6;
    private Locale m_locale;
    private final Border _sBorder = new EmptyBorder(6, 6, 6, 6);
    protected String m_strHelpContextID;
    protected boolean m_bHelpEnabled;
    protected HelpProvider m_helpProvider;
    private GrayPane gp;
    private ComponentAdapter m_componentListener;
    ResourceBundle dvStrings;

    public PreviewDialog(Frame frame, String string, ViewPrinter viewPrinter, PrintDialogsProvider printDialogsProvider) {
        super(frame, string, true);
        UIViewPrinter[] uIViewPrinterArray = new UIViewPrinter[]{viewPrinter};
        this.setResizable(true);
        this.constructDialog(frame, string, uIViewPrinterArray, printDialogsProvider);
    }

    public PreviewDialog(Frame frame, String string, ViewPrinter[] viewPrinterArray, PrintDialogsProvider printDialogsProvider) {
        super(frame, string, true);
        this.setResizable(true);
        this.constructDialog(frame, string, viewPrinterArray, printDialogsProvider);
    }

    public PreviewDialog(Frame frame, String string, UIViewPrinter uIViewPrinter, PrintDialogsProvider printDialogsProvider) {
        super(frame, string, true);
        UIViewPrinter[] uIViewPrinterArray = new UIViewPrinter[]{uIViewPrinter};
        this.setResizable(true);
        this.constructDialog(frame, string, uIViewPrinterArray, printDialogsProvider);
    }

    public PreviewDialog(Frame frame, String string, UIViewPrinter uIViewPrinter, PrintDialogsProvider printDialogsProvider, boolean bl) {
        super(frame, string, true);
        UIViewPrinter[] uIViewPrinterArray = new UIViewPrinter[]{uIViewPrinter};
        this.setResizable(true);
        this.m_entireWkbkSelected = bl;
        this.constructDialog(frame, string, uIViewPrinterArray, printDialogsProvider);
    }

    public PreviewPanel getPreviewPanel() {
        return this.m_previewPanel;
    }

    private void constructDialog(Frame frame, String string, UIViewPrinter[] uIViewPrinterArray, PrintDialogsProvider printDialogsProvider) {
        this.m_printers = uIViewPrinterArray;
        this.m_pdp = printDialogsProvider;
        this.updateResourceBundle(uIViewPrinterArray[0].getLocale());
        this.setSize(800, 600);
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.setLayout(new BorderLayout(0, 6));
        jComponent.setBorder(this._sBorder);
        if (UIManager.getLookAndFeel() instanceof OracleLookAndFeel) {
            jComponent.setBackground(UIManager.getColor(ColorScheme.DARK_LOOK));
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new DataviewDialogBarLayout(jPanel));
        String string2 = this.getIntlString("help");
        this.helpButton = new PushButton(StringUtils.stripMnemonic((String)string2));
        this.helpButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string2));
        jPanel.add((Component)this.helpButton, DialogButtonBar.CONSTRAINT_HELP);
        this.helpButton.addActionListener((ActionListener)this);
        this.helpButton.setLeftmost(true);
        this.helpButton.setRightmost(true);
        string2 = this.getIntlString("pagesetup");
        this.pgButton = new PushButton(StringUtils.stripMnemonic((String)string2));
        this.pgButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string2));
        jPanel.add((Component)this.pgButton, DialogButtonBar.CONSTRAINT_FINISH);
        this.pgButton.addActionListener((ActionListener)this);
        this.pgButton.setLeftmost(true);
        this.pgButton.setRightmost(true);
        if (this.m_entireWkbkSelected) {
            this.pgButton.setEnabled(false);
        }
        string2 = this.getIntlString("pnt");
        this.printButton = new PushButton(StringUtils.stripMnemonic((String)string2));
        this.printButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string2));
        jPanel.add((Component)this.printButton, DialogButtonBar.CONSTRAINT_YES);
        this.printButton.addActionListener((ActionListener)this);
        this.printButton.setLeftmost(true);
        this.printButton.setRightmost(true);
        string2 = this.getIntlString("Close");
        this.closeButton = new PushButton(StringUtils.stripMnemonic((String)string2));
        this.closeButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string2));
        jPanel.add((Component)this.closeButton, DialogButtonBar.CONSTRAINT_NO);
        this.closeButton.addActionListener((ActionListener)this);
        this.closeButton.setLeftmost(true);
        this.closeButton.setRightmost(true);
        this.closeButton.registerKeyboardAction((ActionListener)this, KeyStroke.getKeyStroke(27, 0), 2);
        this.getContentPane().add((Component)jPanel, "South");
        this.helpButton.registerKeyboardAction((ActionListener)this, KeyStroke.getKeyStroke(112, 0), 2);
        if (uIViewPrinterArray.length > 1) {
            this.m_previewPanel = new PreviewPanel((ViewPrinter[])uIViewPrinterArray, this.m_pdp);
        } else {
            if (this.m_previewPanel != null) {
                this.m_previewPanel.cleanUp();
                this.m_previewPanel = null;
            }
            this.m_previewPanel = new PreviewPanel(uIViewPrinterArray[0], this.m_pdp);
        }
        if (this.gp != null) {
            this.gp.removeAll();
            this.gp = null;
        }
        this.gp = new GrayPane((Component)this.m_previewPanel);
        this.getContentPane().add((Component)this.gp, "Center");
        this.m_componentListener = new ComponentAdapter(){

            public void componentHidden(ComponentEvent componentEvent) {
                int n = 0;
                while (n < PreviewDialog.this.m_printers.length) {
                    PreviewDialog.this.m_printers[n].endPrint();
                    ++n;
                }
            }

            public void componentResized(ComponentEvent componentEvent) {
                PreviewDialog.this.m_previewPanel.componentResized();
            }

            public void componentShown(ComponentEvent componentEvent) {
                PreviewDialog.this.m_previewPanel.componentResized();
            }
        };
        this.addComponentListener(this.m_componentListener);
        WindowUtils.centerWindow((Window)this, (Component)frame);
    }

    public void refreshPreviewDialog(Frame frame, String string, UIViewPrinter[] uIViewPrinterArray, PrintDialogsProvider printDialogsProvider) {
        this.getContentPane().removeAll();
        this.constructDialog(frame, string, uIViewPrinterArray, printDialogsProvider);
    }

    public String getHelpContextID() {
        return this.getClass().getName();
    }

    public void setHelpContextID(String string) {
        this.m_strHelpContextID = string;
    }

    public void setHelpEnabled(boolean bl) {
        this.m_bHelpEnabled = bl;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.printButton) {
            if (this.m_pdp != null) {
                int n = 0;
                while (n < this.m_printers.length) {
                    this.m_printers[n].endPrint();
                    ++n;
                }
                this.setVisible(false);
                Frame frame = WindowUtils.parentFrame((Component)this.printButton);
                this.m_pdp.showPrintDialog(frame);
            }
        } else if (actionEvent.getSource() == this.pgButton) {
            if (this.m_pdp != null) {
                int n = 0;
                while (n < this.m_printers.length) {
                    this.m_printers[n].endPrint();
                    ++n;
                }
                Frame frame = WindowUtils.parentFrame((Component)this.printButton);
                this.setVisible(false);
                this.m_pdp.showPageSetupDialog(frame);
            }
        } else if (actionEvent.getSource() == this.helpButton) {
            if (this.getHelpProvider() == null) {
                return;
            }
            try {
                if (this.getHelpProvider() != null) {
                    this.getHelpProvider().showHelp((Component)this);
                } else if (HelpUtils.getDefaultHelpProvider() != null) {
                    HelpUtils.getDefaultHelpProvider().showHelp((Component)this);
                }
            }
            catch (HelpUnavailableException helpUnavailableException) {}
        } else {
            int n = 0;
            while (n < this.m_printers.length) {
                this.m_printers[n].endPrint();
                ++n;
            }
            this.setVisible(false);
        }
    }

    protected void setCursor(Component component, Cursor cursor) {
        component.setCursor(cursor);
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = 0;
            while (n < container.getComponentCount()) {
                this.setCursor(container.getComponent(n), cursor);
                ++n;
            }
        }
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.updateResourceBundle(locale);
    }

    public String getIntlString(String string) {
        return this.getIntlString(string, this.dvStrings);
    }

    public String getIntlString(String string, ResourceBundle resourceBundle) {
        String string2;
        if (resourceBundle == null) {
            return string;
        }
        try {
            string2 = resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            String string3 = string;
            return string3;
        }
        return string2;
    }

    private void updateResourceBundle(Locale locale) {
        try {
            this.dvStrings = locale != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", locale) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
        }
        catch (MissingResourceException missingResourceException) {
            this.dvStrings = null;
        }
    }

    public void cleanUp() {
        this.helpButton.removeActionListener((ActionListener)this);
        this.helpButton.unregisterKeyboardAction(KeyStroke.getKeyStroke(112, 0));
        this.pgButton.removeActionListener((ActionListener)this);
        this.printButton.removeActionListener((ActionListener)this);
        this.closeButton.removeActionListener((ActionListener)this);
        this.closeButton.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
        this.removeComponentListener(this.m_componentListener);
        this.m_pdp = null;
        this.m_previewPanel.cleanUp();
        this.m_previewPanel = null;
        this.m_printers = null;
        this.pgButton.removeAll();
        this.pgButton = null;
        this.printButton.removeAll();
        this.printButton = null;
        this.closeButton.removeAll();
        this.closeButton = null;
        this.helpButton.removeAll();
        this.helpButton = null;
        this.m_locale = null;
        this.m_strHelpContextID = null;
        this.m_helpProvider = null;
        this.m_componentListener = null;
        this.dvStrings = null;
        this.gp.removeAll();
        this.getContentPane().remove((Component)this.gp);
        this.gp = null;
        this.getContentPane().removeAll();
        this.removeAll();
        super.removeAll();
        super.dispose();
    }
}

