/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.ControllerEvent;
import oracle.dss.dataView.DataviewTitles;
import oracle.dss.dataView.FontAttribute;
import oracle.dss.dataView.GraphAttribute;
import oracle.dss.dataView.GridViewAttribute;
import oracle.dss.dataView.PageItemComponentHandle;
import oracle.dss.dataView.UIDataview;
import oracle.dss.dataView.gui.DataviewTool;
import oracle.dss.dataView.gui.DataviewToolbarRollover;
import oracle.dss.dataView.gui.ToolBar;
import oracle.dss.dataView.managers.ViewStyle;

public class ItalicFontTool
extends JToggleButton
implements DataviewToolbarRollover,
DataviewTool,
ActionListener {
    public static final String PROPERTY_FONT_ITALIC = "FontItalic";
    protected Object m_selectedObject;
    protected ComponentHandle m_selectedComponentHandle;
    protected UIDataview m_currentDataview;
    private static final Insets insets0 = new Insets(0, 0, 0, 0);
    private ResourceBundle rBundle;
    private boolean m_enable = true;
    private MouseListener m_mouseListener;
    protected boolean m_bRolloverIconEnabled;

    public ItalicFontTool() {
        this.setMargin(insets0);
        this.addActionListener(this);
        this.setEnabled(false);
        this.setIcon(this.makeImage("images/italic_18t.gif"));
        this.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())));
        this.setBorderPainted(false);
        this.updateResourceBundle(Locale.getDefault());
        this.setToolTipText(this.rBundle.getString("ItalicFont"));
        if (!(UIManager.getLookAndFeel() instanceof OracleLookAndFeel)) {
            this.setPreferredSize(new Dimension(24, 24));
            this.setMinimumSize(this.getPreferredSize());
            this.setMaximumSize(this.getPreferredSize());
            this.m_mouseListener = new MouseAdapter(){

                public void mouseEntered(MouseEvent mouseEvent) {
                    if (!ItalicFontTool.this.isRolloverIconEnabled()) {
                        ItalicFontTool.this.setBorderPainted(true);
                    }
                    if (!ItalicFontTool.this.isEnabled()) {
                        ItalicFontTool.this.setBorderPainted(ItalicFontTool.this.isSelected());
                    }
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    if (!ItalicFontTool.this.isRolloverIconEnabled()) {
                        ItalicFontTool.this.setBorderPainted(ItalicFontTool.this.isSelected());
                    }
                }
            };
            this.addMouseListener(this.m_mouseListener);
        }
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.updateResourceBundle(locale);
        this.setToolTipText(this.rBundle.getString("ItalicFont"));
    }

    public void selectedAction(ControllerEvent controllerEvent, UIDataview uIDataview, ToolBar toolBar) {
        if (uIDataview == null) {
            return;
        }
        this.m_currentDataview = uIDataview;
        if (controllerEvent == null) {
            return;
        }
        if (controllerEvent.getComponentHandle() == null || this.m_currentDataview instanceof GraphAttribute && controllerEvent.getComponentHandle().getComponent() == null) {
            this.m_selectedObject = null;
            this.m_currentDataview = null;
            this.setEnabled(false);
            return;
        }
        Object object = controllerEvent.getComponentHandle().getComponent();
        this.m_enable = false;
        if (this.isEnabled(controllerEvent.getComponentHandle())) {
            this.m_selectedObject = object;
            this.m_selectedComponentHandle = controllerEvent.getComponentHandle();
            this.setEnabled(true);
            if (this.getFontItalic()) {
                this.setSelected(true);
            } else {
                this.setSelected(false);
            }
            this.setBorderPainted(this.isSelected());
        } else {
            this.setEnabled(false);
            this.m_selectedObject = null;
            this.m_selectedComponentHandle = null;
        }
        this.m_enable = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent == null || !this.m_enable) {
            return;
        }
        if (actionEvent.getSource() == this) {
            this.setFontItalic(this.isSelected());
            if (this.isSelected()) {
                this.setBorderPainted(true);
            } else {
                this.setBorderPainted(false);
            }
        }
    }

    private void updateResourceBundle(Locale locale) {
        this.rBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", locale) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
    }

    public void update() {
    }

    private ImageIcon makeImage(String string) {
        return new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.dataView.gui.ToolBar"), (String)string));
    }

    public void cleanUp() {
        this.removeMouseListener(this.m_mouseListener);
        this.removeActionListener(this);
    }

    public void setRolloverIconEnabled(boolean bl) {
        this.m_bRolloverIconEnabled = bl;
        if (bl) {
            this.setIcon(this.makeImage("images/italic.gif"));
            this.setRolloverIcon(this.makeImage("images/l_italic.gif"));
            this.setRolloverSelectedIcon(this.makeImage("images/l_italic.gif"));
        } else {
            this.setIcon(this.makeImage("images/italic_18t.gif"));
            this.setRolloverIcon(null);
            this.setRolloverSelectedIcon(null);
        }
        this.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())));
    }

    public boolean isRolloverIconEnabled() {
        return this.m_bRolloverIconEnabled;
    }

    private boolean isEnabled(ComponentHandle componentHandle) {
        if (this.m_currentDataview instanceof GridViewAttribute && ((GridViewAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(componentHandle) != null) {
            return true;
        }
        if (this.m_currentDataview instanceof GraphAttribute && componentHandle instanceof PageItemComponentHandle && ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(componentHandle) != null) {
            return true;
        }
        return componentHandle.getComponent() instanceof FontAttribute;
    }

    private boolean getFontItalic() {
        if (this.m_selectedComponentHandle.getID() == 6 || this.m_selectedComponentHandle.getID() == 7 || this.m_selectedComponentHandle.getID() == 8) {
            return ((DataviewTitles)this.m_selectedObject).getFont().isItalic();
        }
        if (this.m_currentDataview instanceof GridViewAttribute) {
            ViewStyle viewStyle = ((GridViewAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle);
            return viewStyle.isFontItalic();
        }
        if (this.m_currentDataview instanceof GraphAttribute && this.m_selectedComponentHandle instanceof PageItemComponentHandle && ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle) != null) {
            ViewStyle viewStyle = ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle);
            return viewStyle.isFontItalic();
        }
        if (this.m_selectedObject instanceof FontAttribute) {
            return ((FontAttribute)this.m_selectedObject).getFont().isItalic();
        }
        return false;
    }

    private void setFontItalic(boolean bl) {
        boolean bl2 = this.getFontItalic();
        if (this.m_selectedComponentHandle.getID() == 6 || this.m_selectedComponentHandle.getID() == 7 || this.m_selectedComponentHandle.getID() == 8) {
            Font font = ((DataviewTitles)this.m_selectedObject).getFont();
            int n = font.getStyle();
            n = bl ? (n |= 2) : (n &= 0xFFFFFFFD);
            ((DataviewTitles)this.m_selectedObject).setFont(new Font(font.getName(), n, font.getSize()));
        } else if (this.m_currentDataview instanceof GridViewAttribute) {
            ViewStyle viewStyle = new ViewStyle();
            viewStyle.setFontItalic(bl);
            ((GridViewAttribute)((Object)this.m_currentDataview)).applyViewStyle(this.m_selectedComponentHandle, viewStyle);
        } else if (this.m_currentDataview instanceof GraphAttribute && this.m_selectedComponentHandle instanceof PageItemComponentHandle && ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle) != null) {
            ViewStyle viewStyle = new ViewStyle();
            viewStyle.setFontItalic(bl);
            ((GraphAttribute)((Object)this.m_currentDataview)).applyViewStyle(this.m_selectedComponentHandle, viewStyle);
        } else if (this.m_selectedObject instanceof FontAttribute) {
            Font font = ((FontAttribute)this.m_selectedObject).getFont();
            int n = font.getStyle();
            n = bl ? (n |= 2) : (n &= 0xFFFFFFFD);
            ((FontAttribute)this.m_selectedObject).setFont(new Font(font.getName(), n, font.getSize()));
        }
        this.firePropertyChange(PROPERTY_FONT_ITALIC, bl2, bl);
    }
}

