/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.ControllerEvent;
import oracle.dss.dataView.DataviewFont;
import oracle.dss.dataView.DataviewFontAttribute;
import oracle.dss.dataView.DataviewTitles;
import oracle.dss.dataView.GraphAttribute;
import oracle.dss.dataView.GridViewAttribute;
import oracle.dss.dataView.PageItemComponentHandle;
import oracle.dss.dataView.UIDataview;
import oracle.dss.dataView.gui.DataviewTool;
import oracle.dss.dataView.gui.DataviewToolbarRollover;
import oracle.dss.dataView.gui.ToolBar;
import oracle.dss.dataView.managers.ViewStyle;

public class FontUnderLineTool
extends JToggleButton
implements DataviewToolbarRollover,
DataviewTool,
ActionListener {
    public static final String PROPERTY_FONT_UNDERLINE = "FontUnderline";
    protected Object m_selectedObject;
    protected ComponentHandle m_selectedComponentHandle;
    protected UIDataview m_currentDataview;
    private static final Insets insets0 = new Insets(0, 0, 0, 0);
    private ResourceBundle rBundle;
    private boolean m_enable = true;
    private MouseListener m_mouseListener;
    protected boolean m_bRolloverIconEnabled;
    public static final int FS_PLAIN = 0;
    public static final int FS_ITALIC = 1;
    public static final int FS_BOLD = 2;
    public static final int FS_ITALIC_BOLD = 3;
    public static final int FS_UNDERLINE = 4;
    public static final int FS_ITALIC_UNDERLINE = 5;
    public static final int FS_BOLD_UNDERLINE = 6;
    public static final int FS_BOLD_ITALIC_UNDERLINE = 7;

    public FontUnderLineTool() {
        this.addActionListener(this);
        this.setEnabled(false);
        this.setIcon(this.makeImage("images/underline_18t.gif"));
        this.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())));
        this.setBorderPainted(false);
        this.updateResourceBundle(Locale.getDefault());
        this.setToolTipText(this.rBundle.getString("FontUnderLine"));
        if (!(UIManager.getLookAndFeel() instanceof OracleLookAndFeel)) {
            this.setPreferredSize(new Dimension(24, 24));
            this.setMinimumSize(this.getPreferredSize());
            this.setMaximumSize(this.getPreferredSize());
            this.m_mouseListener = new MouseAdapter(){

                public void mouseEntered(MouseEvent mouseEvent) {
                    if (!FontUnderLineTool.this.isRolloverIconEnabled()) {
                        FontUnderLineTool.this.setBorderPainted(true);
                    }
                    if (!FontUnderLineTool.this.isEnabled()) {
                        FontUnderLineTool.this.setBorderPainted(FontUnderLineTool.this.isSelected());
                    }
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    if (!FontUnderLineTool.this.isRolloverIconEnabled()) {
                        FontUnderLineTool.this.setBorderPainted(FontUnderLineTool.this.isSelected());
                    }
                }
            };
            this.addMouseListener(this.m_mouseListener);
        }
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.updateResourceBundle(locale);
        this.setToolTipText(this.rBundle.getString("FontUnderLine"));
    }

    public void selectedAction(ControllerEvent controllerEvent, UIDataview uIDataview, ToolBar toolBar) {
        if (uIDataview == null) {
            return;
        }
        this.m_currentDataview = uIDataview;
        if (controllerEvent == null) {
            return;
        }
        if (controllerEvent.getComponentHandle() == null || this.m_currentDataview instanceof GraphAttribute && controllerEvent.getComponentHandle().getComponent() == null) {
            this.m_selectedObject = null;
            this.m_selectedComponentHandle = null;
            this.setEnabled(false);
            return;
        }
        Object object = controllerEvent.getComponentHandle().getComponent();
        this.m_enable = false;
        if (this.isEnabled(controllerEvent.getComponentHandle())) {
            this.m_selectedObject = object;
            this.m_selectedComponentHandle = controllerEvent.getComponentHandle();
            this.setEnabled(true);
            if (this.getFontUnderline()) {
                this.setSelected(true);
            } else {
                this.setSelected(false);
            }
            this.setBorderPainted(this.isSelected());
        } else {
            this.setEnabled(false);
            this.m_selectedObject = null;
            this.m_selectedComponentHandle = null;
        }
        this.m_enable = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent == null || !this.m_enable) {
            return;
        }
        if (actionEvent.getSource() == this) {
            this.setFontUnderline(this.isSelected());
            if (this.isSelected()) {
                this.setBorderPainted(true);
            } else {
                this.setBorderPainted(false);
            }
        }
    }

    private void updateResourceBundle(Locale locale) {
        this.rBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", locale) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
    }

    public void update() {
    }

    private ImageIcon makeImage(String string) {
        return new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.dataView.gui.ToolBar"), (String)string));
    }

    public void cleanUp() {
        this.removeMouseListener(this.m_mouseListener);
        this.removeActionListener(this);
    }

    public void setRolloverIconEnabled(boolean bl) {
        this.m_bRolloverIconEnabled = bl;
        if (bl) {
            this.setIcon(this.makeImage("images/underline.gif"));
            this.setRolloverIcon(this.makeImage("images/l_underline.gif"));
            this.setRolloverSelectedIcon(this.makeImage("images/l_underline.gif"));
        } else {
            this.setIcon(this.makeImage("images/underline_18t.gif"));
            this.setRolloverIcon(null);
            this.setRolloverSelectedIcon(null);
        }
        this.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())));
    }

    public boolean isRolloverIconEnabled() {
        return this.m_bRolloverIconEnabled;
    }

    private boolean isEnabled(ComponentHandle componentHandle) {
        if (componentHandle.getID() == 6 || componentHandle.getID() == 7 || componentHandle.getID() == 8) {
            return true;
        }
        if (this.m_currentDataview instanceof GridViewAttribute && ((GridViewAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(componentHandle) != null) {
            return true;
        }
        if (this.m_currentDataview instanceof GraphAttribute && componentHandle instanceof PageItemComponentHandle && ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(componentHandle) != null) {
            return true;
        }
        return componentHandle.getComponent() instanceof DataviewFontAttribute && this.isEnabled();
    }

    private boolean getFontUnderline() {
        if (this.m_selectedComponentHandle.getID() == 6 || this.m_selectedComponentHandle.getID() == 7 || this.m_selectedComponentHandle.getID() == 8) {
            return ((DataviewTitles)this.m_selectedObject).isUnderline();
        }
        if (this.m_currentDataview instanceof GridViewAttribute) {
            ViewStyle viewStyle = ((GridViewAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle);
            return viewStyle.isUnderline();
        }
        if (this.m_currentDataview instanceof GraphAttribute && this.m_selectedComponentHandle instanceof PageItemComponentHandle && ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle) != null) {
            ViewStyle viewStyle = ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle);
            return viewStyle.isUnderline();
        }
        if (this.m_selectedObject instanceof DataviewFontAttribute) {
            int n = ((DataviewFontAttribute)this.m_selectedObject).getDataviewFont().getGraphFontStyle();
            if (n == 4) {
                return true;
            }
            if (n == 5) {
                return true;
            }
            if (n == 6) {
                return true;
            }
            if (n == 7) {
                return true;
            }
        }
        return false;
    }

    private void setFontUnderline(boolean bl) {
        boolean bl2 = this.getFontUnderline();
        if (this.m_selectedComponentHandle.getID() == 6 || this.m_selectedComponentHandle.getID() == 7 || this.m_selectedComponentHandle.getID() == 8) {
            ((DataviewTitles)this.m_selectedObject).setUnderline(bl);
        } else if (this.m_currentDataview instanceof GridViewAttribute) {
            ViewStyle viewStyle = new ViewStyle();
            viewStyle.setUnderline(bl);
            ((GridViewAttribute)((Object)this.m_currentDataview)).applyViewStyle(this.m_selectedComponentHandle, viewStyle);
        } else if (this.m_currentDataview instanceof GraphAttribute && this.m_selectedComponentHandle instanceof PageItemComponentHandle && ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle) != null) {
            ViewStyle viewStyle = new ViewStyle();
            viewStyle.setUnderline(bl);
            ((GraphAttribute)((Object)this.m_currentDataview)).applyViewStyle(this.m_selectedComponentHandle, viewStyle);
        } else if (this.m_selectedObject instanceof DataviewFontAttribute) {
            DataviewFont dataviewFont = ((DataviewFontAttribute)this.m_selectedObject).getDataviewFont();
            int n = dataviewFont.getGraphFontStyle();
            if (bl) {
                if (n == 0) {
                    dataviewFont.setGraphFontStyle(4);
                }
                if (n == 1) {
                    dataviewFont.setGraphFontStyle(5);
                }
                if (n == 2) {
                    dataviewFont.setGraphFontStyle(6);
                }
                if (n == 3) {
                    dataviewFont.setGraphFontStyle(7);
                }
            } else {
                if (n == 4) {
                    dataviewFont.setGraphFontStyle(0);
                }
                if (n == 5) {
                    dataviewFont.setGraphFontStyle(1);
                }
                if (n == 6) {
                    dataviewFont.setGraphFontStyle(2);
                }
                if (n == 7) {
                    dataviewFont.setGraphFontStyle(3);
                }
            }
        } else {
            return;
        }
        this.firePropertyChange(PROPERTY_FONT_UNDERLINE, bl2, bl);
    }
}

