/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.dss.dataView.Background;
import oracle.dss.dataView.ColumnComponentHandle;
import oracle.dss.dataView.ColumnRangeComponentHandle;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.ControllerEvent;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.dataView.DataRangeComponentHandle;
import oracle.dss.dataView.DataviewFontAttribute;
import oracle.dss.dataView.DataviewTitles;
import oracle.dss.dataView.GraphAttribute;
import oracle.dss.dataView.GridViewAttribute;
import oracle.dss.dataView.PageItemComponentHandle;
import oracle.dss.dataView.RowComponentHandle;
import oracle.dss.dataView.RowRangeComponentHandle;
import oracle.dss.dataView.SeriesComponentHandle;
import oracle.dss.dataView.UIDataview;
import oracle.dss.dataView.UIFillColor;
import oracle.dss.dataView.UIParetoLine;
import oracle.dss.dataView.UISeriesColor;
import oracle.dss.dataView.UIStockMarker;
import oracle.dss.dataView.UITransparentFillColor;
import oracle.dss.dataView.gui.DataviewTool;
import oracle.dss.dataView.gui.DataviewToolbarRollover;
import oracle.dss.dataView.gui.ToolBar;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.util.SeriesOutOfRangeException;
import oracle.dss.util.gui.BIColorChoice;
import oracle.dss.util.gui.FontButton;

public class FillColorTool
extends JToolBar
implements DataviewToolbarRollover,
DataviewTool,
PropertyChangeListener {
    public static final String PROPERTY_FILL_COLOR = "FillColor";
    protected Object m_selectedObject;
    int m_selectedSeries;
    int m_selectedGroup;
    protected ComponentHandle m_selectedComponentHandle;
    protected UIDataview m_currentDataview;
    protected boolean m_colorPaletteSet;
    protected NewColorChoice1 m_fillColor = new NewColorChoice1();
    private Image m_fillColorImage;
    protected boolean m_bRolloverIconEnabled;
    private MouseListener m_mouseListener;
    private ResourceBundle rBundle;
    protected boolean m_enable = true;
    protected Color m_flColor;
    protected boolean m_bPause;
    private boolean m_bSuperCalled = true;

    public FillColorTool() {
        this.m_fillColor.setSelectedColor(new Color(153, 153, 153));
        this.m_fillColor.updateIconColor();
        this.m_fillColor.addPropertyChangeListener(this);
        this.m_fillColor.setEnabled(false);
        this.add((Component)((Object)this.m_fillColor));
        this.setBorder(null);
        this.m_fillColor.setBorderPainted(false);
        this.updateResourceBundle(Locale.getDefault());
        this.m_fillColor.setToolTipText(this.rBundle.getString(PROPERTY_FILL_COLOR));
        this.m_fillColor.getAccessibleContext().setAccessibleName(this.rBundle.getString("FillColorButton"));
        if (!(UIManager.getLookAndFeel() instanceof OracleLookAndFeel)) {
            if (this.m_fillColor.getBorder() != null && this.m_fillColor.getBorder() instanceof CompoundBorder) {
                this.m_fillColor.setBorder(new CompoundBorder(((CompoundBorder)this.m_fillColor.getBorder()).getOutsideBorder(), null));
            }
            this.m_fillColor.setPreferredSize(new Dimension(this.m_fillColor.getPreferredSize().width, 24));
            this.m_mouseListener = new MouseAdapter(){

                public void mouseEntered(MouseEvent mouseEvent) {
                    if (!FillColorTool.this.isRolloverIconEnabled()) {
                        FillColorTool.this.m_fillColor.setBorderPainted(true);
                    }
                    if (!FillColorTool.this.m_fillColor.isEnabled()) {
                        FillColorTool.this.m_fillColor.setBorderPainted(FillColorTool.this.m_fillColor.isSelected());
                    }
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    if (!FillColorTool.this.isRolloverIconEnabled()) {
                        FillColorTool.this.m_fillColor.setBorderPainted(FillColorTool.this.m_fillColor.isSelected());
                    }
                }
            };
            this.m_fillColor.addMouseListener(this.m_mouseListener);
        }
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updateResourceBundle(locale);
        this.m_fillColor.setToolTipText(this.rBundle.getString(PROPERTY_FILL_COLOR));
        this.m_fillColor.getAccessibleContext().setAccessibleName(this.rBundle.getString("FillColorButton"));
        this.m_fillColor.setLocale(locale);
    }

    public void setColorPalette(TwoDModel twoDModel) {
        this.m_colorPaletteSet = twoDModel != null;
        this.m_bPause = true;
        if (this.m_flColor == null) {
            this.m_fillColor.setSelectedColor((Color)this.m_fillColor.getColorPalette().getData(0, 0));
        }
        if (this.m_flColor != null) {
            Color color = new Color(this.m_flColor.getRGB());
            this.m_fillColor.setSelectedColor((Color)this.m_fillColor.getColorPalette().getData(0, 0));
            this.m_fillColor.setColorPalette(twoDModel);
            if (!this.m_colorPaletteSet) {
                if (!NewColorChoice1.isColorInPalette((TwoDModel)this.m_fillColor.getColorPalette(), (Color)color)) {
                    this.m_fillColor.setColorPalette(FontButton.getNewColorPalette(this.m_fillColor.getColorPalette(), color, this.m_colorPaletteSet));
                }
                this.m_fillColor.setSelectedColor(color);
            } else {
                this.m_fillColor.setSelectedColor(this.m_fillColor.getClosestColor(color));
            }
        } else {
            this.m_fillColor.setColorPalette(twoDModel);
            this.m_fillColor.setSelectedColor(null);
        }
        this.m_bPause = false;
    }

    public TwoDModel getColorPalette() {
        return this.m_fillColor.getColorPalette();
    }

    public void selectedAction(ControllerEvent controllerEvent, UIDataview uIDataview, ToolBar toolBar) {
        Object object = null;
        int n = 0;
        if (controllerEvent == null) {
            return;
        }
        if (uIDataview == null) {
            return;
        }
        this.m_currentDataview = uIDataview;
        this.m_fillColor.setCustomColorsEnabled(uIDataview.isCustomColorsEnabled());
        this.m_selectedComponentHandle = controllerEvent.getComponentHandle();
        if (this.m_selectedComponentHandle == null) {
            this.m_selectedObject = null;
            this.m_fillColor.setEnabled(false);
            return;
        }
        this.m_enable = false;
        this.m_fillColor.setLocale(uIDataview.getLocale());
        if (controllerEvent.getComponentHandle().getComponent() != null && (controllerEvent.getComponentHandle().getID() == 6 || controllerEvent.getComponentHandle().getID() == 7 || controllerEvent.getComponentHandle().getID() == 8)) {
            this.m_selectedObject = controllerEvent.getComponentHandle().getComponent();
            Color color = ((DataviewTitles)this.m_selectedObject).getBackground();
            if (!this.m_colorPaletteSet) {
                if (!NewColorChoice1.isColorInPalette((TwoDModel)this.m_fillColor.getColorPalette(), (Color)color)) {
                    this.m_fillColor.setColorPalette(FontButton.getNewColorPalette(this.m_fillColor.getColorPalette(), color, this.m_colorPaletteSet));
                }
                this.m_fillColor.setSelectedColor(color);
            } else {
                this.m_fillColor.setSelectedColor(this.m_fillColor.getClosestColor(color));
            }
            this.m_flColor = color;
            this.m_fillColor.setEnabled(true);
            this.m_fillColor.updateIconColor();
            this.m_enable = true;
            return;
        }
        if (uIDataview instanceof GridViewAttribute) {
            ViewStyle viewStyle = ((GridViewAttribute)((Object)uIDataview)).getComponentViewStyle(controllerEvent.getComponentHandle());
            if (viewStyle != null) {
                this.m_selectedObject = controllerEvent.getComponentHandle().getComponent();
                if (viewStyle.getBackground() != null) {
                    Color color = viewStyle.getBackground();
                    if (!this.m_colorPaletteSet) {
                        if (!NewColorChoice1.isColorInPalette((TwoDModel)this.m_fillColor.getColorPalette(), (Color)color)) {
                            this.m_fillColor.setColorPalette(FontButton.getNewColorPalette(this.m_fillColor.getColorPalette(), color, this.m_colorPaletteSet));
                        }
                        this.m_fillColor.setSelectedColor(color);
                    } else {
                        this.m_fillColor.setSelectedColor(this.m_fillColor.getClosestColor(color));
                    }
                    this.m_flColor = color;
                } else {
                    this.m_fillColor.setSelectedColor(null);
                    this.m_flColor = null;
                }
                this.m_fillColor.setEnabled(true);
                this.m_fillColor.updateIconColor();
                if (controllerEvent.getComponentHandle() instanceof DataComponentHandle || controllerEvent.getComponentHandle() instanceof DataRangeComponentHandle || controllerEvent.getComponentHandle() instanceof RowComponentHandle || controllerEvent.getComponentHandle() instanceof RowRangeComponentHandle || controllerEvent.getComponentHandle() instanceof ColumnComponentHandle || controllerEvent.getComponentHandle() instanceof ColumnRangeComponentHandle) {
                    this.m_fillColor.setTransparentAllowed(true);
                } else {
                    this.m_fillColor.setTransparentAllowed(false);
                }
                this.m_enable = true;
            }
            return;
        }
        if (uIDataview instanceof GraphAttribute && this.m_selectedComponentHandle instanceof PageItemComponentHandle) {
            ViewStyle viewStyle = ((GraphAttribute)((Object)uIDataview)).getComponentViewStyle(this.m_selectedComponentHandle);
            if (viewStyle != null) {
                this.m_selectedObject = controllerEvent.getComponentHandle().getComponent();
                Color color = viewStyle.getBackground();
                if (color != null) {
                    if (!this.m_colorPaletteSet) {
                        if (!NewColorChoice1.isColorInPalette((TwoDModel)this.m_fillColor.getColorPalette(), (Color)color)) {
                            this.m_fillColor.setColorPalette(FontButton.getNewColorPalette(this.m_fillColor.getColorPalette(), color, this.m_colorPaletteSet));
                        }
                        this.m_fillColor.setSelectedColor(color);
                    } else {
                        this.m_fillColor.setSelectedColor(this.m_fillColor.getClosestColor(color));
                    }
                    this.m_flColor = color;
                } else {
                    this.m_fillColor.setSelectedColor(null);
                    this.m_flColor = null;
                }
                this.m_fillColor.setEnabled(true);
                this.m_fillColor.updateIconColor();
                if (this.m_selectedComponentHandle instanceof DataComponentHandle || this.m_selectedComponentHandle instanceof DataRangeComponentHandle || this.m_selectedComponentHandle instanceof RowComponentHandle || this.m_selectedComponentHandle instanceof RowRangeComponentHandle || this.m_selectedComponentHandle instanceof ColumnComponentHandle || this.m_selectedComponentHandle instanceof ColumnRangeComponentHandle) {
                    this.m_fillColor.setTransparentAllowed(true);
                } else {
                    this.m_fillColor.setTransparentAllowed(false);
                }
                this.m_enable = true;
            }
            return;
        }
        if (!this.isEnabled()) {
            this.m_fillColor.setEnabled(false);
            return;
        }
        object = controllerEvent.getComponentHandle().getComponent();
        if (object == null) {
            this.m_fillColor.setEnabled(false);
            return;
        }
        if (object instanceof UIFillColor) {
            this.m_selectedObject = object;
            if (this.m_selectedObject instanceof UITransparentFillColor && ((UITransparentFillColor)this.m_selectedObject).isFillTransparent()) {
                this.m_fillColor.setSelectedColor(null);
            } else {
                Color color = ((UIFillColor)this.m_selectedObject).getFillColor();
                try {
                    if (!this.m_colorPaletteSet) {
                        if (!NewColorChoice1.isColorInPalette((TwoDModel)this.m_fillColor.getColorPalette(), (Color)color)) {
                            this.m_fillColor.setColorPalette(FontButton.getNewColorPalette(this.m_fillColor.getColorPalette(), color, this.m_colorPaletteSet));
                        }
                        this.m_fillColor.setSelectedColor(color);
                    } else {
                        this.m_fillColor.setSelectedColor(this.m_fillColor.getClosestColor(color));
                    }
                    this.m_flColor = color;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            this.m_fillColor.setEnabled(true);
            if (object instanceof UITransparentFillColor) {
                this.m_fillColor.setTransparentAllowed(true);
            } else {
                this.m_fillColor.setTransparentAllowed(false);
            }
            this.m_fillColor.updateIconColor();
            this.m_enable = true;
            return;
        }
        if (this.m_selectedComponentHandle instanceof DataComponentHandle && ((DataComponentHandle)this.m_selectedComponentHandle).isSeriesComponent()) {
            n = ((DataComponentHandle)this.m_selectedComponentHandle).getSeries();
            object = ((GraphAttribute)((Object)uIDataview)).getUISeriesColor();
            n %= ((GraphAttribute)((Object)uIDataview)).getSeriesObjectCount();
        } else if (this.m_selectedComponentHandle instanceof SeriesComponentHandle && !(this.m_selectedComponentHandle.getComponent() instanceof DataviewFontAttribute)) {
            n = ((SeriesComponentHandle)this.m_selectedComponentHandle).getSeries();
            object = ((GraphAttribute)((Object)uIDataview)).getUISeriesColor();
            n %= ((GraphAttribute)((Object)uIDataview)).getSeriesObjectCount();
        } else {
            object = controllerEvent.getComponentHandle().getComponent();
        }
        if (object instanceof Background) {
            this.m_selectedObject = object;
            Color color = ((Background)this.m_selectedObject).getBackground();
            if (!this.m_colorPaletteSet) {
                if (!NewColorChoice1.isColorInPalette((TwoDModel)this.m_fillColor.getColorPalette(), (Color)color)) {
                    this.m_fillColor.setColorPalette(FontButton.getNewColorPalette(this.m_fillColor.getColorPalette(), color, this.m_colorPaletteSet));
                }
                this.m_fillColor.setSelectedColor(color);
            } else {
                this.m_fillColor.setSelectedColor(this.m_fillColor.getClosestColor(color));
            }
            this.m_flColor = color;
            this.m_fillColor.setEnabled(true);
            this.m_fillColor.updateIconColor();
            this.m_fillColor.setTransparentAllowed(false);
            this.m_enable = true;
            return;
        }
        Object object2 = controllerEvent.getComponentHandle().getComponent();
        if (object2 instanceof UIStockMarker) {
            this.m_selectedGroup = ((DataComponentHandle)this.m_selectedComponentHandle).getGroup();
            if (((UIStockMarker)object2).getStockMarkerType(this.m_selectedSeries, this.m_selectedGroup) != 3) {
                this.m_selectedObject = object2;
                this.m_selectedSeries = n;
                Color color = null;
                if (((UIStockMarker)this.m_selectedObject).getStockMarkerType(this.m_selectedSeries, this.m_selectedGroup) == 1) {
                    color = ((UIStockMarker)this.m_selectedObject).getRisingColor();
                } else if (((UIStockMarker)this.m_selectedObject).getStockMarkerType(this.m_selectedSeries, this.m_selectedGroup) == 0) {
                    color = ((UIStockMarker)this.m_selectedObject).getFallingColor();
                } else {
                    this.m_fillColor.setEnabled(false);
                    return;
                }
                try {
                    if (!this.m_colorPaletteSet) {
                        if (!NewColorChoice1.isColorInPalette((TwoDModel)this.m_fillColor.getColorPalette(), (Color)color)) {
                            this.m_fillColor.setColorPalette(FontButton.getNewColorPalette(this.m_fillColor.getColorPalette(), color, this.m_colorPaletteSet));
                        }
                        this.m_fillColor.setSelectedColor(color);
                    } else {
                        this.m_fillColor.setSelectedColor(this.m_fillColor.getClosestColor(color));
                    }
                    this.m_flColor = color;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                this.m_fillColor.setEnabled(true);
                this.m_enable = true;
                this.m_fillColor.updateIconColor();
                return;
            }
        }
        if (object2 instanceof UIParetoLine) {
            this.m_selectedObject = object2;
            Color color = ((UIParetoLine)this.m_selectedObject).getColor();
            try {
                if (!this.m_colorPaletteSet) {
                    if (!NewColorChoice1.isColorInPalette((TwoDModel)this.m_fillColor.getColorPalette(), (Color)color)) {
                        this.m_fillColor.setColorPalette(FontButton.getNewColorPalette(this.m_fillColor.getColorPalette(), color, this.m_colorPaletteSet));
                    }
                    this.m_fillColor.setSelectedColor(color);
                } else {
                    this.m_fillColor.setSelectedColor(this.m_fillColor.getClosestColor(color));
                }
                this.m_flColor = color;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.m_fillColor.setEnabled(true);
            this.m_enable = true;
            this.m_fillColor.updateIconColor();
            return;
        }
        if (object instanceof UISeriesColor) {
            this.m_selectedObject = object;
            this.m_selectedSeries = n;
            try {
                Color color = ((UISeriesColor)this.m_selectedObject).getColor(this.m_selectedSeries);
                if (color != null) {
                    this.m_fillColor.setTransparentAllowed(false);
                    if (!this.m_colorPaletteSet) {
                        if (!NewColorChoice1.isColorInPalette((TwoDModel)this.m_fillColor.getColorPalette(), (Color)color)) {
                            this.m_fillColor.setColorPalette(FontButton.getNewColorPalette(this.m_fillColor.getColorPalette(), color, this.m_colorPaletteSet));
                        }
                        this.m_fillColor.setSelectedColor(color);
                    } else {
                        this.m_fillColor.setSelectedColor(this.m_fillColor.getClosestColor(color));
                    }
                    this.m_flColor = color;
                    this.m_fillColor.updateIconColor();
                } else {
                    this.m_fillColor.setSelectedColor(null);
                    this.m_fillColor.setTransparentAllowed(true);
                }
            }
            catch (SeriesOutOfRangeException seriesOutOfRangeException) {
                // empty catch block
            }
            this.m_fillColor.setEnabled(true);
            this.m_enable = true;
            return;
        }
        this.m_fillColor.setEnabled(false);
        this.m_selectedObject = null;
        this.m_selectedComponentHandle = null;
        this.m_selectedSeries = 0;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.m_bPause) {
            return;
        }
        if (propertyChangeEvent == null || !this.m_enable) {
            return;
        }
        if (!propertyChangeEvent.getSource().equals((Object)this.m_fillColor) || !propertyChangeEvent.getPropertyName().equals("selectedColor")) {
            return;
        }
        if (this.m_currentDataview instanceof GraphAttribute && this.m_selectedObject == null) {
            return;
        }
        if (this.m_selectedComponentHandle != null && (this.m_selectedComponentHandle.getID() == 6 || this.m_selectedComponentHandle.getID() == 7 || this.m_selectedComponentHandle.getID() == 8)) {
            ((DataviewTitles)this.m_selectedObject).setBackground(this.m_fillColor.getSelectedColor());
            this.m_fillColor.updateIconColor();
            this.firePropertyChange(PROPERTY_FILL_COLOR, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            return;
        }
        if (this.m_currentDataview instanceof GridViewAttribute) {
            ViewStyle viewStyle = new ViewStyle();
            viewStyle.setBackground(this.m_fillColor.getSelectedColor());
            ((GridViewAttribute)((Object)this.m_currentDataview)).applyViewStyle(this.m_selectedComponentHandle, viewStyle);
            this.m_fillColor.updateIconColor();
            this.firePropertyChange(PROPERTY_FILL_COLOR, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            return;
        }
        if (this.m_currentDataview instanceof GraphAttribute && this.m_selectedComponentHandle instanceof PageItemComponentHandle) {
            ViewStyle viewStyle = new ViewStyle();
            viewStyle.setBackground(this.m_fillColor.getSelectedColor());
            ((GraphAttribute)((Object)this.m_currentDataview)).applyViewStyle(this.m_selectedComponentHandle, viewStyle);
            this.m_fillColor.updateIconColor();
            this.firePropertyChange(PROPERTY_FILL_COLOR, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            return;
        }
        if (this.m_selectedObject instanceof UIStockMarker) {
            if (((UIStockMarker)this.m_selectedObject).getStockMarkerType(this.m_selectedSeries, this.m_selectedGroup) == 0) {
                ((UIStockMarker)this.m_selectedObject).setFallingColor(this.m_fillColor.getSelectedColor());
            } else if (((UIStockMarker)this.m_selectedObject).getStockMarkerType(this.m_selectedSeries, this.m_selectedGroup) == 1) {
                ((UIStockMarker)this.m_selectedObject).setRisingColor(this.m_fillColor.getSelectedColor());
            }
            this.m_fillColor.updateIconColor();
        } else if (this.m_selectedObject instanceof UIParetoLine) {
            ((UIParetoLine)this.m_selectedObject).setColor(this.m_fillColor.getSelectedColor());
            this.m_fillColor.updateIconColor();
            this.firePropertyChange(PROPERTY_FILL_COLOR, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        } else if (this.m_selectedObject instanceof UISeriesColor) {
            try {
                ((UISeriesColor)this.m_selectedObject).setColor(this.m_fillColor.getSelectedColor(), this.m_selectedSeries);
                this.m_fillColor.updateIconColor();
                if (this.m_fillColor.getSelectedColor() != null) {
                    this.m_fillColor.setTransparentAllowed(false);
                }
            }
            catch (SeriesOutOfRangeException seriesOutOfRangeException) {}
        } else if (this.m_selectedObject instanceof Background) {
            ((Background)this.m_selectedObject).setBackground(this.m_fillColor.getSelectedColor());
            this.m_fillColor.updateIconColor();
        } else if (this.m_selectedObject instanceof UIFillColor) {
            if (this.m_fillColor.getSelectedColor() == null && this.m_selectedObject instanceof UITransparentFillColor) {
                ((UITransparentFillColor)this.m_selectedObject).setFillTransparent(true);
            } else {
                ((UIFillColor)this.m_selectedObject).setFillColor(this.m_fillColor.getSelectedColor());
            }
            this.m_fillColor.updateIconColor();
        } else {
            return;
        }
        this.firePropertyChange(PROPERTY_FILL_COLOR, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
    }

    public void update() {
        this.m_fillColor.setEnabled(this.isEnabled() && this.m_fillColor.isEnabled());
    }

    private void updateResourceBundle(Locale locale) {
        this.rBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", locale) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
    }

    public void cleanUp() {
        this.m_fillColor.dispose();
        this.m_fillColor.removeMouseListener(this.m_mouseListener);
        this.m_fillColor.removePropertyChangeListener(this);
        this.remove((Component)((Object)this.m_fillColor));
        this.m_fillColor._filter = null;
        this.m_fillColor = null;
        this.rBundle = null;
    }

    public void setRolloverIconEnabled(boolean bl) {
        this.m_bRolloverIconEnabled = bl;
        if (bl) {
            this.m_fillColor.updateIconColor();
        } else {
            this.m_fillColor.setIcon(this.m_fillColor.getColorIcon());
            this.m_fillColor.setRolloverIcon(null);
            this.m_fillColor.setRolloverSelectedIcon(null);
        }
    }

    public boolean isRolloverIconEnabled() {
        return this.m_bRolloverIconEnabled;
    }

    private ImageIcon makeImage(String string) {
        return new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.dataView.gui.ToolBar"), (String)string));
    }

    class Filter_Fill
    extends RGBImageFilter {
        private int _color;
        private int _sCOLOR = new Color(0, 153, 153).getRGB();

        public Filter_Fill() {
            this.canFilterIndexColorModel = true;
        }

        public void setColor(Color color) {
            this._color = color == null ? 0 : color.getRGB();
        }

        public int filterRGB(int n, int n2, int n3) {
            if (n3 == this._sCOLOR) {
                return this._color;
            }
            return n3;
        }
    }

    class NewColorChoice1
    extends BIColorChoice {
        Image image;
        private Image m_fontColorImage;
        private Image m_fontColorImage1;
        private String imageName;
        protected Image newImage;
        protected Filter_Fill _filter = null.new Filter_Fill();
        protected Filter_Fill _filter1 = null.new Filter_Fill();

        NewColorChoice1() {
        }

        protected void updateIconColor() {
            this.setIcon(this.getColorIcon());
            this.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())));
            if (this.getSelectedColor() != null) {
                this._filter1.setColor(this.getSelectedColor());
                Object var1_1 = null;
                this.m_fontColorImage1 = ImageUtils.getImageResource(Class.forName("oracle.dss.dataView.gui.FillColorTool$Filter_Fill"), (String)"images/l_fillcolorwitharrow.gif");
                FilteredImageSource filteredImageSource = new FilteredImageSource(this.m_fontColorImage1.getSource(), this._filter1);
                this.newImage = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
                if (FillColorTool.this.isRolloverIconEnabled()) {
                    this.setRolloverIcon(new ImageIcon(this.newImage));
                    this.setRolloverSelectedIcon(new ImageIcon(this.newImage));
                }
            } else if (FillColorTool.this.isRolloverIconEnabled()) {
                this.setRolloverIcon(new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.dataView.gui.FillColorTool$Filter_Fill"), (String)"images/l_transparent.gif")));
                this.setRolloverSelectedIcon(this.getRolloverIcon());
            }
        }

        protected Icon getColorIcon() {
            if (this.getSelectedColor() == null) {
                if (FillColorTool.this.isRolloverIconEnabled()) {
                    return new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.dataView.gui.FillColorTool$NewColorChoice1"), (String)"images/transparent_24t.gif"));
                }
                return new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.dataView.gui.FillColorTool$NewColorChoice1"), (String)"images/transparent_18t.gif"));
            }
            this._filter.setColor(this.getSelectedColor());
            Image image = null;
            String string = FillColorTool.this.isRolloverIconEnabled() ? "images/fillcolorwitharrow.gif" : "images/fillcolorwitharrow_18t.gif";
            if (this.imageName != string || this.m_fontColorImage == null) {
                this.m_fontColorImage = ImageUtils.getImageResource(Class.forName("oracle.dss.dataView.gui.FillColorTool$NewColorChoice1"), (String)string);
                this.imageName = string;
            }
            image = this.m_fontColorImage;
            FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), this._filter);
            this.newImage = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
            return new ImageIcon(this.newImage);
        }

        public Icon getDisabledIcon() {
            if (this.getSelectedColor() == null) {
                if (FillColorTool.this.isRolloverIconEnabled()) {
                    return new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.dataView.gui.FillColorTool$NewColorChoice1"), (String)"images/transparent_disabled_24.gif"));
                }
                return new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.dataView.gui.FillColorTool$NewColorChoice1"), (String)"images/transparent_disabled_18.gif"));
            }
            this._filter.setColor(new Color(153, 153, 153));
            Image image = null;
            image = this.m_fontColorImage;
            FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), this._filter);
            this.newImage = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
            return new ImageIcon(this.newImage);
        }

        private ImageIcon makeImage(String string) {
            return new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.dataView.gui.FontColorTool"), (String)string));
        }
    }
}

