/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.datacache;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.dss.dataView.ViewFormatHandle;
import oracle.dss.dataView.ViewStyleHandle;
import oracle.dss.util.AbstractMap;
import oracle.dss.util.xml.BaseObjectNode;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.NoSuchPropertyException;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class Map {
    private String m_nodeName;
    private AbstractMap m_map;
    private AbstractMap m_expectedMap;
    private Hashtable m_readMap;
    public static final String ENTRY = "Entry";
    public static final String ID = "id";
    public static final String PARAM = "a";
    public static final String TYPE = "type";

    public Map(String string, AbstractMap abstractMap) {
        this(string, null, abstractMap);
    }

    public Map(String string, AbstractMap abstractMap, AbstractMap abstractMap2) {
        this.m_nodeName = string;
        this.m_map = abstractMap;
        this.m_expectedMap = abstractMap2;
    }

    public void setExpectedMap(AbstractMap abstractMap) {
        this.m_expectedMap = abstractMap;
    }

    public AbstractMap getExpectedMap() {
        return this.m_expectedMap;
    }

    public AbstractMap getSupportedMap() {
        return this.m_map;
    }

    public void setSupportedMap(AbstractMap abstractMap) {
        this.m_map = (AbstractMap)this.m_expectedMap.clone();
        Enumeration enumeration = this.m_map.types();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (abstractMap.containsType(string) != -1) continue;
            this.m_map.removeType(string);
        }
    }

    private void clear() {
        this.m_readMap = new Hashtable();
        try {
            this.m_map = (AbstractMap)this.m_expectedMap.getClass().newInstance();
        }
        catch (Exception exception) {
            this.m_map = null;
        }
    }

    public void readMapFromXML(ObjectNode objectNode) {
        this.clear();
        ContainerNode containerNode = objectNode.getContainer(this.m_nodeName);
        if (containerNode == null) {
            return;
        }
        Enumeration enumeration = containerNode.getContainedObject(ENTRY);
        while (enumeration.hasMoreElements()) {
            ObjectNode objectNode2 = (ObjectNode)enumeration.nextElement();
            try {
                int n = objectNode2.getPropertyValueAsInteger(ID);
                String string = objectNode2.getPropertyValueAsString(TYPE);
                if (n < 0) continue;
                this.m_map.addType(string);
                this.m_readMap.put(string, this.getParamName(n));
            }
            catch (NoSuchPropertyException noSuchPropertyException) {
                // empty catch block
            }
        }
    }

    public void addMapToXML(ObjectNode objectNode) {
        ContainerNode containerNode = new ContainerNode(this.m_nodeName);
        Enumeration enumeration = this.getSupportedMap().types();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ObjectNode objectNode2 = new ObjectNode(ENTRY);
            objectNode2.addProperty(ID, n++);
            objectNode2.addProperty(TYPE, string);
            containerNode.addContainedObject(objectNode2);
        }
        objectNode.addContainer(containerNode);
    }

    public Object readDataFromXML(BaseObjectNode baseObjectNode, String string) {
        String string2 = (String)this.m_readMap.get(string);
        if (string2 == null) {
            return null;
        }
        Object object = null;
        if ((string.equals("dataViewStyle") || string.equals("viewStyle") || string.equals("viewStyle")) && baseObjectNode instanceof ObjectNode) {
            ObjectNode objectNode = ((ObjectNode)baseObjectNode).getPropertyValueAsObjectNode(string2, true);
            if (objectNode != null) {
                ViewStyleHandle viewStyleHandle = new ViewStyleHandle();
                viewStyleHandle.setXML(objectNode);
                object = viewStyleHandle;
            }
        } else if (string.equals("dataViewFormat") && baseObjectNode instanceof ObjectNode) {
            ObjectNode objectNode = ((ObjectNode)baseObjectNode).getPropertyValueAsObjectNode(string2, true);
            if (objectNode != null) {
                ViewFormatHandle viewFormatHandle = new ViewFormatHandle();
                viewFormatHandle.setXML(objectNode);
                object = viewFormatHandle;
            }
        } else {
            PropertyNode propertyNode = baseObjectNode.getProperty(string2);
            if (propertyNode != null) {
                object = propertyNode.getValueAsString();
            }
        }
        return object;
    }

    public Enumeration types() {
        return this.getSupportedMap().types();
    }

    public void addDataToXML(BaseObjectNode baseObjectNode, String string, Object object) {
        if (object == null) {
            return;
        }
        int n = this.getSupportedMap().indexOf(string);
        if (n < 0) {
            return;
        }
        if ((string.equals("dataViewStyle") || string.equals("viewStyle") || string.equals("viewStyle")) && baseObjectNode instanceof ObjectNode && object instanceof ViewStyleHandle) {
            ObjectNode objectNode = ((ViewStyleHandle)object).getXML(this.getParamName(n), false);
            if (objectNode != null) {
                ((ObjectNode)baseObjectNode).addProperty(objectNode);
            }
        } else if (string.equals("dataViewFormat") && baseObjectNode instanceof ObjectNode && object instanceof ViewFormatHandle) {
            ObjectNode objectNode = ((ViewFormatHandle)object).getXML(this.getParamName(n), false);
            if (objectNode != null) {
                ((ObjectNode)baseObjectNode).addProperty(objectNode);
            }
        } else {
            baseObjectNode.addProperty(this.getParamName(n), object.toString());
        }
    }

    private String getParamName(int n) {
        return String.valueOf(String.valueOf(PARAM)) + String.valueOf(n);
    }
}

