/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.Locale;
import java.util.Vector;
import netscape.security.PrivilegeManager;
import oracle.bali.ewt.util.WindowUtils;
import oracle.dss.dataView.BaseTitle;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.CustomHeaderAndFooterCallback;
import oracle.dss.dataView.DataSubsetRecord;
import oracle.dss.dataView.Dataview;
import oracle.dss.dataView.Footnote;
import oracle.dss.dataView.HeaderAndFooterPainter;
import oracle.dss.dataView.PaginationRecord;
import oracle.dss.dataView.Subtitle;
import oracle.dss.dataView.Title;
import oracle.dss.dataView.TokenSubstitution;
import oracle.dss.dataView.TokenSubstitutionAdapter;
import oracle.dss.dataView.UIViewPrinter;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataDirectorException;
import oracle.dss.util.DataException;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.FormattedText;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;

public abstract class ViewPrinter
implements Printable,
UIViewPrinter {
    public static final int CURRENT_LOGICAL_PAGE = 0;
    public static final int ALL_LOGICAL_PAGES = 1;
    public static final int SELECTED_LOGICAL_PAGES = 2;
    public static final int ORIGINAL_SIZE = 0;
    public static final int SCALE_TO_ZOOM_FACTOR = 1;
    public static final int SCALE_TO_FIT_PAGES = 2;
    public static final int SCALE_TO_FIT_FULL_PAGE = 3;
    public static final int SCALE_TO_FIT_PAGE = 4;
    public static final int TEXT_COMPONENTS_ALL = -1;
    public static final int TEXT_COMPONENTS_NONE = 0;
    public static final int BELOW_HEADER = 1;
    public static final int ABOVE_FOOTER = 2;
    public static final int GRIDVIEW_COLUMN_HEADER = 1;
    public static final int GRIDVIEW_ROW_HEADER = 2;
    public static final int PAGE_HEADER = 4;
    public static final int TITLE = 8;
    public static final int SUBTITLE = 16;
    public static final int FOOTNOTE = 32;
    public static final int TOP_FORMATTED_TEXT_AREA = 64;
    public static final int BOTTOM_FORMATTED_TEXT_AREA = 128;
    public static final int HEADER_LEFT = 1;
    public static final int HEADER_CENTER = 2;
    public static final int HEADER_RIGHT = 4;
    public static final int FOOTER_LEFT = 16;
    public static final int FOOTER_CENTER = 32;
    public static final int FOOTER_RIGHT = 64;
    public static final int HEADERS_AND_FOOTERS_ALL = 255;
    public static final int HEADERS_AND_FOOTERS_NONE = 0;
    public static final int IGNORE_HEADERS_AND_FOOTERS = 1;
    public static final int ADJUST_FOR_HEADERS_AND_FOOTERS = 2;
    public static final int OCCLUDE_HEADERS_AND_FOOTERS = 3;
    public static final int MIN_PRINT_ZOOM_FACTOR = 10;
    public static final int UNIT_PIXELS = 0;
    public static final int UNIT_INCHES = 1;
    public static final int UNIT_CM = 2;
    protected int paperWidth = 612;
    protected int paperHeight = 792;
    protected int leftMargin = 72;
    protected int rightMargin = 72;
    protected int topMargin = 72;
    protected int bottomMargin = 72;
    protected int units;
    protected int printZoomFactor = 100;
    protected int fitToNumPagesTall;
    protected int fitToNumPagesWide;
    protected int m_gridViewPrintScaleType = 0;
    protected int m_graphPrintScaleType = 4;
    protected int rangeType = 0;
    protected int headerHeight;
    protected int footerHeight;
    protected int[] logicalPage;
    protected int printableWidth;
    protected int printableHeight;
    protected HPosWrapper currLogPage = null.new HPosWrapper();
    protected HPosWrapper viewLogPage = null.new HPosWrapper();
    protected Vector m_selectedHPos;
    protected int viewLogPageNum;
    protected int m_seqPageNumber;
    protected boolean printByColumns = true;
    protected boolean currentLogicalPage;
    protected boolean resize;
    protected boolean m_gridlinesVisible = true;
    protected int m_repeatComponents = 63;
    protected PaginationRecord record;
    protected DataSubsetRecord subSetRecord;
    protected HeaderAndFooterPainter LeftHeader;
    protected HeaderAndFooterPainter CenterHeader;
    protected HeaderAndFooterPainter RightHeader;
    protected HeaderAndFooterPainter LeftFooter;
    protected HeaderAndFooterPainter CenterFooter;
    protected HeaderAndFooterPainter RightFooter;
    protected CustomHeaderAndFooterCallback _callback;
    protected int callbackMask;
    protected int MarginAdjustment = 1;
    protected Rectangle pagingControlBounds;
    protected TokenSubstitution m_tokenSubstitution;
    protected FormattedText m_topFormattedText;
    protected FormattedText m_bottomFormattedText;
    protected Title title;
    protected Subtitle subtitle;
    protected Footnote footnote;
    protected Dataview dataView;
    protected Dimension oldTitleSize;
    protected Dimension oldSubtitleSize;
    protected Dimension oldFootnoteSize;
    protected Dimension oldTopFTASize;
    protected Dimension oldBottomFTASize;
    protected int titleHeight;
    protected int subtitleHeight;
    protected int footnoteHeight;
    protected int topFTAHeight;
    protected int bottomFTAHeight;
    protected int totalAdornHeight;
    protected int repeatAdornHeight;
    private boolean m_bTitleFocus;
    private boolean m_bSubtitleFocus;
    private boolean m_bFootnoteFocus;
    protected int m_aboveFooterWidth;
    protected int m_belowHeaderWidth;
    protected boolean m_bPreviewMode;
    protected PageFormat m_pageFormat;
    protected Dimension viewDim;
    protected Dimension dimension;
    protected static final String dataUnavailableMsg = "data is unavailable to print";
    protected static final String m_insuffSpace = "Insufficient space to print the View";
    protected static final int PAGING_CONTROL_GAP = 5;
    protected int pIndex = -1;
    private int oldtopMargin = this.topMargin;
    private int oldbottomMargin = this.bottomMargin;
    private PrintJob pjob;

    public abstract int getViewPrinterType();

    public ViewPrinter(Dataview dataview) {
        this.LeftHeader = new HeaderAndFooterPainter(dataview, 1, null, null, 4);
        this.CenterHeader = new HeaderAndFooterPainter(dataview, 2, null, null, 4);
        this.RightHeader = new HeaderAndFooterPainter(dataview, 4, null, null, 4);
        this.LeftFooter = new HeaderAndFooterPainter(dataview, 16, null, null, 4);
        this.CenterFooter = new HeaderAndFooterPainter(dataview, 32, null, null, 4);
        this.RightFooter = new HeaderAndFooterPainter(dataview, 64, null, null, 4);
        this.setDataview(dataview);
        this.setTokenSubstitution(new TokenSubstitutionAdapter(this, 56));
    }

    public void setTopFormattedText(FormattedText formattedText) {
        this.m_topFormattedText = formattedText;
    }

    public void setBottomFormattedText(FormattedText formattedText) {
        this.m_bottomFormattedText = formattedText;
    }

    public boolean print(boolean bl) {
        if (this.dataView.isDataUnavailable()) {
            this.dataView.getErrorHandler().log(dataUnavailableMsg, this.getClass().getName(), "print");
            return false;
        }
        try {
            if (this.rangeType == 0) {
                this.print(true, bl);
            } else {
                this.print(false, bl);
            }
        }
        catch (Exception exception) {
            this.dataView.getErrorHandler().error(exception, this.getClass().getName(), "print");
        }
        return true;
    }

    public void setUnits(int n) {
        this.units = n;
    }

    public int getUnits() {
        return this.units;
    }

    public void setLeftMargin(int n) {
        this.leftMargin = n;
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public void setRightMargin(int n) {
        this.rightMargin = n;
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    public void setTopMargin(int n) {
        this.oldtopMargin = this.topMargin = n;
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public void setBottomMargin(int n) {
        this.oldbottomMargin = this.bottomMargin = n;
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public void setHeaderMargin(int n) {
        this.LeftHeader.setMargin(n);
        this.CenterHeader.setMargin(n);
        this.RightHeader.setMargin(n);
    }

    public int getHeaderMargin() {
        return this.LeftHeader.getMargin();
    }

    public void setFooterMargin(int n) {
        this.LeftFooter.setMargin(n);
        this.CenterFooter.setMargin(n);
        this.RightFooter.setMargin(n);
    }

    public int getFooterMargin() {
        return this.LeftFooter.getMargin();
    }

    public void setPrintZoomFactor(int n) {
        if (n < 10) {
            this.dataView.getErrorHandler().log("Print zoom factor is less than 10%", this.getClass().getName(), "setPrintZoomFactor");
            return;
        }
        this.printZoomFactor = n;
    }

    public int getPrintZoomFactor() {
        return this.printZoomFactor;
    }

    public void setPrintScaleType(int n) {
        if (this.getViewPrinterType() != 2) {
            this.m_gridViewPrintScaleType = n;
        } else {
            this.m_graphPrintScaleType = n;
        }
    }

    public int getPrintScaleType() {
        if (this.getViewPrinterType() != 2) {
            return this.m_gridViewPrintScaleType;
        }
        return this.m_graphPrintScaleType;
    }

    public void setGraphPrintScaleType(int n) {
        this.m_graphPrintScaleType = n;
    }

    public int getGraphPrintScaleType() {
        return this.m_graphPrintScaleType;
    }

    public void setGridViewPrintScaleType(int n) {
        this.m_gridViewPrintScaleType = n;
    }

    public int getGridViewPrintScaleType() {
        return this.m_gridViewPrintScaleType;
    }

    public void setFitToNumPagesTall(int n) {
        this.fitToNumPagesTall = n;
    }

    public int getFitToNumPagesTall() {
        return this.fitToNumPagesTall;
    }

    public void setFitToNumPagesWide(int n) {
        this.fitToNumPagesWide = n;
    }

    public int getFitToNumPagesWide() {
        return this.fitToNumPagesWide;
    }

    public void setGridlinesVisible(boolean bl) {
        this.m_gridlinesVisible = bl;
    }

    public boolean isGridlinesVisible() {
        return this.m_gridlinesVisible;
    }

    public boolean setLogicalPage(int[] nArray) {
        if (this.dataView.isDataUnavailable()) {
            this.dataView.getErrorHandler().log(dataUnavailableMsg, this.getClass().getName(), "setLogicalPage");
            return false;
        }
        this.logicalPage = nArray;
        int n = -1;
        if (nArray != null) {
            n = nArray.length - 1;
        }
        try {
            this.changePageEdgeCurrentHPos(this.logicalPage, n);
        }
        catch (DataException dataException) {
            this.dataView.getErrorHandler().error(dataException, this.getClass().getName(), "setLogicalPage");
        }
        this.resize = true;
        return true;
    }

    public int[] getLogicalPage() {
        return this.logicalPage;
    }

    public void setSelectedHPos(Vector vector) {
        this.m_selectedHPos = vector;
    }

    public Vector getSelectedHPos() {
        return this.m_selectedHPos;
    }

    public void setRangeType(int n) {
        this.rangeType = n;
    }

    public int getRangeType() {
        return this.rangeType;
    }

    public HeaderAndFooterPainter getFooterPainter() {
        return this.CenterFooter;
    }

    public HeaderAndFooterPainter getHeaderPainter() {
        return this.CenterHeader;
    }

    public HeaderAndFooterPainter getHeaderAndFooterPainter(int n) {
        switch (n) {
            case 1: {
                return this.LeftHeader;
            }
            case 2: {
                return this.CenterHeader;
            }
            case 4: {
                return this.RightHeader;
            }
            case 16: {
                return this.LeftFooter;
            }
            case 32: {
                return this.CenterFooter;
            }
            case 64: {
                return this.RightFooter;
            }
        }
        return null;
    }

    public void setCustomHeaderAndFooterCallback(CustomHeaderAndFooterCallback customHeaderAndFooterCallback) {
        this._callback = customHeaderAndFooterCallback;
    }

    public CustomHeaderAndFooterCallback getCustomHeaderAndFooterCallback() {
        return this._callback;
    }

    public void setHeadersAndFootersUsingCallback(int n) {
        this.callbackMask = n;
    }

    public int getHeadersAndFootersUsingCallback() {
        return this.callbackMask;
    }

    public void setMarginAdjustment(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                this.MarginAdjustment = n;
                return;
            }
        }
        this.dataView.getErrorHandler().log("invalid margin adjustment", this.getClass().getName().toString(), "setMarginAdjustment (int adjustment)");
    }

    public int getMarginAdjustment() {
        return this.MarginAdjustment;
    }

    public void setViewDimension(Dimension dimension) {
        this.paperWidth = dimension.width;
        this.paperHeight = dimension.height;
        this.dimension = this.viewDim = dimension;
    }

    public Dimension getViewDimension() {
        return this.viewDim;
    }

    public void setPrintByColumns(boolean bl) {
        this.printByColumns = bl;
    }

    public boolean isPrintByColumns() {
        return this.printByColumns;
    }

    public PrintJob getPrintJob() {
        return this.pjob;
    }

    public Dataview getDataview() {
        return this.dataView;
    }

    public boolean showPrintJob() {
        Frame frame = WindowUtils.parentFrame((Component)this.dataView);
        PrivilegeManager.enablePrivilege("UniversalPrintJobAccess");
        this.pjob = Toolkit.getDefaultToolkit().getPrintJob(frame, this.dataView.getIntlString("Print"), null);
        if (this.pjob != null) {
            this.dimension = this.pjob.getPageDimension();
            this.paperWidth = this.dimension.width;
            this.paperHeight = this.dimension.height;
            this.viewDim = this.dimension;
            return true;
        }
        return false;
    }

    public void setPrintJob(PrintJob printJob) {
        this.pjob = printJob;
        if (this.pjob != null) {
            this.dimension = this.pjob.getPageDimension();
            this.paperWidth = this.dimension.width;
            this.paperHeight = this.dimension.height;
            this.viewDim = this.dimension;
        }
    }

    public boolean renderPage(Graphics graphics) {
        if (this.dataView.isDataUnavailable()) {
            this.dataView.getErrorHandler().log(dataUnavailableMsg, this.getClass().getName(), "renderPage");
            return false;
        }
        if (!this.checkDataSourceLogPage()) {
            this.resetCurrentLogicalPage();
        }
        this.calcMargins(graphics);
        this.printToGraphics(graphics, this.record);
        this.printHeaderAndFooter(graphics);
        return true;
    }

    public abstract boolean isFirstPhysicalPage();

    public abstract boolean isLastPhysicalPage();

    public void setSequentialPageNumber(int n) {
        this.m_seqPageNumber = n;
    }

    public int getSequentialPageNumber() {
        return this.m_seqPageNumber;
    }

    /*
     * Unable to fully structure code
     */
    public int print(Graphics var1_1, PageFormat var2_2, int var3_3) throws PrinterException {
        if (var3_3 != 0) ** GOTO lbl21
        if (this.pIndex == -1) {
            if (this.prepareFirstPage(var1_1)) {
                this.renderPage(var1_1);
                return 0;
            }
            var4_4 = false;
            while (!var4_4) {
                if (this.hasNextPage()) {
                    if (!this.prepareNextPage(var1_1)) continue;
                    this.renderPage(var1_1);
                    var4_4 = true;
                    return 0;
                }
                return 1;
            }
            this.pIndex = 0;
        } else {
            this.renderPage(var1_1);
            return 0;
lbl21:
            // 1 sources

            if (this.hasNextPage()) {
                if (this.pIndex != var3_3) {
                    this.pIndex = var3_3;
                    var4_5 = false;
                    while (!var4_5) {
                        if (this.hasNextPage()) {
                            if (!this.prepareNextPage(var1_1)) continue;
                            this.renderPage(var1_1);
                            var4_5 = true;
                            return 0;
                        }
                        return 1;
                    }
                } else {
                    this.renderPage(var1_1);
                    return 0;
                }
                return 1;
            }
            if (this.pIndex == var3_3) {
                this.renderPage(var1_1);
            }
        }
        return 1;
    }

    protected void print(boolean bl, boolean bl2) {
        if (this.pjob != null) {
            this.printPages(this.pjob, bl);
            if (bl2) {
                this.pjob.end();
            }
        }
    }

    private CustomHeaderAndFooterCallback getCallback(int n) {
        if ((this.callbackMask & n) > 0) {
            return this._callback;
        }
        return null;
    }

    protected void printHeaderAndFooter(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this.getMarginAdjustment();
        if (this.headerHeight == -1 && this.footerHeight == -1) {
            this.calcHeaderAndFooterHeights(graphics);
            n5 = 1;
        }
        switch (this.getMarginAdjustment()) {
            case 1: {
                n4 = this.headerHeight;
                n3 = this.footerHeight;
                n2 = this.paperHeight - this.footerHeight;
                break;
            }
            case 2: {
                n4 = this.headerHeight;
                n3 = this.footerHeight;
                n2 = this.paperHeight - this.footerHeight;
                break;
            }
            case 3: {
                n4 = this.topMargin;
                n3 = this.bottomMargin - this.LeftFooter.getMargin();
                if (this.footerHeight < this.bottomMargin) {
                    n2 = this.paperHeight - this.footerHeight;
                    break;
                }
                n2 = this.paperHeight - this.bottomMargin;
                break;
            }
            default: {
                n4 = 0;
                n3 = 0;
                n2 = 0;
            }
        }
        int n6 = this.printableWidth;
        graphics.translate(this.leftMargin, 0);
        int[] nArray = this.viewLogPage.getHPos();
        this.LeftHeader.paint(graphics, 0, 0, n6, n4, this.getCallback(1), this.m_seqPageNumber, nArray);
        this.CenterHeader.paint(graphics, n6 / 3, 0, n6, n4, this.getCallback(2), this.m_seqPageNumber, nArray);
        this.RightHeader.paint(graphics, n6 * 2 / 3, 0, n6, n4, this.getCallback(4), this.m_seqPageNumber, nArray);
        this.LeftFooter.paint(graphics, 0, n2, n6, n3, this.getCallback(16), this.m_seqPageNumber, nArray);
        this.CenterFooter.paint(graphics, n6 / 3, n2, n6, n3, this.getCallback(32), this.m_seqPageNumber, nArray);
        this.RightFooter.paint(graphics, n6 * 2 / 3, n2, n6, n3, this.getCallback(64), this.m_seqPageNumber, nArray);
        graphics.setClip(0, 0, this.paperWidth, this.paperHeight);
        if (this.m_belowHeaderWidth > 0) {
            n = this.headerHeight;
            if (n == 0) {
                n = this.LeftHeader.getMargin();
            } else if (n > n4) {
                n = n4;
            }
            if (this.m_belowHeaderWidth == 1) {
                graphics.drawLine(0, n, n6, n);
            } else {
                graphics.fillRect(0, n, n6, this.m_belowHeaderWidth);
            }
        }
        if (this.m_aboveFooterWidth > 0) {
            n = 0;
            n = this.footerHeight == 0 ? this.paperHeight - this.LeftFooter.getMargin() : n2;
            if (this.m_aboveFooterWidth == 1) {
                graphics.drawLine(0, n, n6, n);
            } else {
                graphics.fillRect(0, n -= this.m_aboveFooterWidth, n6, this.m_aboveFooterWidth);
            }
        }
        graphics.translate(-this.leftMargin, 0);
        if (n5 == 2) {
            this.topMargin = this.oldtopMargin;
            this.bottomMargin = this.oldbottomMargin;
        }
    }

    protected void calcAdornmentsDimension(int n) {
        this.saveAdornmentsSize();
        this.totalAdornHeight = 0;
        this.repeatAdornHeight = 0;
        if (this.m_topFormattedText != null) {
            this.totalAdornHeight = this.topFTAHeight = this.m_topFormattedText.getRequiredHeight(n);
            if (this.isRepeatComponent(64)) {
                this.repeatAdornHeight = this.topFTAHeight;
            }
        }
        if (this.title.isVisible()) {
            this.title.setSize(n, this.title.getPreferredSize().height);
            this.title.setSize(n, this.title.getPreferredSize().height);
            this.titleHeight = this.title.getSize().height;
            this.totalAdornHeight += this.titleHeight;
            if (this.isRepeatComponent(8)) {
                this.repeatAdornHeight += this.titleHeight;
            }
        }
        if (this.subtitle.isVisible()) {
            this.subtitle.setSize(n, this.subtitle.getPreferredSize().height);
            this.subtitle.setSize(n, this.subtitle.getPreferredSize().height);
            this.subtitleHeight = this.subtitle.getSize().height;
            this.totalAdornHeight += this.subtitleHeight;
            if (this.isRepeatComponent(16)) {
                this.repeatAdornHeight += this.subtitleHeight;
            }
        }
        if (this.footnote.isVisible()) {
            this.footnote.setSize(n, this.footnote.getPreferredSize().height);
            this.footnote.setSize(n, this.footnote.getPreferredSize().height);
            this.footnoteHeight = this.footnote.getSize().height;
            this.totalAdornHeight += this.footnoteHeight;
            this.repeatAdornHeight += this.footnoteHeight;
        }
        if (this.m_bottomFormattedText != null) {
            this.bottomFTAHeight = this.m_bottomFormattedText.getRequiredHeight(n);
            this.totalAdornHeight += this.bottomFTAHeight;
            this.repeatAdornHeight += this.bottomFTAHeight;
        }
        try {
            if (this.dataView.isPagingControlVisible() && this.dataView.getModel().getDataAccess().getLayerCount(2) > 0) {
                this.dataView.getPagingControl().getPagingComponent().validate();
                this.pagingControlBounds = this.dataView.getPagingControl().getPagingComponent().getPageBounds(null, null, 0, 0, n, this.printableHeight);
                this.pagingControlBounds.height += 5;
                this.totalAdornHeight += this.pagingControlBounds.height;
                if (this.isRepeatComponent(4)) {
                    this.repeatAdornHeight += this.pagingControlBounds.height;
                }
            }
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
            // empty catch block
        }
        this.resetAdornmentsSize();
    }

    protected void saveAdornmentsSize() {
        if (this.title.isVisible()) {
            this.oldTitleSize = this.title.getSize();
        }
        if (this.subtitle.isVisible()) {
            this.oldSubtitleSize = this.subtitle.getSize();
        }
        if (this.footnote.isVisible()) {
            this.oldFootnoteSize = this.footnote.getSize();
        }
    }

    protected void resetAdornmentsSize() {
        if (this.title.isVisible()) {
            this.title.setSize(this.oldTitleSize);
        }
        if (this.subtitle.isVisible()) {
            this.subtitle.setSize(this.oldSubtitleSize);
        }
        if (this.footnote.isVisible()) {
            this.footnote.setSize(this.oldFootnoteSize);
        }
    }

    protected void saveTitlesFocus() {
        if (((BaseTitle)this.dataView.getDataviewTitle()).isSelected()) {
            this.m_bTitleFocus = true;
            ((BaseTitle)this.dataView.getDataviewTitle()).setSelected(false);
        } else {
            this.m_bTitleFocus = false;
        }
        if (((BaseTitle)this.dataView.getDataviewSubtitle()).isSelected()) {
            this.m_bSubtitleFocus = true;
            ((BaseTitle)this.dataView.getDataviewSubtitle()).setSelected(false);
        } else {
            this.m_bSubtitleFocus = false;
        }
        if (((BaseTitle)this.dataView.getDataviewFootnote()).isSelected()) {
            this.m_bFootnoteFocus = true;
            ((BaseTitle)this.dataView.getDataviewFootnote()).setSelected(false);
        } else {
            this.m_bFootnoteFocus = false;
        }
    }

    protected void restoreTitlesFocus() {
        ComponentHandle componentHandle = this.dataView.getSelectedObject();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (componentHandle != null) {
            bl = componentHandle.getID() == 0;
            bl2 = componentHandle.getID() == 1;
            boolean bl4 = bl3 = componentHandle.getID() == 2;
        }
        if (this.m_bTitleFocus && bl) {
            ((BaseTitle)this.dataView.getDataviewTitle()).setSelected(true);
        }
        if (this.m_bSubtitleFocus && bl2) {
            ((BaseTitle)this.dataView.getDataviewSubtitle()).setSelected(true);
        }
        if (this.m_bFootnoteFocus && bl3) {
            ((BaseTitle)this.dataView.getDataviewFootnote()).setSelected(true);
        }
    }

    protected void setDataview(Dataview dataview) {
        this.dataView = dataview;
    }

    protected void calcMargins(Graphics graphics) {
        if (graphics == null) {
            this.headerHeight = -1;
            this.footerHeight = -1;
            return;
        }
        this.calcHeaderAndFooterHeights(graphics);
        if (this.getMarginAdjustment() == 2) {
            this.adjustMargins();
        }
    }

    protected void adjustMargins() {
        this.oldtopMargin = this.topMargin;
        this.oldbottomMargin = this.bottomMargin;
        if (this.headerHeight > this.topMargin) {
            this.topMargin = this.headerHeight;
        }
        if (this.footerHeight > this.bottomMargin) {
            this.bottomMargin = this.footerHeight;
        }
    }

    public void calcHeaderAndFooterHeights(Graphics graphics) {
        int[] nArray = this.viewLogPage.getHPos();
        this.footerHeight = this.LeftFooter.calcMaximumHeight(graphics, this.getCallback(16), this.m_seqPageNumber, nArray);
        this.footerHeight = Math.max(this.footerHeight, this.CenterFooter.calcMaximumHeight(graphics, this.getCallback(32), this.m_seqPageNumber, nArray));
        this.footerHeight = Math.max(this.footerHeight, this.RightFooter.calcMaximumHeight(graphics, this.getCallback(64), this.m_seqPageNumber, nArray));
        this.headerHeight = this.LeftHeader.calcMaximumHeight(graphics, this.getCallback(1), this.m_seqPageNumber, nArray);
        this.headerHeight = Math.max(this.headerHeight, this.CenterHeader.calcMaximumHeight(graphics, this.getCallback(2), this.m_seqPageNumber, nArray));
        this.headerHeight = Math.max(this.headerHeight, this.RightHeader.calcMaximumHeight(graphics, this.getCallback(4), this.m_seqPageNumber, nArray));
    }

    protected boolean checkForNoData() {
        DataAccess dataAccess = this.dataView.getModel().getDataAccess();
        try {
            if (dataAccess.getEdgeExtent(1) != 0 && dataAccess.getEdgeExtent(0) != 0) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception exception) {
            this.dataView.getErrorHandler().error(exception, this.getClass().getName(), "checkForNoData");
        }
        return true;
    }

    public abstract boolean startPrint();

    public abstract boolean startPrint(boolean var1);

    public abstract void endPrint();

    public void setRepeatHeaders(boolean bl) {
        this.m_repeatComponents = bl ? 255 : 0;
    }

    public boolean isRepeatHeaders() {
        return this.m_repeatComponents == 255;
    }

    public void setRepeatComponent(int n, boolean bl) {
        if (bl) {
            this.m_repeatComponents |= n;
        } else {
            int n2 = ~n;
            this.m_repeatComponents &= n2;
        }
    }

    public boolean isRepeatComponent(int n) {
        return (this.m_repeatComponents & n) != 0;
    }

    protected abstract void printPages(PrintJob var1, boolean var2);

    protected abstract void printToGraphics(Graphics var1, PaginationRecord var2);

    public abstract boolean goToFirstPage();

    public abstract boolean goToNextPage();

    public abstract boolean goToPrevPage();

    public abstract boolean prepareFirstPage(Graphics var1);

    public abstract boolean prepareNextPage(Graphics var1);

    public abstract void setScaleFontSize(int var1);

    public abstract int getScaleFontSize();

    public abstract boolean preparePrevPage(Graphics var1);

    public abstract boolean hasNextPage();

    public abstract boolean hasPrevPage();

    public void setTokenSubstitution(TokenSubstitution tokenSubstitution) {
        this.m_tokenSubstitution = tokenSubstitution;
        this.LeftHeader.setTokenSubstitution(tokenSubstitution);
        this.CenterHeader.setTokenSubstitution(tokenSubstitution);
        this.RightHeader.setTokenSubstitution(tokenSubstitution);
        this.LeftFooter.setTokenSubstitution(tokenSubstitution);
        this.CenterFooter.setTokenSubstitution(tokenSubstitution);
        this.RightFooter.setTokenSubstitution(tokenSubstitution);
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.m_pageFormat = pageFormat;
        int n = (int)this.m_pageFormat.getWidth();
        int n2 = (int)this.m_pageFormat.getHeight();
        this.setViewDimension(new Dimension(n, n2));
    }

    public PageFormat getPageFormat() {
        return this.m_pageFormat;
    }

    public TokenSubstitution getTokenSubstitution() {
        return this.m_tokenSubstitution;
    }

    public Locale getLocale() {
        return this.dataView.getLocale();
    }

    public boolean isDataviewTitleVisible() {
        return this.dataView.getDataviewTitle().isVisible();
    }

    public boolean isDataviewSubtitleVisible() {
        return this.dataView.getDataviewSubtitle().isVisible();
    }

    public boolean isDataviewFootnoteVisible() {
        return this.dataView.getDataviewFootnote().isVisible();
    }

    public void setLineWidth(int n, int n2) {
        if (n == 2) {
            this.m_aboveFooterWidth = n2;
        } else if (n == 1) {
            this.m_belowHeaderWidth = n2;
        }
    }

    public int getLineWidth(int n) {
        if (n == 2) {
            return this.m_aboveFooterWidth;
        }
        if (n == 1) {
            return this.m_belowHeaderWidth;
        }
        return 0;
    }

    public boolean renderFirstPage(Graphics graphics) {
        return false;
    }

    public boolean renderLastPage(Graphics graphics) {
        return false;
    }

    public boolean goToFirstPage(Graphics graphics) {
        return false;
    }

    public boolean goToLastPage(Graphics graphics) {
        return false;
    }

    public Cursor getWaitCursor() {
        return this.dataView.getController().getCursorType(2);
    }

    public Cursor getDefaultCursor() {
        return this.dataView.getController().getCursorType(0);
    }

    protected boolean checkDataSourceLogPage() {
        boolean bl = true;
        try {
            HPosWrapper hPosWrapper = null.new HPosWrapper(this.dataView.getModel().getDataAccess().getEdgeCurrentHPos(2));
            if (!this.viewLogPage.equals(hPosWrapper)) {
                bl = false;
                int[] nArray = this.viewLogPage.getHPos();
                int n = -1;
                if (nArray != null) {
                    n = nArray.length - 1;
                }
                this.changePageEdgeCurrentHPos(nArray, n);
            }
        }
        catch (DataException dataException) {
            this.dataView.getErrorHandler().error(dataException, this.getClass().getName(), "checkDataSourceLogPage");
        }
        return bl;
    }

    protected int fetchRowBlock(int n, int n2) {
        try {
            int[] nArray = new int[2];
            int[] nArray2 = new int[2];
            nArray[0] = 0;
            nArray2[0] = this.dataView.getModel().getDataAccess().getEdgeExtent(0) - 1;
            nArray[1] = n;
            nArray2[1] = n2;
            if (!this.dataView.getModel().getDataAccess().isFetched(nArray, nArray2)) {
                if (!this.dataView.getModel().getDataAccess().forceFetch(nArray, nArray2)) {
                    this.dataView.getErrorHandler().log("could not fetch rows", this.getClass().getName(), "fetchRowBlock");
                } else {
                    int n3 = nArray[1];
                    while (n3 <= nArray2[1]) {
                        if (this.dataView.getWaitDataForRow(n3) != null) {
                            this.dataView.setWaitDataForRow(n3, null);
                        }
                        ++n3;
                    }
                }
            }
        }
        catch (DataException dataException) {
            this.dataView.getErrorHandler().error(dataException, this.getClass().getName(), "fetchRowBlock");
            int n4 = -1;
            return n4;
        }
        return n2;
    }

    protected abstract void resetCurrentLogicalPage();

    protected boolean changePageEdgeCurrentHPos(int[] nArray, int n) throws DataDirectorException, SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        boolean bl = this.dataView.getModel().getDataDirector().changeEdgeCurrentHPos(2, nArray, n);
        return bl;
    }

    public HPosWrapper getLogicalPageInUse() {
        return this.viewLogPage;
    }

    public class HPosWrapper {
        private int[] m_hPos;

        public HPosWrapper() {
        }

        public HPosWrapper(int[] nArray) {
            this.m_hPos = nArray;
        }

        public void setHPos(int[] nArray) {
            this.m_hPos = nArray;
        }

        public int[] getHPos() {
            return this.m_hPos;
        }

        public boolean equals(int[] nArray) {
            if (this.m_hPos == null && nArray != null) {
                return false;
            }
            if (this.m_hPos != null && nArray == null) {
                return false;
            }
            if (this.m_hPos == null && nArray == null) {
                return true;
            }
            if (this.m_hPos.length != nArray.length) {
                return false;
            }
            int n = 0;
            while (n < this.m_hPos.length) {
                if (this.m_hPos[n] != nArray[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public boolean equals(HPosWrapper hPosWrapper) {
            return this.equals(hPosWrapper.getHPos());
        }
    }
}

