/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.beans.BeanInfo;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.BitSet;
import javax.swing.UIManager;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.pivot.PageItem;
import oracle.bali.ewt.pivot.PagingComponent;
import oracle.bali.ewt.util.WindowUtils;
import oracle.dss.dataView.Dataview;
import oracle.dss.dataView.DataviewCommon;
import oracle.dss.dataView.DataviewPageItem;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.dataView.Model;
import oracle.dss.dataView.PageItemData;
import oracle.dss.dataView.PagingControl;
import oracle.dss.dataView.ViewComponent;
import oracle.dss.dataView.managers.Styleable;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.dataView.managers.ViewStyleCallback;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataDirector;
import oracle.dss.util.DataException;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;

public class DataviewPagingComponent
extends PagingComponent
implements PropertyChangeListener,
ViewComponent,
ViewStyleCallback,
Styleable {
    protected Model m_model;
    protected Dataview m_view;
    protected PagingControl m_pc;
    protected ViewStyle m_viewStyle;
    protected boolean m_bUpdating;
    protected int m_zoomFactor = Dataview.DEFAULT_ZOOM_FACTOR;
    private boolean pageSelected;

    public DataviewPagingComponent(Dataview dataview, Model model) {
        this.m_model = model;
        this.m_view = dataview;
        this.setDefaultViewStyle();
        this.setSelectionTransparent(true);
        this.newPageItems();
    }

    public void newPageItems() {
        this.m_model = this.m_view.getModel();
        if (this.m_model == null) {
            return;
        }
        this.removeAll();
        DataAccess dataAccess = this.m_model.getDataAccess();
        if (dataAccess == null) {
            return;
        }
        String string = null;
        PageItemData pageItemData = null;
        int[] nArray = null;
        DataviewPageItem dataviewPageItem = null;
        try {
            nArray = dataAccess.getEdgeCurrentHPos(2);
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
            this.m_model.getErrorHandler().error(edgeOutOfRangeException, this.getClass().getName(), "newPageItems()");
        }
        int n = -1;
        if (nArray != null) {
            n = nArray.length;
        }
        int n2 = 0;
        while (n2 < n) {
            string = null;
            pageItemData = null;
            try {
                Object object = null;
                String string2 = this.m_view.getLayerMetadataLabelType(2);
                if (this.m_view.isLayerMetadataLabelTypeSupported(string2)) {
                    object = dataAccess.getLayerMetadata(2, n2, string2);
                }
                string = object == null ? "" : object.toString();
                pageItemData = new PageItemData(this.m_view, nArray, n2);
                dataviewPageItem = new DataviewPageItem(string, pageItemData);
                this.add((Component)((Object)dataviewPageItem));
                if (nArray[n2] != -1) {
                    dataviewPageItem.setSelectedIndex(nArray[n2]);
                }
                dataviewPageItem.addPropertyChangeListener(this);
            }
            catch (LayerOutOfRangeException layerOutOfRangeException) {
                this.m_model.getErrorHandler().error(layerOutOfRangeException, this.getClass().getName(), "newPageItems()");
            }
            catch (EdgeOutOfRangeException edgeOutOfRangeException) {
                this.m_model.getErrorHandler().error(edgeOutOfRangeException, this.getClass().getName(), "newPageItems()");
            }
            ++n2;
        }
        this.setEnabled(this.isEnabled());
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.m_zoomFactor != Dataview.DEFAULT_ZOOM_FACTOR) {
            dimension.height = DataviewUtils.scaleByZoom(dimension.height, this.m_zoomFactor);
        }
        return dimension;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.m_bUpdating) {
            return;
        }
        if (propertyChangeEvent.getPropertyName() == "selectedIndex") {
            PageItem pageItem = (PageItem)propertyChangeEvent.getSource();
            int n = this.getIndex(pageItem);
            int n2 = pageItem.getSelectedIndex();
            this.setPageItemSelected(true);
            DataDirector dataDirector = this.m_model.getDataDirector();
            DataAccess dataAccess = this.m_model.getDataAccess();
            try {
                try {
                    int[] nArray = dataAccess.getEdgeCurrentHPos(2);
                    nArray[n] = n2;
                    this.setCursor(WindowUtils.getWindow((Component)((Object)this)), this.m_view.getController().getCursorType(2));
                    if (!this.m_model.pageChangeHappened(this.m_view, nArray, n)) {
                        // empty if block
                    }
                }
                catch (DataException dataException) {
                    this.m_model.getErrorHandler().error(dataException, this.getClass().getName(), "propertyChange");
                    Object var9_10 = null;
                    this.setCursor(WindowUtils.getWindow((Component)((Object)this)), this.m_view.getController().getCursorType(0));
                }
                Object var9_9 = null;
                this.setCursor(WindowUtils.getWindow((Component)((Object)this)), this.m_view.getController().getCursorType(0));
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                this.setCursor(WindowUtils.getWindow((Component)((Object)this)), this.m_view.getController().getCursorType(0));
                throw throwable;
            }
        }
    }

    public void setPageItemSelected(boolean bl) {
        this.pageSelected = bl;
    }

    public boolean isPageItemSelected() {
        return this.pageSelected;
    }

    public int getID() {
        return 3;
    }

    public String getComponentName() {
        return "PageHeader";
    }

    public BeanInfo getBeanInfo() {
        return null;
    }

    public int getEdge() {
        return 2;
    }

    public void updateCurrentPage() {
        this.m_bUpdating = true;
        DataAccess dataAccess = this.m_model.getDataAccess();
        if (dataAccess == null) {
            return;
        }
        try {
            int[] nArray = dataAccess.getEdgeCurrentHPos(2);
            int n = -1;
            if (nArray != null) {
                n = nArray.length;
            }
            int n2 = 0;
            while (n2 < n) {
                PageItem pageItem = this.getItem(n2);
                if (pageItem != null && nArray[n2] != -1) {
                    pageItem.setSelectedIndex(nArray[n2]);
                }
                ++n2;
            }
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
            this.m_view.getErrorHandler().error(edgeOutOfRangeException, this.getClass().getName(), "void updateCurrentPage()");
        }
        this.m_bUpdating = false;
    }

    public Dataview getView() {
        return this.m_view;
    }

    public ViewStyle getViewStyle() {
        return this.m_viewStyle;
    }

    public void setViewStyle(ViewStyle viewStyle) {
        ViewStyle viewStyle2 = this.m_viewStyle;
        this.m_viewStyle = (ViewStyle)viewStyle.clone();
        this.m_viewStyle.setView(this.m_view);
        this.m_viewStyle.setViewStyleCallback(this);
        this.updateForPropSet(ViewStyle.createDifferencesBitSet(viewStyle2, this.m_viewStyle));
    }

    public void styleChanged(int n, String string, Object object, Object object2) {
        this.updateForPropSet(ViewStyle.createDifferencesBitSet(n));
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.m_model == null) {
            return;
        }
        try {
            int n = 0;
            while (n < this.m_model.getDataAccess().getLayerCount(2)) {
                PageItem pageItem = this.getItem(n);
                if (pageItem != null) {
                    this.getItem(n).setEnabled(bl);
                    this.getItem(n).setEditable(bl);
                } else {
                    this.m_view.getErrorHandler().log("null PageItem", this.getClass().getName(), "setEnabled");
                }
                ++n;
            }
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
            this.m_view.getErrorHandler().error(edgeOutOfRangeException, this.getClass().getName(), "setEnabled");
        }
    }

    protected void setZoomFactor(int n) {
        this.m_zoomFactor = n;
    }

    protected void resetToDefault(int n) {
        this.m_viewStyle.resetToDefault(n);
        this.m_pc.updatePageItemStyles();
    }

    protected void updateForPropSet(BitSet bitSet) {
        this.m_pc.updatePageItemStyles();
    }

    void setPagingControl(PagingControl pagingControl) {
        this.m_pc = pagingControl;
    }

    private Appearance getDefaultAppearance() {
        Appearance appearance = ((Appearance)UIManager.get("PageItem.DefaultAppearance")).copy();
        appearance.setForeground(UIManager.getColor(LookAndFeel.CONTROL_TEXT));
        appearance.setBackground(UIManager.getColor(LookAndFeel.CONTROL));
        return appearance;
    }

    void setViewStyleNoRefresh(ViewStyle viewStyle) {
        this.m_viewStyle = viewStyle;
        this.m_viewStyle.setView(this.m_view);
        this.m_viewStyle.setViewStyleCallback(this);
    }

    private void setDefaultViewStyle() {
        this.m_viewStyle = new ViewStyle((DataviewCommon)this.m_view, this.getDefaultAppearance());
        this.m_viewStyle.setViewStyleCallback(this);
    }

    private void setCursor(Component component, Cursor cursor) {
        component.setCursor(cursor);
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = 0;
            while (n < container.getComponentCount()) {
                this.setCursor(container.getComponent(n), cursor);
                ++n;
            }
        }
    }
}

