/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.BeanInfo;
import java.io.Serializable;
import java.util.BitSet;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import oracle.dss.dataView.BaseTitleAttributes;
import oracle.dss.dataView.BaseTitleXML;
import oracle.dss.dataView.Dataview;
import oracle.dss.dataView.DataviewDefaultValues;
import oracle.dss.dataView.DataviewTitles;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.dataView.NonDataComponentHandle;
import oracle.dss.dataView.TokenSubstitution;
import oracle.dss.dataView.ViewComponent;
import oracle.dss.util.xml.ObjectNode;

public abstract class BaseTitle
extends JLabel
implements DataviewTitles,
ViewComponent,
Serializable,
BaseTitleAttributes {
    protected BitSet _userOverrideFlags;
    protected BitSet _styleOverrideFlags;
    protected Dataview dataView;
    protected boolean m_underline = DataviewDefaultValues.isBaseTitleUnderline();
    protected int m_horzAlign = DataviewDefaultValues.getBaseTitleHorzAlign();
    protected Font m_font;
    protected FontMetrics fm;
    protected int baseline;
    protected int constrainWidth = -1;
    protected int zoomFactor = Dataview.DEFAULT_ZOOM_FACTOR;
    protected String m_text = DataviewDefaultValues.getBaseTitleText();
    protected static final String m_errorMsg = "Text is null";
    protected static final String m_errorBG = "Background is null";
    protected static final String m_errorFG = "Foreground is null";
    protected static final String m_errorSetFont = "Font size is less or equal to 0";
    protected static final String m_errorSetZoom = "Zoom factor is negative";
    protected static final String m_errorSetHA = "Invalid value for Horizontal Alignment";
    protected static final String m_method_setText = "setText";
    protected static final String m_method_setBG = "setBackground";
    protected static final String m_method_setFG = "setForeground";
    protected static final String m_method_setFont = "setFont";
    protected static final String m_method_setZoomFactor = "setZoomFactor";
    protected static final String m_method_setHA = "setHorizontalAlignment";
    private Color focusColor = UIManager.getColor("Button.focus");
    private boolean selected = DataviewDefaultValues.isBaseTitleSelected();
    private boolean m_visible = DataviewDefaultValues.isBaseTitleVisible();
    protected BaseTitleXML _baseTitleXML;
    protected int d_fontSize;
    protected String m_version;

    public BaseTitle(String string, Dataview dataview) {
        this.dataView = dataview;
        if (this.dataView != null && this.dataView.isJavaComponent()) {
            super.setVisible(DataviewDefaultValues.isBaseTitleVisible());
        }
        super.setForeground(DataviewDefaultValues.getBaseTitleForeground());
        super.setBackground(DataviewDefaultValues.getBaseTitleBackground());
        super.setHorizontalAlignment(DataviewDefaultValues.getBaseTitleHorizontalAlignment());
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
        this.setText(string);
        this.setOpaque(true);
        this.m_version = "";
        if (dataview != null) {
            this.m_version = dataview.getVersion();
        }
        this.createPropertyOverrideFlags();
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void setVisible(boolean bl) {
        boolean bl2 = this.isVisible();
        if (bl2 != bl) {
            if (this.dataView != null && this.dataView.isJavaComponent()) {
                super.setVisible(bl);
                this.dataView.validate();
            } else {
                this.m_visible = bl;
            }
        }
    }

    public boolean isVisible() {
        if (this.dataView != null && this.dataView.isJavaComponent()) {
            return super.isVisible();
        }
        return this.m_visible;
    }

    public void setText(String string) {
        if (string == null) {
            if (this.dataView != null) {
                this.dataView.getErrorHandler().log(m_errorMsg, this.getClass().getName(), m_method_setText);
            }
            return;
        }
        if (!string.equals("")) {
            this.setVisible(true);
        } else {
            this.setVisible(false);
        }
        if (this.dataView != null) {
            String string2 = this.getText();
            TokenSubstitution tokenSubstitution = this.dataView.getTokenSubstitution();
            String[] stringArray = null;
            if (tokenSubstitution != null) {
                stringArray = tokenSubstitution.getListItems();
                int n = 0;
                while (n < stringArray.length) {
                    stringArray[n] = tokenSubstitution.getToken(stringArray[n]);
                    ++n;
                }
            }
            string = this.truncateText(string, stringArray);
            String string3 = tokenSubstitution.getParsedString(string);
            if (string2 != null && !string2.equals(string3) || string2 == null && string3 != null) {
                super.setText(string3);
                this.m_text = string;
                if (this.dataView != null && this.dataView.isJavaComponent()) {
                    this.invalidate();
                    this.dataView.validate();
                    this.repaint();
                }
            }
        } else {
            string = this.truncateText(string);
            super.setText(string);
            this.m_text = string;
        }
    }

    public String getText() {
        if (this.dataView == null) {
            return super.getText();
        }
        TokenSubstitution tokenSubstitution = this.dataView.getTokenSubstitution();
        return tokenSubstitution.getParsedString(this.m_text);
    }

    public String getUnParseText() {
        return this.m_text;
    }

    public void setBackground(Color color) {
        if (color == null) {
            if (this.dataView != null) {
                this.dataView.getErrorHandler().log(m_errorBG, this.getClass().getName(), m_method_setBG);
            }
            return;
        }
        super.setBackground(color);
        this.setPropertyOverrideFlags(5);
    }

    public void setForeground(Color color) {
        if (color == null) {
            if (this.dataView != null) {
                this.dataView.getErrorHandler().log(m_errorFG, this.getClass().getName(), m_method_setFG);
            }
            return;
        }
        super.setForeground(color);
        this.setPropertyOverrideFlags(4);
    }

    public void setFont(Font font) {
        if (font.getSize() <= 0) {
            if (this.dataView != null) {
                this.dataView.getErrorHandler().log(m_errorSetFont, this.getClass().getName(), m_method_setFont);
            }
            return;
        }
        this.m_font = font;
        if (this.dataView != null && this.dataView.isJavaComponent()) {
            super.setFont(font);
        }
        this.setPropertyOverrideFlags(0);
        this.setPropertyOverrideFlags(2);
        this.setPropertyOverrideFlags(3);
        this.setPropertyOverrideFlags(1);
    }

    public Font getFont() {
        Font font = this.getUnscaledFont();
        if (this.dataView != null) {
            return this.dataView.scaleFont(font, this.zoomFactor);
        }
        return font;
    }

    public Font getUnscaledFont() {
        if (this.dataView != null && this.dataView.isJavaComponent()) {
            return super.getFont();
        }
        return this.m_font;
    }

    public int getFontSize() {
        return this.getFont().getSize();
    }

    public void setFontSize(int n) {
        Font font = this.getFont();
        this.m_font = new Font(font.getName(), font.getStyle(), n);
        if (this.dataView != null && this.dataView.isJavaComponent()) {
            super.setFont(this.m_font);
        }
        this.setPropertyOverrideFlags(1);
    }

    public String getFontName() {
        return this.getFont().getName();
    }

    public void setFontName(String string) {
        Font font = this.getFont();
        this.m_font = new Font(string, font.getStyle(), font.getSize());
        if (this.dataView != null && this.dataView.isJavaComponent()) {
            super.setFont(this.m_font);
        }
        this.setPropertyOverrideFlags(0);
    }

    public boolean isFontBold() {
        return this.getFont().isBold();
    }

    public void setFontBold(boolean bl) {
        Font font = this.getFont();
        int n = font.getStyle();
        n = bl ? (n |= 1) : (n &= 0xFFFFFFFE);
        this.m_font = new Font(font.getName(), n, font.getSize());
        if (this.dataView != null && this.dataView.isJavaComponent()) {
            super.setFont(this.m_font);
        }
        this.setPropertyOverrideFlags(2);
    }

    public boolean isFontItalic() {
        return this.getFont().isItalic();
    }

    public void setFontItalic(boolean bl) {
        Font font = this.getFont();
        int n = font.getStyle();
        n = bl ? (n |= 2) : (n &= 0xFFFFFFFD);
        this.m_font = new Font(font.getName(), n, font.getSize());
        if (this.dataView != null && this.dataView.isJavaComponent()) {
            super.setFont(this.m_font);
        }
        this.setPropertyOverrideFlags(3);
    }

    public void setStyleProperty(int n, String string) {
        switch (n) {
            case 0: {
                this.setFontName(string);
                break;
            }
            case 1: {
                this.setFontSize(Integer.valueOf(string));
                break;
            }
            case 2: {
                this.setFontBold(Boolean.valueOf(string));
                break;
            }
            case 3: {
                this.setFontItalic(Boolean.valueOf(string));
                break;
            }
        }
    }

    public void setUnderline(boolean bl) {
        if (this.m_underline != bl) {
            this.m_underline = bl;
            if (this.dataView != null && this.dataView.isJavaComponent()) {
                this.invalidate();
                this.repaint();
            }
        }
        this.setPropertyOverrideFlags(6);
    }

    public boolean isUnderline() {
        return this.m_underline;
    }

    public void setHorizontalAlignment(int n) {
        if (n == 4 || n == 2 || n == 0 || n == 10) {
            super.setHorizontalAlignment(n);
            this.setPropertyOverrideFlags(7);
        } else if (this.dataView != null) {
            this.dataView.getErrorHandler().log(m_errorSetHA, this.getClass().getName(), m_method_setHA);
        }
    }

    public int getHorizontalAlignment() {
        return super.getHorizontalAlignment();
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public BeanInfo getBeanInfo() {
        return null;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        BaseTitle baseTitle = this;
        return this.dataView.getRolloverTextManager().getRolloverText(this.dataView, new NonDataComponentHandle(baseTitle.getID(), baseTitle.getComponentName(), baseTitle), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.adjustForEnhancements(super.getPreferredSize());
        String string = this.getText();
        if (string == null) {
            return dimension;
        }
        Border border = this.getBorder();
        Insets insets = border != null ? border.getBorderInsets(this) : new Insets(0, 0, 0, 0);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        int n = stringTokenizer.countTokens();
        int n2 = 0;
        int n3 = 0;
        this.fm = this.getToolkit().getFontMetrics(this.getFont());
        int n4 = 0;
        while (n4 < n) {
            int n5 = this.fm.stringWidth(stringTokenizer.nextToken());
            this.constrainWidth = this.dataView.isPrintOrPreviewMode() ? this.getBounds().width : this.getParent().getParent().getBounds().width;
            if (n5 > this.constrainWidth && this.constrainWidth != 0) {
                n2 += n5 / this.constrainWidth;
                n5 %= this.constrainWidth;
                n3 = this.constrainWidth;
            }
            if (n5 > n3) {
                n3 = n5;
            }
            ++n4;
        }
        n4 = (n + n2) * this.fm.getHeight();
        this.fm = null;
        return this.adjustForEnhancements(new Dimension(n3 + insets.left + insets.right, n4 + insets.top + insets.bottom));
    }

    /*
     * Unable to fully structure code
     */
    public void paintComponent(Graphics var1_1) {
        block11: {
            var2_2 = this.getText();
            var3_3 = this.getBorder();
            var4_4 = var3_3 != null ? var3_3.getBorderInsets(this) : new Insets(0, 0, 0, 0);
            this.fm = this.getToolkit().getFontMetrics(this.getFont());
            this.baseline = this.fm.getMaxAscent();
            var5_5 = var4_4.left;
            var6_6 = var4_4.top;
            var7_7 = this.getWidth() - var4_4.right - var4_4.left;
            var8_8 = this.getHeight() - var4_4.bottom - var4_4.top;
            var9_9 = var1_1.getColor();
            var1_1.setColor(this.getBackground());
            var1_1.fillRect(0, 0, this.getWidth(), this.getHeight());
            var1_1.setColor(var9_9);
            if (var2_2 == null) break block11;
            var10_10 = new StringTokenizer(var2_2, "\r\n");
            var11_11 = new String[var10_10.countTokens()];
            var12_12 = 0;
            while (var10_10.hasMoreTokens()) {
                var11_11[var12_12++] = var10_10.nextToken();
            }
            var13_13 = new Vector<String>();
            var12_12 = 0;
            while (var6_6 <= var8_8 && var12_12 < var11_11.length) {
                block12: {
                    var2_2 = var11_11[var12_12++];
                    var14_14 = 0;
                    var15_15 = 0;
                    break block12;
                    while (++var14_14 < var2_2.length()) lbl-1000:
                    // 2 sources

                    {
                        ** while (var14_14 >= var2_2.length() || var2_2.charAt((int)var14_14) != ' ')
lbl30:
                        // 1 sources

                    }
lbl31:
                    // 2 sources

                    var15_15 = var14_14;
                    var16_16 = -1;
                    var17_17 = null;
                    while (var15_15 >= var14_14) {
                        var18_18 = (var15_15 = var2_2.indexOf(32, var15_15)) == -1 ? var2_2.substring(var14_14) : var2_2.substring(var14_14, var15_15);
                        if (this.fm.stringWidth(var18_18) > var7_7) break;
                        var17_17 = var18_18;
                        var16_16 = var15_15;
                        if (var15_15 == -1) break;
                        ++var15_15;
                    }
                    if (var17_17 == null) {
                        var18_19 = 0;
                        var15_15 = var14_14;
                        while (var15_15 < var2_2.length()) {
                            var19_20 = this.fm.charWidth(var2_2.charAt(var15_15));
                            if (var18_19 + var19_20 > var7_7) break;
                            var18_19 += var19_20;
                            ++var15_15;
                        }
                        var13_13.addElement(var2_2.substring(var14_14, var15_15));
                        var14_14 = var15_15;
                    } else {
                        var13_13.addElement(var17_17);
                        var14_14 = var16_16;
                    }
                    var6_6 += this.fm.getHeight();
                }
                if (var6_6 <= var8_8 && var14_14 != -1) ** GOTO lbl-1000
            }
            var6_6 = var4_4.top + (var8_8 - var13_13.size() * this.fm.getHeight()) / 2;
            if (var6_6 < var4_4.top) {
                var6_6 = var4_4.top;
            }
            var14_14 = 0;
            while (var14_14 < var13_13.size()) {
                this.drawAlignedString(var1_1, (String)var13_13.elementAt(var14_14), var5_5, var6_6, var7_7, false);
                if ((var6_6 += this.fm.getHeight()) > var8_8) break;
                ++var14_14;
            }
            this.fm = null;
            var13_13 = null;
        }
        if (this.isSelected()) {
            var10_10 = new Rectangle(var4_4.left, var4_4.top, var7_7, var8_8);
            this.paintFocus(var1_1, (Rectangle)var10_10);
        }
    }

    public static void drawEnhancedAdornments(FontMetrics fontMetrics, Graphics graphics, int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            graphics.drawLine(n, n2 + 2, n + n3, n2 + 2);
        } else if (bl2) {
            graphics.drawLine(n, n2 + 2, n + n3, n2 + 2);
            graphics.drawLine(n, n2 + 2 + 2, n + n3, n2 + 2 + 2);
        }
        if (bl3) {
            graphics.drawLine(n, n2 - fontMetrics.getAscent() / 2 + 1, n + n3, n2 - fontMetrics.getAscent() / 2 + 1);
        }
    }

    public void setZoomFactor(int n) {
        if (n < 0) {
            if (this.dataView != null) {
                this.dataView.getErrorHandler().log(m_errorSetZoom, this.getClass().getName(), m_method_setZoomFactor);
            }
            return;
        }
        this.zoomFactor = n;
        if (this.dataView != null && this.dataView.isJavaComponent()) {
            this.invalidate();
            this.repaint();
        }
    }

    public void setSelected(boolean bl) {
        if (bl != this.isSelected()) {
            this.selected = bl;
            this.repaint();
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public boolean isForegroundUsed() {
        return this.isUserOverrideFlag(4);
    }

    public boolean isBackgroundUsed() {
        return this.isUserOverrideFlag(5);
    }

    protected void paintFocus(Graphics graphics, Rectangle rectangle) {
        Color color = graphics.getColor();
        graphics.setColor(this.focusColor);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        graphics.setColor(color);
    }

    protected void drawAlignedString(Graphics graphics, String string, int n, int n2, int n3, boolean bl) {
        String string2;
        int n4 = this.fm.stringWidth(string);
        if (this.dataView != null && this.dataView.getLocale() != null && this.getHorizontalAlignment() == 10 && ((string2 = this.getLocale().getLanguage()).equals("ar") || string2.equals("he") || string2.equals("iw"))) {
            n = n + n3 - n4;
        }
        if (this.getHorizontalAlignment() == 0) {
            n += (n3 - n4) / 2;
        } else if (this.getHorizontalAlignment() == 4) {
            n = n + n3 - n4;
        }
        if (!bl) {
            graphics.drawString(string, n, n2 + this.baseline);
        }
        BaseTitle.drawEnhancedAdornments(this.fm, graphics, n, n2 + this.baseline, n4, this.isUnderline(), false, false);
    }

    protected Dimension adjustForEnhancements(Dimension dimension) {
        Dimension dimension2 = new Dimension(dimension);
        dimension2.setSize(dimension.width, DataviewUtils.adjustForEnhancedFont(dimension.height, this.isUnderline(), false));
        return dimension2;
    }

    public abstract String getComponentName();

    public void setXML(ObjectNode objectNode, String string, int n) {
        this._baseTitleXML.setXML(objectNode, string, n);
    }

    public ObjectNode getXML(boolean bl) {
        return this._baseTitleXML.getXML(bl);
    }

    public void setStyleXML(ObjectNode objectNode, String string, int n) {
        this._baseTitleXML.setStyleXML(objectNode);
    }

    public ObjectNode getStyleXML(boolean bl) {
        return this._baseTitleXML.getStyleXML(bl);
    }

    public void resetToDefault(int n) {
        this.resetToDefault(n, this.dataView.getVersion());
    }

    public void resetToDefault(int n, String string) {
        this._baseTitleXML.resetToDefault(n, string);
        this.createPropertyOverrideFlags();
    }

    protected Font initializeFont() {
        this.m_font = this.dataView != null ? this.dataView.getFontList().getFont(DataviewDefaultValues.getBaseTitleFontName(), DataviewUtils.fontStyle(DataviewDefaultValues.isBaseTitleFontBold(), DataviewDefaultValues.isBaseTitleFontItalic()), this.d_fontSize) : new Font(DataviewDefaultValues.getBaseTitleFontName(), DataviewUtils.fontStyle(DataviewDefaultValues.isBaseTitleFontBold(), DataviewDefaultValues.isBaseTitleFontItalic()), this.d_fontSize);
        return this.m_font;
    }

    public void createPropertyOverrideFlags() {
        if (this.dataView != null) {
            this._userOverrideFlags = this.dataView.createPropertyOverrideFlags(8);
            this._styleOverrideFlags = this.dataView.createPropertyOverrideFlags(8);
        }
    }

    private void setPropertyOverrideFlags(int n) {
        if (this.dataView != null) {
            this.dataView.setPropertyOverrideFlags(n, this._userOverrideFlags, this._styleOverrideFlags);
        }
    }

    public boolean isUserOverrideFlag(int n) {
        if (this.dataView == null) {
            return false;
        }
        return this.dataView.isPropertyOverrideFlag(n, this._userOverrideFlags);
    }

    public boolean isStyleOverrideFlag(int n) {
        if (this.dataView == null) {
            return false;
        }
        return this.dataView.isPropertyOverrideFlag(n, this._styleOverrideFlags);
    }

    public void resetStyle() {
        this._baseTitleXML.resetStyle();
        this.createPropertyOverrideFlags();
    }

    private String truncateText(String string) {
        return this.truncateText(string, null);
    }

    private String truncateText(String string, String[] stringArray) {
        if (string.length() <= 1024) {
            return string;
        }
        int n = 0;
        String string2 = string.substring(0, 1024);
        if (stringArray != null) {
            int n2 = -1;
            int n3 = 0;
            int n4 = 0;
            while (n4 < stringArray.length) {
                String string3 = stringArray[n4];
                n = string2.lastIndexOf(string3);
                if (n > n2) {
                    n2 = n;
                    n3 = string3.length();
                }
                ++n4;
            }
            if (n2 == -1) {
                if (string.charAt(1024) != ' ' && (n = string2.lastIndexOf(32)) != -1) {
                    string2 = string2.substring(0, n);
                }
            } else if (string.charAt(1024) != ' ') {
                n = string2.lastIndexOf(32);
                string2 = n != -1 ? (n > n2 ? string2.substring(0, n) : string2.substring(0, n2 + n3)) : string2.substring(0, n2 + n3);
            }
        } else if (string.charAt(1024) != ' ' && (n = string2.lastIndexOf(32)) != -1) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    public abstract int getID();
}

