/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jbo.JboException;
import oracle.jbo.Row;
import oracle.jbo.Transaction;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.domain.DomainAttributeDef;
import oracle.jbo.domain.DomainInterface;
import oracle.jbo.domain.DomainOwnerInterface;
import oracle.jdbc.driver.OracleConnection;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.Datum;
import oracle.sql.REF;
import oracle.sql.StructDescriptor;

public class Ref
implements Serializable,
CustomDatum,
DomainInterface {
    String mStructName;
    byte[] mData;
    Transaction mTrans;
    static CustomDatumFactory fac = null;
    static final long serialVersionUID = -4710224942623842135L;

    private /* synthetic */ void $init$() {
        this.mStructName = null;
        this.mData = null;
        this.mTrans = null;
    }

    public static CustomDatumFactory getCustomDatumFactory() {
        if (fac == null) {
            fac = new 1facClass();
        }
        return fac;
    }

    protected Ref() throws SQLException {
        this.$init$();
    }

    public Ref(String string, byte[] byArray) {
        this.$init$();
        this.mStructName = string;
        this.mData = byArray;
    }

    public Ref(Datum datum) throws SQLException {
        this.$init$();
        this.mStructName = ((REF)datum).getBaseTypeName();
        this.mData = datum.getBytes();
    }

    public Datum toDatum(OracleConnection oracleConnection) throws SQLException {
        return new REF(new StructDescriptor(this.mStructName, (Connection)oracleConnection), (Connection)oracleConnection, this.mData);
    }

    public void setContext(DomainOwnerInterface domainOwnerInterface, Transaction transaction, Object object) {
        this.mTrans = transaction;
    }

    public Object getData() {
        return this.mTrans.createRef(this.mStructName, this.mData);
    }

    public String getStructName() {
        return this.mStructName;
    }

    public byte[] getBytes() {
        return this.mData;
    }

    public Row getReferencedObject(DomainAttributeDef domainAttributeDef) {
        try {
            if (domainAttributeDef != null) {
                Row row = domainAttributeDef.getReferencedObject((Object)this, this.mTrans);
                return row;
            }
            Row row = null;
            return row;
        }
        catch (JboException jboException) {
            throw jboException;
        }
        catch (Exception exception) {
            Diagnostic.println((String)"Must be running in non-local mode!");
            throw new JboException((Throwable)exception);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof Ref) {
            Ref ref = (Ref)object;
            String string = ref.getStructName();
            byte[] byArray = ref.getBytes();
            if (this.mStructName == null ? string != null : !this.mStructName.equals(string)) {
                return false;
            }
            if (this.mData == null) {
                if (byArray != null) {
                    return false;
                }
            } else {
                if (this.mData.length != byArray.length) {
                    return false;
                }
                int n = 0;
                while (n < this.mData.length) {
                    if (this.mData[n] != byArray[n]) {
                        return false;
                    }
                    ++n;
                }
            }
            return true;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.mStructName != null) {
            objectOutputStream.writeBoolean(false);
            objectOutputStream.writeUTF(this.mStructName);
        } else {
            objectOutputStream.writeBoolean(true);
        }
        if (this.mData != null) {
            objectOutputStream.writeBoolean(false);
            objectOutputStream.writeInt(this.mData.length);
            objectOutputStream.write(this.mData);
        } else {
            objectOutputStream.writeBoolean(true);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (!objectInputStream.readBoolean()) {
            this.mStructName = objectInputStream.readUTF();
        }
        if (!objectInputStream.readBoolean()) {
            int n = objectInputStream.readInt();
            this.mData = new byte[n];
            objectInputStream.read(this.mData, 0, n);
        }
    }

    public static class 1facClass
    implements CustomDatumFactory {
        public CustomDatum create(Datum datum, int n) throws SQLException {
            if (datum != null) {
                return new Ref(datum);
            }
            return null;
        }

        1facClass() {
        }
    }
}

