/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import oracle.jbo.JboException;
import oracle.jbo.LocaleContext;
import oracle.jbo.Session;
import oracle.jbo.Transaction;
import oracle.jbo.common.PropertyMetadata;
import oracle.jbo.domain.DataCreationException;
import oracle.jbo.domain.DatumFactory;
import oracle.jbo.domain.DomainInterface;
import oracle.jbo.domain.DomainOwnerInterface;
import oracle.jbo.domain.GenericDomainException;
import oracle.jbo.domain.KeyAttributeInterface;
import oracle.jbo.domain.Number;
import oracle.jbo.domain.TypeConvMapEntry;
import oracle.jbo.domain.TypeFactory;
import oracle.jbo.domain.XMLDomainFactory;
import oracle.jbo.domain.XMLDomainReaderFactory;
import oracle.jbo.domain.XMLDomainWriter;
import oracle.jbo.server.DBTransaction;
import oracle.jdbc.driver.OracleConnection;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Date
extends DATE
implements Serializable,
CustomDatum,
KeyAttributeInterface,
XMLDomainWriter,
DomainInterface {
    private transient boolean mbConvertToUserTZ;
    private static final long serialVersionUID = 5600076615126868258L;
    private static final int BIND_SQL_DATE_UNINIT = -1;
    private static final int BIND_SQL_DATE_TRUE = 1;
    private static final int BIND_SQL_DATE_FALSE = 0;
    private static int bindSQLDate;
    static CustomDatumFactory fac;
    private int mHashCode;
    public static final Time ZERO_TIME;
    private static final int IGNORE_ZERO_UNINIT = -1;
    private static final int IGNORE_ZERO_TRUE = 1;
    private static final int IGNORE_ZERO_FALSE = 0;
    private static int ignoreZero;
    private static /* synthetic */ Class class$oracle$jbo$domain$Date;
    private static /* synthetic */ Class class$java$lang$String;

    private /* synthetic */ void $init$() {
        this.mbConvertToUserTZ = false;
        this.mHashCode = 0;
    }

    static {
        Class clazz;
        bindSQLDate = -1;
        fac = null;
        Class clazz2 = class$oracle$jbo$domain$Date;
        if (clazz2 == null) {
            clazz2 = class$oracle$jbo$domain$Date = Date.class$("oracle.jbo.domain.Date");
        }
        if ((clazz = class$java$lang$String) == null) {
            clazz = class$java$lang$String = Date.class$("java.lang.String");
        }
        TypeFactory.addCustomConverter((Class)clazz2, (Class)clazz, (TypeConvMapEntry)new 1());
        ZERO_TIME = new Time(0, 0, 0);
        ignoreZero = -1;
    }

    public static CustomDatumFactory getCustomDatumFactory() {
        if (fac == null) {
            fac = new 2facClass();
        }
        return fac;
    }

    public Datum toDatum(OracleConnection oracleConnection) throws SQLException {
        return new DATE(this.getBytes());
    }

    public Date() {
        this.$init$();
    }

    public Date(byte[] byArray) {
        super(byArray);
        this.$init$();
    }

    public Date(DATE dATE) {
        super(dATE.getBytes());
        this.$init$();
    }

    public Date(Date date) {
        super(date.getBytes());
        this.$init$();
    }

    public Date(java.sql.Date date) {
        super(date);
        this.$init$();
    }

    public Date(Time time) {
        super(time);
        this.$init$();
    }

    public Date(Timestamp timestamp) {
        super(timestamp);
        this.$init$();
    }

    public Date(Object object) throws SQLException {
        this.$init$();
        if (object instanceof String) {
            this.setBytes(Date.toDate((String)object).getBytes());
        } else {
            this.setBytes(new DATE(object).getBytes());
        }
    }

    public Date(String string) {
        this.$init$();
        this.setBytes(Date.toDate(string).toBytes());
    }

    public Date(java.sql.Date date, boolean bl) {
        this(date);
        this.mbConvertToUserTZ = bl;
    }

    public Date(java.sql.Date date, Calendar calendar) {
        super(date, calendar);
        this.$init$();
    }

    public Date(Time time, boolean bl) {
        this(time);
        this.mbConvertToUserTZ = bl;
    }

    public Date(Time time, Calendar calendar) {
        super(time, calendar);
        this.$init$();
    }

    public Date(Timestamp timestamp, boolean bl) {
        this(timestamp);
        this.mbConvertToUserTZ = bl;
    }

    public Date(Timestamp timestamp, Calendar calendar) {
        super(timestamp, calendar);
        this.$init$();
    }

    public Date(String string, boolean bl) {
        this(string);
        this.mbConvertToUserTZ = bl;
    }

    public Date(String string, Calendar calendar) {
        this(string);
        this.convertToTimeZone(calendar);
    }

    public java.util.Date getValue() {
        return (java.util.Date)this.convertToJdbc(true);
    }

    public Object getData() {
        if (bindSQLDate == -1) {
            bindSQLDate = PropertyMetadata.DOMAIN_BIND_SQL_DATE.getPropertyAsBoolean() ? 1 : 0;
        }
        return bindSQLDate == 0 ? this.convertToJdbc(true) : this;
    }

    private Object convertToJdbc(boolean bl) {
        byte[] byArray = this.getBytes();
        if (bl && Date.toTime((byte[])byArray).equals(ZERO_TIME)) {
            return Date.toDate((byte[])byArray);
        }
        return Date.toTimestamp((byte[])byArray);
    }

    public void setContext(DomainOwnerInterface domainOwnerInterface, Transaction transaction, Object object) {
        Calendar calendar;
        LocaleContext localeContext;
        Session session;
        if (this.mbConvertToUserTZ && transaction instanceof DBTransaction && (session = ((DBTransaction)transaction).getSession()) != null && (localeContext = session.getLocaleContext()) != null && (calendar = Calendar.getInstance(localeContext.getUserTimeZone(), localeContext.getLocale())) != null) {
            this.convertToTimeZone(calendar);
        }
        this.mbConvertToUserTZ = false;
    }

    public static Date toDate(String string) {
        DATE dATE;
        string = string.trim();
        try {
            dATE = new DATE(string);
        }
        catch (Exception exception) {
            java.sql.Date date = java.sql.Date.valueOf(string);
            dATE = new DATE(date);
        }
        return new Date(dATE);
    }

    public String toString() {
        Object object;
        if (ignoreZero == -1) {
            ignoreZero = PropertyMetadata.DOMAIN_DATE_SUPPRESS_ZERO.getPropertyAsBoolean() ? 1 : 0;
        }
        if ((object = this.convertToJdbc(ignoreZero == 1)) != null) {
            return object.toString();
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            try {
                Date date = new Date(object);
                boolean bl = super.equals((Object)date);
                return bl;
            }
            catch (Exception exception) {
                boolean bl = false;
                return bl;
            }
        }
        return super.equals(object);
    }

    public int hashCode() {
        if (this.mHashCode == 0) {
            this.mHashCode = this.convertToJdbc(true).hashCode();
            if (this.mHashCode == 0) {
                this.mHashCode = -6855;
            }
        }
        return this.mHashCode;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        byte[] byArray = this.getBytes();
        objectOutputStream.writeInt(byArray.length);
        objectOutputStream.write(byArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        byte[] byArray = new byte[n];
        objectInputStream.read(byArray);
        this.setBytes(byArray);
    }

    public DATE addJulianDays(int n, int n2) {
        try {
            Date date = new Date(super.addJulianDays(n, n2));
            return date;
        }
        catch (SQLException sQLException) {
            throw new GenericDomainException("Date.addJulianDays", (Object)this, (Exception)sQLException);
        }
    }

    public DATE addMonths(int n) {
        try {
            Date date = new Date(super.addMonths(n));
            return date;
        }
        catch (SQLException sQLException) {
            throw new GenericDomainException("Date.addMonths", (Object)this, (Exception)sQLException);
        }
    }

    public Number diffInMonths(Date date) {
        try {
            Number number = new Number(super.diffInMonths((DATE)date));
            return number;
        }
        catch (SQLException sQLException) {
            throw new GenericDomainException("Date.diffInMonths", (Object)this, (Exception)sQLException);
        }
    }

    public NUMBER diffInMonths(DATE dATE) {
        return this.diffInMonths(new Date(dATE));
    }

    public static DATE getCurrentDate() {
        return new Date(new java.sql.Date(System.currentTimeMillis()));
    }

    public static DATE fromJulianDays(int n, int n2) {
        try {
            Date date = new Date(DATE.fromJulianDays((int)n, (int)n2));
            return date;
        }
        catch (SQLException sQLException) {
            throw new GenericDomainException("Date.fromJulianDays", null, (Exception)sQLException);
        }
    }

    public static DATE fromText(String string, String string2, String string3) {
        try {
            Date date = new Date(DATE.fromText((String)string, (String)string2, (String)string3));
            return date;
        }
        catch (SQLException sQLException) {
            throw new GenericDomainException("Date.fromText", (Object)string, (Exception)sQLException);
        }
    }

    public DATE lastDayOfMonth() {
        try {
            Date date = new Date(super.lastDayOfMonth());
            return date;
        }
        catch (SQLException sQLException) {
            throw new GenericDomainException("Date.lastDayOfMonth", (Object)this, (Exception)sQLException);
        }
    }

    public DATE round(String string) {
        try {
            Date date = new Date(super.round(string));
            return date;
        }
        catch (SQLException sQLException) {
            throw new GenericDomainException("Date.round", (Object)this, (Exception)sQLException);
        }
    }

    public DATE setDayOfWeek(int n) {
        try {
            Date date = new Date(super.setDayOfWeek(n));
            return date;
        }
        catch (SQLException sQLException) {
            throw new GenericDomainException("Date.setDayOfWeek", (Object)this, (Exception)sQLException);
        }
    }

    public NUMBER toNumber() {
        try {
            Number number = new Number(super.toNumber());
            return number;
        }
        catch (SQLException sQLException) {
            throw new GenericDomainException("Date.toNumber", (Object)this, (Exception)sQLException);
        }
    }

    public DATE truncate(String string) {
        try {
            Date date = new Date(super.truncate(string));
            return date;
        }
        catch (SQLException sQLException) {
            throw new GenericDomainException("Date.truncate", (Object)this, (Exception)sQLException);
        }
    }

    private void convertToTimeZone(Calendar calendar) {
        this.setBytes(DATE.toBytes((Timestamp)DATE.toTimestamp((byte[])this.getBytes(), (Calendar)calendar)));
    }

    public String printXMLDefinition(Hashtable hashtable, PrintWriter printWriter, boolean bl) {
        return "#PCDATA";
    }

    public Node getXMLContentNode(Document document) {
        return document.createTextNode(this.toString());
    }

    public Node getSerializedDomainXML(Document document) {
        return document.createTextNode(this.toString());
    }

    public static XMLDomainReaderFactory getXMLDomainFactory(Class clazz) {
        return new 1facClass();
    }

    public static void main(String[] stringArray) throws SQLException {
        System.out.println("Date Test BEGIN");
        Date date = new Date();
        try {
            System.out.println(date);
            Date date2 = (Date)Date.getCurrentDate();
            if (date.addMonths(2) instanceof Date) {
                System.out.println("Date: addMonths() = " + date.addMonths(2));
            }
            if (date.lastDayOfMonth() instanceof Date) {
                System.out.println("Date: lastDayOfMonth() = " + date.lastDayOfMonth());
            }
            if (date.setDayOfWeek(4) instanceof Date) {
                System.out.println("Date: setDayOfWeek() = " + date.setDayOfWeek(4));
            }
            if (date.toNumber() instanceof Number) {
                System.out.println("Date: toNumber() = " + date.toNumber());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final class 1
    extends TypeConvMapEntry {
        protected Object convert(Class clazz, Class clazz2, Object object) {
            try {
                Date date = new Date((String)object);
                return date;
            }
            catch (Exception exception) {
                if (object instanceof String && ((String)object).trim().length() == 0) {
                    Object var6_6 = null;
                    return var6_6;
                }
                throw new DataCreationException(clazz.getName(), object, exception);
            }
        }
    }

    public static class 2facClass
    implements DatumFactory {
        public Datum createDatum(CallableStatement callableStatement, int n) throws SQLException {
            byte[] byArray = callableStatement.getBytes(n);
            return byArray != null ? new Date(byArray) : null;
        }

        public Datum createDatum(ResultSet resultSet, int n) throws SQLException {
            byte[] byArray = resultSet.getBytes(n);
            return byArray != null ? new Date(byArray) : null;
        }

        public CustomDatum create(Datum datum, int n) throws SQLException {
            if (datum != null) {
                return new Date(datum.getBytes());
            }
            return null;
        }

        2facClass() {
        }
    }

    public static class 1facClass
    implements XMLDomainFactory,
    XMLDomainReaderFactory {
        public DomainInterface createDomainFromXMLElement(Element element) {
            try {
                String string;
                Node node = element.getFirstChild();
                if (node != null && (string = node.getNodeValue()) != null) {
                    Date date = new Date(string);
                    return date;
                }
            }
            catch (JboException jboException) {
                throw jboException;
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
            return null;
        }

        public Object createDomainFromSerializedXML(Element element) {
            try {
                String string;
                Node node = element.getFirstChild();
                if (node != null && (string = node.getNodeValue()) != null) {
                    Date date = new Date(string);
                    return date;
                }
            }
            catch (JboException jboException) {
                throw jboException;
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
            return null;
        }

        1facClass() {
        }
    }
}

