/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.domain;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import oracle.jbo.JboException;
import oracle.jbo.Transaction;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.SvcMsgResponseValues;
import oracle.jbo.domain.BaseLobDomain;
import oracle.jbo.domain.DomainInterface;
import oracle.jbo.domain.DomainOwnerInterface;
import oracle.jbo.domain.LobInterface;
import oracle.jbo.domain.LobStreamInterface;
import oracle.jbo.domain.XMLDomainFactory;
import oracle.jdbc.driver.OracleConnection;
import oracle.sql.CLOB;
import oracle.sql.Datum;
import oracle.svcmsg.ResponseValues;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import sun.io.ByteToCharConverter;

public class ClobDomain
extends BaseLobDomain
implements Serializable,
LobStreamInterface {
    private static final long serialVersionUID = 4019326676362184304L;
    private transient CLOB mylob;
    transient ClobWriter mcData;
    transient ClobReader inReader;
    transient Writer outWriter;
    private static /* synthetic */ Class class$oracle$jbo$Transaction;
    private static /* synthetic */ Class class$oracle$jbo$domain$DomainOwnerInterface;
    private static /* synthetic */ Class class$java$lang$String;
    private static /* synthetic */ Class class$oracle$jbo$Row;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;

    private /* synthetic */ void $init$() {
        this.mylob = null;
    }

    public ClobDomain() {
        this.$init$();
    }

    public ClobDomain(String string) {
        this.$init$();
        this.setChars(string != null ? string.toCharArray() : new char[]{});
    }

    public ClobDomain(byte[] byArray) {
        this.$init$();
        if (byArray != null) {
            this.setChars(new String(byArray).toCharArray());
        }
    }

    public ClobDomain(char[] cArray) {
        this.$init$();
        if (cArray != null) {
            this.setChars(cArray);
        }
    }

    public ClobDomain(CLOB cLOB) {
        super((Datum)cLOB);
        this.$init$();
        this.mylob = cLOB;
    }

    public ClobDomain(CLOB cLOB, byte[] byArray) {
        this.$init$();
        this.syncLob((Datum)cLOB);
        if (byArray != null) {
            this.setChars(new String(byArray).toCharArray());
        }
    }

    public ClobDomain(CLOB cLOB, char[] cArray) {
        this.$init$();
        this.syncLob((Datum)cLOB);
        if (cArray != null) {
            this.setChars(cArray);
        }
    }

    public ClobDomain(ClobDomain clobDomain, byte[] byArray) {
        super(clobDomain, byArray);
        this.$init$();
        try {
            if (clobDomain.lob != null) {
                this.syncLob((Datum)new CLOB((oracle.jdbc.OracleConnection)clobDomain.mylob.getConnection()));
            }
        }
        catch (SQLException sQLException) {
            throw new JboException((Throwable)sQLException);
        }
    }

    public ClobDomain(ClobDomain clobDomain, char[] cArray) {
        this.$init$();
        this.mClient = clobDomain.mClient;
        if (cArray != null) {
            this.setChars(cArray);
        }
        try {
            if (clobDomain.lob != null) {
                this.syncLob((Datum)new CLOB((oracle.jdbc.OracleConnection)clobDomain.mylob.getConnection()));
            }
        }
        catch (SQLException sQLException) {
            throw new JboException((Throwable)sQLException);
        }
    }

    public ClobDomain(ResponseValues responseValues) {
        this.$init$();
        boolean bl = responseValues.getBooleanValues()[0];
        boolean bl2 = responseValues.getBooleanValues()[1];
        boolean bl3 = responseValues.getBooleanValues()[2];
        String string = (String)responseValues.getObjectValues()[0];
        char[] cArray = (char[])responseValues.getObjectValues()[1];
        this.mDataModified = bl2;
        if (bl && bl2) {
            this.setChars(cArray);
        }
        this.mNeedsServerSync = bl3;
    }

    public void useCLOB(CLOB cLOB) {
        if (cLOB != null) {
            this.syncLob((Datum)cLOB);
            if (this.mDataModified && this.mcData == null) {
                this.mDataModified = false;
            }
        }
    }

    public ResponseValues marshal() {
        boolean bl;
        SvcMsgResponseValues svcMsgResponseValues = new SvcMsgResponseValues(4255, null);
        boolean bl2 = this.mClient || this.mDataModified;
        String string = this.getClass().getName();
        char[] cArray = null;
        if (this.mDataModified) {
            bl = false;
            cArray = this.toCharArray();
        } else {
            bl = !this.mClient && this.lob != null || this.mClient && this.mNeedsServerSync;
        }
        svcMsgResponseValues.setBooleanValues(new boolean[]{bl2, this.mDataModified, bl});
        svcMsgResponseValues.setObjectValues(new Object[]{string, cArray});
        return svcMsgResponseValues;
    }

    public void prepareForDML(Object object) {
        if (this.mylob == null) {
            try {
                this.syncLob((Datum)CLOB.empty_lob());
            }
            catch (SQLException sQLException) {
                throw new JboException((Throwable)sQLException);
            }
        }
    }

    public Datum toDatum(OracleConnection oracleConnection) throws SQLException {
        this.prepareForDML(oracleConnection);
        return this.mylob;
    }

    public void saveToDatabase(Transaction transaction) throws SQLException {
        if (this.mylob != null && this.mcData != null) {
            this.writeCharsToLob();
        }
    }

    public void saveToDatabase(Transaction transaction, Object object) throws SQLException {
        try {
            if (this.inReader != null) {
                this.inReader.close();
                this.inReader = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.closeOutputStream();
        if (this.mcData != null) {
            this.syncLob((Datum)((ClobDomain)object).mylob);
            this.writeCharsToLob();
        }
    }

    public boolean equals(Object object) {
        if (object instanceof ClobDomain) {
            ClobDomain clobDomain = (ClobDomain)object;
            if (this.mylob != null && clobDomain.mylob != null && !this.mDataModified) {
                if (this.mylob == clobDomain.mylob) {
                    return true;
                }
                return this.getLength() == clobDomain.getLength();
            }
            if (this.mcData == null && this.lob != null) {
                this.dumplob();
            }
            if (clobDomain.mcData == null && clobDomain.lob != null) {
                clobDomain.dumplob();
            }
            if (this.mcData == clobDomain.mcData) {
                return true;
            }
            if (this.mcData != null) {
                return this.mcData.size() == clobDomain.mcData.size();
            }
            return clobDomain.getData() == null;
        }
        return false;
    }

    public static XMLDomainFactory getXMLDomainFactory(Class clazz) {
        return new 1facClass(clazz);
    }

    public static CLOB createEmptyCLOB(Object object) {
        try {
            CLOB cLOB = CLOB.empty_lob();
            return cLOB;
        }
        catch (SQLException sQLException) {
            throw new JboException((Throwable)sQLException);
        }
    }

    public String getSubString(long l, int n) {
        if (this.mcData != null) {
            if (l < 1L) {
                return null;
            }
            char[] cArray = new char[n];
            System.arraycopy(this.mcData.getStorage(), (int)l - 1, cArray, 0, n);
            return new String(cArray);
        }
        if (this.mClient) {
            Method method = ClobDomain.getInvokeDomainMethod();
            try {
                if (this.mIndexString == null) {
                    this.getRemoteIdString();
                }
                String string = (String)method.invoke((Object)this.xAct, this.getOwnerRow(), this.mIndexString, Boolean.FALSE, "getSubString", new String[]{Long.TYPE.getName(), Integer.TYPE.getName()}, new Object[]{new Long(l), new Integer(n)});
                return string;
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        }
        if (this.mylob != null) {
            try {
                String string = this.mylob.getSubString(l, n);
                return string;
            }
            catch (SQLException sQLException) {
                throw new JboException((Throwable)sQLException);
            }
        }
        return null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeBoolean(this.mClient || this.mDataModified);
        if (this.mClient || this.mDataModified) {
            objectOutputStream.writeBoolean(this.mDataModified);
            if (this.mDataModified) {
                char[] cArray = this.toCharArray();
                if (cArray != null) {
                    objectOutputStream.writeInt(cArray.length);
                    objectOutputStream.writeChars(new String(cArray));
                } else {
                    objectOutputStream.writeInt(-1);
                }
                objectOutputStream.writeBoolean(false);
                return;
            }
        }
        objectOutputStream.writeBoolean(!this.mClient && this.lob != null || this.mClient && this.mNeedsServerSync);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        boolean bl = objectInputStream.readBoolean();
        if (bl && objectInputStream.readBoolean()) {
            int n = objectInputStream.readInt();
            char[] cArray = null;
            if (n > -1) {
                cArray = new char[n];
                int n2 = 0;
                while (n2 < cArray.length) {
                    cArray[n2] = objectInputStream.readChar();
                    ++n2;
                }
            }
            this.setChars(cArray);
        }
        this.mNeedsServerSync = objectInputStream.readBoolean();
    }

    public OutputStream getAsciiOutputStream() {
        return this.getOutputStream();
    }

    public InputStream getInputStream() {
        return new ClobInputStream(this.getCharacterStream());
    }

    public InputStream getAsciiStream() {
        return this.getInputStream();
    }

    protected void resetCachedData() {
        this.mcData = null;
        this.mDataModified = false;
    }

    public char[] getStorageCharArray() {
        if (this.mcData != null) {
            return this.mcData.getStorage();
        }
        return null;
    }

    public byte[] getStorageByteArray() {
        return this.getStorageByteArray(ByteToCharConverter.getDefault().getCharacterEncoding());
    }

    public byte[] getStorageByteArray(String string) {
        if (this.mcData != null) {
            try {
                byte[] byArray = new String(this.mcData.getStorage()).getBytes(string);
                return byArray;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byte[] byArray = null;
                return byArray;
            }
        }
        return null;
    }

    public OutputStream getOutputStream() {
        return new ClobOutputStream(this.getCharacterOutputStream());
    }

    public Writer getCharacterOutputStream() {
        if (this.outWriter != null) {
            return this.outWriter;
        }
        if (this.inReader != null) {
            try {
                this.inReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.inReader = null;
        }
        if (!this.mDataModified && this.mcData != null) {
            this.resetCachedData();
        }
        if (!this.mClient) {
            DomainOwnerInterface domainOwnerInterface = this.getOwnerRow();
            if (domainOwnerInterface != null) {
                try {
                    Method method;
                    Class<?> clazz = Class.forName("oracle.jbo.server.EntityDefImpl");
                    Class[] classArray = new Class[1];
                    Class clazz2 = class$oracle$jbo$Row;
                    if (clazz2 == null) {
                        clazz2 = classArray[0] = (class$oracle$jbo$Row = ClobDomain.class$("oracle.jbo.Row"));
                    }
                    if (!((Boolean)(method = clazz.getMethod("checkEntityLocked", classArray)).invoke(null, domainOwnerInterface)).booleanValue()) {
                        Class clazz3 = class$oracle$jbo$CSMessageBundle;
                        if (clazz3 == null) {
                            clazz3 = class$oracle$jbo$CSMessageBundle = ClobDomain.class$("oracle.jbo.CSMessageBundle");
                        }
                        throw new JboException(clazz3, "25040", null);
                    }
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)exception);
                }
            }
            if (this.mylob != null) {
                if (this.mDataModified) {
                    this.writeCharsToLob();
                }
                try {
                    this.outWriter = this.mylob.getCharacterOutputStream();
                }
                catch (SQLException sQLException) {
                    throw new JboException((Throwable)sQLException);
                }
            } else if (this.mcData != null) {
                this.outWriter = this.mcData;
            } else {
                this.mcData = new ClobWriter();
                this.outWriter = this.mcData;
                this.mDataModified = true;
            }
        } else {
            if (this.mIndexString == null) {
                this.getRemoteIdString();
            }
            try {
                Class clazz;
                Class clazz4;
                Class<?> clazz5 = Class.forName("oracle.jbo.client.remote.ClobDomainCharacterOutputStream");
                Class[] classArray = new Class[3];
                Class clazz6 = class$oracle$jbo$Transaction;
                if (clazz6 == null) {
                    clazz6 = classArray[0] = (class$oracle$jbo$Transaction = ClobDomain.class$("oracle.jbo.Transaction"));
                }
                if ((clazz4 = class$oracle$jbo$domain$DomainOwnerInterface) == null) {
                    clazz4 = classArray[1] = (class$oracle$jbo$domain$DomainOwnerInterface = ClobDomain.class$("oracle.jbo.domain.DomainOwnerInterface"));
                }
                if ((clazz = class$java$lang$String) == null) {
                    clazz = class$java$lang$String = ClobDomain.class$("java.lang.String");
                }
                classArray[2] = clazz;
                Constructor<?> constructor = clazz5.getConstructor(classArray);
                this.outWriter = (Writer)constructor.newInstance(this.xAct, this.getOwnerRow(), this.mIndexString);
                this.resetCachedData();
            }
            catch (Exception exception) {
                Throwable throwable = exception;
                if (throwable instanceof InvocationTargetException) {
                    throwable = ((InvocationTargetException)throwable).getTargetException();
                }
                if (throwable instanceof JboException) {
                    throw (JboException)throwable;
                }
                throw new JboException(throwable);
            }
        }
        return this.outWriter;
    }

    public Writer getCharacterOutputStream(String string) {
        return this.getCharacterOutputStream();
    }

    public void closeCharacterStream() {
        if (this.inReader != null) {
            try {
                this.inReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.inReader = null;
        }
    }

    public Reader getCharacterStream() {
        if (this.inReader != null) {
            if (!this.inReader.isClosed()) {
                return this.inReader;
            }
            this.inReader = null;
        }
        if (this.mylob != null) {
            if (this.mDataModified) {
                this.writeCharsToLob();
            }
            try {
                this.inReader = new ClobReader(this.mylob.getCharacterStream());
                this.inReader.reset();
            }
            catch (SQLException sQLException) {
                throw new JboException((Throwable)sQLException);
            }
            catch (IOException iOException) {}
        } else if (this.mcData != null || this.mDataModified) {
            this.inReader = new ClobReader(new CharArrayReader(this.mcData.toCharArray()));
        } else if (this.mClient) {
            if (this.mIndexString == null) {
                this.getRemoteIdString();
            }
            try {
                Class clazz;
                Class clazz2;
                Class<?> clazz3 = Class.forName("oracle.jbo.client.remote.ClobDomainCharacterStream");
                Class[] classArray = new Class[3];
                Class clazz4 = class$oracle$jbo$Transaction;
                if (clazz4 == null) {
                    clazz4 = classArray[0] = (class$oracle$jbo$Transaction = ClobDomain.class$("oracle.jbo.Transaction"));
                }
                if ((clazz2 = class$oracle$jbo$domain$DomainOwnerInterface) == null) {
                    clazz2 = classArray[1] = (class$oracle$jbo$domain$DomainOwnerInterface = ClobDomain.class$("oracle.jbo.domain.DomainOwnerInterface"));
                }
                if ((clazz = class$java$lang$String) == null) {
                    clazz = class$java$lang$String = ClobDomain.class$("java.lang.String");
                }
                classArray[2] = clazz;
                Constructor<?> constructor = clazz3.getConstructor(classArray);
                this.inReader = new ClobReader((Reader)constructor.newInstance(this.xAct, this.getOwnerRow(), this.mIndexString));
            }
            catch (Exception exception) {
                Throwable throwable = exception;
                if (throwable instanceof InvocationTargetException) {
                    throwable = ((InvocationTargetException)throwable).getTargetException();
                }
                if (throwable instanceof JboException) {
                    throw (JboException)throwable;
                }
                throw new JboException(throwable);
            }
        }
        return this.inReader;
    }

    public Reader getCharacterStream(String string) {
        return this.getCharacterStream();
    }

    public void setBytes(byte[] byArray) {
        if (byArray != null) {
            this.setChars(new String(byArray).toCharArray());
        }
    }

    public void setChars(char[] cArray) {
        Writer writer = this.getCharacterOutputStream();
        if (writer != null) {
            try {
                if (this.inReader != null) {
                    this.inReader.close();
                    this.inReader = null;
                }
                if (cArray != null) {
                    writer.write(cArray, 0, cArray.length);
                } else {
                    writer.write(new char[0], 0, 0);
                }
                this.closeCharacterOutputStream();
                return;
            }
            catch (IOException iOException) {
                Diagnostic.println((String)"Error opening cache'd stream. Set the attribute again into it's row");
            }
        }
        this.mDataModified = true;
    }

    public void syncClientLob(LobInterface lobInterface) {
        if (lobInterface != null) {
            ClobDomain clobDomain = (ClobDomain)lobInterface;
            this.mcData = null;
            this.mDataModified = false;
            this.mcData = clobDomain.mcData;
            this.mDataModified = clobDomain.mDataModified;
            if (this.inReader != null) {
                try {
                    this.inReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.inReader = null;
            }
            this.closeCharacterOutputStream();
        }
    }

    public void syncServerLob(LobInterface lobInterface) {
        if (lobInterface != null) {
            ClobDomain clobDomain = (ClobDomain)lobInterface;
            if (this.mNeedsServerSync) {
                this.syncLob(clobDomain.lob);
                this.mcData = clobDomain.mcData;
                this.inReader = clobDomain.inReader;
                this.outWriter = clobDomain.outWriter;
                this.mDataModified = clobDomain.mDataModified;
                this.mNeedsServerSync = false;
            } else if (clobDomain.xAct != null && !clobDomain.mDataModified && !this.mDataModified) {
                this.syncLob(clobDomain.lob);
                this.mcData = null;
                this.mDataModified = false;
                if (this.inReader != null) {
                    try {
                        this.inReader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.inReader = null;
                }
                this.closeCharacterOutputStream();
            }
            this.mOwner = clobDomain.mOwner;
            this.xAct = clobDomain.xAct;
            this.mClient = clobDomain.mClient;
            this.relIdx = clobDomain.relIdx;
        }
    }

    public String toString() {
        if (!(this.mcData != null || this.lob != null || this.mClient && this.mOwner != null)) {
            return "";
        }
        char[] cArray = this.toCharArray();
        if (cArray != null) {
            return new String(cArray);
        }
        return "";
    }

    public Object getData() {
        return this.mylob;
    }

    public char[] toCharArray() {
        if (!this.mDataModified && this.mcData == null) {
            if (this.mylob != null) {
                this.dumplob();
            } else if (this.mOwner != null) {
                this.dumpStream();
            }
        }
        if (this.mcData != null) {
            return this.mcData.toCharArray();
        }
        return null;
    }

    char[] readCharsFromLob(long l, int n) {
        try {
            char[] cArray = this.mylob.getSubString(l, n).toCharArray();
            return cArray;
        }
        catch (SQLException sQLException) {
            throw new JboException((Throwable)sQLException);
        }
    }

    void writeCharsToLob() {
        try {
            this.mylob.putChars(1L, this.mcData.toCharArray());
            super.resetCachedData();
        }
        catch (SQLException sQLException) {
            throw new JboException((Throwable)sQLException);
        }
    }

    byte[] readBytesFromLob(long l, int n) {
        try {
            byte[] byArray = this.mylob.getSubString(l, n).getBytes();
            return byArray;
        }
        catch (SQLException sQLException) {
            throw new JboException((Throwable)sQLException);
        }
    }

    void writeBytesToLob() {
        this.writeCharsToLob();
    }

    OutputStream getInternalOutputStream() {
        try {
            OutputStream outputStream = this.mylob.getAsciiOutputStream();
            return outputStream;
        }
        catch (SQLException sQLException) {
            throw new JboException((Throwable)sQLException);
        }
    }

    InputStream getInternalStream() {
        try {
            InputStream inputStream = this.mylob.getAsciiStream();
            return inputStream;
        }
        catch (SQLException sQLException) {
            throw new JboException((Throwable)sQLException);
        }
    }

    InputStream getInternalDataStream() {
        return new DataInputStream(new ByteArrayInputStream(new String(this.mcData.toCharArray()).getBytes()));
    }

    void syncLob(Datum datum) {
        this.mylob = (CLOB)datum;
        this.lob = this.mylob;
    }

    public long getLength() {
        if (this.mClient) {
            return super.getRemoteLength();
        }
        if (!this.mDataModified && this.mylob != null) {
            try {
                long l = this.mylob.length();
                return l;
            }
            catch (SQLException sQLException) {
                Diagnostic.println((String)"Warning : SQLException during ClobDomain.getLength()");
            }
        }
        if (this.mcData != null) {
            return this.mcData.size();
        }
        return 0L;
    }

    public int getBufferSize() {
        if (this.mClient) {
            return super.getRemoteBufferSize();
        }
        if (!this.mDataModified && this.mylob != null) {
            try {
                int n = this.mylob.getBufferSize();
                return n;
            }
            catch (SQLException sQLException) {
                Diagnostic.println((String)"Warning : SQLException during ClobDomain.getLength()");
            }
        }
        if (this.mcData != null) {
            return this.mcData.size();
        }
        return 0;
    }

    private void dumpStream() {
        Reader reader = this.getCharacterStream();
        try {
            this.mcData = new ClobWriter();
            try {
                boolean bl = false;
                int n = 31744;
                char[] cArray = new char[n];
                do {
                    n = reader.read(cArray, 0, n);
                    this.mcData.write(cArray, 0, n);
                } while (cArray.length == n);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.mcData.flush();
            reader.close();
            this.inReader = null;
            this.mcData.close();
        }
        catch (Exception exception) {
            new JboException((Throwable)exception);
        }
    }

    private CharArrayWriter dumplob() {
        try {
            this.mcData = new ClobWriter();
            try {
                char[] cArray;
                int n = 0;
                int n2 = 31744;
                while ((cArray = this.readCharsFromLob(n + 1, n2)) != null) {
                    this.mcData.write(cArray, 0, cArray.length);
                    n += cArray.length;
                    if (cArray.length == n2) continue;
                    break;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.mcData.flush();
            this.mcData.close();
        }
        catch (Exception exception) {
            new JboException((Throwable)exception);
        }
        return this.mcData;
    }

    public void closeOutputStream() {
        this.closeCharacterOutputStream();
    }

    public void closeCharacterOutputStream() {
        if (this.outWriter != null) {
            try {
                this.outWriter.flush();
                this.outWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.outWriter = null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class 1facClass
    implements XMLDomainFactory {
        Class mAttrClass;

        1facClass(Class clazz) {
            this.mAttrClass = clazz;
        }

        public DomainInterface createDomainFromXMLElement(Element element) {
            try {
                ClobDomain clobDomain = (ClobDomain)this.mAttrClass.newInstance();
                Node node = element.getFirstChild();
                if (node != null) {
                    clobDomain.setChars(node.getNodeValue().toCharArray());
                }
                ClobDomain clobDomain2 = clobDomain;
                return clobDomain2;
            }
            catch (JboException jboException) {
                throw jboException;
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        }
    }

    public class ClobWriter
    extends CharArrayWriter {
        ClobWriter() {
        }

        ClobWriter(int n) {
            super(n);
        }

        synchronized char[] getStorage() {
            return this.buf;
        }
    }

    public class ClobInputStream
    extends InputStream {
        Reader in;

        private /* synthetic */ void $init$() {
            this.in = null;
        }

        ClobInputStream(Reader reader) {
            this.$init$();
            this.in = reader;
        }

        public int read() throws IOException {
            return this.in.read();
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                throw new NullPointerException();
            }
            char[] cArray = new char[n2];
            int n3 = this.in.read(cArray, n, n2);
            int n4 = 0;
            while (n4 < n3) {
                byArray[n4] = (byte)cArray[n4];
                ++n4;
            }
            return n3;
        }

        public long skip(long l) throws IOException {
            return this.in.skip(l);
        }

        public int available() throws IOException {
            return this.in.ready() ? 1 : 0;
        }

        public void close() throws IOException {
            this.in.close();
        }

        public synchronized void mark(int n) {
            try {
                this.in.mark(n);
            }
            catch (Exception exception) {
                Diagnostic.printStackTrace((Throwable)exception);
            }
        }

        public synchronized void reset() throws IOException {
            this.in.reset();
        }

        public boolean markSupported() {
            return this.in.markSupported();
        }
    }

    public class ClobReader
    extends Reader {
        Reader reader;
        boolean bClosed;

        private /* synthetic */ void $init$() {
            this.reader = null;
            this.bClosed = false;
        }

        ClobReader(Reader reader) {
            this.$init$();
            this.reader = reader;
        }

        public void close() throws IOException {
            this.reader.close();
            this.bClosed = true;
        }

        public void mark(int n) throws IOException {
            this.reader.mark(n);
        }

        public boolean markSupported() {
            return this.reader.markSupported();
        }

        public int read() throws IOException {
            return this.reader.read();
        }

        public int read(char[] cArray) throws IOException {
            return this.reader.read(cArray);
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            return this.reader.read(cArray, n, n2);
        }

        public boolean ready() throws IOException {
            return this.reader.ready();
        }

        public void reset() throws IOException {
            this.reader.reset();
        }

        public long skip(long l) throws IOException {
            return this.reader.skip(l);
        }

        public boolean isClosed() {
            return this.bClosed;
        }
    }

    public class ClobOutputStream
    extends OutputStream {
        Writer os;

        private /* synthetic */ void $init$() {
            this.os = null;
        }

        ClobOutputStream(Writer writer) {
            this.$init$();
            this.os = writer;
        }

        public void close() throws IOException {
            this.os.close();
        }

        public void flush() throws IOException {
            this.os.flush();
        }

        public void write(byte[] byArray) throws IOException {
            this.os.write(new String(byArray));
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.os.write(new String(byArray, n, n2));
        }

        public void write(int n) throws IOException {
            this.os.write(n);
        }
    }
}

