/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.StringTokenizer;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.RowSetWriter;
import oracle.jdbc.rowset.OracleCachedRowSet;
import oracle.jdbc.rowset.OracleCachedRowSetReader;
import oracle.jdbc.rowset.OracleRow;

public class OracleCachedRowSetWriter
implements RowSetWriter,
Serializable {
    private StringBuffer updateClause = new StringBuffer("");
    private StringBuffer deleteClause = new StringBuffer("");
    private StringBuffer insertClause = new StringBuffer("");
    private PreparedStatement insertStmt;
    private PreparedStatement updateStmt;
    private PreparedStatement deleteStmt;
    private ResultSetMetaData rsmd;
    private transient Connection connection;
    private int columnCount;

    private boolean deleteRow(RowSet rowSet, OracleRow oracleRow) throws SQLException {
        this.deleteStmt.clearParameters();
        int n = 1;
        while (n <= this.columnCount) {
            if (oracleRow.isOriginalNull(n)) {
                return this.deleteRowWithNull(rowSet, oracleRow);
            }
            Object object = oracleRow.getColumn(n);
            if (object == null) {
                this.deleteStmt.setNull(n, this.rsmd.getColumnType(n));
            } else {
                this.deleteStmt.setObject(n, object);
            }
            ++n;
        }
        return this.deleteStmt.executeUpdate() == 1;
    }

    private boolean deleteRowWithNull(RowSet rowSet, OracleRow oracleRow) throws SQLException {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer("DELETE FROM " + this.getTableName(rowSet) + " WHERE ");
        int n = 1;
        while (n <= this.columnCount) {
            if (n != 1) {
                stringBuffer.append(" AND ");
            }
            if (oracleRow.isOriginalNull(n)) {
                stringBuffer.append(String.valueOf(this.rsmd.getColumnName(n)) + " IS NULL ");
            } else {
                stringBuffer.append(String.valueOf(this.rsmd.getColumnName(n)) + " = :" + n);
            }
            ++n;
        }
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.connection.prepareStatement(stringBuffer.substring(0, stringBuffer.length()));
            int n2 = 1;
            int n3 = 1;
            while (n2 <= this.columnCount) {
                if (!oracleRow.isOriginalNull(n2)) {
                    preparedStatement.setObject(n3++, oracleRow.getColumn(n2));
                }
                ++n2;
            }
            bl = preparedStatement.executeUpdate() == 1;
        }
        finally {
            Object var8_9 = null;
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return bl;
    }

    private String getSchemaName(RowSet rowSet) throws SQLException {
        return rowSet.getUsername();
    }

    private String getTableName(RowSet rowSet) throws SQLException {
        String string = rowSet.getCommand().toUpperCase();
        int n = string.indexOf(" FROM ");
        if (n == -1) {
            throw new SQLException("Could not parse the SQL String to get the table name.\n" + (string != "" ? string : "Please use RowSet.setCommand (String) to set the SQL query string."));
        }
        String string2 = string.substring(n + 6).trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        return string2;
    }

    private void initSQLStatement(RowSet rowSet) throws SQLException {
        this.insertClause = new StringBuffer("INSERT INTO " + this.getTableName(rowSet) + "(");
        this.updateClause = new StringBuffer("UPDATE " + this.getTableName(rowSet) + " SET ");
        this.deleteClause = new StringBuffer("DELETE FROM " + this.getTableName(rowSet) + " WHERE ");
        this.rsmd = rowSet.getMetaData();
        this.columnCount = this.rsmd.getColumnCount();
        int n = 0;
        while (n < this.columnCount) {
            if (n != 0) {
                this.insertClause.append(", ");
            }
            this.insertClause.append(this.rsmd.getColumnName(n + 1));
            if (n != 0) {
                this.updateClause.append(", ");
            }
            this.updateClause.append(String.valueOf(this.rsmd.getColumnName(n + 1)) + " = :" + n);
            if (n != 0) {
                this.deleteClause.append(" AND ");
            }
            this.deleteClause.append(String.valueOf(this.rsmd.getColumnName(n + 1)) + " = :" + n);
            ++n;
        }
        this.insertClause.append(") VALUES (");
        this.updateClause.append(" WHERE ");
        int n2 = 0;
        while (n2 < this.columnCount) {
            if (n2 != 0) {
                this.insertClause.append(", ");
            }
            this.insertClause.append(":" + n2);
            if (n2 != 0) {
                this.updateClause.append(" AND ");
            }
            this.updateClause.append(String.valueOf(this.rsmd.getColumnName(n2 + 1)) + " = :" + n2);
            ++n2;
        }
        this.insertClause.append(")");
        this.insertStmt = this.connection.prepareStatement(this.insertClause.substring(0, this.insertClause.length()));
        this.updateStmt = this.connection.prepareStatement(this.updateClause.substring(0, this.updateClause.length()));
        this.deleteStmt = this.connection.prepareStatement(this.deleteClause.substring(0, this.deleteClause.length()));
    }

    private boolean insertRow(OracleRow oracleRow) throws SQLException {
        this.insertStmt.clearParameters();
        int n = 1;
        while (n <= this.columnCount) {
            Object object = null;
            Object object2 = object = oracleRow.isColumnChanged(n) ? oracleRow.getModifiedColumn(n) : oracleRow.getColumn(n);
            if (object == null) {
                this.insertStmt.setNull(n, this.rsmd.getColumnType(n));
            } else {
                this.insertStmt.setObject(n, object);
            }
            ++n;
        }
        return this.insertStmt.executeUpdate() == 1;
    }

    private boolean updateRow(RowSet rowSet, OracleRow oracleRow) throws SQLException {
        this.updateStmt.clearParameters();
        int n = 1;
        while (n <= this.columnCount) {
            Object object = null;
            Object object2 = object = oracleRow.isColumnChanged(n) ? oracleRow.getModifiedColumn(n) : oracleRow.getColumn(n);
            if (object == null) {
                this.updateStmt.setNull(n, this.rsmd.getColumnType(n));
            } else {
                this.updateStmt.setObject(n, object);
            }
            ++n;
        }
        int n2 = 1;
        while (n2 <= this.columnCount) {
            if (oracleRow.isOriginalNull(n2)) {
                return this.updateRowWithNull(rowSet, oracleRow);
            }
            this.updateStmt.setObject(n2 + this.columnCount, oracleRow.getColumn(n2));
            ++n2;
        }
        return this.updateStmt.executeUpdate() == 1;
    }

    private boolean updateRowWithNull(RowSet rowSet, OracleRow oracleRow) throws SQLException {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer("UPDATE " + this.getTableName(rowSet) + " SET ");
        int n = 1;
        while (n <= this.columnCount) {
            if (n != 1) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(String.valueOf(this.rsmd.getColumnName(n)) + " = :" + n);
            ++n;
        }
        stringBuffer.append(" WHERE ");
        int n2 = 1;
        while (n2 <= this.columnCount) {
            if (n2 != 1) {
                stringBuffer.append(" AND ");
            }
            if (oracleRow.isOriginalNull(n2)) {
                stringBuffer.append(String.valueOf(this.rsmd.getColumnName(n2)) + " IS NULL ");
            } else {
                stringBuffer.append(String.valueOf(this.rsmd.getColumnName(n2)) + " = :" + n2);
            }
            ++n2;
        }
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.connection.prepareStatement(stringBuffer.substring(0, stringBuffer.length()));
            int n3 = 1;
            while (n3 <= this.columnCount) {
                Object object = null;
                Object object2 = object = oracleRow.isColumnChanged(n3) ? oracleRow.getModifiedColumn(n3) : oracleRow.getColumn(n3);
                if (object == null) {
                    preparedStatement.setNull(n3, this.rsmd.getColumnType(n3));
                } else {
                    preparedStatement.setObject(n3, object);
                }
                ++n3;
            }
            int n4 = 1;
            int n5 = 1;
            while (n4 <= this.columnCount) {
                if (!oracleRow.isOriginalNull(n4)) {
                    preparedStatement.setObject(n5 + this.columnCount, oracleRow.getColumn(n4));
                    ++n5;
                }
                ++n4;
            }
            bl = preparedStatement.executeUpdate() == 1;
        }
        finally {
            Object var9_12 = null;
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        return bl;
    }

    public synchronized boolean writeData(RowSetInternal rowSetInternal) throws SQLException {
        OracleCachedRowSet oracleCachedRowSet = (OracleCachedRowSet)rowSetInternal;
        this.connection = ((OracleCachedRowSetReader)oracleCachedRowSet.getReader()).getConnection(rowSetInternal);
        if (this.connection == null) {
            throw new SQLException("Unable to get Connection");
        }
        if (this.connection.getAutoCommit()) {
            this.connection.setAutoCommit(false);
        }
        this.connection.setTransactionIsolation(oracleCachedRowSet.getTransactionIsolation());
        this.initSQLStatement(oracleCachedRowSet);
        if (this.columnCount < 1) {
            this.connection.close();
            return true;
        }
        boolean bl = oracleCachedRowSet.getShowDeleted();
        oracleCachedRowSet.setShowDeleted(true);
        oracleCachedRowSet.beforeFirst();
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        OracleRow oracleRow = null;
        while (oracleCachedRowSet.next()) {
            if (oracleCachedRowSet.rowInserted()) {
                if (oracleCachedRowSet.rowDeleted()) continue;
                oracleRow = oracleCachedRowSet.getCurrentRow();
                bl3 = this.insertRow(oracleRow) || bl3;
                continue;
            }
            if (oracleCachedRowSet.rowUpdated()) {
                oracleRow = oracleCachedRowSet.getCurrentRow();
                bl2 = this.updateRow(oracleCachedRowSet, oracleRow) || bl2;
                continue;
            }
            if (!oracleCachedRowSet.rowDeleted()) continue;
            oracleRow = oracleCachedRowSet.getCurrentRow();
            boolean bl5 = bl4 = this.deleteRow(oracleCachedRowSet, oracleRow) || bl4;
        }
        if (bl2 && bl3 && bl4) {
            this.connection.commit();
        } else {
            this.connection.rollback();
        }
        this.insertStmt.close();
        this.updateStmt.close();
        this.deleteStmt.close();
        this.connection.close();
        oracleCachedRowSet.setShowDeleted(bl);
        return true;
    }
}

