/*
 * Decompiled with CFR 0.152.
 */
package tdg.draw;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import tdg.FontCache;
import tdg.Perspective;
import tdg.SmartText;
import tdg.VC;
import tdg.draw.ImageLoader;

public class TextStyleObj
implements Serializable {
    private static final int NEWLINE = 10;
    private static final int BLANK = 32;
    private static final int FORCE_LINEBREAK = 10;
    private static final int POSSIBLE_LINEBREAK = 32;
    private static final int FORCE_BREAK = 1;
    private static final int POSSIBLE_BREAK = 2;
    private static final int NO_SUCH_CHAR = -1;
    private static final int AUTOFIT_MIN = 200;
    private static final int AUTOFIT_MAX = 2200;
    private static final int MIN_SIZE_PTS = 0;
    private static final int MAX_SIZE_PTS = 128;
    private static final int MIN_SIZE_VC = 0;
    private static final int MAX_SIZE_VC = 6000;
    public static final int ALIGN_HORIZ_LEFT = 0;
    public static final int ALIGN_HORIZ_CENTER = 1;
    public static final int ALIGN_HORIZ_RIGHT = 2;
    public static final int ALIGN_VERT_TOP = 0;
    public static final int ALIGN_VERT_CENTER = 1;
    public static final int ALIGN_VERT_BOTTOM = 2;
    public static final int STYLE_PLAIN = 0;
    public static final int STYLE_ITALIC = 1;
    public static final int STYLE_BOLD = 2;
    public static final int STYLE_UNDERLINE = 4;
    public static final int ROTATE_NONE = 0;
    public static final int ROTATE_90 = 1;
    public static final int ROTATE_270 = 2;
    public static final int HEIGHT_AND_WIDTH_OK = 0;
    public static final int HEIGHT_LARGER = 1;
    public static final int WIDTH_LARGER = 2;
    public static final int WIDTH_AND_HEIGHT_LARGER = 3;
    public boolean m_legendTrunc = false;
    public boolean m_legendTruncated = false;
    public int m_stopAtLine = -1;
    public static final String ELLIPSES = "...";
    private String m_strFontName;
    private boolean m_bUseDC;
    private int m_nFontSizeDC;
    private int m_nFontSizeVC;
    private int m_nFontStyle;
    private int m_nAngleSetting;
    private int m_nJustH;
    private int m_nJustV;
    private boolean m_bAutofit;
    private boolean m_bAdjustBox;
    private boolean m_bWordwrap;
    private boolean m_displayDrillIcon;
    private Dimension m_dimLargestTextDC;
    private int m_nTruncateCount;
    private FontCache m_fontCache;
    static /* synthetic */ Class class$tdg$draw$TextStyleObj;

    public TextStyleObj(FontCache fontCache, String strFontName, int nFontStyle, boolean bUseDC, int nFontSizeDC, int nFontSizeVC, int nAngleSetting, int nJustH, int nJustV, boolean bAutofit, boolean bAdjustBox, boolean bWordwrap) {
        this.m_fontCache = fontCache;
        this.m_strFontName = strFontName;
        this.m_nFontStyle = nFontStyle;
        this.m_bUseDC = bUseDC;
        this.m_nFontSizeDC = nFontSizeDC;
        this.m_nFontSizeVC = nFontSizeVC;
        if (this.m_bUseDC) {
            this.m_nFontSizeDC = this.rangeChkFontPtSize(this.m_nFontSizeDC);
        } else {
            this.m_nFontSizeVC = this.rangeChkFontVCSize(this.m_nFontSizeVC);
        }
        this.m_nAngleSetting = nAngleSetting;
        this.m_nJustH = nJustH;
        this.m_nJustV = nJustV;
        this.m_bAutofit = bAutofit && !bUseDC;
        this.m_bAdjustBox = bAdjustBox;
        this.m_bWordwrap = bWordwrap;
        this.m_nTruncateCount = 0;
        this.m_displayDrillIcon = false;
    }

    public TextStyleObj(TextStyleObj ts) {
        this.copy(ts);
    }

    private int autofit(Graphics gx, String strText, Dimension dim, VC vc) {
        int nIncrement;
        int nTooBigDC = nIncrement = 10;
        int nTooSmallDC = 0;
        if (strText != null) {
            Dimension textDimDC;
            while (true) {
                textDimDC = this.getTextSizeDC(gx, strText, nTooBigDC, vc, dim, null);
                if (textDimDC.width > dim.width || textDimDC.height > dim.height) break;
                nTooBigDC += nIncrement;
                nTooSmallDC += nIncrement;
            }
            do {
                int nTrySizeDC = nTooSmallDC + (nTooBigDC - nTooSmallDC) / 2;
                textDimDC = this.getTextSizeDC(gx, strText, nTrySizeDC, vc, dim, null);
                if (textDimDC.width <= dim.width && textDimDC.height <= dim.height) {
                    nTooSmallDC = nTrySizeDC;
                    continue;
                }
                nTooBigDC = nTrySizeDC;
            } while (nTooSmallDC != nTooBigDC - 1);
            this.m_nFontSizeDC = nTooSmallDC;
            this.m_nFontSizeVC = vc.destToVirtHeight(nTooSmallDC);
        }
        return nTooSmallDC;
    }

    private int autofit(Graphics gx, Vector textTable, Dimension dim, VC vc) {
        int nFontSize = 0;
        nFontSize = vc.getVirtDimension().height;
        int listCount = textTable.size();
        int index = 0;
        while (index < listCount) {
            Object o = textTable.elementAt(index);
            if (o != null && o.getClass().getName().equals("java.lang.String") && ((String)o).length() > 0) {
                String strText = (String)o;
                int nSize = this.autofit(gx, strText, dim, vc);
                nFontSize = Math.min(nFontSize, nSize);
            }
            ++index;
        }
        return nFontSize;
    }

    public void copy(TextStyleObj ts) {
        this.m_fontCache = ts.m_fontCache;
        this.m_strFontName = ts.m_strFontName;
        this.m_nFontStyle = ts.m_nFontStyle;
        this.m_bUseDC = ts.m_bUseDC;
        this.m_nFontSizeDC = ts.m_nFontSizeDC;
        this.m_nFontSizeVC = ts.m_nFontSizeVC;
        this.m_nAngleSetting = ts.m_nAngleSetting;
        this.m_nJustH = ts.m_nJustH;
        this.m_nJustV = ts.m_nJustV;
        this.m_bAutofit = ts.m_bAutofit;
        this.m_bAdjustBox = ts.m_bAdjustBox;
        this.m_bWordwrap = ts.m_bWordwrap;
        this.m_nTruncateCount = ts.m_nTruncateCount;
        this.m_legendTrunc = ts.m_legendTrunc;
        this.m_legendTruncated = ts.m_legendTruncated;
        this.m_stopAtLine = ts.m_stopAtLine;
        this.m_displayDrillIcon = ts.m_displayDrillIcon;
    }

    public void draw(Graphics gx, Component comp, String strText, Rectangle rBoundsDC, Color dropShadowColor, Dimension dropShadowOffset, VC vc) {
        int nFontSizeDC = this.getFontSizeDC(vc);
        int nStyle = TextStyleObj.getStyleBI(this.m_nFontStyle);
        Font font = this.getFont(this.m_strFontName, nStyle, nFontSizeDC);
        FontMetrics fm = gx.getFontMetrics(font);
        gx.setFont(font);
        Vector<String> strLines = new Vector<String>();
        int nNumLines = 1;
        if (this.m_bWordwrap) {
            nNumLines = this.extractLinesWordWrap(strText, strLines, rBoundsDC.width, fm);
        } else {
            strLines.addElement(strText);
        }
        Perspective perspect = (Perspective)comp;
        SmartText smartText = perspect.getSmartText();
        Dimension dimThisLineDC = new Dimension(0, 0);
        Rectangle rTextBoundsDC = new Rectangle(rBoundsDC.x, rBoundsDC.y, rBoundsDC.width, rBoundsDC.height);
        Dimension dimMaxDC = new Dimension(rTextBoundsDC.width, rTextBoundsDC.height);
        int nLine = 0;
        while (nLine < nNumLines) {
            String strThisLine = smartText.getDisplayString(perspect, (String)strLines.elementAt(nLine));
            dimThisLineDC = this.getTextSizeDC(gx, strThisLine, nFontSizeDC, vc, dimMaxDC, dropShadowOffset, false);
            Point ptTextDC = this.alignTextInBox(nLine, nNumLines, fm, rTextBoundsDC, dimThisLineDC);
            if (dropShadowOffset != null) {
                Point ptDropShadow = new Point(ptTextDC.x + dropShadowOffset.width, ptTextDC.y + dropShadowOffset.height);
                Color color = gx.getColor();
                gx.setColor(dropShadowColor);
                gx.drawString(strThisLine, ptDropShadow.x, ptDropShadow.y);
                if ((this.m_nFontStyle & 4) != 0) {
                    int i = 0;
                    while (i < dimThisLineDC.height / 10) {
                        gx.drawLine(ptDropShadow.x, ptDropShadow.y + i + dimThisLineDC.height / 10, ptDropShadow.x + dimThisLineDC.width, ptDropShadow.y + i + dimThisLineDC.height / 10);
                        ++i;
                    }
                }
                gx.setColor(color);
            }
            if (this.m_displayDrillIcon) {
                String imageName = "images/graph_drill_up.gif";
                Image image = TextStyleObj.getImageResource(class$tdg$draw$TextStyleObj == null ? TextStyleObj.class$("tdg.draw.TextStyleObj") : class$tdg$draw$TextStyleObj, imageName);
                int imageSize = 8;
                gx.drawImage(image, ptTextDC.x, ptTextDC.y - (fm.getHeight() - imageSize), null);
                ptTextDC.x += imageSize + 2;
                dimThisLineDC.width -= imageSize + 2;
            }
            gx.drawString(strThisLine, ptTextDC.x, ptTextDC.y);
            if ((this.m_nFontStyle & 4) != 0) {
                int i = 0;
                while (i < dimThisLineDC.height / 10) {
                    gx.drawLine(ptTextDC.x, ptTextDC.y + i + dimThisLineDC.height / 10, ptTextDC.x + dimThisLineDC.width, ptTextDC.y + i + dimThisLineDC.height / 10);
                    ++i;
                }
            }
            ++nLine;
        }
    }

    private Point alignTextInBox(int nLine, int nNumLines, FontMetrics fm, Rectangle rTextDC, Dimension dimThisLineDC) {
        Point ptTextDC = new Point(0, 0);
        switch (this.m_nJustH) {
            case 0: {
                ptTextDC.x = rTextDC.x;
                break;
            }
            default: {
                ptTextDC.x = rTextDC.x + (rTextDC.width - dimThisLineDC.width) / 2;
                break;
            }
            case 2: {
                ptTextDC.x = rTextDC.x + rTextDC.width - dimThisLineDC.width;
            }
        }
        int descent = (int)Math.ceil((double)fm.getDescent() / 2.0);
        switch (this.m_nJustV) {
            case 0: {
                int nLineAdjustment = (nLine + 1) * dimThisLineDC.height;
                ptTextDC.y = rTextDC.y + nLineAdjustment - descent;
                break;
            }
            default: {
                int nLineAdjustment = (nLine + 1) * dimThisLineDC.height;
                int nMiddleY = (rTextDC.height - nNumLines * dimThisLineDC.height) / 2;
                ptTextDC.y = rTextDC.y + nMiddleY + nLineAdjustment - descent;
                break;
            }
            case 2: {
                int nLineAdjustment = (nNumLines - nLine - 1) * dimThisLineDC.height;
                ptTextDC.y = rTextDC.y + rTextDC.height - nLineAdjustment - descent;
            }
        }
        return ptTextDC;
    }

    public int formatAndAutofit(Graphics gx, Perspective perspective, boolean bGroupAutofit, int nMinAutofit, int nMaxAutofit, int nFontSizeVC, Vector strLabels, Dimension labelDimVC, VC vc) {
        boolean bRotate = this.getRotationAngle() != 0;
        Dimension dimLabelDC = bRotate ? new Dimension(vc.virtToDestHeight(labelDimVC.height), vc.virtToDestWidth(labelDimVC.width)) : vc.virtToDest(labelDimVC);
        if (bGroupAutofit && !this.m_bUseDC) {
            int nFontSize = this.autofit(gx, strLabels, dimLabelDC, vc);
            nFontSizeVC = vc.destToVirtHeight(nFontSize);
            if (nFontSizeVC < nMinAutofit) {
                nFontSizeVC = nMinAutofit;
            }
            if (nFontSizeVC > nMaxAutofit) {
                nFontSizeVC = nMaxAutofit;
            }
            this.m_nFontSizeVC = nFontSizeVC;
            this.m_bAutofit = false;
        }
        this.m_dimLargestTextDC = new Dimension(0, 0);
        int nStyle = TextStyleObj.getStyleBI(this.m_nFontStyle);
        int nFontSizeDC = vc.virtToDestHeight(nFontSizeVC);
        Font font = this.getFont(this.m_strFontName, nStyle, nFontSizeDC);
        FontMetrics fm = gx.getFontMetrics(font);
        int i = 0;
        while (i < strLabels.size()) {
            String strText = (String)strLabels.elementAt(i);
            if (strText != null && strText.length() > 0) {
                Dimension dimTextDC = new Dimension(0, 0);
                Vector<String> strLines = new Vector<String>();
                if (this.m_bWordwrap) {
                    this.extractLinesWordWrap(strText, strLines, dimLabelDC.width, fm);
                } else {
                    strLines.addElement(strText);
                }
                dimTextDC = this.getSizeBoxDC(strLines, fm);
                this.m_dimLargestTextDC.width = Math.max(this.m_dimLargestTextDC.width, dimTextDC.width);
                this.m_dimLargestTextDC.height = Math.max(this.m_dimLargestTextDC.height, dimTextDC.height);
            }
            ++i;
        }
        int nShrinkBox = 0;
        if (this.m_dimLargestTextDC.height > dimLabelDC.height) {
            ++nShrinkBox;
        }
        if (this.m_dimLargestTextDC.width > dimLabelDC.width) {
            nShrinkBox += 2;
        }
        dimLabelDC.width = Math.min(dimLabelDC.width, this.m_dimLargestTextDC.width);
        dimLabelDC.height = Math.min(dimLabelDC.height, this.m_dimLargestTextDC.height);
        if (bRotate) {
            labelDimVC.width = vc.destToVirtWidth(dimLabelDC.height);
            labelDimVC.height = vc.destToVirtHeight(dimLabelDC.width);
        } else {
            labelDimVC.width = vc.destToVirtWidth(dimLabelDC.width);
            labelDimVC.height = vc.destToVirtHeight(dimLabelDC.height);
        }
        return nShrinkBox;
    }

    public Dimension getDimLargeTextVC(VC vc) {
        Dimension dimLargeVC = null;
        if (this.m_dimLargestTextDC != null) {
            dimLargeVC = new Dimension(this.m_dimLargestTextDC);
            dimLargeVC.width = vc.destToVirtWidth(this.m_dimLargestTextDC.width);
            dimLargeVC.height = vc.destToVirtHeight(this.m_dimLargestTextDC.height);
        }
        return dimLargeVC;
    }

    public Font getFont(VC vc) {
        int nFontSize = this.getFontSizeDC(vc);
        int nStyle = TextStyleObj.getStyleBI(this.m_nFontStyle);
        return this.getFont(this.m_strFontName, nStyle, nFontSize);
    }

    private Font getFont(String strFontName, int nStyle, int nFontSize) {
        Font font = this.m_fontCache != null ? this.m_fontCache.getFont(strFontName, nStyle, nFontSize) : new Font(strFontName, nStyle, nFontSize);
        return font;
    }

    public int getFontSizeDC(VC vc) {
        int nFontSize = this.m_bUseDC ? this.m_nFontSizeDC : vc.virtToDestHeight(this.m_nFontSizeVC);
        nFontSize = this.rangeChkFontPtSize(nFontSize);
        return nFontSize;
    }

    public int getFontSizeVC(VC vc) {
        int nFontSizeVC = this.m_bUseDC ? vc.destToVirtHeight(this.m_nFontSizeDC) : this.m_nFontSizeVC;
        nFontSizeVC = this.rangeChkFontVCSize(nFontSizeVC);
        return nFontSizeVC;
    }

    public int getHorizAlign() {
        return this.m_nJustH;
    }

    public int getRotationAngle() {
        return this.m_nAngleSetting;
    }

    public void setRotationAngle(int nAngle) {
        this.m_nAngleSetting = nAngle;
    }

    public void setFontStyle(int style) {
        this.m_nFontStyle = style;
    }

    public int getFontStyle() {
        return this.m_nFontStyle;
    }

    public int getNumLines(Graphics gx, String strText, int nWidthDC, Dimension dropShadowOffset, VC vc) {
        FontMetrics fm = this.getFontMetrics(gx, vc);
        Vector strLines = new Vector();
        int nNumLines = 1;
        if (this.m_bWordwrap) {
            nNumLines = this.extractLinesWordWrap(strText, strLines, nWidthDC, fm);
        }
        return nNumLines;
    }

    public FontMetrics getFontMetrics(Graphics gx, VC vc) {
        int nFontSizeDC = this.getFontSizeDC(vc);
        int nStyle = TextStyleObj.getStyleBI(this.m_nFontStyle);
        Font font = this.getFont(this.m_strFontName, nStyle, nFontSizeDC);
        FontMetrics fm = gx.getFontMetrics(font);
        return fm;
    }

    public Rectangle getTextBox(Graphics gx, String strText, Rectangle rBoundsDC, Dimension dropShadowOffset, VC vc) {
        int nFontSizeDC = this.getFontSizeDC(vc);
        FontMetrics fm = this.getFontMetrics(gx, vc);
        int nLeading = fm.getLeading();
        Vector<String> strLines = new Vector<String>();
        if (this.m_bWordwrap) {
            this.extractLinesWordWrap(strText, strLines, rBoundsDC.width, fm);
        } else {
            strLines.addElement(strText);
        }
        Rectangle rTextDC = new Rectangle(rBoundsDC.x, rBoundsDC.y, rBoundsDC.width, rBoundsDC.height);
        Dimension dimTextDC = new Dimension(0, 0);
        Dimension dimMaxDC = new Dimension(rTextDC.width, rTextDC.height);
        int nMaxWidth = 0;
        int nLines = strLines.size();
        int iLine = 0;
        while (iLine < nLines) {
            dimTextDC = this.getTextSizeDC(gx, (String)strLines.elementAt(iLine), nFontSizeDC, vc, dimMaxDC, dropShadowOffset, false);
            nMaxWidth = Math.max(dimTextDC.width, nMaxWidth);
            ++iLine;
        }
        return rTextDC;
    }

    public Dimension getTextSizeDC(Graphics gx, String strText, int nFontSizeDC, VC vc, Dimension dimMaxDC, Dimension dropShadowOffset) {
        return this.getTextSizeDC(gx, strText, nFontSizeDC, vc, dimMaxDC, dropShadowOffset, this.m_bWordwrap);
    }

    public Dimension getTextSizeDC(Graphics gx, String strText, int nFontSizeDC, VC vc, Dimension dimMaxDC, Dimension dropShadowOffset, boolean bWordwrap) {
        int nStyle = TextStyleObj.getStyleBI(this.m_nFontStyle);
        Font font = this.getFont(this.m_strFontName, nStyle, nFontSizeDC);
        FontMetrics fm = gx.getFontMetrics(font);
        Vector<String> strLines = new Vector<String>();
        if (bWordwrap) {
            this.extractLinesWordWrap(strText, strLines, dimMaxDC.width, fm);
        } else {
            strLines.addElement(strText);
        }
        Dimension dimTextDC = this.getSizeBoxDC(strLines, fm);
        if (dropShadowOffset != null) {
            dimTextDC.width = dimTextDC.width + dropShadowOffset.width + 1;
        }
        return dimTextDC;
    }

    private Dimension getSizeBoxDC(Vector strLines, FontMetrics fm) {
        int nNumLines = strLines.size();
        Dimension dimTextDC = new Dimension(0, 0);
        int nWidth = 0;
        int i = 0;
        while (i < nNumLines) {
            nWidth = fm.stringWidth((String)strLines.elementAt(i));
            dimTextDC.width = Math.max(dimTextDC.width, nWidth);
            ++i;
        }
        if (this.m_displayDrillIcon) {
            dimTextDC.width += 10;
        }
        dimTextDC.height = nNumLines * TextStyleObj.getFontHeight(fm);
        return dimTextDC;
    }

    public static int getFontHeight(FontMetrics fm) {
        int height = fm.getHeight();
        int percent = 85;
        height = (int)((double)(percent * fm.getHeight()) / 100.0);
        return height;
    }

    public Dimension preDraw(Graphics gx, String strText, Rectangle rBoundsDC, VC vc, Dimension dropShadowOffset) {
        int nFontSizeDC = this.m_bAutofit ? this.autofit(gx, strText, new Dimension(rBoundsDC.width, rBoundsDC.height), vc) : (this.m_bUseDC ? this.m_nFontSizeDC : vc.virtToDestHeight(this.m_nFontSizeVC));
        nFontSizeDC = this.rangeChkFontPtSize(nFontSizeDC);
        Dimension dimMaxDC = new Dimension(rBoundsDC.width, rBoundsDC.height);
        Dimension dimLabelDC = this.getTextSizeDC(gx, strText, nFontSizeDC, vc, dimMaxDC, dropShadowOffset);
        return dimLabelDC;
    }

    public void setHorizAlign(int nJustH) {
        this.m_nJustH = nJustH;
    }

    public void setVertAlign(int nJustV) {
        this.m_nJustV = nJustV;
    }

    private int rangeChkFontPtSize(int nFontPtSize) {
        if (nFontPtSize > 128) {
            nFontPtSize = 128;
        }
        if (nFontPtSize <= 0) {
            nFontPtSize = 1;
        }
        return nFontPtSize;
    }

    private int rangeChkFontVCSize(int nFontVCSize) {
        if (nFontVCSize > 6000) {
            nFontVCSize = 6000;
        }
        if (nFontVCSize <= 0) {
            nFontVCSize = 1;
        }
        return nFontVCSize;
    }

    protected static int getStyleBI(int nStyle) {
        int nStyleBI = 0;
        nStyleBI += (nStyle & 1) != 0 ? 2 : 0;
        return nStyleBI += (nStyle & 2) != 0 ? 1 : 0;
    }

    public int extractLinesWordWrap(String strText, Vector strLines, int nMaxWidth, FontMetrics fm) {
        int nNumLines = 0;
        strLines.removeAllElements();
        int spaceWidth = fm.charWidth(' ');
        if (strText != null) {
            int colPos = 0;
            String separators = " \t\n\r\f";
            String line = "";
            StringTokenizer tokenizer = new StringTokenizer(strText, separators, true);
            while (tokenizer.hasMoreTokens()) {
                boolean firstWord;
                String word = tokenizer.nextToken();
                if (separators.indexOf(word) != -1) {
                    if (!word.equals("\n")) continue;
                    if (this.m_legendTrunc && strLines.size() == this.m_stopAtLine - 1) {
                        strLines.addElement(line + ELLIPSES);
                        return strLines.size();
                    }
                    colPos = 0;
                    strLines.addElement(line);
                    line = "";
                    continue;
                }
                int width = fm.stringWidth(word);
                boolean bl = firstWord = line.length() == 0;
                if (!firstWord) {
                    colPos += spaceWidth;
                }
                if ((colPos += width) > nMaxWidth) {
                    if (!firstWord) {
                        if (this.m_legendTrunc) {
                            if (this.m_stopAtLine == -1) {
                                this.truncateText(strLines, line, nMaxWidth, fm);
                            } else {
                                if (strLines.size() == this.m_stopAtLine - 1) {
                                    this.truncateText(strLines, line + ELLIPSES, nMaxWidth, fm);
                                    return strLines.size();
                                }
                                this.truncateText(strLines, line, nMaxWidth, fm);
                            }
                        } else {
                            strLines.addElement(line);
                        }
                    }
                    line = word;
                    colPos = width;
                    continue;
                }
                if (!firstWord) {
                    line = line + ' ';
                }
                line = line + word;
            }
            if (this.m_legendTrunc) {
                if (this.m_stopAtLine == -1) {
                    this.truncateText(strLines, line, nMaxWidth, fm);
                } else {
                    if (strLines.size() == this.m_stopAtLine - 1) {
                        this.truncateText(strLines, line + ELLIPSES, nMaxWidth, fm);
                        return strLines.size();
                    }
                    this.truncateText(strLines, line, nMaxWidth, fm);
                }
            } else {
                strLines.addElement(line);
            }
        }
        nNumLines = strLines.size();
        return nNumLines;
    }

    public boolean getWordWrap() {
        return this.m_bWordwrap;
    }

    public void setLegendTruncate(boolean trunc, int stopAtLine) {
        this.m_legendTrunc = trunc;
        this.m_stopAtLine = stopAtLine;
    }

    public boolean isLegendTruncated() {
        return this.m_legendTruncated;
    }

    public static int getJavaFontStyle(int pfjStyle) {
        int fontStyle = 0;
        fontStyle |= (pfjStyle & 1) != 0 ? 2 : 0;
        return fontStyle |= (pfjStyle & 2) != 0 ? 1 : 0;
    }

    public static String truncateText(String text, FontMetrics fm, int minChars, int width) {
        int totalChars = text.length();
        if (totalChars > minChars) {
            int j;
            int strWidth = fm.stringWidth(text);
            float wRatio = (float)width / (float)strWidth;
            StringBuffer buffer = new StringBuffer();
            int numChars = 0;
            int twentyPercChars = (int)((double)totalChars * 0.2);
            if (twentyPercChars > 2) {
                if ((double)wRatio > 0.2) {
                    numChars = (int)((float)totalChars * (wRatio -= 0.1f));
                    buffer.append(text.substring(0, numChars));
                }
            } else if (twentyPercChars >= 1 && (double)wRatio > 0.3) {
                numChars = (int)((float)totalChars * (wRatio -= 0.2f));
                buffer.append(text.substring(0, numChars));
            }
            int dotsWidth = fm.stringWidth(ELLIPSES);
            if (fm.stringWidth(buffer.toString()) + dotsWidth < width) {
                j = numChars;
                while (j < text.length()) {
                    buffer.append(text.charAt(j));
                    if (fm.stringWidth(buffer.toString()) + dotsWidth > width) {
                        numChars = j;
                        break;
                    }
                    ++j;
                }
            } else {
                j = numChars - 1;
                while (j >= 0) {
                    buffer.deleteCharAt(j);
                    if (fm.stringWidth(buffer.toString()) + dotsWidth < width) {
                        numChars = j;
                        break;
                    }
                    --j;
                }
            }
            if (numChars < minChars) {
                text = "";
            } else {
                buffer = new StringBuffer(text);
                String subString = buffer.substring(0, numChars);
                text = subString + ELLIPSES;
            }
        } else {
            text = "";
        }
        return text;
    }

    private void truncateText(Vector strLines, String line, int nMaxWidth, FontMetrics fm) {
        if (fm.stringWidth(line) <= nMaxWidth) {
            strLines.addElement(line);
            return;
        }
        this.m_legendTruncated = true;
        line = TextStyleObj.truncateText(line, fm, 2, nMaxWidth);
        strLines.addElement(line);
    }

    public String truncateString(String strText, int nTruncCount) {
        String strTrunc = strText;
        if (strText.length() > nTruncCount && nTruncCount > 3) {
            strTrunc = strText.substring(0, nTruncCount - 3);
            strTrunc = strTrunc.concat(ELLIPSES);
        }
        return strTrunc;
    }

    public static int calcAxisLabelGap(int fontSize) {
        int incrInFont = (fontSize - 10) * 100 / 10;
        int gap = 10 + incrInFont * 50 * 10 / 26000;
        return gap;
    }

    public void setDisplayDrillIcon(boolean flag) {
        this.m_displayDrillIcon = flag;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public static Image getImageResource(Class cl, String name) {
        byte[] imageBuffer;
        Image outImage;
        block14: {
            outImage = null;
            imageBuffer = null;
            InputStream inStream = cl.getResourceAsStream(name);
            if (inStream != null) {
                int n;
                BufferedInputStream inBuffer = new BufferedInputStream(inStream);
                ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
                imageBuffer = new byte[1024];
                while ((n = inBuffer.read(imageBuffer)) > 0) {
                    void var7_9;
                    out.write(imageBuffer, 0, (int)var7_9);
                }
                out.flush();
                imageBuffer = out.toByteArray();
                Object var9_10 = null;
                try {
                    inStream.close();
                }
                catch (IOException e2) {}
                break block14;
                {
                    catch (IOException e) {
                        Object var9_11 = null;
                        try {
                            inStream.close();
                        }
                        catch (IOException e2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var9_12 = null;
                    try {
                        inStream.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        if (imageBuffer != null) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            outImage = tk.createImage(imageBuffer);
            int status = tk.checkImage(outImage, -1, -1, null);
            boolean imageLoaded = false;
            if ((status & 0x30) == 0) {
                ImageLoader load = new ImageLoader(outImage);
                load.start();
                imageLoaded = load.waitFor();
            } else {
                imageLoaded = true;
            }
            if (!imageLoaded) {
                outImage = null;
            }
        }
        return outImage;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

