/*
 * Decompiled with CFR 0.152.
 */
package tdg.draw;

import java.awt.Image;
import java.awt.image.PixelGrabber;
import tdg.draw.ImageLoader;
import tdg.draw.OctreeNode;

class OctreeQuantizer {
    private static final int _MAX_COLORS = 255;
    private int _colors;
    private OctreeNode[] _listHead;
    private OctreeNode[] _listEnd;
    private int _maxDepth = 8;
    private OctreeNode _root = new OctreeNode(this);

    public OctreeQuantizer(Image im) {
        this();
        ImageLoader il = new ImageLoader(im);
        il.start();
        if (!il.waitFor()) {
            throw new IllegalArgumentException("Problem loading...");
        }
        int width = im.getWidth(il);
        int height = im.getHeight(il);
        int[] pixels = new int[width * height];
        PixelGrabber grabber = new PixelGrabber(im.getSource(), 0, 0, width, height, pixels, 0, width);
        try {
            grabber.grabPixels();
        }
        catch (InterruptedException e) {
            throw new IllegalArgumentException("While grabbing pixels:");
        }
        if ((grabber.getStatus() & 0x80) != 0) {
            throw new IllegalArgumentException("Error while fetching image. grabbed " + pixels.length + " pixel values of the " + width + " x " + height + " image.");
        }
        int i = 0;
        while (i < pixels.length) {
            this.addColor(pixels[i]);
            ++i;
        }
    }

    public static void mapColors(int[] pixels) {
        OctreeQuantizer o = new OctreeQuantizer();
        int i = 0;
        while (i < pixels.length) {
            o.addColor(pixels[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < pixels.length) {
            pixels[i2] = o.mapColor(pixels[i2]);
            ++i2;
        }
    }

    public void addColor(int rgb) {
        this._root.addColor(rgb);
    }

    public int mapColor(int rgb) {
        return this._root.mapColor(rgb);
    }

    OctreeNode _getListHead(int i) {
        return this._listHead[i];
    }

    int _getMaxDepth() {
        return this._maxDepth;
    }

    void _incColors() {
        if (++this._colors > 255) {
            this._reduce();
        }
    }

    void _setListHead(int i, OctreeNode n) {
        this._listHead[i] = n;
        this._listEnd[i] = n;
    }

    void _setListEnd(int i, OctreeNode n) {
        this._listEnd[i]._setNext(n);
        this._listEnd[i] = n;
    }

    private OctreeQuantizer() {
        this._listHead = new OctreeNode[8];
        this._listEnd = new OctreeNode[8];
    }

    private OctreeNode _pickNode() {
        int i = this._maxDepth - 2;
        while (i >= 0) {
            OctreeNode n = this._getListHead(i);
            OctreeNode p = null;
            OctreeNode saveNode = null;
            OctreeNode savePrev = null;
            while (n != null) {
                if (n._getChildren() > 1 && (saveNode == null || n._getChildren() < saveNode._getChildren())) {
                    saveNode = n;
                    savePrev = p;
                }
                p = n;
                n = n._getNext();
            }
            if (saveNode != null) {
                if (savePrev == null) {
                    this._listHead[i] = saveNode._getNext();
                } else {
                    OctreeNode nextNode = saveNode._getNext();
                    if (nextNode == null) {
                        this._listEnd[i] = savePrev;
                    }
                    savePrev._setNext(nextNode);
                }
                return saveNode;
            }
            --this._maxDepth;
            --i;
        }
        return null;
    }

    private void _reduce() {
        OctreeNode n = this._pickNode();
        n._setMaxLevel(n._getLevel());
        n._computeColor();
        this._colors -= n._getChildren() - 1;
        n._setChildren(0);
    }
}

