/*
 * Decompiled with CFR 0.152.
 */
package tdg.draw;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.image.FilteredImageSource;
import java.awt.image.PixelGrabber;
import tdg.Perspective;
import tdg.VC;
import tdg.draw.ColorObj;
import tdg.draw.FillObj;
import tdg.draw.RotateImageFilter;
import tdg.draw.TextStyleObj;

public class FillColorObj
extends FillObj {
    private ColorObj m_ColorFill;

    public FillColorObj() {
        this.m_ColorFill = new ColorObj();
    }

    public FillColorObj(Color c) {
        this.m_ColorFill = new ColorObj(c);
    }

    public void copy(FillObj fo) {
        this.m_ColorFill.copy(((FillColorObj)fo).m_ColorFill);
    }

    public boolean equals(Object obj) {
        boolean bEqual;
        if (obj instanceof FillColorObj) {
            FillColorObj fco = (FillColorObj)obj;
            bEqual = this.m_ColorFill.equals(fco.m_ColorFill);
        } else {
            bEqual = false;
        }
        return bEqual;
    }

    public void fillOval(Graphics g, Component c, int x, int y, int width, int height) {
        g.setColor(this.m_ColorFill.getColor());
        g.fillOval(x, y, width, height);
    }

    public void fillPolygon(Graphics g, Component c, Polygon p) {
        g.setColor(this.m_ColorFill.getColor());
        g.fillPolygon(p.xpoints, p.ypoints, p.npoints);
    }

    public void fillPolygon(Graphics g, Component c, GeneralPath p) {
        g.setColor(this.m_ColorFill.getColor());
        Graphics2D g2 = (Graphics2D)g;
        g2.fill(p);
    }

    public void fillPolygon(Graphics g, Component c, Area area) {
        g.setColor(this.m_ColorFill.getColor());
        Graphics2D g2 = (Graphics2D)g;
        g2.fill(area);
    }

    public void fillPolygon(Graphics g, Component c, int[] nXPoints, int[] nYPoints, int nPoints) {
        g.setColor(this.m_ColorFill.getColor());
        g.fillPolygon(nXPoints, nYPoints, nPoints);
    }

    public void fillRect(Graphics g, Component c, int x, int y, int width, int height) {
        g.setColor(this.m_ColorFill.getColor());
        g.fillRect(x, y, width, height);
    }

    public void fillShadedPolygon(Graphics g, Component c, int[] nXPoints, int[] nYPoints, int nPoints, int nShading) {
        ColorObj color = new ColorObj(this.m_ColorFill);
        color.shadeColor(nShading);
        g.setColor(color.getColor());
        g.fillPolygon(nXPoints, nYPoints, nPoints);
    }

    public void fillText(Graphics g, Component c, String szText, Rectangle rBounds, Color dropShadowColor, Dimension dropShadowOffset, TextStyleObj textStyle, VC vc, Color backgroundColor, int nBackgroundFillType, boolean bPrintingInProgress) {
        g.setColor(this.m_ColorFill.getColor());
        if (textStyle.getRotationAngle() == 0) {
            textStyle.preDraw(g, szText, rBounds, vc, dropShadowOffset);
            textStyle.draw(g, c, szText, rBounds, dropShadowColor, dropShadowOffset, vc);
        } else if (nBackgroundFillType == 2) {
            super.fillText(g, c, szText, rBounds, dropShadowColor, dropShadowOffset, textStyle, vc, backgroundColor, nBackgroundFillType, bPrintingInProgress);
        } else {
            this.fillTextRotated(g, c, szText, rBounds, dropShadowColor, dropShadowOffset, textStyle, vc, backgroundColor, nBackgroundFillType, bPrintingInProgress);
        }
    }

    public void fillTextRotated(Graphics g, Component c, String szText, Rectangle rBoundsDC, Color dropShadowColor, Dimension dropShadowOffset, TextStyleObj textStyle, VC vc, Color backgroundColor, int nBackgroundFillType, boolean bPrintingInProgress) {
        if (rBoundsDC.width <= 0 || rBoundsDC.height <= 0) {
            return;
        }
        Rectangle rTextDC = new Rectangle(0, 0, rBoundsDC.height, rBoundsDC.width);
        if (textStyle != null && textStyle.getWordWrap()) {
            Dimension dimTextDC = textStyle.preDraw(g, szText, rTextDC, vc, dropShadowOffset);
            rTextDC.width = Math.max(rTextDC.width, dimTextDC.width);
            rTextDC.height = Math.max(rTextDC.height, dimTextDC.height);
        }
        if (rTextDC.width <= 1 || rTextDC.height <= 1) {
            return;
        }
        if (!(g instanceof Graphics2D)) {
            Perspective persp = (Perspective)c;
            Image imgSmall = persp.createOffscreenImage(rTextDC.width, rTextDC.height);
            Graphics gos = imgSmall.getGraphics();
            Color color = g.getColor();
            gos.setColor(backgroundColor);
            gos.fillRect(0, 0, rTextDC.width, rTextDC.height);
            gos.setColor(color);
            textStyle.draw(gos, c, szText, rTextDC, dropShadowColor, dropShadowOffset, vc);
            gos.dispose();
            imgSmall = c.createImage(new FilteredImageSource(imgSmall.getSource(), new RotateImageFilter(textStyle.getRotationAngle())));
            Point pt = new Point(rBoundsDC.x, rBoundsDC.y);
            this.drawImageJDKPatch(g, imgSmall, pt.x, pt.y, imgSmall.getWidth(null), imgSmall.getHeight(null));
            imgSmall.flush();
        } else {
            rBoundsDC.height = rTextDC.width;
            rBoundsDC.width = rTextDC.height;
            Graphics2D g2d = (Graphics2D)g;
            AffineTransform saveXform = g2d.getTransform();
            AffineTransform rotate = new AffineTransform();
            int oldw = rBoundsDC.width;
            int oldh = rBoundsDC.height;
            int width = rBoundsDC.width;
            rBoundsDC.width = rBoundsDC.height;
            rBoundsDC.height = width;
            rBoundsDC.y = rBoundsDC.y + oldh / 2 - oldw / 2;
            rBoundsDC.x = rBoundsDC.x - oldh / 2 + oldw / 2;
            if (textStyle.getRotationAngle() == 2) {
                rotate.rotate(Math.toRadians(90.0), rBoundsDC.x + rBoundsDC.width / 2, rBoundsDC.y + rBoundsDC.height / 2);
            } else if (textStyle.getRotationAngle() == 1) {
                rotate.rotate(Math.toRadians(270.0), rBoundsDC.x + rBoundsDC.width / 2, rBoundsDC.y + rBoundsDC.height / 2);
            }
            g2d.transform(rotate);
            textStyle.draw(g2d, c, szText, rBoundsDC, dropShadowColor, dropShadowOffset, vc);
            g2d.setTransform(saveXform);
        }
    }

    private void drawImageJDKPatch(Graphics g, Image img, int x, int y, int nWidth, int nHeight) {
        int[] pixelBuf = new int[nWidth * nHeight];
        PixelGrabber pixelGrab = new PixelGrabber(img, 0, 0, nWidth, nHeight, pixelBuf, 0, nWidth);
        try {
            pixelGrab.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("Interrupted waiting for pixels in drawImageJDKPatch!");
            return;
        }
        if ((pixelGrab.getStatus() & 0x80) != 0) {
            System.err.println("Image fetch aborted or errored in drawImageJDKPatch!");
            return;
        }
        int j = 0;
        while (j < nHeight) {
            int i = 0;
            while (i < nWidth) {
                int X = x + i;
                int Y = y + j;
                int nPixel = pixelBuf[j * nWidth + i];
                int nAlpha = nPixel >> 24 & 0xFF;
                int nRed = nPixel >> 16 & 0xFF;
                int nGreen = nPixel >> 8 & 0xFF;
                int nBlue = nPixel & 0xFF;
                Color savedColor = g.getColor();
                g.setColor(new Color(nRed, nGreen, nBlue));
                g.drawLine(X, Y, X, Y);
                g.setColor(savedColor);
                ++i;
            }
            ++j;
        }
    }

    public Color getColor() {
        return this.m_ColorFill.getColor();
    }

    public void setColor(int r, int g, int b, int a) {
        this.m_ColorFill = new ColorObj(r, g, b, a);
    }
}

