/*
 * Decompiled with CFR 0.152.
 */
package tdg.draw;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import tdg.VC;
import tdg.draw.BlackBoxIF;
import tdg.draw.DetObj;
import tdg.draw.Detectiv;
import tdg.draw.IdentObj;

public class DetRect
extends DetObj {
    public static final float SLOP_FACTOR = 1.05f;
    public static final int PAINT_SHAPE = 0;
    public static final int DO_NOT_PAINT_SHAPE = 1;
    public static final int PERFECT_SQUARE = 2;
    Rectangle m_rBounds;
    Rectangle m_rLooseBounds;
    Rectangle m_rDestBounds;
    boolean m_bLooseBounds;
    boolean m_bDotted = false;
    int m_draw = 0;

    public DetRect(Detectiv detectiv, IdentObj id, int x, int y, int width, int height, BlackBoxIF blackBox) {
        this(detectiv, id, x, y, width, height, blackBox, null, false, true, false);
    }

    public DetRect(Detectiv detectiv, IdentObj id, int x, int y, int width, int height, BlackBoxIF blackBox, boolean bDotted) {
        this(detectiv, id, x, y, width, height, blackBox, null, false, true, false);
        this.m_bDotted = bDotted;
    }

    public DetRect(Detectiv detectiv, IdentObj id, int x, int y, int width, int height, BlackBoxIF blackBox, boolean bMoveable, boolean bDetectable) {
        this(detectiv, id, x, y, width, height, blackBox, null, bMoveable, bDetectable, false);
    }

    public DetRect(Detectiv detectiv, IdentObj id, int width, int height, BlackBoxIF blackBox, Rectangle clipRect) {
        this(detectiv, id, 0, 0, width, height, blackBox, clipRect, false, true, false);
    }

    public DetRect(Detectiv detectiv, IdentObj id, Rectangle r, BlackBoxIF blackBox, Rectangle clipRect) {
        this(detectiv, id, r.x, r.y, r.width, r.height, blackBox, clipRect, false, true, false);
    }

    public DetRect(Detectiv detectiv, IdentObj id, Rectangle r, BlackBoxIF blackBox, Rectangle clipRect, int type) {
        this(detectiv, id, r.x, r.y, r.width, r.height, blackBox, clipRect, false, true, false);
        this.m_draw = type;
    }

    public DetRect(Detectiv detectiv, IdentObj id, Rectangle r, BlackBoxIF blackBox) {
        super(detectiv, id, blackBox, null, false, true);
        this.m_draw = 2;
        this.m_rDestBounds = r;
    }

    public DetRect(Detectiv detectiv, IdentObj id, int x, int y, int width, int height, BlackBoxIF blackBox, Rectangle clipRect, boolean bMoveable, boolean bDetectable, boolean bLooseBounds) {
        super(detectiv, id, blackBox, clipRect, bMoveable, bDetectable);
        this.m_bLooseBounds = bLooseBounds;
        this.m_rBounds = new Rectangle(x, y, width, height);
        if (bLooseBounds) {
            this.m_rLooseBounds = new Rectangle(x, y, width, height);
            this.setBounds(x, y, width, height);
        } else {
            this.m_rLooseBounds = this.m_rBounds;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DetRect)) {
            return false;
        }
        DetRect detRect = (DetRect)obj;
        return this.m_id.equals(detRect.m_id);
    }

    public Rectangle getBounds() {
        if (this.m_draw == 2) {
            Rectangle rect = this.m_Detectiv.getPerspective().getVC().destToVirt(this.m_rDestBounds);
            return new Rectangle(rect.x, rect.y, rect.width, rect.height);
        }
        return new Rectangle(this.m_rBounds.x, this.m_rBounds.y, this.m_rBounds.width, this.m_rBounds.height);
    }

    public Rectangle getLooseBounds() {
        if (this.m_draw == 2) {
            Rectangle rect = this.m_Detectiv.getPerspective().getVC().destToVirt(this.m_rDestBounds);
            return new Rectangle(rect.x, rect.y, rect.width, rect.height);
        }
        return new Rectangle(this.m_rLooseBounds.x, this.m_rLooseBounds.y, this.m_rLooseBounds.width, this.m_rLooseBounds.height);
    }

    public void hilite(Graphics g, VC vc) {
        if (this.m_draw != 1) {
            Rectangle dest = null;
            dest = this.m_draw == 2 ? this.m_rDestBounds : vc.virtToDest(this.m_rBounds);
            g.setXORMode(Color.yellow);
            g.drawRect(dest.x, dest.y, dest.width, dest.height);
            g.setPaintMode();
        }
    }

    public boolean isPointInObj(int x, int y, VC vc) {
        if (this.m_draw == 2) {
            return this.m_bDetectable && this.m_rDestBounds.contains(vc.virtToDestX(x), vc.virtToDestY(y));
        }
        return this.m_bDetectable && this.m_rLooseBounds.contains(x, y);
    }

    public boolean isPointInObj(Point pt, VC vc) {
        return this.isPointInObj(pt.x, pt.y, vc);
    }

    public void paintIt(Graphics g, VC vc) {
        if (this.m_draw == 1) {
            return;
        }
        if (this.m_clipRect != null) {
            Rectangle rClip = vc.virtToDest(this.m_clipRect);
            Shape shape = g.getClip();
            g.setClip(rClip);
            if (this.m_bDotted) {
                this.m_blackBox.paint(g, vc.virtToDest(this.m_rBounds), false, true);
            } else {
                this.m_blackBox.paint(g, vc.virtToDest(this.m_rBounds));
            }
            g.setClip(shape);
        } else {
            if (this.m_draw == 2) {
                this.m_blackBox.paint(g, this.m_rDestBounds);
                return;
            }
            if (this.m_bDotted) {
                this.m_blackBox.paint(g, vc.virtToDest(this.m_rBounds), false, true, true);
            } else {
                this.m_blackBox.paint(g, vc.virtToDest(this.m_rBounds));
            }
        }
    }

    public void setBounds(Rectangle rBounds) {
        this.setBounds(rBounds.x, rBounds.y, rBounds.width, rBounds.height);
    }

    public void setBounds(int x, int y, int w, int h) {
        this.m_rBounds.x = x;
        this.m_rBounds.y = y;
        this.m_rBounds.width = w;
        this.m_rBounds.height = h;
        if (this.m_bLooseBounds) {
            float xCenter = (float)x + (float)w / 2.0f;
            float yCenter = (float)y + (float)h / 2.0f;
            float fWidth = (float)w * 1.05f;
            float fHeight = (float)h * 1.05f;
            this.m_rLooseBounds.x = (int)((double)xCenter - (double)fWidth / 2.0);
            this.m_rLooseBounds.y = (int)((double)yCenter - (double)fHeight / 2.0);
            this.m_rLooseBounds.width = (int)fWidth;
            this.m_rLooseBounds.height = (int)fHeight;
        }
    }

    public Polygon getShape(VC vc) {
        if (this.m_rDestBounds != null) {
            return this.rectToPoly(vc.destToVirt(this.m_rDestBounds));
        }
        return this.rectToPoly(this.m_rBounds);
    }
}

