/*
 * Decompiled with CFR 0.152.
 */
package tdg.draw;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.Serializable;
import tdg.ObjClassID;
import tdg.VC;
import tdg.draw.BlackBoxIF;
import tdg.draw.BlackBoxObj;
import tdg.draw.Detectiv;
import tdg.draw.IdentObj;

public abstract class DetObj
implements Serializable {
    protected static final int SLOP_THICKNESS = 5;
    protected IdentObj m_id;
    protected BlackBoxIF m_blackBox;
    protected boolean m_bDetectable;
    protected boolean m_bHiliteable;
    private boolean m_bMoveable;
    private double m_nData;
    protected String m_szRefLabel;
    protected Rectangle m_clipRect;
    protected Detectiv m_Detectiv;
    private boolean m_bReferenceObj = false;

    protected DetObj(Detectiv detectiv, IdentObj id, BlackBoxIF blackBox, Rectangle clipRect, boolean bMoveable, boolean bDetectable) {
        this(detectiv, id, blackBox, clipRect, bMoveable, bDetectable, true);
    }

    protected DetObj(Detectiv detectiv, IdentObj id, BlackBoxIF blackBox, Rectangle clipRect, boolean bMoveable, boolean bDetectable, boolean bHiliteable) {
        IdentObj erID;
        this.m_id = id;
        this.m_blackBox = blackBox;
        this.m_clipRect = clipRect;
        this.m_bMoveable = bMoveable;
        this.m_bDetectable = bDetectable;
        this.m_bHiliteable = bHiliteable;
        this.m_Detectiv = detectiv;
        this.m_bReferenceObj = false;
        if (this.m_Detectiv.m_bExceptionalFlag && id.canBeExceptional() && this.m_Detectiv.isExceptionalAllowed() && (erID = this.m_Detectiv.getExceptionalID(id)) != null) {
            int oExceptional = ObjClassID.addExceptionalOffset(0);
            this.m_id = new IdentObj(oExceptional, id.getSeriesID(), id.getGroupID());
            this.m_blackBox = new BlackBoxObj(this.m_Detectiv.getPerspective(), erID);
            oExceptional = ObjClassID.addExceptionalOffset(id.getObjectID());
            this.m_id = new IdentObj(oExceptional, id.getSeriesID(), id.getGroupID());
            this.m_id.setMiscID(id.getMiscID());
        }
        this.m_Detectiv.insertDetNode(this);
    }

    public BlackBoxIF getBlackBox() {
        return this.m_blackBox;
    }

    public int getGroupID() {
        return this.m_id.m_groupID;
    }

    public IdentObj getIdentID() {
        return new IdentObj(this.m_id);
    }

    public IdentObj getIdentIDRef() {
        return this.m_id;
    }

    public Rectangle getLooseBounds() {
        return this.getBounds();
    }

    public int getObjectID() {
        return this.m_id.m_objectID;
    }

    public int getSeriesID() {
        return this.m_id.m_seriesID;
    }

    public boolean idMatchExactly(IdentObj id) {
        return this.m_id.equals(id);
    }

    public boolean isDetectable() {
        return this.m_bDetectable;
    }

    public boolean isExceptional() {
        return this.m_id.isExceptional();
    }

    public boolean isHiliteable() {
        return this.m_bHiliteable;
    }

    public boolean isMoveable() {
        return this.m_bMoveable;
    }

    public boolean isSelRelated(DetObj dto, int nColorMode) {
        boolean bRelated = false;
        if (nColorMode == 3) {
            if (this.getIdentID().isColorByHeightRelated()) {
                if (dto.getIdentID().isColorByHeightRelated()) {
                    bRelated = this.m_blackBox.equals(dto.m_blackBox);
                }
            } else {
                bRelated = this.getObjectID() == dto.getObjectID() && dto.isDetectable();
            }
        } else if (this.getIdentID().isSeriesRelated()) {
            if (dto.getIdentID().isSeriesRelated()) {
                bRelated = nColorMode == 2 ? this.getGroupID() == dto.getGroupID() : this.getSeriesID() == dto.getSeriesID();
            }
        } else {
            bRelated = this.getIdentID().isGroupRelated() ? dto.getIdentID().isGroupRelated() && this.getGroupID() == dto.getGroupID() : this.getObjectID() == dto.getObjectID() && dto.isDetectable();
        }
        return bRelated;
    }

    public void paint(Graphics g, VC vc) {
        this.paintIt(g, vc);
    }

    public String toString() {
        return this.m_id.toString();
    }

    public Polygon rectToPoly(Rectangle rect) {
        int[] xPts = new int[]{rect.x, rect.x + rect.width, rect.x + rect.width, rect.x};
        int[] yPts = new int[]{rect.y, rect.y, rect.y + rect.height, rect.y + rect.height};
        return new Polygon(xPts, yPts, 4);
    }

    public void setReferenceData(double data) {
        this.m_nData = data;
    }

    public void setReferenceLabel(String str) {
        this.m_szRefLabel = str;
    }

    public double getReferenceData() {
        return this.m_nData;
    }

    public String getReferenceLabel() {
        return this.m_szRefLabel;
    }

    public boolean IsReferenceObject() {
        return this.m_bReferenceObj;
    }

    public void setReferenceObject() {
        this.m_bReferenceObj = true;
    }

    public boolean getReferenceObject() {
        return this.m_bReferenceObj;
    }

    public abstract Rectangle getBounds();

    public abstract void hilite(Graphics var1, VC var2);

    public abstract boolean isPointInObj(int var1, int var2, VC var3);

    public abstract boolean isPointInObj(Point var1, VC var2);

    public abstract void paintIt(Graphics var1, VC var2);

    public abstract void setBounds(Rectangle var1);

    public abstract Polygon getShape(VC var1);
}

