/*
 * Decompiled with CFR 0.152.
 */
package tdg.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.io.Serializable;
import tdg.Perspective;
import tdg.VC;
import tdg.draw.ColorObj;

public class BorderObj
implements Serializable {
    static final int DOTTED_SIZE = 2;
    private ColorObj m_ColorObj = new ColorObj();

    public BorderObj() {
    }

    public BorderObj(Color c) {
        this.m_ColorObj.setColor(c);
    }

    public BorderObj(BorderObj b) {
        this.copy(b);
    }

    public void copy(BorderObj b) {
        this.m_ColorObj.copy(b.m_ColorObj);
    }

    public Color getColor() {
        return this.m_ColorObj.getColor();
    }

    public void paint(Graphics g, Point a, Point b) {
        g.setColor(this.m_ColorObj.getColor());
        g.drawLine(a.x, a.y, b.x, b.y);
    }

    public void paint(Graphics g, Perspective pfj, Polygon p) {
        g.setColor(this.m_ColorObj.getColor());
        VC vc = pfj.getVC();
        g.drawPolygon(p.xpoints, p.ypoints, p.npoints);
    }

    public void paint(Graphics g, Perspective pfj, Area area) {
        g.setColor(this.m_ColorObj.getColor());
        Graphics2D g2 = (Graphics2D)g;
        if (Perspective.compareVersions(Perspective.m_JavaVersion, "1.4.0") == -1 || pfj.getPrimitiveAntialiasing()) {
            g2.draw(area);
        } else {
            g2.setStroke(new BasicStroke(1.01f));
            g2.draw(area);
            g2.setStroke(new BasicStroke(1.0f));
        }
    }

    public void paint(Graphics g, Perspective pfj, GeneralPath path) {
        g.setColor(this.m_ColorObj.getColor());
        Graphics2D g2 = (Graphics2D)g;
        g2.draw(path);
    }

    public void paint(Graphics g, Polygon p) {
        g.setColor(this.m_ColorObj.getColor());
        g.drawPolygon(p.xpoints, p.ypoints, p.npoints);
    }

    public void paint(Graphics g, Rectangle r) {
        g.setColor(this.m_ColorObj.getColor());
        g.drawRect(r.x, r.y, r.width, r.height);
    }

    public void paint(Graphics g, Rectangle r, boolean bDotted) {
        g.setColor(this.m_ColorObj.getColor());
        int nX = r.x;
        int nXRight = r.x + r.width - 2;
        while (nX <= nXRight) {
            g.drawLine(nX, r.y, nX + 2, r.y);
            nX += 4;
        }
        nX = r.x;
        while (nX <= nXRight) {
            g.drawLine(nX, r.y + r.height, nX + 2, r.y + r.height);
            nX += 4;
        }
        int nY = r.y;
        int nYBot = r.y + r.height - 2;
        while (nY <= nYBot) {
            g.drawLine(r.x, nY, r.x, nY + 2);
            nY += 4;
        }
        nY = r.y;
        nYBot = r.y + r.height - 2;
        while (nY <= nYBot) {
            g.drawLine(r.x + r.width, nY, r.x + r.width, nY + 2);
            nY += 4;
        }
        g.drawLine(r.x, r.y, r.x + 1, r.y);
        g.drawLine(r.x, r.y, r.x, r.y + 1);
        g.drawLine(r.x, r.y + r.height - 1, r.x, r.y + r.height);
        g.drawLine(r.x, r.y + r.height, r.x + 1, r.y + r.height);
        g.drawLine(r.x + r.width - 1, r.y + r.height, r.x + r.width, r.y + r.height);
        g.drawLine(r.x + r.width, r.y + r.height - 1, r.x + r.width, r.y + r.height);
        g.drawLine(r.x + r.width - 1, r.y, r.x + r.width, r.y);
        g.drawLine(r.x + r.width, r.y, r.x + r.width, r.y + 1);
    }

    public void paintOval(Graphics g, Rectangle r) {
        g.setColor(this.m_ColorObj.getColor());
        g.drawOval(r.x, r.y, r.width, r.height);
    }

    public void setColor(Color color) {
        this.m_ColorObj.setColor(color);
    }

    public void paint(Graphics g, Point a, Point b, int nThickness) {
        g.setColor(this.m_ColorObj.getColor());
        g.drawLine(a.x, a.y, b.x, b.y);
        g.fillRect(a.x, a.y, b.x - b.y, nThickness);
    }

    public void paintOval(Graphics g, Rectangle r, int nThickness, int nUnitWidth) {
        g.setColor(this.m_ColorObj.getColor());
        g.drawOval(r.x, r.y, r.width, r.height);
    }
}

