/*
 * Decompiled with CFR 0.152.
 */
package tdg;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.io.Serializable;

public final class VC
implements Serializable {
    public static final int DEFAULT_VX = 16000;
    public static final int DEFAULT_VY = 16000;
    private double m_dvWidth;
    private double m_dvHeight;
    private double m_vdWidth;
    private double m_vdHeight;
    private double m_dvOffX;
    private double m_dvOffY;
    private double m_vdOffX;
    private double m_vdOffY;
    private int m_destWidth;
    private int m_destHeight;
    private int m_virtWidth;
    private int m_virtHeight;

    public VC(double destWidth, double destHeight) {
        this(destWidth, destHeight, 32000.0, 32000.0);
    }

    public VC(double destWidth, double destHeight, double virtWidth, double virtHeight) {
        this.m_dvWidth = virtWidth / destWidth;
        this.m_dvHeight = virtHeight / destHeight;
        this.m_vdWidth = destWidth / virtWidth;
        this.m_vdHeight = destHeight / virtHeight;
        this.m_dvOffX = -virtWidth / 2.0;
        this.m_dvOffY = virtHeight / 2.0;
        this.m_vdOffX = destWidth / 2.0;
        this.m_vdOffY = destHeight / 2.0;
        this.m_virtWidth = (int)virtWidth;
        this.m_virtHeight = (int)virtHeight;
        this.m_destWidth = (int)destWidth;
        this.m_destHeight = (int)destHeight;
    }

    public VC(VC source) {
        this(source.m_destWidth, source.m_destHeight, source.m_virtWidth, source.m_virtHeight);
    }

    public Point destToVirt(int dx, int dy) {
        return this.destToVirt(new Point(dx, dy));
    }

    public Dimension destToVirt(Dimension d) {
        return new Dimension((int)Math.round((double)d.width * this.m_dvWidth), (int)Math.round((double)d.height * this.m_dvHeight));
    }

    public Point destToVirt(Point dest) {
        double x = this.dvX(dest.x);
        double y = this.dvY(dest.y);
        Point virt = new Point((int)Math.round(x), (int)Math.round(y));
        return virt;
    }

    public Polygon destToVirt(Polygon dest) {
        Polygon virt = new Polygon();
        int i = 0;
        while (i < dest.npoints) {
            double x = this.dvX(dest.xpoints[i]);
            double y = this.dvY(dest.ypoints[i]);
            virt.addPoint((int)Math.round(x), (int)Math.round(y));
            ++i;
        }
        return virt;
    }

    public Rectangle destToVirt(Rectangle dest) {
        double x = this.dvX(dest.x);
        double y = this.dvY(dest.y + dest.height);
        double width = (double)dest.width * this.m_dvWidth;
        double height = (double)dest.height * this.m_dvHeight;
        Rectangle virt = new Rectangle((int)Math.round(x), (int)Math.round(y), (int)Math.round(width), (int)Math.round(height));
        return virt;
    }

    public int destToVirtHeight(int nHeight) {
        return (int)Math.round((double)nHeight * this.m_dvHeight);
    }

    public int destToVirtWidth(int nWidth) {
        return (int)Math.round((double)nWidth * this.m_dvWidth);
    }

    public int destToVirtX(int x) {
        return (int)Math.round(this.dvX(x));
    }

    public int destToVirtY(int y) {
        return (int)Math.round(this.dvY(y));
    }

    private double dvX(double dx) {
        double vx = dx * this.m_dvWidth + this.m_dvOffX;
        return vx;
    }

    private double dvY(double dy) {
        double vy = dy * -this.m_dvHeight + this.m_dvOffY;
        return vy;
    }

    public Rectangle getDestCoords() {
        return new Rectangle(0, 0, this.m_destWidth, this.m_destHeight);
    }

    public Rectangle getVirtCoords() {
        return new Rectangle(-this.m_virtWidth / 2, -this.m_virtHeight / 2, this.m_virtWidth, this.m_virtHeight);
    }

    public Dimension getVirtDimension() {
        return new Dimension(this.m_virtWidth, this.m_virtHeight);
    }

    private double vdX(double vx) {
        double dx = vx * this.m_vdWidth + this.m_vdOffX;
        return dx;
    }

    private double vdY(double vy) {
        double dy = vy * -this.m_vdHeight + this.m_vdOffY;
        return dy;
    }

    public Point virtToDest(int vx, int vy) {
        return this.virtToDest(new Point(vx, vy));
    }

    public Dimension virtToDest(Dimension d) {
        return new Dimension((int)Math.round((double)d.width * this.m_vdWidth), (int)Math.round((double)d.height * this.m_vdHeight));
    }

    public Point virtToDest(Point virt) {
        double x = this.vdX(virt.x);
        double y = this.vdY(virt.y);
        Point dest = new Point((int)Math.round(x), (int)Math.round(y));
        return dest;
    }

    public Polygon virtToDest(Polygon virt) {
        Polygon dest = new Polygon();
        int i = 0;
        while (i < virt.npoints) {
            double x = this.vdX(virt.xpoints[i]);
            double y = this.vdY(virt.ypoints[i]);
            dest.addPoint((int)Math.round(x), (int)Math.round(y));
            ++i;
        }
        return dest;
    }

    public GeneralPath virtToDestPath(Polygon virt) {
        GeneralPath path = new GeneralPath();
        int i = 0;
        while (i < virt.npoints) {
            float x = (float)this.vdX(virt.xpoints[i]);
            float y = (float)this.vdY(virt.ypoints[i]);
            if (i == 0) {
                path.moveTo(x, y);
            }
            path.lineTo(x, y);
            ++i;
        }
        return path;
    }

    public Rectangle virtToDest(Rectangle virt) {
        double dTop = this.vdY(virt.y + virt.height);
        double dBot = this.vdY(virt.y);
        int top = (int)Math.round(dTop);
        int bottom = (int)Math.round(dBot);
        int height = bottom - top;
        double dLeft = this.vdX(virt.x);
        double dRight = this.vdX(virt.x + virt.width);
        int left = (int)Math.round(dLeft);
        int right = (int)Math.round(dRight);
        int width = right - left;
        Rectangle dest = new Rectangle(left, top, width, height);
        return dest;
    }

    public Rectangle virtToDestConstLength(Rectangle virt) {
        int top = (int)Math.round(this.vdY(virt.y + virt.height));
        int height = Math.round(this.virtToDestHeight(virt.height));
        int left = (int)Math.round(this.vdX(virt.x));
        int width = Math.round(this.virtToDestWidth(virt.width));
        Rectangle dest = new Rectangle(left, top, width, height);
        return dest;
    }

    public double virtToDestHeight(double fVHeight) {
        return fVHeight * this.m_vdHeight;
    }

    public int virtToDestHeight(int nVHeight) {
        return (int)Math.round((double)nVHeight * this.m_vdHeight);
    }

    public double virtToDestWidth(double fVWidth) {
        return fVWidth * this.m_vdWidth;
    }

    public int virtToDestWidth(int nVWidth) {
        return (int)Math.round((double)nVWidth * this.m_vdWidth);
    }

    public int virtToDestX(int x) {
        return (int)Math.round(this.vdX(x));
    }

    public int virtToDestY(int y) {
        return (int)Math.round(this.vdY(y));
    }

    public double destToVirtX(double x) {
        return this.dvX(x);
    }

    public double destToVirtY(double y) {
        return this.dvY(y);
    }

    public double virtToDestY(double vy) {
        double dy = vy * -this.m_vdHeight + this.m_vdOffY;
        return dy;
    }
}

