/*
 * Decompiled with CFR 0.152.
 */
package tdg;

import java.awt.Component;
import java.util.Locale;
import tdg.BIDISupport;
import tdg.Perspective;

public class SmartText {
    private BIDISupport m_bidiInt = null;

    public SmartText(BIDISupport bidiInt) {
        this.m_bidiInt = bidiInt;
        if (this.m_bidiInt == null) {
            try {
                Class<?> locUtil = Class.forName("oracle.ewt.util.LocaleUtils");
                Class<?> ewtBIDI = Class.forName("tdg.BIDISupportEWT");
                this.m_bidiInt = (BIDISupport)ewtBIDI.newInstance();
            }
            catch (Exception e) {
                this.m_bidiInt = null;
            }
        }
    }

    public String getDisplayString(Component perspective, String szText) {
        if (this.m_bidiInt != null) {
            Locale loc = perspective.getLocale();
            Perspective perspect = (Perspective)perspective;
            int nDirection = perspect.getTextDirection();
            szText = this.m_bidiInt.getDisplayString(szText, loc, nDirection);
        }
        return szText;
    }

    public int getDefaultTextDirection(Component perspective) {
        int nDirection = 1;
        if (this.m_bidiInt != null) {
            Locale loc = perspective.getLocale();
            nDirection = this.m_bidiInt.getReadingDirectionForLocale(loc);
        }
        return nDirection;
    }
}

