/*
 * Decompiled with CFR 0.152.
 */
package tdg;

import tdg.Access;
import tdg.DataRange;
import tdg.Perspective;

public class SeriesEnumerator {
    static final boolean FORWARD = true;
    static final boolean REVERSE = false;
    int[] m_seriesArray;
    int m_index;

    SeriesEnumerator(Perspective perspective, Access access, boolean bForward) {
        DataRange drViewable = access.getViewableDataRangeSG(perspective);
        int nViewSeriesStart = drViewable.getRowStart();
        int nViewSeriesStop = drViewable.getRowStop();
        int numSeries = nViewSeriesStop - nViewSeriesStart + 1;
        int numActualSeries = 0;
        this.m_index = 0;
        if (numSeries < 0) {
            this.m_seriesArray = new int[0];
            return;
        }
        this.m_seriesArray = new int[numSeries];
        if (bForward) {
            int index = 0;
            int s = nViewSeriesStart;
            while (s <= nViewSeriesStop) {
                if (!perspective.getIgnoreSeries(s)) {
                    this.m_seriesArray[index++] = s;
                    ++numActualSeries;
                }
                ++s;
            }
            if (numActualSeries < numSeries) {
                int[] smallerArray = new int[numActualSeries];
                System.arraycopy(this.m_seriesArray, 0, smallerArray, 0, numActualSeries);
                this.m_seriesArray = smallerArray;
            }
        } else {
            int index = numSeries - 1;
            int s = nViewSeriesStart;
            while (s <= nViewSeriesStop) {
                if (!perspective.getIgnoreSeries(s)) {
                    this.m_seriesArray[index--] = s;
                    ++numActualSeries;
                }
                ++s;
            }
            if (numActualSeries < numSeries) {
                int delta = numSeries - numActualSeries;
                int[] smallerArray = new int[numActualSeries];
                System.arraycopy(this.m_seriesArray, delta, smallerArray, 0, numActualSeries);
                this.m_seriesArray = smallerArray;
            }
        }
    }

    public int getAbsoluteSeries(int sRelative) {
        return this.seriesAt(sRelative);
    }

    public int getFirstSeries() {
        return this.seriesAt(0);
    }

    public int getLastSeries() {
        return this.seriesAt(this.m_seriesArray.length - 1);
    }

    public int getNumSeries() {
        return this.m_seriesArray.length;
    }

    public int getRelativeSeries(int sAbsolute) {
        int i = 0;
        while (i < this.m_seriesArray.length) {
            if (this.m_seriesArray[i] == sAbsolute) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean hasMoreElements() {
        return this.m_index < this.m_seriesArray.length;
    }

    public int nextSeries() {
        return this.m_seriesArray[this.m_index++];
    }

    public int seriesAt(int index) {
        try {
            return this.m_seriesArray[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return -1;
        }
    }

    public int peekAtNextSeries() {
        return this.seriesAt(this.m_index);
    }

    public int peekAtSeriesAfter(int sAbsolute) {
        int index = this.getRelativeSeries(sAbsolute);
        int sNext = -1;
        if (index >= 0) {
            sNext = this.seriesAt(index + 1);
        }
        return sNext;
    }

    public int peekAtSeriesBefore(int sAbsolute) {
        int index = this.getRelativeSeries(sAbsolute);
        int sNext = -1;
        if (index >= 1) {
            sNext = this.seriesAt(index - 1);
        }
        return sNext;
    }

    public void reset() {
        this.m_index = 0;
    }
}

