/*
 * Decompiled with CFR 0.152.
 */
package tdg;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JPanel;
import tdg.AssertionException;
import tdg.Attr;
import tdg.BackgroundObj;
import tdg.ConfigObj;
import tdg.JChart_Base;
import tdg.LookKeyObj;
import tdg.TDGNestedLabel;
import tdg.TDGProperties;
import tdg.TitleObj;
import tdg.draw.IdentObj;
import tdg.draw.SelList;
import tdg.event.TDGErrorListener;
import tdg.event.TDGErrorManager;
import tdg.event.TDGEventManager;
import tdg.event.TDGListener;

public class PerspectiveBase
extends JPanel {
    protected static final int CALC_TO_BEGIN = 0;
    protected static final int CALC_COMPLETE = 1;
    protected static final int CALC_DONE_DRAW_IN_PROGRESS = 2;
    protected static final int CHART_COMPLETE = 3;
    public static final int MAX_EXCEPTIONAL_RISERS = 256;
    public static final int NUM_PRESET_SERIES = 64;
    protected transient BackgroundObj m_background = null;
    protected transient JChart_Base m_chart = null;
    protected transient TitleObj m_title = null;
    protected transient TitleObj m_subtitle = null;
    protected transient TitleObj m_footnote = null;
    public ConfigObj m_config;
    protected TDGProperties m_look;
    private HashMap m_calcLook = null;
    protected TDGErrorManager m_ErrorManager = null;
    protected TDGEventManager m_EventManager = null;
    protected TDGNestedLabel m_O1LabelCallback = null;
    protected SelList m_selList = null;
    protected int m_nChartState = 0;
    protected Vector m_groupLabels = new Vector(100);
    protected Vector m_seriesLabels = new Vector(100);

    public PerspectiveBase() {
        this.m_config = new ConfigObj();
    }

    void sync3DPresetParameters(int newValue) {
    }

    Object getFromLook(Attr AttrID) {
        return this.getFromLook(AttrID, 0);
    }

    Object getFromLook(Attr AttrID, int lookGetType) {
        IdentObj id = this.m_selList.firstElement();
        if (this.m_selList.hasMoreElements()) {
            IdentObj newId;
            switch (lookGetType) {
                case 1: {
                    newId = new IdentObj(-3, id.getSeriesID());
                    break;
                }
                case 2: {
                    newId = new IdentObj(-3, -3, id.getGroupID());
                    break;
                }
                case 3: {
                    newId = new IdentObj(-3, id.getSeriesID(), id.getGroupID());
                    break;
                }
                default: {
                    newId = id;
                }
            }
            return this.getFromLook(newId, AttrID);
        }
        return AttrID.getDefault();
    }

    Object getFromLook(IdentObj id, Attr AttrID) {
        return this.getFromLook(id, AttrID, true);
    }

    Object getFromLook(IdentObj id, Attr AttrID, boolean bUseDefault) {
        Object obj;
        LookKeyObj lookKey = new LookKeyObj(AttrID, id);
        if (this.m_calcLook != null && (obj = this.m_calcLook.get(lookKey)) != null) {
            return obj;
        }
        obj = this.m_look.get(lookKey);
        if (obj != null) {
            return obj;
        }
        lookKey.setStackID(-3);
        lookKey.setMiscID(-3);
        if (!id.isSERIES_NA() && !id.isGROUP_NA()) {
            lookKey.setObjectID(-3);
            lookKey.setSeriesID(id.getSeriesID());
            lookKey.setGroupID(id.getGroupID());
            if (this.m_calcLook != null && (obj = this.m_calcLook.get(lookKey)) != null) {
                return obj;
            }
            obj = this.m_look.get(lookKey);
            if (obj != null) {
                return obj;
            }
        }
        if (!id.isSERIES_NA()) {
            lookKey.setObjectID(-3);
            lookKey.setGroupID(-3);
            lookKey.setSeriesID(id.getSeriesID());
            if (this.m_calcLook != null && (obj = this.m_calcLook.get(lookKey)) != null) {
                return obj;
            }
            obj = this.m_look.get(lookKey);
            if (obj != null) {
                return obj;
            }
        }
        if (!id.isGROUP_NA()) {
            lookKey.setObjectID(-3);
            lookKey.setSeriesID(-3);
            lookKey.setGroupID(id.getGroupID());
            if (this.m_calcLook != null && (obj = this.m_calcLook.get(lookKey)) != null) {
                return obj;
            }
            obj = this.m_look.get(lookKey);
            if (obj != null) {
                return obj;
            }
        }
        if (!id.isOBJECT_NA()) {
            lookKey.setObjectID(id.getObjectID());
            lookKey.setGroupID(-3);
            lookKey.setSeriesID(-3);
            if (this.m_calcLook != null && (obj = this.m_calcLook.get(lookKey)) != null) {
                return obj;
            }
            obj = this.m_look.get(lookKey);
            if (obj != null) {
                return obj;
            }
        }
        if (bUseDefault) {
            return AttrID.getDefault();
        }
        return null;
    }

    protected void destroyCalcLook() {
        this.m_calcLook = null;
    }

    protected void putToLook(Attr AttrID, Object newValue) throws AssertionException {
        this.putToLook(AttrID, newValue, 0);
    }

    protected void putToLook(Attr AttrID, Object newValue, int lookPutType) throws AssertionException {
        IdentObj id = this.m_selList.firstElement();
        while (this.m_selList.hasMoreElements()) {
            IdentObj newId;
            switch (lookPutType) {
                case 1: {
                    newId = new IdentObj(-3, id.getSeriesID());
                    break;
                }
                case 2: {
                    newId = new IdentObj(-3, -3, id.getGroupID());
                    break;
                }
                case 3: {
                    newId = new IdentObj(-3, id.getSeriesID(), id.getGroupID());
                    break;
                }
                default: {
                    newId = id;
                }
            }
            this.putToLook(newId, AttrID, newValue);
            id = this.m_selList.nextElement();
        }
    }

    protected void putToLook(IdentObj id, Attr AttrID, Object newValue) throws AssertionException {
        if (AttrID == null) {
            return;
        }
        AttrID.rangeCheckIfPossible(newValue);
        this.m_look.put(new LookKeyObj(AttrID, id), newValue);
        this.m_nChartState = 0;
    }

    public void putToLookNoCalc(IdentObj id, Attr AttrID, Object newValue) {
        this.putToLookNoCalc(id, AttrID, newValue, false);
    }

    public void putToLookNoCalc(IdentObj id, Attr AttrID, Object newValue, boolean isCalcLook) {
        if (isCalcLook) {
            if (this.m_calcLook == null) {
                this.m_calcLook = new HashMap();
            }
            this.m_calcLook.put(new LookKeyObj(AttrID, id), newValue);
        } else {
            this.m_look.put(new LookKeyObj(AttrID, id), newValue);
        }
    }

    protected void putToLookAndRepaint(IdentObj id, Attr AttrID, Object newValue) throws AssertionException {
        this.putToLook(id, AttrID, newValue);
        if (!this.getManualRedraw()) {
            this.repaint();
        }
    }

    protected void putToLookAndRepaint(Attr AttrID, Object newValue) throws AssertionException {
        this.putToLookAndRepaint(AttrID, newValue, 0);
    }

    protected void putToLookAndRepaint(Attr AttrID, Object newValue, int lookPutType) throws AssertionException {
        this.putToLook(AttrID, newValue, lookPutType);
        if (!this.getManualRedraw()) {
            this.repaint();
        }
    }

    void removeFromLook(Attr attr) {
        this.removeFromLook(attr, 0);
    }

    void removeFromLook(Attr attr, int lookRemoveType) {
        IdentObj id = this.m_selList.firstElement();
        while (this.m_selList.hasMoreElements()) {
            IdentObj newId;
            switch (lookRemoveType) {
                case 1: {
                    newId = new IdentObj(-3, id.getSeriesID());
                    break;
                }
                case 2: {
                    newId = new IdentObj(-3, -3, id.getGroupID());
                    break;
                }
                case 3: {
                    newId = new IdentObj(-3, id.getSeriesID(), id.getGroupID());
                    break;
                }
                default: {
                    newId = id;
                }
            }
            this.removeFromLook(newId, attr);
            id = this.m_selList.nextElement();
        }
    }

    void removeFromLook(IdentObj id, Attr attr) {
        IdentObj NewId;
        Object RemovedKey = this.m_look.remove(new LookKeyObj(attr, id));
        if (RemovedKey == null && !id.isSERIES_NA() && !id.isGROUP_NA()) {
            NewId = new IdentObj(-3, id.getSeriesID(), id.getGroupID());
            RemovedKey = this.m_look.remove(new LookKeyObj(attr, NewId));
        }
        if (RemovedKey == null && !id.isSERIES_NA()) {
            NewId = new IdentObj(-3, id.getSeriesID());
            RemovedKey = this.m_look.remove(new LookKeyObj(attr, NewId));
        }
        if (RemovedKey == null && !id.isGROUP_NA()) {
            NewId = new IdentObj(-3, -3, id.getGroupID());
            RemovedKey = this.m_look.remove(new LookKeyObj(attr, NewId));
        }
        if (RemovedKey == null && !id.isOBJECT_NA()) {
            NewId = new IdentObj(id.getObjectID());
            Object v = this.m_look.remove(new LookKeyObj(attr, NewId));
        }
    }

    void DeleteAttribute(int seriesID, int groupID, Attr AttrID) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        this.removeFromLook(id, AttrID);
    }

    void DeleteAttribute(int seriesID, Attr AttrID) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.removeFromLook(id, AttrID);
    }

    void DeleteAttribute(Attr AttrID) {
        this.removeFromLook(AttrID);
    }

    void DeleteAttribute(IdentObj id, Attr AttrID) {
        this.removeFromLook(id, AttrID);
    }

    public boolean getManualRedraw() {
        Boolean m_Obj = (Boolean)this.getFromLook(IdentObj.GLOBAL, Attr.ManualRedraw);
        return m_Obj;
    }

    public void setManualRedraw(boolean newValue) {
        if (newValue) {
            this.putToLook(IdentObj.GLOBAL, Attr.ManualRedraw, new Boolean(newValue));
        } else {
            this.putToLookAndRepaint(IdentObj.GLOBAL, Attr.ManualRedraw, new Boolean(newValue));
        }
    }

    synchronized void init() {
    }

    static Attr GraphCategory_3D_Attr_Resolution(int AttrID) {
        return null;
    }

    static Attr GraphCategory_BLA_Attr_Resolution(int AttrID) {
        return null;
    }

    static Attr GraphCategory_PIE_Attr_Resolution(int AttrID) {
        return null;
    }

    static Attr GraphCategory_SCATTER_Attr_Resolution(int AttrID) {
        return null;
    }

    static Attr GraphCategory_HILO_Attr_Resolution(int AttrID) {
        return null;
    }

    static Attr GraphCategory_MISC_Attr_Resolution(int AttrID) {
        return null;
    }

    public boolean getUseOffScreen() {
        Boolean m_Obj = (Boolean)this.getFromLook(IdentObj.GLOBAL, Attr.UseOffScreen);
        return m_Obj;
    }

    public void setUseOffScreen(boolean newValue) {
        this.putToLook(IdentObj.GLOBAL, Attr.UseOffScreen, new Boolean(newValue));
    }

    public void addPerspectiveListener(TDGListener Listener) {
        this.m_EventManager.addPerspectiveListener(Listener);
    }

    public void removePerspectiveListener(TDGListener Listener) {
        this.m_EventManager.removePerspectiveListener(Listener);
    }

    public void addErrorListener(TDGErrorListener Listener) {
        this.m_ErrorManager.addErrorListener(Listener);
    }

    public void removeErrorListener(TDGErrorListener Listener) {
        this.m_ErrorManager.removeErrorListener(Listener);
    }

    public boolean getConnectLineMarkers() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.ConnectLineMarkers);
        return m_Obj;
    }

    public void setConnectLineMarkers(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ConnectLineMarkers, new Boolean(newValue));
    }

    public boolean getConnectScatterMarkers() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.ConnectScatterMarkers);
        return m_Obj;
    }

    public void setConnectScatterMarkers(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ConnectScatterMarkers, new Boolean(newValue));
    }

    public double getCubeFocusFactor() {
        Double m_Obj = (Double)this.getFromLook(new IdentObj(2000), Attr.CubeFocusFactor);
        return m_Obj;
    }

    public void setCubeFocusFactor(double newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeFocusFactor, new Double(newValue));
    }

    public void setO1LabelCallback(TDGNestedLabel cb) {
        this.m_O1LabelCallback = cb;
    }

    public TDGNestedLabel getO1LabelCallBack() {
        return this.m_O1LabelCallback;
    }

    public double getCubeSizeX() {
        Double m_Obj = (Double)this.getFromLook(new IdentObj(2000), Attr.CubeSizeX);
        return m_Obj;
    }

    public void setCubeSizeX(double newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeSizeX, new Double(newValue));
    }

    public double getCubeSizeY() {
        Double m_Obj = (Double)this.getFromLook(new IdentObj(2000), Attr.CubeSizeY);
        return m_Obj;
    }

    public void setCubeSizeY(double newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeSizeY, new Double(newValue));
    }

    public double getCubeSizeZ() {
        Double m_Obj = (Double)this.getFromLook(new IdentObj(2000), Attr.CubeSizeZ);
        return m_Obj;
    }

    public void setCubeSizeZ(double newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeSizeZ, new Double(newValue));
    }

    public double getCubeTranslationX() {
        Double m_Obj = (Double)this.getFromLook(new IdentObj(2000), Attr.CubeTranslationX);
        return m_Obj;
    }

    public void setCubeTranslationX(double newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeTranslationX, new Double(newValue));
    }

    public double getCubeTranslationY() {
        Double m_Obj = (Double)this.getFromLook(new IdentObj(2000), Attr.CubeTranslationY);
        return m_Obj;
    }

    public void setCubeTranslationY(double newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeTranslationY, new Double(newValue));
    }

    public double getCubeTranslationZ() {
        Double m_Obj = (Double)this.getFromLook(new IdentObj(2000), Attr.CubeTranslationZ);
        return m_Obj;
    }

    public void setCubeTranslationZ(double newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeTranslationZ, new Double(newValue));
    }

    public double getCubeViewerX() {
        Double m_Obj = (Double)this.getFromLook(new IdentObj(2000), Attr.CubeViewerX);
        return m_Obj;
    }

    public void setCubeViewerX(double newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeViewerX, new Double(newValue));
    }

    public double getCubeViewerY() {
        Double m_Obj = (Double)this.getFromLook(new IdentObj(2000), Attr.CubeViewerY);
        return m_Obj;
    }

    public void setCubeViewerY(double newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeViewerY, new Double(newValue));
    }

    public double getCubeViewerZ() {
        Double m_Obj = (Double)this.getFromLook(new IdentObj(2000), Attr.CubeViewerZ);
        return m_Obj;
    }

    public void setCubeViewerZ(double newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeViewerZ, new Double(newValue));
    }

    public boolean getCubeIsometricProjection() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.CubeIsometricProjection);
        return m_Obj;
    }

    public void setCubeIsometricProjection(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeIsometricProjection, new Boolean(newValue));
    }

    public boolean getSquareMarkers() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.SquareMarkers);
        return m_Obj;
    }

    public void setSquareMarkers(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.SquareMarkers, new Boolean(newValue));
    }

    public boolean getCubeSquareRisers() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.CubeSquareRisers);
        return m_Obj;
    }

    public void setCubeSquareRisers(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeSquareRisers, new Boolean(newValue));
    }

    public int getColorMode() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.ColorMode);
        return m_Obj;
    }

    public void setColorMode(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ColorMode, new Integer(newValue));
    }

    public boolean getAutoshading() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.Autoshading);
        return m_Obj;
    }

    public void setAutoshading(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.Autoshading, new Boolean(newValue));
    }

    public double getCubeWallThickX() {
        Double m_Obj = (Double)this.getFromLook(new IdentObj(2000), Attr.CubeWallThickX);
        return m_Obj;
    }

    public void setCubeWallThickX(double newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeWallThickX, new Double(newValue));
    }

    public double getCubeWallThickY() {
        Double m_Obj = (Double)this.getFromLook(new IdentObj(2000), Attr.CubeWallThickY);
        return m_Obj;
    }

    public void setCubeWallThickY(double newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeWallThickY, new Double(newValue));
    }

    public double getCubeWallThickZ() {
        Double m_Obj = (Double)this.getFromLook(new IdentObj(2000), Attr.CubeWallThickZ);
        return m_Obj;
    }

    public void setCubeWallThickZ(double newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeWallThickZ, new Double(newValue));
    }

    public double getCubeZoomFactor() {
        Double m_Obj = (Double)this.getFromLook(new IdentObj(2000), Attr.CubeZoomFactor);
        return m_Obj;
    }

    public void setCubeZoomFactor(double newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeZoomFactor, new Double(newValue));
    }

    public boolean getDataItemsAlongSeries() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.DataItemsAlongSeries);
        return m_Obj;
    }

    public void setDataItemsAlongSeries(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.DataItemsAlongSeries, new Boolean(newValue));
    }

    public int getDataTextFormat() {
        return this.getTextFormatPreset(new IdentObj(2000));
    }

    public void setDataTextFormat(int newValue) {
        this.setTextFormatPreset(new IdentObj(2000), newValue);
    }

    public int getDataTextAngleDefault() {
        return this.getDataTextAngle(new IdentObj(2000));
    }

    public void setDataTextAngleDefault(int newValue) {
        this.setDataTextAngle(new IdentObj(2000), newValue);
    }

    public boolean getDataTextDisplay() {
        return this.getDisplay(new IdentObj(260));
    }

    public void setDataTextDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(260), newValue);
    }

    public int getDataTextRadiusDefault() {
        return this.getDataTextRadius(new IdentObj(2000));
    }

    public void setDataTextRadiusDefault(int newValue) {
        this.setDataTextRadius(new IdentObj(2000), newValue);
    }

    public int getDepthAngle() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.DepthAngle);
        return m_Obj;
    }

    public void setDepthAngle(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.DepthAngle, new Integer(newValue));
    }

    public int getDepthRadius() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.DepthRadius);
        return m_Obj;
    }

    public void setDepthRadius(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.DepthRadius, new Integer(newValue));
    }

    public boolean getDisplay3DFloor() {
        return this.getDisplay(new IdentObj(514));
    }

    public void setDisplay3DFloor(boolean newValue) {
        this.setDisplay(new IdentObj(514), newValue);
    }

    public boolean getDisplay3DLeftWall() {
        return this.getDisplay(new IdentObj(515));
    }

    public void setDisplay3DLeftWall(boolean newValue) {
        this.setDisplay(new IdentObj(515), newValue);
    }

    public boolean getDisplay3DRightWall() {
        return this.getDisplay(new IdentObj(516));
    }

    public void setDisplay3DRightWall(boolean newValue) {
        this.setDisplay(new IdentObj(516), newValue);
    }

    public int getDualAxisSplitPosition() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.DualAxisSplitPosition);
        return m_Obj;
    }

    public void setDualAxisSplitPosition(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.DualAxisSplitPosition, new Integer(newValue));
    }

    public boolean getFootnoteAutofit() {
        return this.getAutofit(new IdentObj(3));
    }

    public void setFootnoteAutofit(boolean newValue) {
        this.setAutofit(new IdentObj(3), newValue);
    }

    public boolean getFootnoteDisplay() {
        return this.getDisplay(new IdentObj(3));
    }

    public void setFootnoteDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(3), newValue);
    }

    public String getFootnoteString() {
        return this.getTextString(new IdentObj(3));
    }

    public void setFootnoteString(String newValue) {
        this.setTextString(new IdentObj(3), newValue);
        if (this.getCascade() && newValue.length() > 0) {
            this.setFootnoteDisplay(true);
        }
    }

    public boolean getFrameDisplay() {
        return this.getDisplay(new IdentObj(2));
    }

    public void setFrameDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(2), newValue);
    }

    public boolean getGrid3DFloorDisplayX() {
        return this.getDisplay(new IdentObj(525));
    }

    public void setGrid3DFloorDisplayX(boolean newValue) {
        this.setDisplay(new IdentObj(525), newValue);
    }

    public boolean getGrid3DFloorDisplayZ() {
        return this.getDisplay(new IdentObj(526));
    }

    public void setGrid3DFloorDisplayZ(boolean newValue) {
        this.setDisplay(new IdentObj(526), newValue);
    }

    public boolean getGrid3DLeftWallDisplayY() {
        return this.getDisplay(new IdentObj(527));
    }

    public void setGrid3DLeftWallDisplayY(boolean newValue) {
        this.setDisplay(new IdentObj(527), newValue);
    }

    public boolean getGrid3DLeftWallDisplayZ() {
        return this.getDisplay(new IdentObj(528));
    }

    public void setGrid3DLeftWallDisplayZ(boolean newValue) {
        this.setDisplay(new IdentObj(528), newValue);
    }

    public boolean getGrid3DRightWallDisplayX() {
        return this.getDisplay(new IdentObj(529));
    }

    public void setGrid3DRightWallDisplayX(boolean newValue) {
        this.setDisplay(new IdentObj(529), newValue);
    }

    public boolean getGrid3DRightWallDisplayY() {
        return this.getDisplay(new IdentObj(530));
    }

    public void setGrid3DRightWallDisplayY(boolean newValue) {
        this.setDisplay(new IdentObj(530), newValue);
    }

    public boolean getGrid3DRiserDisplayX() {
        return this.getDisplay(new IdentObj(518));
    }

    public void setGrid3DRiserDisplayX(boolean newValue) {
        this.setDisplay(new IdentObj(518), newValue);
    }

    public boolean getGrid3DRiserDisplayY() {
        return this.getDisplay(new IdentObj(519));
    }

    public void setGrid3DRiserDisplayY(boolean newValue) {
        this.setDisplay(new IdentObj(519), newValue);
    }

    public boolean getGrid3DRiserDisplayZ() {
        return this.getDisplay(new IdentObj(520));
    }

    public void setGrid3DRiserDisplayZ(boolean newValue) {
        this.setDisplay(new IdentObj(520), newValue);
    }

    public boolean getLegendAutomatic() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.LegendAutomatic);
        return m_Obj;
    }

    public void setLegendAutomatic(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.LegendAutomatic, new Boolean(newValue));
    }

    public boolean getLegendDisplay() {
        return this.getDisplay(new IdentObj(12));
    }

    public void setLegendDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(12), newValue);
    }

    public int getLegendMarkerPosition() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.LegendMarkerPosition);
        return m_Obj;
    }

    public void setLegendMarkerPosition(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.LegendMarkerPosition, new Integer(newValue));
    }

    public boolean getLegendTextAutofit() {
        return this.getAutofit(new IdentObj(12));
    }

    public void setLegendTextAutofit(boolean newValue) {
        this.setAutofit(new IdentObj(12), newValue);
    }

    public boolean getMarkerDisplay() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.MarkerDisplay);
        return m_Obj;
    }

    public void setMarkerDisplay(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.MarkerDisplay, new Boolean(newValue));
    }

    public int getMarkerSizeDefault() {
        return this.getMarkerSize(new IdentObj(2000));
    }

    public void setMarkerSizeDefault(int newValue) {
        this.setMarkerSize(new IdentObj(2000), newValue);
    }

    public int getO1AxisSide() {
        return this.getAxisSide(new IdentObj(2001));
    }

    public void setO1AxisSide(int newValue) {
        this.setAxisSide(new IdentObj(2001), newValue);
    }

    public boolean getO1ExcludeMaxLabel() {
        return this.getExcludeMaxLabel(this.getO1Label());
    }

    public void setO1ExcludeMaxLabel(boolean newValue) {
        this.setExcludeMaxLabel(this.getO1Label(), newValue);
    }

    public boolean getO1ExcludeMinLabel() {
        return this.getExcludeMinLabel(this.getO1Label());
    }

    public void setO1ExcludeMinLabel(boolean newValue) {
        this.setExcludeMinLabel(this.getO1Label(), newValue);
    }

    public boolean getO1LabelAutofit() {
        return this.getAutofit(this.getO1Label());
    }

    public void setO1LabelAutofit(boolean newValue) {
        this.setAutofit(this.getO1Label(), newValue);
    }

    public boolean getO1LabelDisplay() {
        return this.getDisplay(this.getO1Label());
    }

    public void setO1LabelDisplay(boolean newValue) {
        this.setDisplay(this.getO1Label(), newValue);
    }

    public boolean getO1LabelStagger() {
        return this.getLabelStagger(this.getO1Label());
    }

    public void setO1LabelStagger(boolean newValue) {
        this.setLabelStagger(this.getO1Label(), newValue);
    }

    public boolean getO1LabelWrap() {
        return this.getTextWrap(this.getO1Label());
    }

    public void setO1LabelWrap(boolean newValue) {
        this.setTextWrap(this.getO1Label(), newValue);
    }

    public boolean getO1MajorGridDisplay() {
        return this.getDisplay(new IdentObj(271));
    }

    public void setO1MajorGridDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(271), newValue);
    }

    public int getO1MajorGridStyle() {
        return this.getGridStyle(new IdentObj(271));
    }

    public void setO1MajorGridStyle(int newValue) {
        this.setGridStyle(new IdentObj(271), newValue);
    }

    public boolean getO1MinorGridDisplay() {
        return this.getDisplay(new IdentObj(272));
    }

    public void setO1MinorGridDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(272), newValue);
    }

    public int getO1MinorGridStyle() {
        return this.getGridStyle(new IdentObj(272));
    }

    public void setO1MinorGridStyle(int newValue) {
        this.setGridStyle(new IdentObj(272), newValue);
    }

    public boolean getO1TitleAutofit() {
        return this.getAutofit(new IdentObj(8));
    }

    public void setO1TitleAutofit(boolean newValue) {
        this.setAutofit(new IdentObj(8), newValue);
    }

    public boolean getO1TitleDisplay() {
        return this.getDisplay(new IdentObj(8));
    }

    public void setO1TitleDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(8), newValue);
    }

    public String getO1TitleString() {
        return this.getTextString(new IdentObj(8));
    }

    public void setO1TitleString(String newValue) {
        this.setTextString(new IdentObj(8), newValue);
        if (this.getCascade() && newValue.length() > 0) {
            this.setO1TitleDisplay(true);
        }
    }

    public boolean getO2ExcludeMaxLabel() {
        return this.getExcludeMaxLabel(this.getO2Label());
    }

    public void setO2ExcludeMaxLabel(boolean newValue) {
        this.setExcludeMaxLabel(this.getO2Label(), newValue);
    }

    public boolean getO2ExcludeMinLabel() {
        return this.getExcludeMinLabel(this.getO2Label());
    }

    public void setO2ExcludeMinLabel(boolean newValue) {
        this.setExcludeMinLabel(this.getO2Label(), newValue);
    }

    public boolean getO2LabelAutofit() {
        return this.getAutofit(this.getO2Label());
    }

    public void setO2LabelAutofit(boolean newValue) {
        this.setAutofit(this.getO2Label(), newValue);
    }

    public boolean getO2LabelDisplay() {
        return this.getDisplay(this.getO2Label());
    }

    public void setO2LabelDisplay(boolean newValue) {
        this.setDisplay(this.getO2Label(), newValue);
    }

    public boolean getStockCloseTicksDisplay() {
        return this.getDisplay(new IdentObj(307));
    }

    public void setStockCloseTicksDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(307), newValue);
    }

    public boolean getStockOpenTicksDisplay() {
        return this.getDisplay(new IdentObj(308));
    }

    public void setStockOpenTicksDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(308), newValue);
    }

    public boolean getStockCloseSplitDisplay() {
        return this.getDisplay(new IdentObj(306));
    }

    public void setStockCloseSplitDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(306), newValue);
    }

    public boolean getO2LabelWrap() {
        return this.getTextWrap(this.getO2Label());
    }

    public void setO2LabelWrap(boolean newValue) {
        this.setTextWrap(this.getO2Label(), newValue);
    }

    public boolean getO2TitleAutofit() {
        return this.getAutofit(new IdentObj(9));
    }

    public void setO2TitleAutofit(boolean newValue) {
        this.setAutofit(new IdentObj(9), newValue);
    }

    public boolean getO2TitleDisplay() {
        return this.getDisplay(new IdentObj(9));
    }

    public void setO2TitleDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(9), newValue);
    }

    public String getO2TitleString() {
        return this.getTextString(new IdentObj(9));
    }

    public void setO2TitleString(String newValue) {
        this.setTextString(new IdentObj(9), newValue);
        if (this.getCascade() && newValue.length() > 0) {
            this.setO2TitleDisplay(true);
        }
    }

    public double getCubePanX() {
        Double m_Obj = (Double)this.getFromLook(new IdentObj(2000), Attr.CubePanX);
        return m_Obj;
    }

    public void setCubePanX(double newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubePanX, new Double(newValue));
    }

    public double getCubePanY() {
        Double m_Obj = (Double)this.getFromLook(new IdentObj(2000), Attr.CubePanY);
        return m_Obj;
    }

    public void setCubePanY(double newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubePanY, new Double(newValue));
    }

    public int getPieDepth() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.PieDepth);
        return m_Obj;
    }

    public void setPieDepth(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.PieDepth, new Integer(newValue));
    }

    public int getPieFeelerTextDisplay() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.PieFeelerTextDisplay);
        return m_Obj;
    }

    public void setPieFeelerTextDisplay(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.PieFeelerTextDisplay, new Integer(newValue));
    }

    public int getPieFeelerTextFormat() {
        return this.getTextFormatPreset(new IdentObj(295));
    }

    public void setPieFeelerTextFormat(int newValue) {
        this.setTextFormatPreset(new IdentObj(295), newValue);
    }

    public int getPieLabelDisplay() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.PieLabelDisplay);
        return m_Obj;
    }

    public void setPieLabelDisplay(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.PieLabelDisplay, new Integer(newValue));
    }

    public int getPieRingSize() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.PieRingSize);
        return m_Obj;
    }

    public void setPieRingSize(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.PieRingSize, new Integer(newValue));
    }

    public boolean getPieRingTotalDisplay() {
        return this.getDisplay(new IdentObj(297));
    }

    public void setPieRingTotalDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(297), newValue);
    }

    public int getPieRotate() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.PieRotate);
        return m_Obj;
    }

    public void setPieRotate(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.PieRotate, new Integer(newValue));
    }

    public int getPiesPerRow() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.PiesPerRow);
        return m_Obj;
    }

    public void setPiesPerRow(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.PiesPerRow, new Integer(newValue));
    }

    public int getPieTilt() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.PieTilt);
        return m_Obj;
    }

    public void setPieTilt(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.PieTilt, new Integer(newValue));
    }

    public boolean getReshapeEnable() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.ReshapeEnable);
        return m_Obj;
    }

    public void setReshapeEnable(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ReshapeEnable, new Boolean(newValue));
    }

    public boolean getResizeBarMode() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.ResizeBarMode);
        return m_Obj;
    }

    public void setResizeBarMode(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ResizeBarMode, new Boolean(newValue));
    }

    public int getGridCount() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.GridCount);
        return m_Obj;
    }

    public int getGridCount(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.GridCount);
        return m_Obj;
    }

    public int getGridCount(int objectID) {
        return this.getGridCount(new IdentObj(objectID));
    }

    public void setGridCount(int newValue) {
        this.putToLookAndRepaint(Attr.GridCount, new Integer(newValue));
    }

    public void setGridCount(IdentObj id, int newValue) {
        this.putToLookAndRepaint(id, Attr.GridCount, new Integer(newValue));
    }

    public void setGridCount(int objectID, int newValue) {
        this.setGridCount(new IdentObj(objectID), newValue);
    }

    public double getStock52WeekHighValue() {
        Double m_Obj = (Double)this.getFromLook(new IdentObj(2000), Attr.Stock52WeekHighValue);
        return m_Obj;
    }

    public void setStock52WeekHighValue(double newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.Stock52WeekHighValue, new Double(newValue));
        if (this.getCascade()) {
            this.setStock52WeekHighDisplay(true);
        }
    }

    public boolean getReverseGroups() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.ReverseGroups);
        return m_Obj;
    }

    public void setReverseGroups(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ReverseGroups, new Boolean(newValue));
    }

    public boolean getReverseSeries() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.ReverseSeries);
        return m_Obj;
    }

    public void setReverseSeries(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ReverseSeries, new Boolean(newValue));
    }

    public int getRiser3DThicknessY() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.Riser3DThicknessY);
        return m_Obj;
    }

    public void setRiser3DThicknessY(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.Riser3DThicknessY, new Integer(newValue));
    }

    public int getRiserBarGroupSpacing() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.RiserBarGroupSpacing);
        return m_Obj;
    }

    public void setRiserBarGroupSpacing(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.RiserBarGroupSpacing, new Integer(newValue));
    }

    public int getRiserWidth() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.RiserWidth);
        return m_Obj;
    }

    public void setRiserWidth(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.RiserWidth, new Integer(newValue));
    }

    public boolean getScaleFromZero() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.ScaleFromZero);
        return m_Obj;
    }

    public void setScaleFromZero(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ScaleFromZero, new Boolean(newValue));
    }

    public int getSelectionEnable() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.SelectionEnable);
        return m_Obj;
    }

    public void setSelectionEnable(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.SelectionEnable, new Integer(newValue));
    }

    public boolean getSelectionEnableMove() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.SelectionEnableMove);
        return m_Obj;
    }

    public void setSelectionEnableMove(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.SelectionEnableMove, new Boolean(newValue));
    }

    public int getShadowXOffsetDefault() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.ShadowXOffsetDefault);
        return m_Obj;
    }

    public void setShadowXOffsetDefault(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ShadowXOffsetDefault, new Integer(newValue));
    }

    public int getShadowYOffsetDefault() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.ShadowYOffsetDefault);
        return m_Obj;
    }

    public void setShadowYOffsetDefault(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ShadowYOffsetDefault, new Integer(newValue));
    }

    public boolean getStock52WeekHighDisplay() {
        return this.getDisplay(new IdentObj(304));
    }

    public void setStock52WeekHighDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(304), newValue);
    }

    public boolean getStock52WeekLowDisplay() {
        return this.getDisplay(new IdentObj(305));
    }

    public void setStock52WeekLowDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(305), newValue);
    }

    public boolean getStockMovingAverageDisplay() {
        return this.getDisplay(new IdentObj(309));
    }

    public void setStockMovingAverageDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(309), newValue);
    }

    public int getStockTickLength() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.StockTickLength);
        return m_Obj;
    }

    public void setStockTickLength(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.StockTickLength, new Integer(newValue));
    }

    public boolean getSubtitleAutofit() {
        return this.getAutofit(new IdentObj(4));
    }

    public void setSubtitleAutofit(boolean newValue) {
        this.setAutofit(new IdentObj(4), newValue);
    }

    public boolean getSubtitleDisplay() {
        return this.getDisplay(new IdentObj(4));
    }

    public void setSubtitleDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(4), newValue);
    }

    public String getSubtitleString() {
        return this.getTextString(new IdentObj(4));
    }

    public void setSubtitleString(String newValue) {
        this.setTextString(new IdentObj(4), newValue);
        if (this.getCascade() && newValue.length() > 0) {
            this.setSubtitleDisplay(true);
        }
    }

    public boolean getTitleAutofit() {
        return this.getAutofit(new IdentObj(5));
    }

    public void setTitleAutofit(boolean newValue) {
        this.setAutofit(new IdentObj(5), newValue);
    }

    public boolean getTitleDisplay() {
        return this.getDisplay(new IdentObj(5));
    }

    public void setTitleDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(5), newValue);
    }

    public String getTitleString() {
        return this.getTextString(new IdentObj(5));
    }

    public void setTitleString(String newValue) {
        this.setTextString(new IdentObj(5), newValue);
        if (this.getCascade() && newValue.length() > 0) {
            this.setTitleDisplay(true);
        }
    }

    public boolean getToolTipDisplay() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.ToolTipDisplay);
        return m_Obj;
    }

    public void setToolTipDisplay(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ToolTipDisplay, new Boolean(newValue));
    }

    public boolean getToolTipMode() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.ToolTipMode);
        return m_Obj;
    }

    public void setToolTipMode(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ToolTipMode, new Boolean(newValue));
    }

    public boolean getUseSeriesShapes() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.UseSeriesShapes);
        return m_Obj;
    }

    public void setUseSeriesShapes(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.UseSeriesShapes, new Boolean(newValue));
    }

    public int getViewing3DAnglePreset() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.Viewing3DAnglePreset);
        return m_Obj;
    }

    public void setViewing3DAnglePreset(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.Viewing3DAnglePreset, new Integer(newValue));
        if (this.getCascade()) {
            this.sync3DPresetParameters(newValue);
        }
    }

    public boolean getX1AxisDescending() {
        return this.getAxisDescending(new IdentObj(2003));
    }

    public void setX1AxisDescending(boolean newValue) {
        this.setAxisDescending(new IdentObj(2003), newValue);
    }

    public int getX1AxisSide() {
        return this.getAxisSide(new IdentObj(2003));
    }

    public void setX1AxisSide(int newValue) {
        this.setAxisSide(new IdentObj(2003), newValue);
    }

    public boolean getX1OffScaleDisplay() {
        return this.getDisplayOffScale(new IdentObj(2003));
    }

    public void setX1OffScaleDisplay(boolean newValue) {
        this.setDisplayOffScale(new IdentObj(2003), newValue);
    }

    public boolean getX1ExcludeMaxLabel() {
        return this.getExcludeMaxLabel(new IdentObj(280));
    }

    public void setX1ExcludeMaxLabel(boolean newValue) {
        this.setExcludeMaxLabel(new IdentObj(280), newValue);
    }

    public boolean getX1ExcludeMinLabel() {
        return this.getExcludeMinLabel(new IdentObj(280));
    }

    public void setX1ExcludeMinLabel(boolean newValue) {
        this.setExcludeMinLabel(new IdentObj(280), newValue);
    }

    public boolean getX1LabelAutofit() {
        return this.getAutofit(new IdentObj(280));
    }

    public void setX1LabelAutofit(boolean newValue) {
        this.setAutofit(new IdentObj(280), newValue);
    }

    public boolean getY2TitleDisplay() {
        return this.getDisplay(new IdentObj(7));
    }

    public void setY2TitleDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(7), newValue);
    }

    public boolean getX1LabelDisplay() {
        return this.getDisplay(new IdentObj(280));
    }

    public void setX1LabelDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(280), newValue);
    }

    public int getX1LabelFormat() {
        return this.getTextFormatPreset(new IdentObj(280));
    }

    public void setX1LabelFormat(int newValue) {
        this.setTextFormatPreset(new IdentObj(280), newValue);
    }

    public boolean getX1LabelStagger() {
        return this.getLabelStagger(new IdentObj(280));
    }

    public void setX1LabelStagger(boolean newValue) {
        this.setLabelStagger(new IdentObj(280), newValue);
    }

    public boolean getX1LogScale() {
        return this.getLogScale(new IdentObj(2003));
    }

    public void setX1LogScale(boolean newValue) {
        this.setLogScale(new IdentObj(2003), newValue);
    }

    public boolean getX1MajorGridDisplay() {
        return this.getDisplay(new IdentObj(281));
    }

    public void setX1MajorGridDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(281), newValue);
    }

    public double getX1MajorGridStep() {
        return this.getGridStep(new IdentObj(281));
    }

    public void setX1MajorGridStep(double newValue) {
        this.setGridStep(new IdentObj(281), newValue);
        if (this.getCascade()) {
            this.setX1MajorGridStepAuto(false);
        }
    }

    public boolean getX1MajorGridStepAuto() {
        return this.getGridStepAuto(new IdentObj(281));
    }

    public void setX1MajorGridStepAuto(boolean newValue) {
        this.setGridStepAuto(new IdentObj(281), newValue);
    }

    public int getX1MajorGridStyle() {
        return this.getGridStyle(new IdentObj(281));
    }

    public void setX1MajorGridStyle(int newValue) {
        this.setGridStyle(new IdentObj(281), newValue);
    }

    public boolean getX1MinorGridDisplay() {
        return this.getDisplay(new IdentObj(282));
    }

    public void setX1MinorGridDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(282), newValue);
    }

    public double getX1MinorGridStep() {
        return this.getGridStep(new IdentObj(282));
    }

    public void setX1MinorGridStep(double newValue) {
        this.setGridStep(new IdentObj(282), newValue);
    }

    public boolean getX1MinorGridStepAuto() {
        return this.getGridStepAuto(new IdentObj(282));
    }

    public void setX1MinorGridStepAuto(boolean newValue) {
        this.setGridStepAuto(new IdentObj(282), newValue);
    }

    public int getX1MinorGridStyle() {
        return this.getGridStyle(new IdentObj(282));
    }

    public void setX1MinorGridStyle(int newValue) {
        this.setGridStyle(new IdentObj(282), newValue);
    }

    public boolean getX1MustIncludeZero() {
        if (this.getX1LogScale()) {
            return false;
        }
        return this.getScaleMustIncludeZero(new IdentObj(2003));
    }

    public void setX1MustIncludeZero(boolean newValue) {
        this.setScaleMustIncludeZero(new IdentObj(2003), newValue);
    }

    public double getX1ScaleMax() {
        return this.getScaleMax(new IdentObj(2003));
    }

    public void setX1ScaleMax(double newValue) {
        this.setScaleMax(new IdentObj(2003), newValue);
    }

    public boolean getX1ScaleMaxAuto() {
        return this.getScaleMaxAuto(new IdentObj(2003));
    }

    public void setX1ScaleMaxAuto(boolean newValue) {
        this.setScaleMaxAuto(new IdentObj(2003), newValue);
    }

    public double getX1ScaleMin() {
        return this.getScaleMin(new IdentObj(2003));
    }

    public void setX1ScaleMin(double newValue) {
        this.setScaleMin(new IdentObj(2003), newValue);
    }

    public boolean getX1ScaleMinAuto() {
        return this.getScaleMinAuto(new IdentObj(2003));
    }

    public void setX1ScaleMinAuto(boolean newValue) {
        this.setScaleMinAuto(new IdentObj(2003), newValue);
    }

    public boolean getX1TitleAutofit() {
        return this.getAutofit(new IdentObj(10));
    }

    public void setX1TitleAutofit(boolean newValue) {
        this.setAutofit(new IdentObj(10), newValue);
    }

    public boolean getX1TitleDisplay() {
        return this.getDisplay(new IdentObj(10));
    }

    public void setX1TitleDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(10), newValue);
    }

    public String getX1TitleString() {
        return this.getTextString(new IdentObj(10));
    }

    public void setX1TitleString(String newValue) {
        this.setTextString(new IdentObj(10), newValue);
        if (this.getCascade() && newValue.length() > 0) {
            this.setX1TitleDisplay(true);
        }
    }

    public boolean getX1ZeroLineDisplay() {
        return this.getDisplay(new IdentObj(291));
    }

    public void setX1ZeroLineDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(291), newValue);
    }

    public boolean getY1AxisDescending() {
        return this.getAxisDescending(new IdentObj(2004));
    }

    public void setY1AxisDescending(boolean newValue) {
        this.setAxisDescending(new IdentObj(2004), newValue);
    }

    public int getY1AxisSide() {
        return this.getAxisSide(new IdentObj(2004));
    }

    public void setY1AxisSide(int newValue) {
        this.setAxisSide(new IdentObj(2004), newValue);
    }

    public boolean getY1OffScaleDisplay() {
        return this.getDisplayOffScale(new IdentObj(2004));
    }

    public void setY1OffScaleDisplay(boolean newValue) {
        this.setDisplayOffScale(new IdentObj(2004), newValue);
    }

    public boolean getY1ExcludeMaxLabel() {
        return this.getExcludeMaxLabel(new IdentObj(284));
    }

    public void setY1ExcludeMaxLabel(boolean newValue) {
        this.setExcludeMaxLabel(new IdentObj(284), newValue);
    }

    public int getO1LabelAutoSkip() {
        return this.getAutoSkip(this.getO1Label());
    }

    public void setO1LabelAutoSkip(int newValue) {
        this.setAutoSkip(this.getO1Label(), newValue);
    }

    public int getO1LabelSkipCount() {
        return this.getSkipCount(this.getO1Label());
    }

    public void setO1LabelSkipCount(int newValue) {
        this.setSkipCount(this.getO1Label(), newValue);
    }

    public int getO1LabelSkipBegin() {
        return this.getSkipBegin(this.getO1Label());
    }

    public void setO1LabelSkipBegin(int newValue) {
        this.setSkipBegin(this.getO1Label(), newValue);
    }

    public int getAutoSkip() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.AutoSkip);
        return m_Obj;
    }

    public int getAutoSkip(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.AutoSkip);
        return m_Obj;
    }

    public int getAutoSkip(int objectID) {
        return this.getAutoSkip(new IdentObj(objectID));
    }

    public void setAutoSkip(int newValue) {
        this.putToLookAndRepaint(Attr.AutoSkip, new Integer(newValue));
    }

    public void setAutoSkip(IdentObj id, int newValue) {
        this.putToLookAndRepaint(id, Attr.AutoSkip, new Integer(newValue));
    }

    public void setAutoSkip(int objectID, int newValue) {
        this.setAutoSkip(new IdentObj(objectID), newValue);
    }

    public int getSkipBegin() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.SkipBegin);
        return m_Obj;
    }

    public int getSkipBegin(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.SkipBegin);
        return m_Obj;
    }

    public int getSkipBegin(int objectID) {
        return this.getSkipBegin(new IdentObj(objectID));
    }

    public void setSkipBegin(int newValue) {
        this.putToLookAndRepaint(Attr.SkipBegin, new Integer(newValue));
    }

    public void setSkipBegin(IdentObj id, int newValue) {
        this.putToLookAndRepaint(id, Attr.SkipBegin, new Integer(newValue));
    }

    public void setSkipBegin(int objectID, int newValue) {
        this.setSkipBegin(new IdentObj(objectID), newValue);
    }

    public int getSkipCount() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.SkipCount);
        return m_Obj;
    }

    public int getSkipCount(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.SkipCount);
        return m_Obj;
    }

    public int getSkipCount(int objectID) {
        return this.getSkipCount(new IdentObj(objectID));
    }

    public void setSkipCount(int newValue) {
        this.putToLookAndRepaint(Attr.SkipCount, new Integer(newValue));
    }

    public void setSkipCount(IdentObj id, int newValue) {
        this.putToLookAndRepaint(id, Attr.SkipCount, new Integer(newValue));
    }

    public void setSkipCount(int objectID, int newValue) {
        this.setSkipCount(new IdentObj(objectID), newValue);
    }

    public boolean getExactColorByHeight() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.ExactColorByHeight);
        return m_Obj;
    }

    public void setExactColorByHeight(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ExactColorByHeight, new Boolean(newValue));
    }

    public int getViewableSeries() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.ViewableSeries);
        return m_Obj;
    }

    public void setViewableSeries(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ViewableSeries, new Integer(newValue));
    }

    public int getViewableGroups() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.ViewableGroups);
        return m_Obj;
    }

    public void setViewableGroups(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ViewableGroups, new Integer(newValue));
    }

    public int getViewableSeriesStock() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.ViewableSeriesStock);
        return m_Obj;
    }

    public void setViewableSeriesStock(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ViewableSeriesStock, new Integer(newValue));
    }

    public int getViewableGroupsStock() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.ViewableGroupsStock);
        return m_Obj;
    }

    public void setViewableGroupsStock(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ViewableGroupsStock, new Integer(newValue));
    }

    public int getScrollOffsetSeries() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.ScrollOffsetSeries);
        return m_Obj;
    }

    public void setScrollOffsetSeries(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ScrollOffsetSeries, new Integer(newValue));
    }

    public int getScrollOffsetGroup() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.ScrollOffsetGroup);
        return m_Obj;
    }

    public void setScrollOffsetGroup(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ScrollOffsetGroup, new Integer(newValue));
    }

    public int getSeriesLooping() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.SeriesLooping);
        return m_Obj;
    }

    public void setSeriesLooping(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.SeriesLooping, new Integer(newValue));
    }

    public double getZoomPercentage() {
        Double m_Obj = (Double)this.getFromLook(new IdentObj(2000), Attr.ZoomPercentage);
        return m_Obj;
    }

    public void setZoomPercentage(double newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ZoomPercentage, new Double(newValue));
    }

    public int getRiserBorderMode() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.RiserBorderMode);
        return m_Obj;
    }

    public void setRiserBorderMode(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.RiserBorderMode, new Integer(newValue));
    }

    public boolean getOtherSeries() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.OtherSeries);
        return m_Obj;
    }

    public void setOtherSeries(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.OtherSeries, new Boolean(newValue));
    }

    public double getOtherPercentage() {
        Double m_Obj = (Double)this.getFromLook(new IdentObj(2000), Attr.OtherPercentage);
        return m_Obj;
    }

    public void setOtherPercentage(double newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.OtherPercentage, new Double(newValue));
    }

    public int getCubeRiserInterpolation() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.CubeRiserInterpolation);
        return m_Obj;
    }

    public void setCubeRiserInterpolation(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeRiserInterpolation, new Integer(newValue));
    }

    public boolean getOverdrawSkip() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.OverdrawSkip);
        return m_Obj;
    }

    public void setOverdrawSkip(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.OverdrawSkip, new Boolean(newValue));
    }

    public boolean getInterpretAsHLOC() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.InterpretAsHLOC);
        return m_Obj;
    }

    public void setInterpretAsHLOC(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.InterpretAsHLOC, new Boolean(newValue));
    }

    public boolean getUseSeriesBorderDefaults() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.UseSeriesBorderDefaults);
        return m_Obj;
    }

    public void setUseSeriesBorderDefaults(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.UseSeriesBorderDefaults, new Boolean(newValue));
    }

    public Color getSeriesDefaultBorderColor() {
        Color m_Obj = (Color)this.getFromLook(new IdentObj(2000), Attr.SeriesDefaultBorderColor);
        return m_Obj;
    }

    public void setSeriesDefaultBorderColor(Color newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.SeriesDefaultBorderColor, newValue);
    }

    public boolean getSeriesDefaultTransparentBorderColor() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.SeriesDefaultTransparentBorderColor);
        return m_Obj;
    }

    public void setSeriesDefaultTransparentBorderColor(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.SeriesDefaultTransparentBorderColor, new Boolean(newValue));
    }

    public boolean getStackedDataValueSum() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.StackedDataValueSum);
        return m_Obj;
    }

    public void setStackedDataValueSum(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.StackedDataValueSum, new Boolean(newValue));
    }

    public int getValidGroupsMin() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.ValidGroupsMin);
        return m_Obj;
    }

    public void setValidGroupsMin(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ValidGroupsMin, new Integer(newValue));
    }

    public int getValidSeriesMin() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.ValidSeriesMin);
        return m_Obj;
    }

    public void setValidSeriesMin(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ValidSeriesMin, new Integer(newValue));
    }

    public int getCurveFitType() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.CurveFitType, 1);
        return m_Obj;
    }

    public int getCurveFitType(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.CurveFitType);
        return m_Obj;
    }

    public int getCurveFitType(int seriesID) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        return this.getCurveFitType(id);
    }

    public void setCurveFitType(int newValue) {
        this.putToLookAndRepaint(Attr.CurveFitType, new Integer(newValue), 1);
    }

    public void setCurveFitType(IdentObj id, int newValue) {
        this.putToLookAndRepaint(id, Attr.CurveFitType, new Integer(newValue));
    }

    public void setCurveFitType(int seriesID, int newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setCurveFitType(id, newValue);
    }

    public int getCurveFitPolynomialOrder() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.CurveFitPolynomialOrder, 1);
        return m_Obj;
    }

    public int getCurveFitPolynomialOrder(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.CurveFitPolynomialOrder);
        return m_Obj;
    }

    public int getCurveFitPolynomialOrder(int seriesID) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        return this.getCurveFitPolynomialOrder(id);
    }

    public void setCurveFitPolynomialOrder(int newValue) {
        this.putToLookAndRepaint(Attr.CurveFitPolynomialOrder, new Integer(newValue), 1);
    }

    public void setCurveFitPolynomialOrder(IdentObj id, int newValue) {
        this.putToLookAndRepaint(id, Attr.CurveFitPolynomialOrder, new Integer(newValue));
    }

    public void setCurveFitPolynomialOrder(int seriesID, int newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setCurveFitPolynomialOrder(id, newValue);
    }

    public int getCurveFitNumSegments() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.CurveFitNumSegments);
        return m_Obj;
    }

    public void setCurveFitNumSegments(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CurveFitNumSegments, new Integer(newValue));
    }

    public boolean getCurveFitEquationDisplay() {
        return this.getDisplay(new IdentObj(42));
    }

    public void setCurveFitEquationDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(42), newValue);
    }

    public boolean getCurveFitHighOrderFirst() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.CurveFitHighOrderFirst);
        return m_Obj;
    }

    public void setCurveFitHighOrderFirst(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CurveFitHighOrderFirst, new Boolean(newValue));
    }

    public int getDeadZonePercent() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.DeadZonePercent);
        return m_Obj;
    }

    public void setDeadZonePercent(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.DeadZonePercent, new Integer(newValue));
    }

    public boolean getDisplaySystemConsoleMessages() {
        return this.getDisplay(new IdentObj(2000));
    }

    public void setDisplaySystemConsoleMessages(boolean newValue) {
        this.setDisplay(new IdentObj(2000), newValue);
    }

    public int getFillMissingData() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.FillMissingData);
        return m_Obj;
    }

    public void setFillMissingData(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.FillMissingData, new Integer(newValue));
    }

    public int getNumMissingDataSegments() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.NumMissingDataSegments);
        return m_Obj;
    }

    public void setNumMissingDataSegments(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.NumMissingDataSegments, new Integer(newValue));
    }

    public boolean getFontSizeAbsolute() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.FontSizeAbsolute);
        return m_Obj;
    }

    public boolean getFontSizeAbsolute(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.FontSizeAbsolute);
        return m_Obj;
    }

    public boolean getFontSizeAbsolute(int objectID) {
        return this.getFontSizeAbsolute(new IdentObj(objectID));
    }

    public void setFontSizeAbsolute(boolean newValue) {
        this.putToLookAndRepaint(Attr.FontSizeAbsolute, new Boolean(newValue));
    }

    public void setFontSizeAbsolute(IdentObj id, boolean newValue) {
        this.putToLookAndRepaint(id, Attr.FontSizeAbsolute, new Boolean(newValue));
    }

    public void setFontSizeAbsolute(int objectID, boolean newValue) {
        this.setFontSizeAbsolute(new IdentObj(objectID), newValue);
    }

    public int getLegendSeriesStart() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.LegendSeriesStart);
        return m_Obj;
    }

    public void setLegendSeriesStart(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.LegendSeriesStart, new Integer(newValue));
    }

    public int getLegendSeriesCount() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.LegendSeriesCount);
        return m_Obj;
    }

    public void setLegendSeriesCount(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.LegendSeriesCount, new Integer(newValue));
    }

    public int getLegendMarkerSize() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.LegendMarkerSize);
        return m_Obj;
    }

    public void setLegendMarkerSize(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.LegendMarkerSize, new Integer(newValue));
    }

    public int getLegendMarkerSizeMax() {
        return 1000;
    }

    public void setLegendMarkerSizeMax(int newValue) {
    }

    public int getO1LabelAutoAngle() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.O1LabelAutoAngle);
        return m_Obj;
    }

    public void setO1LabelAutoAngle(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.O1LabelAutoAngle, new Integer(newValue));
    }

    public int getLegendScroll() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.LegendScroll);
        return m_Obj;
    }

    public void setLegendScroll(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.LegendScroll, new Integer(newValue));
    }

    public int getO2LabelAutoSkip() {
        return this.getAutoSkip(this.getO2Label());
    }

    public void setO2LabelAutoSkip(int newValue) {
        this.setAutoSkip(this.getO2Label(), newValue);
    }

    public int getO2LabelSkipCount() {
        return this.getSkipCount(this.getO2Label());
    }

    public void setO2LabelSkipCount(int newValue) {
        this.setSkipCount(this.getO2Label(), newValue);
    }

    public int getO2LabelSkipBegin() {
        return this.getSkipBegin(this.getO2Label());
    }

    public void setO2LabelSkipBegin(int newValue) {
        this.setSkipBegin(this.getO2Label(), newValue);
    }

    public boolean getY1ExcludeMinLabel() {
        return this.getExcludeMinLabel(new IdentObj(284));
    }

    public void setY1ExcludeMinLabel(boolean newValue) {
        this.setExcludeMinLabel(new IdentObj(284), newValue);
    }

    public boolean getY1LabelAutofit() {
        return this.getAutofit(new IdentObj(284));
    }

    public void setY1LabelAutofit(boolean newValue) {
        this.setAutofit(new IdentObj(284), newValue);
    }

    public boolean getY1LabelDisplay() {
        return this.getDisplay(new IdentObj(284));
    }

    public void setY1LabelDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(284), newValue);
    }

    public int getY1LabelFormat() {
        return this.getTextFormatPreset(new IdentObj(284));
    }

    public void setY1LabelFormat(int newValue) {
        this.setTextFormatPreset(new IdentObj(284), newValue);
    }

    public boolean getY1LabelStagger() {
        return this.getLabelStagger(new IdentObj(284));
    }

    public void setY1LabelStagger(boolean newValue) {
        this.setLabelStagger(new IdentObj(284), newValue);
    }

    public boolean getY1LogScale() {
        return this.getLogScale(new IdentObj(2004));
    }

    public void setY1LogScale(boolean newValue) {
        this.setLogScale(new IdentObj(2004), newValue);
    }

    public boolean getY1MajorGridDisplay() {
        return this.getDisplay(new IdentObj(285));
    }

    public void setY1MajorGridDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(285), newValue);
    }

    public double getY1MajorGridStep() {
        return this.getGridStep(new IdentObj(285));
    }

    public void setY1MajorGridStep(double newValue) {
        this.setGridStep(new IdentObj(285), newValue);
        if (this.getCascade()) {
            this.setY1MajorGridStepAuto(false);
        }
    }

    public boolean getY1MajorGridStepAuto() {
        return this.getGridStepAuto(new IdentObj(285));
    }

    public void setY1MajorGridStepAuto(boolean newValue) {
        this.setGridStepAuto(new IdentObj(285), newValue);
    }

    public int getY1MajorGridStyle() {
        return this.getGridStyle(new IdentObj(285));
    }

    public void setY1MajorGridStyle(int newValue) {
        this.setGridStyle(new IdentObj(285), newValue);
    }

    public boolean getY1MinorGridDisplay() {
        return this.getDisplay(new IdentObj(286));
    }

    public void setY1MinorGridDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(286), newValue);
    }

    public double getY1MinorGridStep() {
        return this.getGridStep(new IdentObj(286));
    }

    public void setY1MinorGridStep(double newValue) {
        this.setGridStep(new IdentObj(286), newValue);
    }

    public boolean getY1MinorGridStepAuto() {
        return this.getGridStepAuto(new IdentObj(286));
    }

    public void setY1MinorGridStepAuto(boolean newValue) {
        this.setGridStepAuto(new IdentObj(286), newValue);
    }

    public int getY1MinorGridStyle() {
        return this.getGridStyle(new IdentObj(286));
    }

    public void setY1MinorGridStyle(int newValue) {
        this.setGridStyle(new IdentObj(286), newValue);
    }

    public boolean getY1MustIncludeZero() {
        if (this.getY1LogScale()) {
            return false;
        }
        return this.getScaleMustIncludeZero(new IdentObj(2004));
    }

    public void setY1MustIncludeZero(boolean newValue) {
        this.setScaleMustIncludeZero(new IdentObj(2004), newValue);
    }

    public double getY1ScaleMax() {
        return this.getScaleMax(new IdentObj(2004));
    }

    public void setY1ScaleMax(double newValue) {
        this.setScaleMax(new IdentObj(2004), newValue);
    }

    public boolean getY1ScaleMaxAuto() {
        return this.getScaleMaxAuto(new IdentObj(2004));
    }

    public void setY1ScaleMaxAuto(boolean newValue) {
        this.setScaleMaxAuto(new IdentObj(2004), newValue);
    }

    public double getY1ScaleMin() {
        return this.getScaleMin(new IdentObj(2004));
    }

    public void setY1ScaleMin(double newValue) {
        this.setScaleMin(new IdentObj(2004), newValue);
    }

    public boolean getY1ScaleMinAuto() {
        return this.getScaleMinAuto(new IdentObj(2004));
    }

    public void setY1ScaleMinAuto(boolean newValue) {
        this.setScaleMinAuto(new IdentObj(2004), newValue);
    }

    public boolean getY1TitleAutofit() {
        return this.getAutofit(new IdentObj(6));
    }

    public void setY1TitleAutofit(boolean newValue) {
        this.setAutofit(new IdentObj(6), newValue);
    }

    public boolean getY1TitleDisplay() {
        return this.getDisplay(new IdentObj(6));
    }

    public void setY1TitleDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(6), newValue);
    }

    public String getY1TitleString() {
        return this.getTextString(new IdentObj(6));
    }

    public void setY1TitleString(String newValue) {
        this.setTextString(new IdentObj(6), newValue);
        if (this.getCascade() && newValue.length() > 0) {
            this.setY1TitleDisplay(true);
        }
    }

    public boolean getY1ZeroLineDisplay() {
        return this.getDisplay(new IdentObj(292));
    }

    public void setY1ZeroLineDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(292), newValue);
    }

    public boolean getY2AxisDescending() {
        return this.getAxisDescending(new IdentObj(2005));
    }

    public void setY2AxisDescending(boolean newValue) {
        this.setAxisDescending(new IdentObj(2005), newValue);
    }

    public int getY2AxisSide() {
        return this.getAxisSide(new IdentObj(2005));
    }

    public void setY2AxisSide(int newValue) {
        this.setAxisSide(new IdentObj(2005), newValue);
    }

    public boolean getY2OffScaleDisplay() {
        return this.getDisplayOffScale(new IdentObj(2005));
    }

    public void setY2OffScaleDisplay(boolean newValue) {
        this.setDisplayOffScale(new IdentObj(2005), newValue);
    }

    public boolean getY2ExcludeMaxLabel() {
        return this.getExcludeMaxLabel(new IdentObj(288));
    }

    public void setY2ExcludeMaxLabel(boolean newValue) {
        this.setExcludeMaxLabel(new IdentObj(288), newValue);
    }

    public boolean getY2ExcludeMinLabel() {
        return this.getExcludeMinLabel(new IdentObj(288));
    }

    public void setY2ExcludeMinLabel(boolean newValue) {
        this.setExcludeMinLabel(new IdentObj(288), newValue);
    }

    public boolean getY2LabelAutofit() {
        return this.getAutofit(new IdentObj(288));
    }

    public void setY2LabelAutofit(boolean newValue) {
        this.setAutofit(new IdentObj(288), newValue);
    }

    public boolean getY2LabelDisplay() {
        return this.getDisplay(new IdentObj(288));
    }

    public void setY2LabelDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(288), newValue);
    }

    public int getY2LabelFormat() {
        return this.getTextFormatPreset(new IdentObj(288));
    }

    public void setY2LabelFormat(int newValue) {
        this.setTextFormatPreset(new IdentObj(288), newValue);
    }

    public boolean getY2LabelStagger() {
        return this.getLabelStagger(new IdentObj(288));
    }

    public void setY2LabelStagger(boolean newValue) {
        this.setLabelStagger(new IdentObj(288), newValue);
    }

    public boolean getY2LogScale() {
        return this.getLogScale(new IdentObj(2005));
    }

    public void setY2LogScale(boolean newValue) {
        this.setLogScale(new IdentObj(2005), newValue);
    }

    public boolean getY2MajorGridDisplay() {
        return this.getDisplay(new IdentObj(289));
    }

    public void setY2MajorGridDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(289), newValue);
    }

    public double getY2MajorGridStep() {
        return this.getGridStep(new IdentObj(289));
    }

    public void setY2MajorGridStep(double newValue) {
        this.setGridStep(new IdentObj(289), newValue);
        if (this.getCascade()) {
            this.setY2MajorGridStepAuto(false);
        }
    }

    public boolean getY2MajorGridStepAuto() {
        return this.getGridStepAuto(new IdentObj(289));
    }

    public void setY2MajorGridStepAuto(boolean newValue) {
        this.setGridStepAuto(new IdentObj(289), newValue);
    }

    public int getY2MajorGridStyle() {
        return this.getGridStyle(new IdentObj(289));
    }

    public void setY2MajorGridStyle(int newValue) {
        this.setGridStyle(new IdentObj(289), newValue);
    }

    public boolean getY2MinorGridDisplay() {
        return this.getDisplay(new IdentObj(290));
    }

    public void setY2MinorGridDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(290), newValue);
    }

    public double getY2MinorGridStep() {
        return this.getGridStep(new IdentObj(290));
    }

    public void setY2MinorGridStep(double newValue) {
        this.setGridStep(new IdentObj(290), newValue);
    }

    public boolean getY2MinorGridStepAuto() {
        return this.getGridStepAuto(new IdentObj(290));
    }

    public void setY2MinorGridStepAuto(boolean newValue) {
        this.setGridStepAuto(new IdentObj(290), newValue);
    }

    public int getY2MinorGridStyle() {
        return this.getGridStyle(new IdentObj(290));
    }

    public void setY2MinorGridStyle(int newValue) {
        this.setGridStyle(new IdentObj(290), newValue);
    }

    public boolean getY2MustIncludeZero() {
        if (this.getY2LogScale()) {
            return false;
        }
        return this.getScaleMustIncludeZero(new IdentObj(2005));
    }

    public void setY2MustIncludeZero(boolean newValue) {
        this.setScaleMustIncludeZero(new IdentObj(2005), newValue);
    }

    public double getY2ScaleMax() {
        return this.getScaleMax(new IdentObj(2005));
    }

    public void setY2ScaleMax(double newValue) {
        this.setScaleMax(new IdentObj(2005), newValue);
    }

    public boolean getY2ScaleMaxAuto() {
        return this.getScaleMaxAuto(new IdentObj(2005));
    }

    public void setY2ScaleMaxAuto(boolean newValue) {
        this.setScaleMaxAuto(new IdentObj(2005), newValue);
    }

    public double getY2ScaleMin() {
        return this.getScaleMin(new IdentObj(2005));
    }

    public void setY2ScaleMin(double newValue) {
        this.setScaleMin(new IdentObj(2005), newValue);
    }

    public boolean getY2ScaleMinAuto() {
        return this.getScaleMinAuto(new IdentObj(2005));
    }

    public void setY2ScaleMinAuto(boolean newValue) {
        this.setScaleMinAuto(new IdentObj(2005), newValue);
    }

    public boolean getY2TitleAutofit() {
        return this.getAutofit(new IdentObj(7));
    }

    public void setY2TitleAutofit(boolean newValue) {
        this.setAutofit(new IdentObj(7), newValue);
    }

    public int getAxisAssignment() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.AxisAssignment, 1);
        return m_Obj;
    }

    public int getAxisAssignment(IdentObj id) {
        Attr a = Attr.AxisAssignment;
        if (id.getObjectID() == -3 && id.getSeriesID() == 1) {
            a = Attr.AxisAssignmentY2;
        }
        Integer m_Obj = (Integer)this.getFromLook(id, a);
        return m_Obj;
    }

    public int getAxisAssignment(int seriesID) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        return this.getAxisAssignment(id);
    }

    public void setAxisAssignment(int newValue) {
        this.putToLookAndRepaint(Attr.AxisAssignment, new Integer(newValue), 1);
    }

    public void setAxisAssignment(IdentObj id, int newValue) {
        Attr a = Attr.AxisAssignment;
        if (id.getObjectID() == -3 && id.getSeriesID() == 1) {
            a = Attr.AxisAssignmentY2;
        }
        this.putToLookAndRepaint(id, a, new Integer(newValue));
    }

    public void setAxisAssignment(int seriesID, int newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setAxisAssignment(id, newValue);
    }

    public boolean getAutofit() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.Autofit);
        return m_Obj;
    }

    public boolean getAutofit(IdentObj id) {
        Attr a = Attr.Autofit;
        if (id.getObjectID() == 297) {
            a = Attr.PieRingLabelAutofit;
        }
        Boolean m_Obj = (Boolean)this.getFromLook(id, a);
        return m_Obj;
    }

    public boolean getAutofit(int objectID) {
        return this.getAutofit(new IdentObj(objectID));
    }

    public void setAutofit(boolean newValue) {
        this.putToLookAndRepaint(Attr.Autofit, new Boolean(newValue));
    }

    public void setAutofit(IdentObj id, boolean newValue) {
        Attr a = Attr.Autofit;
        if (id.getObjectID() == 297) {
            a = Attr.PieRingLabelAutofit;
        }
        this.putToLookAndRepaint(id, a, new Boolean(newValue));
    }

    public void setAutofit(int objectID, boolean newValue) {
        this.setAutofit(new IdentObj(objectID), newValue);
    }

    public int getO1MinorGridCount() {
        return this.getGridCount(new IdentObj(272));
    }

    public void setO1MinorGridCount(int newValue) {
        this.setGridCount(new IdentObj(272), newValue);
    }

    public int getDataTextPosition() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.DataTextPosition);
        return m_Obj;
    }

    public void setDataTextPosition(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.DataTextPosition, new Integer(newValue));
    }

    public int getPieRingTotalFormat() {
        return this.getTextFormatPreset(new IdentObj(297));
    }

    public void setPieRingTotalFormat(int newValue) {
        this.setTextFormatPreset(new IdentObj(297), newValue);
    }

    public boolean getX1AxisLineDisplay() {
        return this.getDisplay(new IdentObj(279));
    }

    public void setX1AxisLineDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(279), newValue);
    }

    public boolean getY1AxisLineDisplay() {
        return this.getDisplay(new IdentObj(283));
    }

    public void setY1AxisLineDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(283), newValue);
    }

    public boolean getY2AxisLineDisplay() {
        return this.getDisplay(new IdentObj(287));
    }

    public void setY2AxisLineDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(287), newValue);
    }

    public boolean getO1AxisLineDisplay() {
        return this.getDisplay(new IdentObj(269));
    }

    public void setO1AxisLineDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(269), newValue);
    }

    public boolean getDualAxisLineDisplay() {
        return this.getDisplay(new IdentObj(17));
    }

    public void setDualAxisLineDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(17), newValue);
    }

    public double getStock52WeekLowValue() {
        Double m_Obj = (Double)this.getFromLook(new IdentObj(2000), Attr.Stock52WeekLowValue);
        return m_Obj;
    }

    public void setStock52WeekLowValue(double newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.Stock52WeekLowValue, new Double(newValue));
        if (this.getCascade()) {
            this.setStock52WeekLowDisplay(true);
        }
    }

    public double getNumPieArcSegmentsPerPixel() {
        Double m_Obj = (Double)this.getFromLook(new IdentObj(2000), Attr.NumPieArcSegmentsPerPixel);
        return m_Obj;
    }

    public void setNumPieArcSegmentsPerPixel(double newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.NumPieArcSegmentsPerPixel, new Double(newValue));
    }

    public boolean getAxisDescending() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.AxisDescending);
        return m_Obj;
    }

    public boolean getAxisDescending(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.AxisDescending);
        return m_Obj;
    }

    public boolean getAxisDescending(int objectID) {
        return this.getAxisDescending(new IdentObj(objectID));
    }

    public void setAxisDescending(boolean newValue) {
        this.putToLookAndRepaint(Attr.AxisDescending, new Boolean(newValue));
    }

    public void setAxisDescending(IdentObj id, boolean newValue) {
        this.putToLookAndRepaint(id, Attr.AxisDescending, new Boolean(newValue));
    }

    public void setAxisDescending(int objectID, boolean newValue) {
        this.setAxisDescending(new IdentObj(objectID), newValue);
    }

    public int getAxisSide() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.AxisSide);
        return m_Obj;
    }

    public int getAxisSide(IdentObj id) {
        Attr a = Attr.AxisSide;
        if (id.getObjectID() == 2005 || id.getObjectID() == 2013) {
            a = Attr.Y2AxisSide;
        }
        Integer m_Obj = (Integer)this.getFromLook(id, a);
        return m_Obj;
    }

    public int getAxisSide(int objectID) {
        return this.getAxisSide(new IdentObj(objectID));
    }

    public void setAxisSide(int newValue) {
        this.putToLookAndRepaint(Attr.AxisSide, new Integer(newValue));
    }

    public void setAxisSide(IdentObj id, int newValue) {
        Attr a = Attr.AxisSide;
        if (id.getObjectID() == 2005 || id.getObjectID() == 2013) {
            a = Attr.Y2AxisSide;
        }
        this.putToLookAndRepaint(id, a, new Integer(newValue));
    }

    public void setAxisSide(int objectID, int newValue) {
        this.setAxisSide(new IdentObj(objectID), newValue);
    }

    public int getDataTextAngle() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.DataTextAngle, 3);
        return m_Obj;
    }

    public int getDataTextAngle(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.DataTextAngle);
        return m_Obj;
    }

    public int getDataTextAngle(int seriesID) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.DataTextAngle, false);
        if (m_Obj != null) {
            return m_Obj;
        }
        return this.getDataTextAngleDefault();
    }

    public int getDataTextAngle(int seriesID, int groupID) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.DataTextAngle, false);
        if (m_Obj != null) {
            return m_Obj;
        }
        return this.getDataTextAngle(seriesID);
    }

    public void setDataTextAngle(int newValue) {
        this.putToLookAndRepaint(Attr.DataTextAngle, new Integer(newValue), 3);
    }

    public void setDataTextAngle(IdentObj id, int newValue) {
        this.putToLookAndRepaint(id, Attr.DataTextAngle, new Integer(newValue));
    }

    public void setDataTextAngle(int seriesID, int newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setDataTextAngle(id, newValue);
    }

    public void setDataTextAngle(int seriesID, int groupID, int newValue) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        this.setDataTextAngle(id, newValue);
    }

    public int getDataTextRadius() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.DataTextRadius, 3);
        return m_Obj;
    }

    public int getDataTextRadius(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.DataTextRadius);
        return m_Obj;
    }

    public int getDataTextRadius(int seriesID) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.DataTextRadius, false);
        if (m_Obj != null) {
            return m_Obj;
        }
        return this.getDataTextRadiusDefault();
    }

    public int getDataTextRadius(int seriesID, int groupID) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.DataTextRadius, false);
        if (m_Obj != null) {
            return m_Obj;
        }
        return this.getDataTextRadius(seriesID);
    }

    public void setDataTextRadius(int newValue) {
        this.putToLookAndRepaint(Attr.DataTextRadius, new Integer(newValue), 3);
    }

    public void setDataTextRadius(IdentObj id, int newValue) {
        this.putToLookAndRepaint(id, Attr.DataTextRadius, new Integer(newValue));
    }

    public void setDataTextRadius(int seriesID, int newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setDataTextRadius(id, newValue);
    }

    public void setDataTextRadius(int seriesID, int groupID, int newValue) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        this.setDataTextRadius(id, newValue);
    }

    public boolean getDisplay() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.Display);
        return m_Obj;
    }

    public boolean getDisplay(IdentObj id) {
        Attr a = Attr.Display;
        switch (id.getObjectID()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 40: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 235: 
            case 260: 
            case 272: 
            case 276: 
            case 282: 
            case 286: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 304: 
            case 305: 
            case 309: 
            case 329: 
            case 518: 
            case 519: 
            case 520: 
            case 525: 
            case 526: 
            case 527: 
            case 528: 
            case 529: 
            case 530: {
                a = Attr.NoDisplay;
                break;
            }
            case 306: {
                a = Attr.StockCloseSplitDisplay;
            }
        }
        Boolean m_Obj = (Boolean)this.getFromLook(id, a);
        return m_Obj;
    }

    public boolean getDisplay(int objectID) {
        return this.getDisplay(new IdentObj(objectID));
    }

    public void setDisplay(boolean newValue) {
        this.putToLookAndRepaint(Attr.Display, new Boolean(newValue));
    }

    public void setDisplay(IdentObj id, boolean newValue) {
        Attr a = Attr.Display;
        switch (id.getObjectID()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 40: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 235: 
            case 260: 
            case 272: 
            case 276: 
            case 282: 
            case 286: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 304: 
            case 305: 
            case 309: 
            case 329: 
            case 518: 
            case 519: 
            case 520: 
            case 525: 
            case 526: 
            case 527: 
            case 528: 
            case 529: 
            case 530: {
                a = Attr.NoDisplay;
                break;
            }
            case 306: {
                a = Attr.StockCloseSplitDisplay;
            }
        }
        this.putToLookAndRepaint(id, a, new Boolean(newValue));
    }

    public void setDisplay(int objectID, boolean newValue) {
        this.setDisplay(new IdentObj(objectID), newValue);
    }

    public boolean getDisplayOffScale() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.DisplayOffScale);
        return m_Obj;
    }

    public boolean getDisplayOffScale(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.DisplayOffScale);
        return m_Obj;
    }

    public boolean getDisplayOffScale(int objectID) {
        return this.getDisplayOffScale(new IdentObj(objectID));
    }

    public void setDisplayOffScale(boolean newValue) {
        this.putToLookAndRepaint(Attr.DisplayOffScale, new Boolean(newValue));
    }

    public void setDisplayOffScale(IdentObj id, boolean newValue) {
        this.putToLookAndRepaint(id, Attr.DisplayOffScale, new Boolean(newValue));
    }

    public void setDisplayOffScale(int objectID, boolean newValue) {
        this.setDisplayOffScale(new IdentObj(objectID), newValue);
    }

    public boolean getExcludeMaxLabel() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.ExcludeMaxLabel);
        return m_Obj;
    }

    public boolean getExcludeMaxLabel(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.ExcludeMaxLabel);
        return m_Obj;
    }

    public boolean getExcludeMaxLabel(int objectID) {
        return this.getExcludeMaxLabel(new IdentObj(objectID));
    }

    public void setExcludeMaxLabel(boolean newValue) {
        this.putToLookAndRepaint(Attr.ExcludeMaxLabel, new Boolean(newValue));
    }

    public void setExcludeMaxLabel(IdentObj id, boolean newValue) {
        this.putToLookAndRepaint(id, Attr.ExcludeMaxLabel, new Boolean(newValue));
    }

    public void setExcludeMaxLabel(int objectID, boolean newValue) {
        this.setExcludeMaxLabel(new IdentObj(objectID), newValue);
    }

    public boolean getExcludeMinLabel() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.ExcludeMinLabel);
        return m_Obj;
    }

    public boolean getExcludeMinLabel(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.ExcludeMinLabel);
        return m_Obj;
    }

    public boolean getExcludeMinLabel(int objectID) {
        return this.getExcludeMinLabel(new IdentObj(objectID));
    }

    public void setExcludeMinLabel(boolean newValue) {
        this.putToLookAndRepaint(Attr.ExcludeMinLabel, new Boolean(newValue));
    }

    public void setExcludeMinLabel(IdentObj id, boolean newValue) {
        this.putToLookAndRepaint(id, Attr.ExcludeMinLabel, new Boolean(newValue));
    }

    public void setExcludeMinLabel(int objectID, boolean newValue) {
        this.setExcludeMinLabel(new IdentObj(objectID), newValue);
    }

    public String getFontName() {
        String m_Obj = (String)this.getFromLook(Attr.FontName);
        return m_Obj;
    }

    public String getFontName(IdentObj id) {
        String m_Obj = (String)this.getFromLook(id, Attr.FontName);
        return m_Obj;
    }

    public String getFontName(int objectID) {
        return this.getFontName(new IdentObj(objectID));
    }

    public void setFontName(String newValue) {
        this.putToLookAndRepaint(Attr.FontName, newValue);
    }

    public void setFontName(IdentObj id, String newValue) {
        this.putToLookAndRepaint(id, Attr.FontName, newValue);
    }

    public void setFontName(int objectID, String newValue) {
        this.setFontName(new IdentObj(objectID), newValue);
    }

    public int getFontSizeVC() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.FontSizeVC);
        return m_Obj;
    }

    public int getFontSizeVC(IdentObj id) {
        Attr a = Attr.FontSizeVC;
        switch (id.getObjectID()) {
            case 3: 
            case 4: 
            case 14: 
            case 235: 
            case 270: 
            case 274: 
            case 280: 
            case 284: 
            case 288: 
            case 295: 
            case 296: 
            case 441: 
            case 446: 
            case 451: {
                a = Attr.LabelFontSizeVC;
                break;
            }
            case 5: 
            case 297: {
                a = Attr.TitleFontSizeVC;
            }
        }
        Integer m_Obj = (Integer)this.getFromLook(id, a);
        return m_Obj;
    }

    public int getFontSizeVC(int objectID) {
        return this.getFontSizeVC(new IdentObj(objectID));
    }

    public void setFontSizeVC(int newValue) {
        this.putToLookAndRepaint(Attr.FontSizeVC, new Integer(newValue));
    }

    public void setFontSizeVC(IdentObj id, int newValue) {
        Attr a = Attr.FontSizeVC;
        switch (id.getObjectID()) {
            case 3: 
            case 4: 
            case 14: 
            case 235: 
            case 270: 
            case 274: 
            case 280: 
            case 284: 
            case 288: 
            case 295: 
            case 296: 
            case 441: 
            case 446: 
            case 451: {
                a = Attr.LabelFontSizeVC;
                break;
            }
            case 5: 
            case 297: {
                a = Attr.TitleFontSizeVC;
            }
        }
        this.putToLookAndRepaint(id, a, new Integer(newValue));
    }

    public void setFontSizeVC(int objectID, int newValue) {
        this.setFontSizeVC(new IdentObj(objectID), newValue);
    }

    public int getFontStyle() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.FontStyle);
        return m_Obj;
    }

    public int getFontStyle(IdentObj id) {
        Attr a = Attr.FontStyle;
        switch (id.getObjectID()) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 260: {
                a = Attr.TitleFontStyle;
                break;
            }
            case 232: 
            case 233: 
            case 235: {
                a = Attr.DrillLabelFontStyle;
            }
        }
        Integer m_Obj = (Integer)this.getFromLook(id, a);
        return m_Obj;
    }

    public int getFontStyle(int objectID) {
        return this.getFontStyle(new IdentObj(objectID));
    }

    public void setFontStyle(int newValue) {
        this.putToLookAndRepaint(Attr.FontStyle, new Integer(newValue));
    }

    public void setFontStyle(IdentObj id, int newValue) {
        Attr a = Attr.FontStyle;
        switch (id.getObjectID()) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 260: {
                a = Attr.TitleFontStyle;
                break;
            }
            case 232: 
            case 233: 
            case 235: {
                a = Attr.DrillLabelFontStyle;
            }
        }
        this.putToLookAndRepaint(id, a, new Integer(newValue));
    }

    public void setFontStyle(int objectID, int newValue) {
        this.setFontStyle(new IdentObj(objectID), newValue);
    }

    public double getMinAutoGridStep() {
        Double m_Obj = (Double)this.getFromLook(Attr.MinAutoGridStep);
        return m_Obj;
    }

    public double getMinAutoGridStep(IdentObj id) {
        Double m_Obj = (Double)this.getFromLook(id, Attr.MinAutoGridStep);
        return m_Obj;
    }

    public double getMinAutoGridStep(int objectID) {
        return this.getMinAutoGridStep(new IdentObj(objectID));
    }

    public void setMinAutoGridStep(double newValue) {
        this.putToLookAndRepaint(Attr.MinAutoGridStep, new Double(newValue));
    }

    public void setMinAutoGridStep(IdentObj id, double newValue) {
        this.putToLookAndRepaint(id, Attr.MinAutoGridStep, new Double(newValue));
    }

    public void setMinAutoGridStep(int objectID, double newValue) {
        this.setMinAutoGridStep(new IdentObj(objectID), newValue);
    }

    public double getGridStep() {
        Double m_Obj = (Double)this.getFromLook(Attr.GridStep);
        return m_Obj;
    }

    public double getGridStep(IdentObj id) {
        Double m_Obj = (Double)this.getFromLook(id, Attr.GridStep);
        return m_Obj;
    }

    public double getGridStep(int objectID) {
        return this.getGridStep(new IdentObj(objectID));
    }

    public void setGridStep(double newValue) {
        this.putToLookAndRepaint(Attr.GridStep, new Double(newValue));
    }

    public void setGridStep(IdentObj id, double newValue) {
        this.putToLookAndRepaint(id, Attr.GridStep, new Double(newValue));
    }

    public void setGridStep(int objectID, double newValue) {
        this.setGridStep(new IdentObj(objectID), newValue);
    }

    public boolean getGridStepAuto() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.GridStepAuto);
        return m_Obj;
    }

    public boolean getGridStepAuto(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.GridStepAuto);
        return m_Obj;
    }

    public boolean getGridStepAuto(int objectID) {
        return this.getGridStepAuto(new IdentObj(objectID));
    }

    public void setGridStepAuto(boolean newValue) {
        this.putToLookAndRepaint(Attr.GridStepAuto, new Boolean(newValue));
    }

    public void setGridStepAuto(IdentObj id, boolean newValue) {
        this.putToLookAndRepaint(id, Attr.GridStepAuto, new Boolean(newValue));
    }

    public void setGridStepAuto(int objectID, boolean newValue) {
        this.setGridStepAuto(new IdentObj(objectID), newValue);
    }

    public int getGridStyle() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.GridStyle);
        return m_Obj;
    }

    public int getGridStyle(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.GridStyle);
        return m_Obj;
    }

    public int getGridStyle(int objectID) {
        return this.getGridStyle(new IdentObj(objectID));
    }

    public void setGridStyle(int newValue) {
        this.putToLookAndRepaint(Attr.GridStyle, new Integer(newValue));
    }

    public void setGridStyle(IdentObj id, int newValue) {
        this.putToLookAndRepaint(id, Attr.GridStyle, new Integer(newValue));
    }

    public void setGridStyle(int objectID, int newValue) {
        this.setGridStyle(new IdentObj(objectID), newValue);
    }

    public String getGroupLabel(int groupID) {
        String ret = null;
        if (this.getNestedLabels()) {
            Vector labels = this.getO1LabelCallBack().getAllLabels(0);
            if (labels.size() > groupID) {
                ret = (String)labels.elementAt(groupID);
            }
            return ret;
        }
        if (this.m_groupLabels.size() > groupID) {
            ret = (String)this.m_groupLabels.elementAt(groupID);
        }
        return ret;
    }

    public void setGroupLabel(int groupID, Object newValue) {
        if (this.m_groupLabels.size() < groupID) {
            this.m_groupLabels.setSize(groupID + 1);
        }
        this.m_groupLabels.insertElementAt(newValue, groupID);
    }

    public boolean getLabelStagger() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.LabelStagger);
        return m_Obj;
    }

    public boolean getLabelStagger(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.LabelStagger);
        return m_Obj;
    }

    public boolean getLabelStagger(int objectID) {
        return this.getLabelStagger(new IdentObj(objectID));
    }

    public void setLabelStagger(boolean newValue) {
        this.putToLookAndRepaint(Attr.LabelStagger, new Boolean(newValue));
    }

    public void setLabelStagger(IdentObj id, boolean newValue) {
        this.putToLookAndRepaint(id, Attr.LabelStagger, new Boolean(newValue));
    }

    public void setLabelStagger(int objectID, boolean newValue) {
        this.setLabelStagger(new IdentObj(objectID), newValue);
    }

    public boolean getLogScale() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.LogScale);
        return m_Obj;
    }

    public boolean getLogScale(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.LogScale);
        return m_Obj;
    }

    public boolean getLogScale(int objectID) {
        return this.getLogScale(new IdentObj(objectID));
    }

    public void setLogScale(boolean newValue) {
        this.putToLookAndRepaint(Attr.LogScale, new Boolean(newValue));
    }

    public void setLogScale(IdentObj id, boolean newValue) {
        this.putToLookAndRepaint(id, Attr.LogScale, new Boolean(newValue));
    }

    public void setLogScale(int objectID, boolean newValue) {
        this.setLogScale(new IdentObj(objectID), newValue);
    }

    public int getMarkerSize() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.MarkerSize, 3);
        return m_Obj;
    }

    public int getMarkerSize(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.MarkerSize);
        return m_Obj;
    }

    public int getMarkerSize(int seriesID) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.MarkerSize, false);
        if (m_Obj != null) {
            return m_Obj;
        }
        return this.getMarkerSizeDefault();
    }

    public int getMarkerSize(int seriesID, int groupID) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.MarkerSize, false);
        if (m_Obj != null) {
            return m_Obj;
        }
        return this.getMarkerSize(seriesID);
    }

    public void setMarkerSize(int newValue) {
        this.putToLookAndRepaint(Attr.MarkerSize, new Integer(newValue), 3);
    }

    public void setMarkerSize(IdentObj id, int newValue) {
        this.putToLookAndRepaint(id, Attr.MarkerSize, new Integer(newValue));
    }

    public void setMarkerSize(int seriesID, int newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setMarkerSize(id, newValue);
    }

    public void setMarkerSize(int seriesID, int groupID, int newValue) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        this.setMarkerSize(id, newValue);
    }

    public boolean getPieSliceDelete() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.PieSliceDelete, 3);
        return m_Obj;
    }

    public boolean getPieSliceDelete(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.PieSliceDelete);
        return m_Obj;
    }

    public boolean getPieSliceDelete(int seriesID) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        return this.getPieSliceDelete(id);
    }

    public boolean getPieSliceDelete(int seriesID, int groupID) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        return this.getPieSliceDelete(id);
    }

    public void setPieSliceDelete(boolean newValue) {
        this.putToLookAndRepaint(Attr.PieSliceDelete, new Boolean(newValue), 3);
    }

    public void setPieSliceDelete(IdentObj id, boolean newValue) {
        this.putToLookAndRepaint(id, Attr.PieSliceDelete, new Boolean(newValue));
    }

    public void setPieSliceDelete(int seriesID, boolean newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setPieSliceDelete(id, newValue);
    }

    public void setPieSliceDelete(int seriesID, int groupID, boolean newValue) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        this.setPieSliceDelete(id, newValue);
    }

    public int getPieSliceDetach() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.PieSliceDetach, 3);
        return m_Obj;
    }

    public int getPieSliceDetach(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.PieSliceDetach);
        return m_Obj;
    }

    public int getPieSliceDetach(int seriesID) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        return this.getPieSliceDetach(id);
    }

    public int getPieSliceDetach(int seriesID, int groupID) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        return this.getPieSliceDetach(id);
    }

    public void setPieSliceDetach(int newValue) {
        this.putToLookAndRepaint(Attr.PieSliceDetach, new Integer(newValue), 3);
    }

    public void setPieSliceDetach(IdentObj id, int newValue) {
        this.putToLookAndRepaint(id, Attr.PieSliceDetach, new Integer(newValue));
    }

    public void setPieSliceDetach(int seriesID, int newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setPieSliceDetach(id, newValue);
    }

    public void setPieSliceDetach(int seriesID, int groupID, int newValue) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        this.setPieSliceDetach(id, newValue);
    }

    public Rectangle getRect() {
        Rectangle m_Obj = (Rectangle)this.getFromLook(Attr.Rect);
        return m_Obj;
    }

    public Rectangle getRect(IdentObj id) {
        Attr a = Attr.Rect;
        switch (id.getObjectID()) {
            case 1: {
                a = Attr.ChartBackgroundRect;
                break;
            }
            case 42: {
                a = Attr.CurveFitEquationTextRect;
                break;
            }
            case 3: {
                a = Attr.FootnoteRect;
                break;
            }
            case 2: {
                a = Attr.FrameRect;
                break;
            }
            case 12: {
                a = Attr.LegendAreaRect;
                break;
            }
            case 302: {
                a = Attr.PieFrameRect;
                break;
            }
            case 4: {
                a = Attr.SubtitleRect;
                break;
            }
            case 5: {
                a = Attr.TitleRect;
                break;
            }
            case 7: {
                a = Attr.Y2TitleRect;
            }
        }
        Rectangle m_Obj = (Rectangle)this.getFromLook(id, a);
        return m_Obj;
    }

    public Rectangle getRect(int objectID) {
        return this.getRect(new IdentObj(objectID));
    }

    public void setRect(Rectangle newValue) {
        this.putToLookAndRepaint(Attr.Rect, newValue);
    }

    public void setRect(IdentObj id, Rectangle newValue) {
        Attr a = Attr.Rect;
        switch (id.getObjectID()) {
            case 1: {
                a = Attr.ChartBackgroundRect;
                break;
            }
            case 42: {
                a = Attr.CurveFitEquationTextRect;
                break;
            }
            case 3: {
                a = Attr.FootnoteRect;
                break;
            }
            case 2: {
                a = Attr.FrameRect;
                break;
            }
            case 12: {
                a = Attr.LegendAreaRect;
                break;
            }
            case 302: {
                a = Attr.PieFrameRect;
                break;
            }
            case 4: {
                a = Attr.SubtitleRect;
                break;
            }
            case 5: {
                a = Attr.TitleRect;
                break;
            }
            case 7: {
                a = Attr.Y2TitleRect;
            }
        }
        this.putToLookAndRepaint(id, a, newValue);
    }

    public void setRect(int objectID, Rectangle newValue) {
        this.setRect(new IdentObj(objectID), newValue);
    }

    public double getScaleMax() {
        Double m_Obj = (Double)this.getFromLook(Attr.ScaleMax);
        return m_Obj;
    }

    public double getScaleMax(IdentObj id) {
        Attr a = Attr.ScaleMax;
        switch (id.getObjectID()) {
            case 2003: {
                a = Attr.X1ScaleMax;
                break;
            }
            case 2004: {
                a = Attr.Y1ScaleMax;
                break;
            }
            case 2005: {
                a = Attr.Y2ScaleMax;
            }
        }
        Double m_Obj = (Double)this.getFromLook(id, a);
        return m_Obj;
    }

    public double getScaleMax(int objectID) {
        return this.getScaleMax(new IdentObj(objectID));
    }

    public void setScaleMax(double newValue) {
        this.putToLookAndRepaint(Attr.ScaleMax, new Double(newValue));
    }

    public void setScaleMax(IdentObj id, double newValue) {
        Attr a = Attr.ScaleMax;
        switch (id.getObjectID()) {
            case 2003: {
                a = Attr.X1ScaleMax;
                break;
            }
            case 2004: {
                a = Attr.Y1ScaleMax;
                break;
            }
            case 2005: {
                a = Attr.Y2ScaleMax;
            }
        }
        this.putToLookAndRepaint(id, a, new Double(newValue));
    }

    public void setScaleMax(int objectID, double newValue) {
        this.setScaleMax(new IdentObj(objectID), newValue);
    }

    public boolean getScaleMaxAuto() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.ScaleMaxAuto);
        return m_Obj;
    }

    public boolean getScaleMaxAuto(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.ScaleMaxAuto);
        return m_Obj;
    }

    public boolean getScaleMaxAuto(int objectID) {
        return this.getScaleMaxAuto(new IdentObj(objectID));
    }

    public void setScaleMaxAuto(boolean newValue) {
        this.putToLookAndRepaint(Attr.ScaleMaxAuto, new Boolean(newValue));
    }

    public void setScaleMaxAuto(IdentObj id, boolean newValue) {
        this.putToLookAndRepaint(id, Attr.ScaleMaxAuto, new Boolean(newValue));
    }

    public void setScaleMaxAuto(int objectID, boolean newValue) {
        this.setScaleMaxAuto(new IdentObj(objectID), newValue);
    }

    public double getScaleMin() {
        Double m_Obj = (Double)this.getFromLook(Attr.ScaleMin);
        return m_Obj;
    }

    public double getScaleMin(IdentObj id) {
        Attr a = Attr.ScaleMin;
        switch (id.getObjectID()) {
            case 2005: {
                a = Attr.Y2ScaleMin;
            }
        }
        Double m_Obj = (Double)this.getFromLook(id, a);
        return m_Obj;
    }

    public double getScaleMin(int objectID) {
        return this.getScaleMin(new IdentObj(objectID));
    }

    public void setScaleMin(double newValue) {
        this.putToLookAndRepaint(Attr.ScaleMin, new Double(newValue));
    }

    public void setScaleMin(IdentObj id, double newValue) {
        Attr a = Attr.ScaleMin;
        switch (id.getObjectID()) {
            case 2005: {
                a = Attr.Y2ScaleMin;
            }
        }
        this.putToLookAndRepaint(id, a, new Double(newValue));
    }

    public void setScaleMin(int objectID, double newValue) {
        this.setScaleMin(new IdentObj(objectID), newValue);
    }

    public boolean getScaleMinAuto() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.ScaleMinAuto);
        return m_Obj;
    }

    public boolean getScaleMinAuto(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.ScaleMinAuto);
        return m_Obj;
    }

    public boolean getScaleMinAuto(int objectID) {
        return this.getScaleMinAuto(new IdentObj(objectID));
    }

    public void setScaleMinAuto(boolean newValue) {
        this.putToLookAndRepaint(Attr.ScaleMinAuto, new Boolean(newValue));
    }

    public void setScaleMinAuto(IdentObj id, boolean newValue) {
        this.putToLookAndRepaint(id, Attr.ScaleMinAuto, new Boolean(newValue));
    }

    public void setScaleMinAuto(int objectID, boolean newValue) {
        this.setScaleMinAuto(new IdentObj(objectID), newValue);
    }

    public boolean getScaleMustIncludeZero() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.ScaleMustIncludeZero);
        return m_Obj;
    }

    public boolean getScaleMustIncludeZero(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.ScaleMustIncludeZero);
        return m_Obj;
    }

    public boolean getScaleMustIncludeZero(int objectID) {
        return this.getScaleMustIncludeZero(new IdentObj(objectID));
    }

    public void setScaleMustIncludeZero(boolean newValue) {
        this.putToLookAndRepaint(Attr.ScaleMustIncludeZero, new Boolean(newValue));
    }

    public void setScaleMustIncludeZero(IdentObj id, boolean newValue) {
        this.putToLookAndRepaint(id, Attr.ScaleMustIncludeZero, new Boolean(newValue));
    }

    public void setScaleMustIncludeZero(int objectID, boolean newValue) {
        this.setScaleMustIncludeZero(new IdentObj(objectID), newValue);
    }

    public String getSeriesLabel(int seriesID) {
        String ret = null;
        if (this.m_seriesLabels.size() > seriesID) {
            ret = (String)this.m_seriesLabels.elementAt(seriesID);
        }
        return ret;
    }

    public void setSeriesLabel(int seriesID, Object newValue) {
        if (this.m_seriesLabels.size() < seriesID) {
            this.m_seriesLabels.setSize(seriesID + 1);
        }
        this.m_seriesLabels.insertElementAt(newValue, seriesID);
    }

    public boolean getShadowDisplay() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.ShadowDisplay);
        return m_Obj;
    }

    public boolean getShadowDisplay(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.ShadowDisplay);
        return m_Obj;
    }

    public boolean getShadowDisplay(int objectID) {
        return this.getShadowDisplay(new IdentObj(objectID));
    }

    public void setShadowDisplay(boolean newValue) {
        this.putToLookAndRepaint(Attr.ShadowDisplay, new Boolean(newValue));
    }

    public void setShadowDisplay(IdentObj id, boolean newValue) {
        this.putToLookAndRepaint(id, Attr.ShadowDisplay, new Boolean(newValue));
    }

    public void setShadowDisplay(int objectID, boolean newValue) {
        this.setShadowDisplay(new IdentObj(objectID), newValue);
    }

    public int getShadowXOffset() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.ShadowXOffset);
        return m_Obj;
    }

    public int getShadowXOffset(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.ShadowXOffset);
        return m_Obj;
    }

    public int getShadowXOffset(int objectID) {
        return this.getShadowXOffset(new IdentObj(objectID));
    }

    public void setShadowXOffset(int newValue) {
        this.putToLookAndRepaint(Attr.ShadowXOffset, new Integer(newValue));
    }

    public void setShadowXOffset(IdentObj id, int newValue) {
        this.putToLookAndRepaint(id, Attr.ShadowXOffset, new Integer(newValue));
    }

    public void setShadowXOffset(int objectID, int newValue) {
        this.setShadowXOffset(new IdentObj(objectID), newValue);
    }

    public int getShadowYOffset() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.ShadowYOffset);
        return m_Obj;
    }

    public int getShadowYOffset(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.ShadowYOffset);
        return m_Obj;
    }

    public int getShadowYOffset(int objectID) {
        return this.getShadowYOffset(new IdentObj(objectID));
    }

    public void setShadowYOffset(int newValue) {
        this.putToLookAndRepaint(Attr.ShadowYOffset, new Integer(newValue));
    }

    public void setShadowYOffset(IdentObj id, int newValue) {
        this.putToLookAndRepaint(id, Attr.ShadowYOffset, new Integer(newValue));
    }

    public void setShadowYOffset(int objectID, int newValue) {
        this.setShadowYOffset(new IdentObj(objectID), newValue);
    }

    public int getTextFormatPreset() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.TextFormatPreset);
        return m_Obj;
    }

    public int getTextFormatPreset(IdentObj id) {
        Attr a = Attr.TextFormatPreset;
        if (id.getObjectID() == 295) {
            a = Attr.SliceLabelTextFormatPreset;
        }
        Integer m_Obj = (Integer)this.getFromLook(id, a);
        return m_Obj;
    }

    public int getTextFormatPreset(int objectID) {
        return this.getTextFormatPreset(new IdentObj(objectID));
    }

    public void setTextFormatPreset(int newValue) {
        this.putToLookAndRepaint(Attr.TextFormatPreset, new Integer(newValue));
    }

    public void setTextFormatPreset(IdentObj id, int newValue) {
        Attr a = Attr.TextFormatPreset;
        if (id.getObjectID() == 295) {
            a = Attr.SliceLabelTextFormatPreset;
        }
        this.putToLookAndRepaint(id, a, new Integer(newValue));
    }

    public void setTextFormatPreset(int objectID, int newValue) {
        this.setTextFormatPreset(new IdentObj(objectID), newValue);
    }

    public int getTextJustHoriz() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.TextJustHoriz);
        return m_Obj;
    }

    public int getTextJustHoriz(IdentObj id) {
        Attr a = Attr.TextJustHoriz;
        switch (id.getObjectID()) {
            case 260: 
            case 274: 
            case 284: 
            case 288: {
                a = Attr.RightTextJustHoriz;
                break;
            }
            case 3: 
            case 14: 
            case 235: {
                a = Attr.LeftTextJustHoriz;
            }
        }
        Integer m_Obj = (Integer)this.getFromLook(id, a);
        return m_Obj;
    }

    public int getTextJustHoriz(int objectID) {
        return this.getTextJustHoriz(new IdentObj(objectID));
    }

    public void setTextJustHoriz(int newValue) {
        this.putToLookAndRepaint(Attr.TextJustHoriz, new Integer(newValue));
    }

    public void setTextJustHoriz(IdentObj id, int newValue) {
        Attr a = Attr.TextJustHoriz;
        switch (id.getObjectID()) {
            case 260: 
            case 274: 
            case 284: 
            case 288: {
                a = Attr.RightTextJustHoriz;
                break;
            }
            case 3: 
            case 14: 
            case 235: {
                a = Attr.LeftTextJustHoriz;
            }
        }
        this.putToLookAndRepaint(id, a, new Integer(newValue));
    }

    public void setTextJustHoriz(int objectID, int newValue) {
        this.setTextJustHoriz(new IdentObj(objectID), newValue);
    }

    public int getTextJustVert() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.TextJustVert);
        return m_Obj;
    }

    public int getTextJustVert(IdentObj id) {
        Attr a = Attr.TextJustVert;
        if (id.getObjectID() == 270) {
            a = Attr.TopTextJustVert;
        }
        Integer m_Obj = (Integer)this.getFromLook(id, a);
        return m_Obj;
    }

    public int getTextJustVert(int objectID) {
        return this.getTextJustVert(new IdentObj(objectID));
    }

    public void setTextJustVert(int newValue) {
        this.putToLookAndRepaint(Attr.TextJustVert, new Integer(newValue));
    }

    public void setTextJustVert(IdentObj id, int newValue) {
        Attr a = Attr.TextJustVert;
        if (id.getObjectID() == 270) {
            a = Attr.TopTextJustVert;
        }
        this.putToLookAndRepaint(id, a, new Integer(newValue));
    }

    public void setTextJustVert(int objectID, int newValue) {
        this.setTextJustVert(new IdentObj(objectID), newValue);
    }

    public int getTextRotation() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.TextRotation);
        return m_Obj;
    }

    public int getTextRotation(IdentObj id) {
        Attr a = Attr.TextRotation;
        switch (id.getObjectID()) {
            case 6: {
                a = Attr.Y1TextRotation;
                break;
            }
            case 7: {
                a = Attr.Y2TextRotation;
            }
        }
        Integer m_Obj = (Integer)this.getFromLook(id, a);
        return m_Obj;
    }

    public int getTextRotation(int objectID) {
        return this.getTextRotation(new IdentObj(objectID));
    }

    public void setTextRotation(int newValue) {
        this.putToLookAndRepaint(Attr.TextRotation, new Integer(newValue));
    }

    public void setTextRotation(IdentObj id, int newValue) {
        Attr a = Attr.TextRotation;
        switch (id.getObjectID()) {
            case 6: {
                a = Attr.Y1TextRotation;
                break;
            }
            case 7: {
                a = Attr.Y2TextRotation;
            }
        }
        this.putToLookAndRepaint(id, a, new Integer(newValue));
    }

    public void setTextRotation(int objectID, int newValue) {
        this.setTextRotation(new IdentObj(objectID), newValue);
    }

    public String getTextString() {
        String m_Obj = (String)this.getFromLook(Attr.TextString);
        return m_Obj;
    }

    public String getTextString(IdentObj id) {
        String m_Obj = (String)this.getFromLook(id, Attr.TextString);
        return m_Obj;
    }

    public String getTextString(int objectID) {
        return this.getTextString(new IdentObj(objectID));
    }

    public void setTextString(String newValue) {
        this.putToLookAndRepaint(Attr.TextString, newValue);
    }

    public void setTextString(IdentObj id, String newValue) {
        this.putToLookAndRepaint(id, Attr.TextString, newValue);
    }

    public void setTextString(int objectID, String newValue) {
        this.setTextString(new IdentObj(objectID), newValue);
    }

    public boolean getTextWrap() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.TextWrap);
        return m_Obj;
    }

    public boolean getTextWrap(IdentObj id) {
        Attr a = Attr.TextWrap;
        switch (id.getObjectID()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 232: 
            case 233: 
            case 260: {
                a = Attr.TitleTextWrap;
            }
        }
        Boolean m_Obj = (Boolean)this.getFromLook(id, a);
        return m_Obj;
    }

    public boolean getTextWrap(int objectID) {
        return this.getTextWrap(new IdentObj(objectID));
    }

    public void setTextWrap(boolean newValue) {
        this.putToLookAndRepaint(Attr.TextWrap, new Boolean(newValue));
    }

    public void setTextWrap(IdentObj id, boolean newValue) {
        Attr a = Attr.TextWrap;
        switch (id.getObjectID()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 232: 
            case 233: 
            case 260: {
                a = Attr.TitleTextWrap;
            }
        }
        this.putToLookAndRepaint(id, a, new Boolean(newValue));
    }

    public void setTextWrap(int objectID, boolean newValue) {
        this.setTextWrap(new IdentObj(objectID), newValue);
    }

    public String getURL() {
        String m_Obj = (String)this.getFromLook(Attr.URL, 3);
        return m_Obj;
    }

    public String getURL(IdentObj id) {
        String m_Obj = (String)this.getFromLook(id, Attr.URL);
        return m_Obj;
    }

    public String getURL(int seriesID) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        return this.getURL(id);
    }

    public String getURL(int seriesID, int groupID) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        return this.getURL(id);
    }

    public void setURL(String newValue) {
        this.putToLookAndRepaint(Attr.URL, newValue, 3);
    }

    public void setURL(IdentObj id, String newValue) {
        this.putToLookAndRepaint(id, Attr.URL, newValue);
    }

    public void setURL(int seriesID, String newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setURL(id, newValue);
    }

    public void setURL(int seriesID, int groupID, String newValue) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        this.setURL(id, newValue);
    }

    public String getURLTarget() {
        String m_Obj = (String)this.getFromLook(Attr.URLTarget, 3);
        return m_Obj;
    }

    public String getURLTarget(IdentObj id) {
        String m_Obj = (String)this.getFromLook(id, Attr.URLTarget);
        return m_Obj;
    }

    public String getURLTarget(int seriesID) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        return this.getURLTarget(id);
    }

    public String getURLTarget(int seriesID, int groupID) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        return this.getURLTarget(id);
    }

    public void setURLTarget(String newValue) {
        this.putToLookAndRepaint(Attr.URLTarget, newValue, 3);
    }

    public void setURLTarget(IdentObj id, String newValue) {
        this.putToLookAndRepaint(id, Attr.URLTarget, newValue);
    }

    public void setURLTarget(int seriesID, String newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setURLTarget(id, newValue);
    }

    public void setURLTarget(int seriesID, int groupID, String newValue) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        this.setURLTarget(id, newValue);
    }

    public int getSeriesType() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.SeriesType, 1);
        return m_Obj;
    }

    public int getSeriesType(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.SeriesType);
        return m_Obj;
    }

    public int getSeriesType(int seriesID) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        return this.getSeriesType(id);
    }

    public void setSeriesType(int newValue) {
        this.putToLookAndRepaint(Attr.SeriesType, new Integer(newValue), 1);
    }

    public void setSeriesType(IdentObj id, int newValue) {
        this.putToLookAndRepaint(id, Attr.SeriesType, new Integer(newValue));
    }

    public void setSeriesType(int seriesID, int newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setSeriesType(id, newValue);
    }

    public int getDataLineThickness() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.DataLineThickness);
        return m_Obj;
    }

    public void setDataLineThickness(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.DataLineThickness, new Integer(newValue));
    }

    public boolean getLegendReverse() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.LegendReverse);
        return m_Obj;
    }

    public void setLegendReverse(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.LegendReverse, new Boolean(newValue));
    }

    public String getY2TitleString() {
        return this.getTextString(new IdentObj(7));
    }

    public void setY2TitleString(String newValue) {
        this.setTextString(new IdentObj(7), newValue);
        if (this.getCascade() && newValue.length() > 0) {
            this.setY2TitleDisplay(true);
        }
    }

    public boolean getDisplayBarAsPictograph() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.DisplayBarAsPictograph);
        return m_Obj;
    }

    public void setDisplayBarAsPictograph(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.DisplayBarAsPictograph, new Boolean(newValue));
    }

    public String getDataTextTemplateHiLo() {
        String m_Obj = (String)this.getFromLook(new IdentObj(2000), Attr.DataTextTemplateHiLo);
        return m_Obj;
    }

    public void setDataTextTemplateHiLo(String newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.DataTextTemplateHiLo, newValue);
    }

    public String getTextFormatPattern() {
        String m_Obj = (String)this.getFromLook(Attr.TextFormatPattern);
        return m_Obj;
    }

    public String getTextFormatPattern(IdentObj id) {
        String m_Obj = (String)this.getFromLook(id, Attr.TextFormatPattern);
        return m_Obj;
    }

    public String getTextFormatPattern(int objectID) {
        return this.getTextFormatPattern(new IdentObj(objectID));
    }

    public void setTextFormatPattern(String newValue) {
        this.putToLookAndRepaint(Attr.TextFormatPattern, newValue);
    }

    public void setTextFormatPattern(IdentObj id, String newValue) {
        this.putToLookAndRepaint(id, Attr.TextFormatPattern, newValue);
    }

    public void setTextFormatPattern(int objectID, String newValue) {
        this.setTextFormatPattern(new IdentObj(objectID), newValue);
    }

    public String getDataTextFormatPattern() {
        return this.getTextFormatPattern(new IdentObj(2000));
    }

    public void setDataTextFormatPattern(String newValue) {
        this.setTextFormatPattern(new IdentObj(2000), newValue);
    }

    public int getTextureDisplayMode() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.TextureDisplayMode);
        return m_Obj;
    }

    public void setTextureDisplayMode(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.TextureDisplayMode, new Integer(newValue));
    }

    public double getCubeLightSourceX() {
        Double m_Obj = (Double)this.getFromLook(new IdentObj(2000), Attr.CubeLightSourceX);
        return m_Obj;
    }

    public void setCubeLightSourceX(double newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeLightSourceX, new Double(newValue));
    }

    public double getCubeLightSourceY() {
        Double m_Obj = (Double)this.getFromLook(new IdentObj(2000), Attr.CubeLightSourceY);
        return m_Obj;
    }

    public void setCubeLightSourceY(double newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeLightSourceY, new Double(newValue));
    }

    public String getPieFeelerTextFormatPattern() {
        return this.getTextFormatPattern(new IdentObj(295));
    }

    public void setPieFeelerTextFormatPattern(String newValue) {
        this.setTextFormatPattern(new IdentObj(295), newValue);
    }

    public String getPieRingTotalFormatPattern() {
        return this.getTextFormatPattern(new IdentObj(297));
    }

    public void setPieRingTotalFormatPattern(String newValue) {
        this.setTextFormatPattern(new IdentObj(297), newValue);
    }

    public String getX1LabelFormatPattern() {
        return this.getTextFormatPattern(new IdentObj(280));
    }

    public void setX1LabelFormatPattern(String newValue) {
        this.setTextFormatPattern(new IdentObj(280), newValue);
    }

    public int getQuadrantLineCountX() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.QuadrantLineCountX);
        return m_Obj;
    }

    public void setQuadrantLineCountX(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.QuadrantLineCountX, new Integer(newValue));
    }

    public int getO1LabelRotate() {
        return this.getTextRotation(this.getO1Label());
    }

    public void setO1LabelRotate(int newValue) {
        this.setTextRotation(this.getO1Label(), newValue);
    }

    public int getO2LabelRotate() {
        return this.getTextRotation(this.getO2Label());
    }

    public void setO2LabelRotate(int newValue) {
        this.setTextRotation(this.getO2Label(), newValue);
    }

    public int getY1LabelRotate() {
        return this.getTextRotation(new IdentObj(284));
    }

    public void setY1LabelRotate(int newValue) {
        this.setTextRotation(new IdentObj(284), newValue);
    }

    public int getY2LabelRotate() {
        return this.getTextRotation(new IdentObj(288));
    }

    public void setY2LabelRotate(int newValue) {
        this.setTextRotation(new IdentObj(288), newValue);
    }

    public int getX1LabelRotate() {
        return this.getTextRotation(new IdentObj(280));
    }

    public void setX1LabelRotate(int newValue) {
        this.setTextRotation(new IdentObj(280), newValue);
    }

    public String getToolTipCustomString() {
        String m_Obj = (String)this.getFromLook(Attr.ToolTipCustomString, 3);
        return m_Obj;
    }

    public String getToolTipCustomString(IdentObj id) {
        String m_Obj = (String)this.getFromLook(id, Attr.ToolTipCustomString);
        return m_Obj;
    }

    public String getToolTipCustomString(int seriesID) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        return this.getToolTipCustomString(id);
    }

    public String getToolTipCustomString(int seriesID, int groupID) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        return this.getToolTipCustomString(id);
    }

    public void setToolTipCustomString(String newValue) {
        this.putToLookAndRepaint(Attr.ToolTipCustomString, newValue, 3);
    }

    public void setToolTipCustomString(IdentObj id, String newValue) {
        this.putToLookAndRepaint(id, Attr.ToolTipCustomString, newValue);
    }

    public void setToolTipCustomString(int seriesID, String newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setToolTipCustomString(id, newValue);
    }

    public void setToolTipCustomString(int seriesID, int groupID, String newValue) {
        IdentObj id = new IdentObj(-3, seriesID, groupID);
        this.setToolTipCustomString(id, newValue);
    }

    public double getCubeLightSourceZ() {
        Double m_Obj = (Double)this.getFromLook(new IdentObj(2000), Attr.CubeLightSourceZ);
        return m_Obj;
    }

    public void setCubeLightSourceZ(double newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeLightSourceZ, new Double(newValue));
    }

    public String getY1LabelFormatPattern() {
        return this.getTextFormatPattern(new IdentObj(284));
    }

    public void setY1LabelFormatPattern(String newValue) {
        this.setTextFormatPattern(new IdentObj(284), newValue);
    }

    public String getY2LabelFormatPattern() {
        return this.getTextFormatPattern(new IdentObj(288));
    }

    public void setY2LabelFormatPattern(String newValue) {
        this.setTextFormatPattern(new IdentObj(288), newValue);
    }

    public int getTextAutofitMin() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.TextAutofitMin);
        return m_Obj;
    }

    public void setTextAutofitMin(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.TextAutofitMin, new Integer(newValue));
    }

    public int getTextAutofitMax() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.TextAutofitMax);
        return m_Obj;
    }

    public void setTextAutofitMax(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.TextAutofitMax, new Integer(newValue));
    }

    public int getQuadrantLineCountY() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.QuadrantLineCountY);
        return m_Obj;
    }

    public void setQuadrantLineCountY(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.QuadrantLineCountY, new Integer(newValue));
    }

    public int getZoomDirection() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.ZoomDirection);
        return m_Obj;
    }

    public void setZoomDirection(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ZoomDirection, new Integer(newValue));
    }

    public boolean getIgnoreSeries() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.IgnoreSeries, 1);
        return m_Obj;
    }

    public boolean getIgnoreSeries(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.IgnoreSeries);
        return m_Obj;
    }

    public boolean getIgnoreSeries(int seriesID) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        return this.getIgnoreSeries(id);
    }

    public void setIgnoreSeries(boolean newValue) {
        this.putToLookAndRepaint(Attr.IgnoreSeries, new Boolean(newValue), 1);
    }

    public void setIgnoreSeries(IdentObj id, boolean newValue) {
        this.putToLookAndRepaint(id, Attr.IgnoreSeries, new Boolean(newValue));
    }

    public void setIgnoreSeries(int seriesID, boolean newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setIgnoreSeries(id, newValue);
    }

    public int getDataScrollerPresenceGroups() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.DataScrollerPresenceGroups);
        return m_Obj;
    }

    public void setDataScrollerPresenceGroups(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.DataScrollerPresenceGroups, new Integer(newValue));
    }

    public int getPieBarSeries() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.PieBarSeries);
        return m_Obj;
    }

    public void setPieBarSeries(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.PieBarSeries, new Integer(newValue));
    }

    public int getO1LabelMargin() {
        return this.getLabelMargin(this.getO1Label());
    }

    public void setO1LabelMargin(int newValue) {
        this.setLabelMargin(this.getO1Label(), newValue);
    }

    public int getLabelMargin() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.LabelMargin);
        return m_Obj;
    }

    public int getLabelMargin(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.LabelMargin);
        return m_Obj;
    }

    public int getLabelMargin(int objectID) {
        return this.getLabelMargin(new IdentObj(objectID));
    }

    public void setLabelMargin(int newValue) {
        this.putToLookAndRepaint(Attr.LabelMargin, new Integer(newValue));
    }

    public void setLabelMargin(IdentObj id, int newValue) {
        this.putToLookAndRepaint(id, Attr.LabelMargin, new Integer(newValue));
    }

    public void setLabelMargin(int objectID, int newValue) {
        this.setLabelMargin(new IdentObj(objectID), newValue);
    }

    public int getDataScrollerPresenceSeries() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.DataScrollerPresenceSeries);
        return m_Obj;
    }

    public void setDataScrollerPresenceSeries(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.DataScrollerPresenceSeries, new Integer(newValue));
    }

    public boolean getBiDirectional() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.BiDirectional);
        return m_Obj;
    }

    public void setBiDirectional(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.BiDirectional, new Boolean(newValue));
    }

    public int getAxisTextAutofitMax() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.AxisTextAutofitMax);
        return m_Obj;
    }

    public void setAxisTextAutofitMax(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.AxisTextAutofitMax, new Integer(newValue));
    }

    public int getAxisTextAutofitMin() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.AxisTextAutofitMin);
        return m_Obj;
    }

    public void setAxisTextAutofitMin(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.AxisTextAutofitMin, new Integer(newValue));
    }

    public int getAxisTextAutofitMode() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.AxisTextAutofitMode);
        return m_Obj;
    }

    public void setAxisTextAutofitMode(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.AxisTextAutofitMode, new Integer(newValue));
    }

    public int getAxisTextAutofitPercent() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.AxisTextAutofitPercent);
        return m_Obj;
    }

    public void setAxisTextAutofitPercent(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.AxisTextAutofitPercent, new Integer(newValue));
    }

    public boolean getNestedLabels() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.NestedLabels);
        return m_Obj;
    }

    public void setNestedLabels(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.NestedLabels, new Boolean(newValue));
    }

    public boolean getNestedLabelsUniformStyle() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.NestedLabelsUniformStyle);
        return m_Obj;
    }

    public void setNestedLabelsUniformStyle(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.NestedLabelsUniformStyle, new Boolean(newValue));
    }

    public String getDataTextTemplateScatter() {
        String m_Obj = (String)this.getFromLook(new IdentObj(2000), Attr.DataTextTemplateScatter);
        return m_Obj;
    }

    public void setDataTextTemplateScatter(String newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.DataTextTemplateScatter, newValue);
    }

    public String getDataTextTemplateBubble() {
        String m_Obj = (String)this.getFromLook(new IdentObj(2000), Attr.DataTextTemplateBubble);
        return m_Obj;
    }

    public void setDataTextTemplateBubble(String newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.DataTextTemplateBubble, newValue);
    }

    public int getFontSize() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.FontSize);
        return m_Obj;
    }

    public int getFontSize(IdentObj id) {
        Attr a = Attr.FontSize;
        switch (id.getObjectID()) {
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: {
                a = Attr.ScrollerFontSize;
                break;
            }
            case 5: {
                a = Attr.TitleFontSize;
                break;
            }
            case 4: {
                a = Attr.SubtitleFontSize;
            }
        }
        Integer m_Obj = (Integer)this.getFromLook(id, a);
        return m_Obj;
    }

    public int getFontSize(int objectID) {
        return this.getFontSize(new IdentObj(objectID));
    }

    public void setFontSize(int newValue) {
        if (this.getCascade()) {
            this.setAutofit(false);
        }
        this.putToLookAndRepaint(Attr.FontSize, new Integer(newValue));
    }

    public void setFontSize(IdentObj id, int newValue) {
        Attr a = Attr.FontSize;
        switch (id.getObjectID()) {
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: {
                a = Attr.ScrollerFontSize;
                break;
            }
            case 5: {
                a = Attr.TitleFontSize;
                break;
            }
            case 4: {
                a = Attr.SubtitleFontSize;
            }
        }
        if (this.getCascade()) {
            this.setAutofit(id, false);
        }
        this.putToLookAndRepaint(id, a, new Integer(newValue));
    }

    public void setFontSize(int objectID, int newValue) {
        this.setFontSize(new IdentObj(objectID), newValue);
    }

    public int getLegendMarkersPerRow() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.LegendMarkersPerRow);
        return m_Obj;
    }

    public void setLegendMarkersPerRow(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.LegendMarkersPerRow, new Integer(newValue));
    }

    public int getLegendOrient() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.LegendOrient);
        return m_Obj;
    }

    public void setLegendOrient(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.LegendOrient, new Integer(newValue));
    }

    public int getTextDirection() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.TextDirection);
        return m_Obj;
    }

    public void setTextDirection(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.TextDirection, new Integer(newValue));
    }

    public double getLogScaleBase() {
        Double m_Obj = (Double)this.getFromLook(Attr.LogScaleBase);
        return m_Obj;
    }

    public double getLogScaleBase(IdentObj id) {
        Double m_Obj = (Double)this.getFromLook(id, Attr.LogScaleBase);
        return m_Obj;
    }

    public double getLogScaleBase(int objectID) {
        return this.getLogScaleBase(new IdentObj(objectID));
    }

    public void setLogScaleBase(double newValue) {
        this.putToLookAndRepaint(Attr.LogScaleBase, new Double(newValue));
    }

    public void setLogScaleBase(IdentObj id, double newValue) {
        this.putToLookAndRepaint(id, Attr.LogScaleBase, new Double(newValue));
    }

    public void setLogScaleBase(int objectID, double newValue) {
        this.setLogScaleBase(new IdentObj(objectID), newValue);
    }

    public boolean getMoveAxisTitles() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.MoveAxisTitles);
        return m_Obj;
    }

    public void setMoveAxisTitles(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.MoveAxisTitles, new Boolean(newValue));
    }

    public String getPieBarLabelString() {
        return this.getTextString(new IdentObj(355));
    }

    public void setPieBarLabelString(String newValue) {
        this.setTextString(new IdentObj(355), newValue);
        if (this.getCascade() && newValue.length() > 0) {
            this.setPieBarLabelDisplay(true);
        }
    }

    public boolean getPieBarLabelDisplay() {
        return this.getDisplay(new IdentObj(355));
    }

    public void setPieBarLabelDisplay(boolean newValue) {
        this.setDisplay(new IdentObj(355), newValue);
    }

    public boolean getCascade() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.Cascade);
        return m_Obj;
    }

    public void setCascade(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.Cascade, new Boolean(newValue));
    }

    public int getTextureFlipMode() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.TextureFlipMode);
        return m_Obj;
    }

    public void setTextureFlipMode(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.TextureFlipMode, new Integer(newValue));
    }

    public boolean getExtendToFrameEdge() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.ExtendToFrameEdge);
        return m_Obj;
    }

    public void setExtendToFrameEdge(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ExtendToFrameEdge, new Boolean(newValue));
    }

    public int getDisplayParetoSeries() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.DisplayParetoSeries);
        return m_Obj;
    }

    public void setDisplayParetoSeries(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.DisplayParetoSeries, new Integer(newValue));
    }

    public boolean getConnectParetoBars() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.ConnectParetoBars);
        return m_Obj;
    }

    public void setConnectParetoBars(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ConnectParetoBars, new Boolean(newValue));
    }

    public double getParetoY2MajorGridStep() {
        Double m_Obj = (Double)this.getFromLook(new IdentObj(2000), Attr.ParetoY2MajorGridStep);
        return m_Obj;
    }

    public void setParetoY2MajorGridStep(double newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ParetoY2MajorGridStep, new Double(newValue));
    }

    public int getAxisSize() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.AxisSize);
        return m_Obj;
    }

    public int getAxisSize(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.AxisSize);
        return m_Obj;
    }

    public int getAxisSize(int objectID) {
        return this.getAxisSize(new IdentObj(objectID));
    }

    public void setAxisSize(int newValue) {
        this.putToLookAndRepaint(Attr.AxisSize, new Integer(newValue));
    }

    public void setAxisSize(IdentObj id, int newValue) {
        this.putToLookAndRepaint(id, Attr.AxisSize, new Integer(newValue));
    }

    public void setAxisSize(int objectID, int newValue) {
        this.setAxisSize(new IdentObj(objectID), newValue);
    }

    public int getAxisOffset() {
        Integer m_Obj = (Integer)this.getFromLook(Attr.AxisOffset);
        return m_Obj;
    }

    public int getAxisOffset(IdentObj id) {
        Integer m_Obj = (Integer)this.getFromLook(id, Attr.AxisOffset);
        return m_Obj;
    }

    public int getAxisOffset(int objectID) {
        return this.getAxisOffset(new IdentObj(objectID));
    }

    public void setAxisOffset(int newValue) {
        this.putToLookAndRepaint(Attr.AxisOffset, new Integer(newValue));
    }

    public void setAxisOffset(IdentObj id, int newValue) {
        this.putToLookAndRepaint(id, Attr.AxisOffset, new Integer(newValue));
    }

    public void setAxisOffset(int objectID, int newValue) {
        this.setAxisOffset(new IdentObj(objectID), newValue);
    }

    public boolean getPrimitiveAntialiasing() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.PrimitiveAntialiasing);
        return m_Obj;
    }

    public void setPrimitiveAntialiasing(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.PrimitiveAntialiasing, new Boolean(newValue));
    }

    public boolean getTextAntialiasing() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.TextAntialiasing);
        return m_Obj;
    }

    public void setTextAntialiasing(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.TextAntialiasing, new Boolean(newValue));
    }

    public boolean getTextTruncate() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.TextTruncate);
        return m_Obj;
    }

    public boolean getTextTruncate(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.TextTruncate);
        return m_Obj;
    }

    public boolean getTextTruncate(int objectID) {
        return this.getTextTruncate(new IdentObj(objectID));
    }

    public void setTextTruncate(boolean newValue) {
        this.putToLookAndRepaint(Attr.TextTruncate, new Boolean(newValue));
    }

    public void setTextTruncate(IdentObj id, boolean newValue) {
        this.putToLookAndRepaint(id, Attr.TextTruncate, new Boolean(newValue));
    }

    public void setTextTruncate(int objectID, boolean newValue) {
        this.setTextTruncate(new IdentObj(objectID), newValue);
    }

    public int getParetoDisplayThreshold() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.ParetoDisplayThreshold);
        return m_Obj;
    }

    public void setParetoDisplayThreshold(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ParetoDisplayThreshold, new Integer(newValue));
    }

    public boolean getNonZeroBaseline() {
        Boolean m_Obj = (Boolean)this.getFromLook(Attr.NonZeroBaseline);
        return m_Obj;
    }

    public boolean getNonZeroBaseline(IdentObj id) {
        Boolean m_Obj = (Boolean)this.getFromLook(id, Attr.NonZeroBaseline);
        return m_Obj;
    }

    public boolean getNonZeroBaseline(int objectID) {
        return this.getNonZeroBaseline(new IdentObj(objectID));
    }

    public void setNonZeroBaseline(boolean newValue) {
        this.putToLookAndRepaint(Attr.NonZeroBaseline, new Boolean(newValue));
    }

    public void setNonZeroBaseline(IdentObj id, boolean newValue) {
        this.putToLookAndRepaint(id, Attr.NonZeroBaseline, new Boolean(newValue));
    }

    public void setNonZeroBaseline(int objectID, boolean newValue) {
        this.setNonZeroBaseline(new IdentObj(objectID), newValue);
    }

    public boolean getTransparentMarkers() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.TransparentMarkers);
        return m_Obj;
    }

    public void setTransparentMarkers(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.TransparentMarkers, new Boolean(newValue));
    }

    public int getTransparentMarkerSize() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.TransparentMarkerSize);
        return m_Obj;
    }

    public void setTransparentMarkerSize(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.TransparentMarkerSize, new Integer(newValue));
    }

    public int getSeriesLineWidthDefault() {
        Integer m_Obj = (Integer)this.getFromLook(new IdentObj(2000), Attr.SeriesLineWidthDefault);
        return m_Obj;
    }

    public void setSeriesLineWidthDefault(int newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.SeriesLineWidthDefault, new Integer(newValue));
    }

    public boolean getIgnoreGridSkip() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.IgnoreGridSkip);
        return m_Obj;
    }

    public void setIgnoreGridSkip(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.IgnoreGridSkip, new Boolean(newValue));
    }

    public boolean getToolTipTimeOutEnabled() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.ToolTipTimeOutEnabled);
        return m_Obj;
    }

    public void setToolTipTimeOutEnabled(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ToolTipTimeOutEnabled, new Boolean(newValue));
    }

    public boolean getToolTipDisplayTimeOut() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.ToolTipDisplayTimeOut);
        return m_Obj;
    }

    public void setToolTipDisplayTimeOut(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ToolTipDisplayTimeOut, new Boolean(newValue));
    }

    public boolean getUseDefaultBubbleMarker() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.UseDefaultBubbleMarker);
        return m_Obj;
    }

    public void setUseDefaultBubbleMarker(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.UseDefaultBubbleMarker, new Boolean(newValue));
    }

    public boolean getSizeToContainer() {
        Boolean m_Obj = (Boolean)this.getFromLook(new IdentObj(2000), Attr.SizeToContainer);
        return m_Obj;
    }

    public void setSizeToContainer(boolean newValue) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.SizeToContainer, new Boolean(newValue));
    }

    public IdentObj getChartBackground() {
        return new IdentObj(1);
    }

    public IdentObj getFrame() {
        return new IdentObj(2);
    }

    public IdentObj getFootnote() {
        return new IdentObj(3);
    }

    public IdentObj getSubtitle() {
        return new IdentObj(4);
    }

    public IdentObj getTitle() {
        return new IdentObj(5);
    }

    public IdentObj getY1Title() {
        return new IdentObj(6);
    }

    public IdentObj getY2Title() {
        return new IdentObj(7);
    }

    public IdentObj getY3Title() {
        return new IdentObj(67);
    }

    public IdentObj getY4Title() {
        return new IdentObj(69);
    }

    public IdentObj getY5Title() {
        return new IdentObj(71);
    }

    public IdentObj getO1Title() {
        return new IdentObj(8);
    }

    public IdentObj getO2Title() {
        return new IdentObj(9);
    }

    public IdentObj getX1Title() {
        return new IdentObj(10);
    }

    public IdentObj getO1DrillLabel() {
        return new IdentObj(232);
    }

    public IdentObj getO2DrillLabel() {
        return new IdentObj(233);
    }

    public IdentObj getDrillMarker() {
        return new IdentObj(234);
    }

    public IdentObj getDrillText() {
        return new IdentObj(235);
    }

    public IdentObj getLegendArea() {
        return new IdentObj(12);
    }

    public IdentObj getLegendMarker() {
        return new IdentObj(13);
    }

    public IdentObj getLegendText() {
        return new IdentObj(14);
    }

    public IdentObj getFrameSide() {
        return new IdentObj(15);
    }

    public IdentObj getFrameBottom() {
        return new IdentObj(16);
    }

    public IdentObj getFrameSeparator() {
        return new IdentObj(17);
    }

    public IdentObj getSpectralLegendMarker() {
        return new IdentObj(18);
    }

    public IdentObj getGroupScroller() {
        return new IdentObj(19);
    }

    public IdentObj getGroupScrollerThumb() {
        return new IdentObj(20);
    }

    public IdentObj getGroupScrollerEditBox() {
        return new IdentObj(21);
    }

    public IdentObj getGroupScrollerEditLeft() {
        return new IdentObj(22);
    }

    public IdentObj getGroupScrollerEditThumb() {
        return new IdentObj(23);
    }

    public IdentObj getGroupScrollerEditRight() {
        return new IdentObj(24);
    }

    public IdentObj getSeriesScroller() {
        return new IdentObj(25);
    }

    public IdentObj getSeriesScrollerThumb() {
        return new IdentObj(26);
    }

    public IdentObj getSeriesScrollerEditBox() {
        return new IdentObj(27);
    }

    public IdentObj getSeriesScrollerEditLeft() {
        return new IdentObj(28);
    }

    public IdentObj getSeriesScrollerEditThumb() {
        return new IdentObj(29);
    }

    public IdentObj getSeriesScrollerEditRight() {
        return new IdentObj(30);
    }

    public IdentObj getNestedO1Label0() {
        return new IdentObj(31);
    }

    public IdentObj getNestedO1Label1() {
        return new IdentObj(32);
    }

    public IdentObj getNestedO1Label2() {
        return new IdentObj(33);
    }

    public IdentObj getNestedO1Label3() {
        return new IdentObj(34);
    }

    public IdentObj getNestedO1Label4() {
        return new IdentObj(35);
    }

    public IdentObj getNestedO1Label5() {
        return new IdentObj(36);
    }

    public IdentObj getNestedO1Label6() {
        return new IdentObj(37);
    }

    public IdentObj getNestedO1Label7() {
        return new IdentObj(38);
    }

    public IdentObj getNestedO1Label8() {
        return new IdentObj(39);
    }

    public IdentObj getNestedO1LabelLine() {
        return new IdentObj(40);
    }

    public IdentObj getCurveFitLineRiser() {
        return new IdentObj(41);
    }

    public IdentObj getCurveFitEquationText() {
        return new IdentObj(42);
    }

    public IdentObj getCurveFitCorrelationText() {
        return new IdentObj(43);
    }

    public IdentObj getFootnoteBox() {
        return new IdentObj(44);
    }

    public IdentObj getSubtitleBox() {
        return new IdentObj(45);
    }

    public IdentObj getTitleBox() {
        return new IdentObj(46);
    }

    public IdentObj getO1TitleBox() {
        return new IdentObj(49);
    }

    public IdentObj getO2TitleBox() {
        return new IdentObj(50);
    }

    public IdentObj getX1TitleBox() {
        return new IdentObj(51);
    }

    public IdentObj getY1TitleBox() {
        return new IdentObj(47);
    }

    public IdentObj getY2TitleBox() {
        return new IdentObj(48);
    }

    public IdentObj getZ1TitleBox() {
        return new IdentObj(52);
    }

    public IdentObj getO1DrillLabelBox() {
        return new IdentObj(230);
    }

    public IdentObj getO2DrillLabelBox() {
        return new IdentObj(231);
    }

    public IdentObj getLegendTextBox() {
        return new IdentObj(53);
    }

    public IdentObj getNestedO1Label0Box() {
        return new IdentObj(54);
    }

    public IdentObj getNestedO1Label1Box() {
        return new IdentObj(55);
    }

    public IdentObj getNestedO1Label2Box() {
        return new IdentObj(56);
    }

    public IdentObj getNestedO1Label3Box() {
        return new IdentObj(57);
    }

    public IdentObj getNestedO1Label4Box() {
        return new IdentObj(58);
    }

    public IdentObj getNestedO1Label5Box() {
        return new IdentObj(59);
    }

    public IdentObj getNestedO1Label6Box() {
        return new IdentObj(60);
    }

    public IdentObj getNestedO1Label7Box() {
        return new IdentObj(61);
    }

    public IdentObj getNestedO1Label8Box() {
        return new IdentObj(62);
    }

    public IdentObj getCurveFitEquationTextBox() {
        return new IdentObj(63);
    }

    public IdentObj getCurveFitCorrelationTextBox() {
        return new IdentObj(64);
    }

    public IdentObj getAreaRiser() {
        return new IdentObj(256);
    }

    public IdentObj getLineRiser() {
        return new IdentObj(258);
    }

    public IdentObj getLineMarker() {
        return new IdentObj(259);
    }

    public IdentObj getDataText() {
        return new IdentObj(260);
    }

    public IdentObj getO1AxisLine() {
        return new IdentObj(269);
    }

    public IdentObj getO1Label() {
        return new IdentObj(270, -3, 0);
    }

    public IdentObj getO1MajorGrid() {
        return new IdentObj(271, true);
    }

    public IdentObj getO1MinorGrid() {
        return new IdentObj(272, true);
    }

    public IdentObj getO2AxisLine() {
        return new IdentObj(273);
    }

    public IdentObj getO2Label() {
        return new IdentObj(274, 0, -3);
    }

    public IdentObj getO2MajorGrid() {
        return new IdentObj(275, true);
    }

    public IdentObj getO2MinorGrid() {
        return new IdentObj(276, true);
    }

    public IdentObj getBarRiser() {
        return new IdentObj(277);
    }

    public IdentObj getX1AxisLine() {
        return new IdentObj(279);
    }

    public IdentObj getX1Label() {
        return new IdentObj(280);
    }

    public IdentObj getX1MajorGrid() {
        return new IdentObj(281, true);
    }

    public IdentObj getX1MinorGrid() {
        return new IdentObj(282, true);
    }

    public IdentObj getY1AxisLine() {
        return new IdentObj(283);
    }

    public IdentObj getY1Label() {
        return new IdentObj(284);
    }

    public IdentObj getY1MajorGrid() {
        return new IdentObj(285, true);
    }

    public IdentObj getY1MinorGrid() {
        return new IdentObj(286, true);
    }

    public IdentObj getY2AxisLine() {
        return new IdentObj(287);
    }

    public IdentObj getY2Label() {
        return new IdentObj(288);
    }

    public IdentObj getY2MajorGrid() {
        return new IdentObj(289, true);
    }

    public IdentObj getY2MinorGrid() {
        return new IdentObj(290, true);
    }

    public IdentObj getX1ZeroLine() {
        return new IdentObj(291);
    }

    public IdentObj getY1ZeroLine() {
        return new IdentObj(292);
    }

    public IdentObj getY2ZeroLine() {
        return new IdentObj(293);
    }

    public IdentObj getPieFeelerLine() {
        return new IdentObj(294);
    }

    public IdentObj getPieSliceLabel() {
        return new IdentObj(295);
    }

    public IdentObj getPieLabel() {
        return new IdentObj(296);
    }

    public IdentObj getPieRingLabel() {
        return new IdentObj(297);
    }

    public IdentObj getSlice() {
        return new IdentObj(298);
    }

    public IdentObj getPieBarSlice() {
        return new IdentObj(332);
    }

    public IdentObj getSliceCrust() {
        return new IdentObj(299);
    }

    public IdentObj getPieBarSliceCrust() {
        return new IdentObj(333);
    }

    public IdentObj getSliceRing() {
        return new IdentObj(300);
    }

    public IdentObj getPieBarConnectLines() {
        return new IdentObj(301);
    }

    public IdentObj getPieFrame() {
        return new IdentObj(302);
    }

    public IdentObj getStockRiser() {
        return new IdentObj(303);
    }

    public IdentObj getStock52WeekHighLine() {
        return new IdentObj(304);
    }

    public IdentObj getStock52WeekLowLine() {
        return new IdentObj(305);
    }

    public IdentObj getStockLowerRiser() {
        return new IdentObj(306);
    }

    public IdentObj getStockCloseTick() {
        return new IdentObj(307);
    }

    public IdentObj getStockOpenTick() {
        return new IdentObj(308);
    }

    public IdentObj getStockMALine() {
        return new IdentObj(309);
    }

    public IdentObj getStockVolumeRiser() {
        return new IdentObj(310);
    }

    public IdentObj getStockRisingRiser() {
        return new IdentObj(319);
    }

    public IdentObj getStockFallingRiser() {
        return new IdentObj(320);
    }

    public IdentObj getStockHighLine() {
        return new IdentObj(321);
    }

    public IdentObj getStockLowLine() {
        return new IdentObj(322);
    }

    public IdentObj getHistogramRiser() {
        return new IdentObj(311);
    }

    public IdentObj getBarRiserSide() {
        return new IdentObj(312);
    }

    public IdentObj getBarRiserBottom() {
        return new IdentObj(313);
    }

    public IdentObj getAreaRiserTop() {
        return new IdentObj(314);
    }

    public IdentObj getAreaRiserBottom() {
        return new IdentObj(316);
    }

    public IdentObj getLineRiserSide() {
        return new IdentObj(317);
    }

    public IdentObj getLineRiserTop() {
        return new IdentObj(318);
    }

    public IdentObj getQuadrantLine() {
        return new IdentObj(328);
    }

    public IdentObj getScatterQuadrantLine() {
        return new IdentObj(329);
    }

    public IdentObj getSpectralMarker() {
        return new IdentObj(330);
    }

    public IdentObj getPieBarRiser() {
        return new IdentObj(331);
    }

    public IdentObj getPieBarRiserSide() {
        return new IdentObj(334);
    }

    public IdentObj getPieBarRiserTop() {
        return new IdentObj(335);
    }

    public IdentObj getPieBarLabel() {
        return new IdentObj(355);
    }

    public IdentObj getWaterfallLine() {
        return new IdentObj(439);
    }

    public IdentObj getY3AxisLine() {
        return new IdentObj(440);
    }

    public IdentObj getY3Label() {
        return new IdentObj(441);
    }

    public IdentObj getY3MajorGrid() {
        return new IdentObj(442);
    }

    public IdentObj getY3MinorGrid() {
        return new IdentObj(443);
    }

    public IdentObj getY3ZeroLine() {
        return new IdentObj(444);
    }

    public IdentObj getY4AxisLine() {
        return new IdentObj(445);
    }

    public IdentObj getY4Label() {
        return new IdentObj(446);
    }

    public IdentObj getY4MajorGrid() {
        return new IdentObj(447);
    }

    public IdentObj getY4MinorGrid() {
        return new IdentObj(448);
    }

    public IdentObj getY4ZeroLine() {
        return new IdentObj(449);
    }

    public IdentObj getY5AxisLine() {
        return new IdentObj(450);
    }

    public IdentObj getY5Label() {
        return new IdentObj(451);
    }

    public IdentObj getY5MajorGrid() {
        return new IdentObj(452);
    }

    public IdentObj getY5MinorGrid() {
        return new IdentObj(453);
    }

    public IdentObj getY5ZeroLine() {
        return new IdentObj(454);
    }

    public IdentObj getBreakevenLossArea() {
        return new IdentObj(367);
    }

    public IdentObj getBreakevenProfitArea() {
        return new IdentObj(368);
    }

    public IdentObj getBreakevenLossLabel() {
        return new IdentObj(369);
    }

    public IdentObj getBreakevenProfitLabel() {
        return new IdentObj(370);
    }

    public IdentObj getBreakevenSummaryLabel() {
        return new IdentObj(371);
    }

    public IdentObj getCubeFloor() {
        return new IdentObj(514);
    }

    public IdentObj getCubeLeftWall() {
        return new IdentObj(515);
    }

    public IdentObj getCubeRightWall() {
        return new IdentObj(516);
    }

    public IdentObj getCubeRiserFace() {
        return new IdentObj(517);
    }

    public IdentObj getCubeRiserGridX() {
        return new IdentObj(518);
    }

    public IdentObj getCubeRiserGridY() {
        return new IdentObj(519);
    }

    public IdentObj getCubeRiserGridZ() {
        return new IdentObj(520);
    }

    public IdentObj getCubeFloorGridX() {
        return new IdentObj(525);
    }

    public IdentObj getCubeFloorGridZ() {
        return new IdentObj(526);
    }

    public IdentObj getCubeLeftWallGridY() {
        return new IdentObj(527);
    }

    public IdentObj getCubeLeftWallGridZ() {
        return new IdentObj(528);
    }

    public IdentObj getCubeRightWallGridX() {
        return new IdentObj(529);
    }

    public IdentObj getCubeRightWallGridY() {
        return new IdentObj(530);
    }

    public IdentObj getO1Axis() {
        return new IdentObj(2001);
    }

    public IdentObj getO2Axis() {
        return new IdentObj(2002);
    }

    public IdentObj getX1Axis() {
        return new IdentObj(2003);
    }

    public IdentObj getY1Axis() {
        return new IdentObj(2004);
    }

    public IdentObj getY2Axis() {
        return new IdentObj(2005);
    }

    public IdentObj getY3Axis() {
        return new IdentObj(2012);
    }

    public IdentObj getY4Axis() {
        return new IdentObj(2013);
    }

    public IdentObj getY5Axis() {
        return new IdentObj(2014);
    }

    public IdentObj getColorByHeight() {
        return new IdentObj(2007);
    }

    public IdentObj getSeries(int nSeries) {
        return new IdentObj(-3, nSeries);
    }

    public IdentObj getGroup(int nGroup) {
        return new IdentObj(-3, -3, nGroup);
    }

    public IdentObj getSeriesGroup(int nSeries, int nGroup) {
        return new IdentObj(-3, nSeries, nGroup);
    }

    public IdentObj getGlobal() {
        return new IdentObj(2000);
    }

    public IdentObj getAreaRiser(int s, int g) {
        return new IdentObj(256, s, g);
    }

    public IdentObj getBarRiser(int s, int g) {
        return new IdentObj(277, s, g);
    }

    public IdentObj getCurveFitEquationText(int s) {
        return new IdentObj(42, s);
    }

    public IdentObj getCurveFitLineRiser(int s) {
        return new IdentObj(41, s);
    }

    public IdentObj getDataText(int s, int g) {
        return new IdentObj(260, s, g);
    }

    public IdentObj getLegendMarker(int s) {
        return new IdentObj(13, s);
    }

    public IdentObj getLegendText(int s) {
        return new IdentObj(14, s);
    }

    public IdentObj getLineMarker(int s, int g) {
        return new IdentObj(259, s, g);
    }

    public IdentObj getLineRiser(int s, int g) {
        return new IdentObj(258, s, g);
    }

    public IdentObj getO1Label(int g) {
        return new IdentObj(270, -3, g);
    }

    public IdentObj getPieBarConnectLineBottom() {
        IdentObj id = new IdentObj(301);
        id.setMiscID(400);
        return id;
    }

    public IdentObj getPieBarConnectLineTop() {
        IdentObj id = new IdentObj(301);
        id.setMiscID(300);
        return id;
    }

    public IdentObj getPieBarSlice(int s, int g) {
        IdentObj id = new IdentObj(332, s, g);
        id.setMiscID(1000);
        return id;
    }

    public IdentObj getPieFeelerLine(int s, int g) {
        IdentObj id = new IdentObj(294, s, g);
        id.setMiscID(200);
        return id;
    }

    public IdentObj getPieSliceLabel(int s, int g) {
        return new IdentObj(295, s, g);
    }

    public IdentObj getPieLabel(int g) {
        return new IdentObj(296, -3, g);
    }

    public IdentObj getPieRingLabel(int g) {
        return new IdentObj(297, -3, g);
    }

    public IdentObj getSlice(int s, int g) {
        IdentObj id = new IdentObj(298, s, g);
        id.setMiscID(1000);
        return id;
    }

    public IdentObj getSpectralLegendMarker(int i) {
        IdentObj id = new IdentObj(18);
        id.setMiscID(i);
        return id;
    }

    public IdentObj getStockMALine(int s, int g) {
        return new IdentObj(309, s, g);
    }

    public IdentObj getStockVolumeRiser(int g) {
        return new IdentObj(310, 1, g);
    }

    public IdentObj getStockCloseTick(int s, int g) {
        return new IdentObj(307, s, g);
    }

    public IdentObj getStockOpenTick(int s, int g) {
        return new IdentObj(308, s, g);
    }

    public IdentObj getStockRisingRiser(int s, int g) {
        return new IdentObj(319, s, g);
    }

    public IdentObj getStockFallingRiser(int s, int g) {
        return new IdentObj(320, s, g);
    }

    public IdentObj getLegendScroller() {
        return new IdentObj(65);
    }

    public IdentObj getLegendScrollerThumb() {
        return new IdentObj(66);
    }

    public IdentObj getReferenceLineLegendText() {
        return new IdentObj(248);
    }

    public String getAlertLabel() {
        String m_Obj = (String)this.getFromLook(Attr.AlertLabel, 1);
        return m_Obj;
    }

    public String getAlertLabel(IdentObj id) {
        String m_Obj = (String)this.getFromLook(id, Attr.AlertLabel);
        return m_Obj;
    }

    public String getAlertLabel(int seriesID) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        return this.getAlertLabel(id);
    }

    public void setAlertLabel(String newValue) {
        this.putToLookAndRepaint(Attr.AlertLabel, newValue, 1);
    }

    public void setAlertLabel(IdentObj id, String newValue) {
        this.putToLookAndRepaint(id, Attr.AlertLabel, newValue);
    }

    public void setAlertLabel(int seriesID, String newValue) {
        IdentObj id = new IdentObj(-3, seriesID, -3);
        this.setAlertLabel(id, newValue);
    }

    public void setY3LogScale(boolean newValue) {
        this.setLogScale(this.getY3Axis(), newValue);
    }

    public boolean getY3LogScale() {
        return this.getLogScale(this.getY3Axis());
    }

    public void setY4LogScale(boolean newValue) {
        this.setLogScale(this.getY4Axis(), newValue);
    }

    public boolean getY4LogScale() {
        return this.getLogScale(this.getY4Axis());
    }

    public void setY5LogScale(boolean newValue) {
        this.setLogScale(this.getY5Axis(), newValue);
    }

    public boolean getY5LogScale() {
        return this.getLogScale(this.getY5Axis());
    }

    public boolean getY3AxisDescending() {
        return this.getAxisDescending(this.getY3Axis());
    }

    public void setY3AxisDescending(boolean newValue) {
        this.setAxisDescending(this.getY3Axis(), newValue);
    }

    public boolean getY4AxisDescending() {
        return this.getAxisDescending(this.getY4Axis());
    }

    public void setY4AxisDescending(boolean newValue) {
        this.setAxisDescending(this.getY4Axis(), newValue);
    }

    public boolean getY5AxisDescending() {
        return this.getAxisDescending(this.getY5Axis());
    }

    public void setY5AxisDescending(boolean newValue) {
        this.setAxisDescending(this.getY5Axis(), newValue);
    }

    public Iterator getPropertyIterator() {
        return this.m_look.keySet().iterator();
    }
}

