/*
 * Decompiled with CFR 0.152.
 */
package tdg;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import tdg.Assert;
import tdg.Axis2DObj;
import tdg.AxisTemplate;
import tdg.FrameObj;
import tdg.GroupsEnumerator;
import tdg.JChart_2D_Standard;
import tdg.LegendObj;
import tdg.MarkerObj;
import tdg.MarkerTemplate;
import tdg.MinMaxObj;
import tdg.RelativeAxisObj;
import tdg.SeriesEnumerator;
import tdg.draw.BlackBoxIF;
import tdg.draw.DetRect;
import tdg.draw.IdentObj;

public class JChart_2D_Spec
extends JChart_2D_Standard {
    protected RelativeAxisObj m_O2Axis;

    public void calc() {
        super.calc();
        this.drawSpectralMarkers();
        if (this.m_bDataTextDisplay) {
            this.drawDataValues();
        }
    }

    protected Rectangle calcDataValuePosition(int s, int g, Dimension labelDim) {
        Rectangle rFrame = this.m_Frame.getBackWallBounds();
        int width = labelDim.width;
        int height = labelDim.height;
        double cellWidth = (double)rFrame.width / (double)this.m_nGroups;
        double cellHeight = (double)rFrame.height / (double)this.m_nSeries;
        SeriesEnumerator sEnum = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        int sRel = sEnum.getRelativeSeries(s);
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        int gRel = gEnum.getRelativeGroup(g);
        double cellOffsetX = (double)rFrame.x + (double)gRel * cellWidth;
        double cellOffsetY = (double)(rFrame.y + rFrame.height) - (double)(sRel + 1) * cellHeight;
        int x = (int)(cellOffsetX + (cellWidth - (double)width) / 2.0);
        int y = (int)(cellOffsetY + (cellHeight - (double)height) / 2.0);
        Rectangle rDataValue = new Rectangle(x, y, width, height);
        return rDataValue;
    }

    public void calcLegend() {
        if (this.m_Legend == null) {
            return;
        }
        if (this.m_Legend.isSpectralLegend()) {
            this.m_Legend.setY1Axis(this.m_Y1Axis);
        }
        this.m_Legend.calc();
    }

    protected void createAxes() {
        int orient = 2;
        int scaling = 1;
        boolean bVerticalAxis = false;
        boolean bAscendingOrd = true;
        boolean bAscendingY1 = !this.m_Perspective.getY1AxisDescending();
        boolean bMustIncludeZero = this.m_Perspective.getY1MustIncludeZero() && !this.m_Perspective.getY1LogScale();
        boolean bDrawOnCalc = false;
        int offsetY1 = 0;
        int sizeY1 = 100;
        this.m_O1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.O1_AXIS, 7, bVerticalAxis, bAscendingOrd);
        if (this.m_O1Axis != null) {
            this.m_O1Axis.calc();
        }
        this.m_O2Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.O2_AXIS, 8, !bVerticalAxis, !bAscendingOrd);
        if (this.m_O2Axis != null) {
            this.m_O2Axis.calc();
        }
        MinMaxObj y1MinMaxObj = this.findLimits(0, scaling, bMustIncludeZero, null);
        this.m_Y1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.Y1_AXIS, y1MinMaxObj, bVerticalAxis, bAscendingY1, offsetY1, sizeY1, bDrawOnCalc);
        if (this.m_Y1Axis != null) {
            this.m_Y1Axis.calc();
        }
    }

    public void createFrame() {
        this.m_Frame = new FrameObj(this.m_Perspective, true);
    }

    public void createLegend() {
        this.m_Legend = new LegendObj(this.m_Perspective, this.m_Access, this, true);
    }

    public void drawSpectralMarkers() {
        SeriesEnumerator sEnum = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        Rectangle rFrame = this.m_Frame.getBackWallBounds();
        int nShape = this.m_Perspective.getMarkerShape(this.m_Perspective.getSpectralMarker());
        boolean bDisplayOOR = true;
        if (this.m_nSeries == 0 || this.m_nGroups == 0) {
            return;
        }
        double dx = (double)rFrame.width / (double)this.m_nGroups;
        double dy = (double)rFrame.height / (double)this.m_nSeries;
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            Assert.assert(s >= 0 && s < this.m_nTotalSeries);
            int sRel = sEnum.getRelativeSeries(s);
            Assert.assert(sRel >= 0 && sRel < this.m_nSeries);
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                int g = gEnum.nextGroup();
                Assert.assert(g >= 0 && g < this.m_nTotalGroups);
                int gRel = gEnum.getRelativeGroup(g);
                Assert.assert(gRel >= 0 && gRel < this.m_nGroups);
                if (!this.m_dataOK[s][g]) continue;
                double fValue = this.getQuantizedDataValue(s, g);
                IdentObj id = new IdentObj(330, s, g);
                double fRatio = this.m_Y1Axis.getValueRelCoord(fValue);
                BlackBoxIF blackBox = this.getBlackBox(id, fRatio);
                double x = (double)rFrame.x + (double)gRel * dx;
                double y = (double)(rFrame.y + rFrame.height) - (double)(sRel + 1) * dy;
                if (nShape == 0) {
                    new DetRect(this.m_Detectiv, id, (int)x, (int)y, (int)dx, (int)dy, blackBox, false, true);
                    continue;
                }
                MarkerTemplate markerTemplate = this.m_Perspective.getMarkerTemplate(nShape);
                int centerX = (int)(x + dx / 2.0);
                int centerY = (int)(y + dy / 2.0);
                Point center = new Point(centerX, centerY);
                int nFullMarkerSize = 1800;
                int markerSizeX = (int)(dx * 100.0 / (double)nFullMarkerSize);
                int markerSizeY = (int)(dy * 100.0 / (double)nFullMarkerSize);
                if (this.m_bSquareMarkers) {
                    double destY;
                    double destX = this.m_Perspective.m_VC.virtToDestWidth((double)markerSizeX);
                    if (destX > (destY = this.m_Perspective.m_VC.virtToDestHeight((double)markerSizeY))) {
                        markerSizeX = (int)((double)markerSizeX * destY / destX);
                    } else {
                        markerSizeY = (int)((double)markerSizeY * destX / destY);
                    }
                }
                new MarkerObj(this.m_Detectiv, id, markerTemplate, center, markerSizeX, markerSizeY, blackBox, this.m_rClip, false);
            }
        }
    }

    protected Point getCoords(int s, int g) {
        Rectangle rFrame = this.m_Frame.getBackWallBounds();
        double dx = (double)rFrame.width / (double)this.m_nSeries;
        double dy = (double)rFrame.height / (double)this.m_nGroups;
        double x = (double)rFrame.x + ((double)s + 0.5) * dx;
        double y = (double)rFrame.y + ((double)g + 0.5) * dy;
        Point center = new Point((int)x, (int)y);
        return center;
    }

    protected String processDataTextTemplate(String[] dataItems, String dataTextTemplate) {
        String ResultString = dataTextTemplate;
        return ResultString;
    }

    public void releaseReferences() {
        if (this.m_O2Axis != null) {
            this.m_O2Axis.releaseReferences();
        }
        super.releaseReferences();
    }
}

