/*
 * Decompiled with CFR 0.152.
 */
package tdg;

import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import tdg.Assert;
import tdg.AssertionException;
import tdg.Axis2DObj;
import tdg.AxisTemplate;
import tdg.DataFormat;
import tdg.DataItem;
import tdg.DatumObj;
import tdg.GroupsEnumerator;
import tdg.JChart_2D_Standard;
import tdg.Line;
import tdg.MarkerObj;
import tdg.MarkerTemplate;
import tdg.MarkerTemplateArray;
import tdg.MinMaxObj;
import tdg.ParetoFrameObj;
import tdg.RelativeAxisObj;
import tdg.SeriesEnumerator;
import tdg.TDGNumberFormat;
import tdg.draw.BlackBoxIF;
import tdg.draw.DetLine;
import tdg.draw.DetPolygon;
import tdg.draw.DetRect;
import tdg.draw.IdentObj;

public class JChart_2D_Pareto
extends JChart_2D_Standard {
    public static final double DEPTH_FACTOR = 12.0;
    public static final double UNSHADED = 1.0;
    public static final double SHADING_FRONT = 1.0;
    public static final double SHADING_TOP = 0.8;
    public static final double SHADING_SIDE = 0.6;
    public static final double SHADING_BOTTOM = 0.4;
    public static final boolean DRAW_NEG_SERIES = true;
    public static final boolean DRAW_POS_SERIES = false;
    boolean m_bFromZero;
    boolean m_bBipolar;
    boolean m_bDualY;
    int m_nLineThick;
    Point[] m_seriesBackOffsets;
    Point[] m_seriesFrontOffsets;
    double m_fThreshholdPercent = 0.2;
    int[] m_nThreshold;
    double[] m_fThresholdValue;
    public boolean m_bParetoPlotFromLeft = false;
    public boolean m_bParetoThresholdEnabled = false;
    boolean m_bFirstPassWithDepth;
    public boolean m_bDebugPrint = false;
    int m_nConverge = 250;

    public void calc() {
        boolean bY1first;
        super.calc();
        this.m_bFirstPassWithDepth = true;
        double tValue = this.m_Perspective.getParetoDisplayThreshold();
        if (tValue < 1.0) {
            this.m_bParetoThresholdEnabled = false;
        } else {
            this.m_fThreshholdPercent = tValue / 100.0;
            this.m_bParetoThresholdEnabled = true;
        }
        boolean bl = bY1first = this.m_bHorz && this.m_nDepthAngle > 90;
        if (this.wantDepthEffect()) {
            this.m_seriesBackOffsets = new Point[this.m_nTotalSeries];
            this.m_seriesFrontOffsets = new Point[this.m_nTotalSeries];
            SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
            while (sEnum.hasMoreElements()) {
                int s = sEnum.nextSeries();
                Assert.assert(s >= 0 && s < this.m_nTotalSeries);
                this.m_seriesBackOffsets[s] = this.calcSeriesOffset(s, false);
                this.m_seriesFrontOffsets[s] = this.calcSeriesOffset(s, true);
            }
        }
        this.calcParetoData();
        if (this.m_bParetoThresholdEnabled) {
            this.findThresholdValues();
        }
        this.calcBarOrdinalCoords();
        if (this.m_bParetoThresholdEnabled) {
            this.makeRects();
        }
        this.drawBarRisers();
        this.drawLineRisers();
        if (this.m_bDataTextDisplay) {
            this.drawDataValues();
        }
        this.fireInapropriateDataEvent();
    }

    protected void calcDataAbsolute() {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        double fValue = 0.0;
        int nSeriesPerPixel = this.calcRisersPerPixel();
        boolean bNumberFormatCallBackActive = this.m_Perspective.isNumberFormatCallBack();
        int nDataFormat = this.m_Perspective.getDataTextFormat();
        String szFormatPattern = this.m_Perspective.getDataTextFormatPattern();
        this.m_numYCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_dataOK = new boolean[this.m_nTotalSeries][this.m_nTotalGroups];
        if (this.m_bDataTextDisplay) {
            this.m_DataLabel = new String[this.m_nTotalSeries][this.m_nTotalGroups];
        }
        int s = this.m_Perspective.getDisplayParetoSeries();
        gEnum.reset();
        while (gEnum.hasMoreElements()) {
            int g = gEnum.nextGroup();
            this.m_dataOK[s][g] = true;
            RelativeAxisObj axisObj = this.whichAxisForSeries(s, null);
            if (axisObj == null) continue;
            DatumObj dObj = this.getDataValue(s, g, DataItem.DI_GENERAL);
            fValue = dObj.m_fValue;
            if (!dObj.m_bOK) {
                this.m_dataOK[s][g] = false;
            }
            if (fValue < 0.0) {
                this.m_negativeVal = true;
            }
            if (fValue <= 0.0 && axisObj.isLogScale()) {
                this.m_dataOK[s][g] = false;
                fValue = 0.0;
            }
            if (this.isIgnoredOffScale(axisObj, fValue)) {
                this.m_dataOK[s][g] = false;
                fValue = 0.0;
            }
            if (fValue == 0.0 && dObj.m_bOK) {
                this.m_zeroVal = true;
            }
            if (fValue > 0.0) {
                this.m_positiveVal = true;
            }
            fValue = Math.abs(fValue);
            this.m_numYCoords[s][g] = (int)axisObj.getValueCoord(fValue);
            if (!this.m_bDataTextDisplay) continue;
            if (bNumberFormatCallBackActive) {
                int nAxisID = this.axisAssignedToSeries(s, DataItem.DI_GENERAL);
                this.m_Perspective.getNumberFormatCallBack().setState(3, s, g, nAxisID, -3);
                this.m_DataLabel[s][g] = this.m_Perspective.getNumberFormatCallBack().toString(fValue);
                continue;
            }
            this.m_DataLabel[s][g] = TDGNumberFormat.toString(this.m_Perspective, nDataFormat, fValue, szFormatPattern);
        }
    }

    public Point calcSeriesOffset(int s, boolean bFront) {
        Point pt;
        if (bFront) {
            double fFront = this.calcFrontOffset(this.m_seriesPlanes[s], this.m_nDepthPlanes);
            pt = this.m_Frame.getDepthOffset(fFront);
        } else {
            double fBack = this.calcBackOffset(this.m_seriesPlanes[s], this.m_nDepthPlanes);
            pt = this.m_Frame.getDepthOffset(fBack);
        }
        return pt;
    }

    protected void copyParams() {
        super.copyParams();
        this.m_bFromZero = this.m_gt.isWaterfall() ? false : this.m_Perspective.getScaleFromZero();
        this.m_bBipolar = this.m_gt.isBipolar();
        this.m_bDualY = this.m_gt.isDualY();
        this.m_nLineThick = this.m_Perspective.getDataLineThickness();
    }

    private void drawAxisBarRisersAbsolute(boolean bDrawY1, boolean bDrawY2) {
        boolean bReverseSeries;
        boolean bReverseGroups;
        boolean bRightToLeft;
        boolean bl = bRightToLeft = this.m_nDepthAngle > 90;
        if (this.m_bHorz) {
            bReverseGroups = true;
            bReverseSeries = true;
        } else {
            bReverseGroups = bRightToLeft;
            bReverseSeries = bRightToLeft;
        }
        boolean bForwardSeries = !bReverseSeries;
        boolean bForwardGroups = !bReverseGroups;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator(bForwardSeries);
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, bForwardGroups);
        int sFirst = sEnum.getFirstSeries();
        int sLast = sEnum.getLastSeries();
        int gFirst = gEnum.getFirstGroup();
        while (gEnum.hasMoreElements()) {
            int axisID;
            RelativeAxisObj yAxisObj;
            int s;
            int g = gEnum.nextGroup();
            Assert.assert(g >= 0 && g < this.m_nTotalGroups);
            if (bDrawY1) {
                sEnum.reset();
                s = this.m_Perspective.getDisplayParetoSeries();
                Assert.assert(s >= 0 && s < this.m_nTotalSeries);
                yAxisObj = this.whichAxisForSeries(s, null);
                if (yAxisObj != null) {
                    axisID = yAxisObj.getAxisObjID();
                    if (axisID != 0 && this.m_bBipolar) continue;
                    this.drawOneBarRiser(s, g, sEnum, gEnum);
                }
            }
            if (!bDrawY2 || !this.m_bBipolar) continue;
            sEnum.reset();
            while (sEnum.hasMoreElements()) {
                s = sEnum.nextSeries();
                Assert.assert(s >= 0 && s < this.m_nTotalSeries);
                yAxisObj = this.whichAxisForSeries(s, null);
                if (yAxisObj == null || (axisID = yAxisObj.getAxisObjID()) != 1 && this.m_bBipolar) continue;
                this.drawOneBarRiser(s, g, sEnum, gEnum);
            }
        }
    }

    private void drawAxisLineRisers(int nAxis) {
        boolean bRightToLeft;
        boolean bl = bRightToLeft = this.m_nDepthAngle > 90;
        if (this.m_bParetoThresholdEnabled) {
            bRightToLeft = false;
        }
        boolean bReverseGroups = this.m_bHorz || bRightToLeft;
        boolean bForwardGroups = !bReverseGroups;
        boolean bForwardSeries = true;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator(bForwardSeries);
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, bForwardGroups);
        int s = this.m_Perspective.getDisplayParetoSeries();
        RelativeAxisObj yAxisObj = this.whichAxisForSeries(s, null);
        if (yAxisObj != null) {
            int axisID = yAxisObj.getAxisObjID();
            if (axisID != nAxis && (!this.m_bAbsolute || this.m_bBipolar)) {
                return;
            }
            if (this.m_Perspective.getConnectLineMarkers()) {
                gEnum.reset();
                while (gEnum.hasMoreElements()) {
                    int g = gEnum.nextGroup();
                    Assert.assert(g >= 0 && g < this.m_nTotalGroups);
                    if (!bForwardGroups && g == gEnum.getFirstGroup()) continue;
                    this.drawOneLineRiser(s, g, gEnum);
                }
            }
            if (this.m_nDepthRadius > 0) {
                this.drawMarkersWithDepth(s);
            }
        }
    }

    private void drawBarGroup(int g, boolean bDrawY1, boolean bDrawY2, boolean bReverseSeries, boolean bNegative, GroupsEnumerator gEnum) {
        int axisID = 0;
        boolean bForwardSeries = !bReverseSeries;
        int gFirst = gEnum.getFirstGroup();
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator(bForwardSeries);
        int sFirst = sEnum.getFirstSeries();
        int sLast = sEnum.getLastSeries();
        while (sEnum.hasMoreElements()) {
            boolean bNegValue;
            int s = sEnum.nextSeries();
            s = this.m_Perspective.getDisplayParetoSeries();
            Assert.assert(s >= 0 && s < this.m_nTotalSeries);
            RelativeAxisObj yAxisObj = this.whichAxisForSeries(s, null);
            if (yAxisObj == null) continue;
            int nZeroCoord = (int)yAxisObj.getValueCoord(0.0);
            boolean bDescending = yAxisObj.isDescending();
            boolean bl = bDescending ? this.m_numYCoords[s][g] > nZeroCoord : (bNegValue = this.m_numYCoords[s][g] < nZeroCoord);
            if (bNegValue != bNegative) continue;
            axisID = yAxisObj.getAxisObjID();
            if (!bDrawY1 && axisID == 0 || !bDrawY2 && axisID == 1) continue;
            this.drawOneBarRiser(s, g, sEnum, gEnum);
        }
    }

    private void drawBarRisers() {
        if (this.m_bBipolar) {
            this.drawAxisBarRisersAbsolute(false, true);
            this.drawAxisBarRisersAbsolute(true, false);
        } else if (this.m_bDualY) {
            this.drawAxisBarRisersAbsolute(true, true);
        } else {
            this.drawAxisBarRisersAbsolute(true, false);
        }
    }

    private void drawLineRisers() {
        if (this.wantDepthEffect()) {
            this.drawLinesWithDepth();
        } else {
            if (this.m_Perspective.getConnectLineMarkers()) {
                this.drawLines(false);
            }
            this.drawMarkers();
        }
    }

    protected void drawLinesWithDepth() {
        if (this.m_bBipolar) {
            this.drawAxisLineRisers(1);
            this.drawAxisLineRisers(0);
        } else if (this.m_bDualY) {
            this.drawAxisLineRisers(0);
            this.drawAxisLineRisers(1);
        } else {
            this.drawAxisLineRisers(0);
        }
    }

    private void drawOneBarRiser(int s, int g, SeriesEnumerator sEnum, GroupsEnumerator gEnum) {
        int nValueCoord = this.m_numYCoords[s][g];
        int sFirst = sEnum.getFirstSeries();
        int sLast = sEnum.getLastSeries();
        int gFirst = gEnum.getFirstGroup();
        int gLast = gEnum.getLastGroup();
        if (!this.m_dataOK[s][g]) {
            return;
        }
        Axis2DObj yAxisObj = (Axis2DObj)this.whichAxisForSeries(s, null);
        if (yAxisObj != null) {
            int top;
            int bottom;
            int right;
            int left;
            int nHigh;
            int nLow;
            int nZeroCoord = (int)yAxisObj.getValueCoord(0.0);
            boolean bDescending = yAxisObj.isDescending();
            BlackBoxIF blackBox = this.assignSeriesColor(s, g);
            BlackBoxIF blackBoxNew = this.getMissingDataBlackBox(s, g);
            if (blackBoxNew == null) {
                blackBoxNew = blackBox;
            }
            boolean bNegValue = bDescending ? nValueCoord > nZeroCoord : nValueCoord < nZeroCoord;
            int sPrev = this.prevSeriesForAxis(s, g, yAxisObj, bNegValue);
            boolean bFromZero = this.wantRisersFromZero(yAxisObj);
            int nBaseCoord = this.m_bAbsolute || sPrev == -2 ? (bFromZero ? nZeroCoord : (int)yAxisObj.getBaseCoord()) : this.m_numYCoords[sPrev][g];
            if (bFromZero) {
                nLow = bDescending != bNegValue ? nValueCoord : nBaseCoord;
                nHigh = bDescending != bNegValue ? nBaseCoord : nValueCoord;
            } else {
                nLow = bDescending ? nValueCoord : nBaseCoord;
                int n = nHigh = bDescending ? nBaseCoord : nValueCoord;
            }
            if (this.m_bHorz) {
                left = nLow;
                right = nHigh;
                bottom = this.m_ordCoords[s][g] - this.m_barThickCoord / 2;
                top = bottom + this.m_barThickCoord;
            } else {
                bottom = nLow;
                top = nHigh;
                left = this.m_ordCoords[s][g] - this.m_barThickCoord / 2;
                right = left + this.m_barThickCoord;
            }
            Rectangle rVirt = new Rectangle(left, bottom, right - left, top - bottom);
            if (this.wantDepthEffect() && this.m_Frame != null) {
                this.drawTwoHalfDBarRiser(s, g, rVirt, blackBoxNew);
            } else {
                IdentObj idFront = new IdentObj(277, s, g);
                new DetRect(this.m_Detectiv, idFront, rVirt, blackBoxNew, this.m_rClip);
            }
        }
    }

    private void drawTwoHalfDBarRiser(int s, int g, Rectangle rVirt, BlackBoxIF blackBox) {
        double fIntensity;
        Polygon polyVC;
        Point ptBackOffset = this.m_seriesBackOffsets[s];
        Point ptFrontOffset = this.m_seriesFrontOffsets[s];
        rVirt.x -= ptFrontOffset.x;
        rVirt.y -= ptFrontOffset.y;
        if (this.m_nDepthAngle != 90) {
            int nXFrame = this.m_nDepthAngle > 90 ? rVirt.x : rVirt.x + rVirt.width;
            polyVC = new Polygon();
            polyVC.addPoint(nXFrame, rVirt.y);
            polyVC.addPoint(nXFrame, rVirt.y + rVirt.height);
            polyVC.addPoint(nXFrame + (ptFrontOffset.x - ptBackOffset.x), rVirt.y + rVirt.height + (ptFrontOffset.y - ptBackOffset.y));
            polyVC.addPoint(nXFrame + (ptFrontOffset.x - ptBackOffset.x), rVirt.y + (ptFrontOffset.y - ptBackOffset.y));
            polyVC.addPoint(nXFrame, rVirt.y);
            fIntensity = this.m_bColorAutoshadeRisers ? 0.6 : 1.0;
            IdentObj idSide = new IdentObj(312, s, g);
            new DetPolygon(this.m_Detectiv, idSide, polyVC, blackBox, fIntensity);
        }
        if (this.m_nDepthAngle != 0 && this.m_nDepthAngle != 180) {
            polyVC = new Polygon();
            polyVC.addPoint(rVirt.x, rVirt.y + rVirt.height);
            polyVC.addPoint(rVirt.x + rVirt.width, rVirt.y + rVirt.height);
            polyVC.addPoint(rVirt.x + rVirt.width + (ptFrontOffset.x - ptBackOffset.x), rVirt.y + rVirt.height + (ptFrontOffset.y - ptBackOffset.y));
            polyVC.addPoint(rVirt.x + (ptFrontOffset.x - ptBackOffset.x), rVirt.y + rVirt.height + (ptFrontOffset.y - ptBackOffset.y));
            polyVC.addPoint(rVirt.x, rVirt.y + rVirt.height);
            fIntensity = 0.8;
            IdentObj idSide = new IdentObj(313, s, g);
            new DetPolygon(this.m_Detectiv, idSide, polyVC, blackBox, fIntensity);
        }
        IdentObj idFront = new IdentObj(277, s, g);
        if (this.m_bColorAutoshadeRisers) {
            fIntensity = 1.0;
            polyVC = new Polygon();
            polyVC.addPoint(rVirt.x, rVirt.y);
            polyVC.addPoint(rVirt.x + rVirt.width, rVirt.y);
            polyVC.addPoint(rVirt.x + rVirt.width, rVirt.y + rVirt.height);
            polyVC.addPoint(rVirt.x, rVirt.y + rVirt.height);
            polyVC.addPoint(rVirt.x, rVirt.y);
            new DetPolygon(this.m_Detectiv, idFront, polyVC, blackBox, fIntensity);
        } else {
            new DetRect(this.m_Detectiv, idFront, rVirt, blackBox, null);
        }
    }

    private void drawOneLineRiser(int s, int g, GroupsEnumerator gEnum) {
        BlackBoxIF blackBox = null;
        BlackBoxIF blackBoxThres1 = null;
        BlackBoxIF blackBoxThres2 = null;
        Point p0 = null;
        Point p1 = null;
        double fIntensity = 1.0;
        int nValueCoord = this.m_numYCoords[s][g];
        int gFirst = gEnum.getFirstGroup();
        int gLast = gEnum.getLastGroup();
        int gPrev = gEnum.peekAtGroupBefore(g);
        int gNext = gEnum.peekAtGroupAfter(g);
        int gAfterNext = gEnum.peekAtGroupAfter(gNext);
        int gBeforePrev = gEnum.peekAtGroupBefore(gPrev);
        boolean bRightToLeft = this.m_nDepthAngle > 90;
        boolean bForwardGroups = gFirst <= gLast;
        Assert.assert(gFirst >= 0 && gLast >= 0 && g >= 0 && g < this.m_nTotalGroups);
        if (!this.m_bParetoThresholdEnabled && (bForwardGroups ? gNext == -1 : gPrev == -1)) {
            return;
        }
        if (this.m_nDepthRadius <= 0) {
            throw new AssertionException("Can't draw 2.5D lines without positive DepthRadius");
        }
        if (this.m_Frame == null) {
            throw new AssertionException("Can't draw 2.5D lines without m_Frame");
        }
        Rectangle rFrame = this.m_Frame.getBackWallBounds();
        if (rFrame == null) {
            throw new AssertionException("Can't draw 2.5D lines when m_Frame has no bounding rect");
        }
        double fThickMax = this.m_bHorz ? (double)rFrame.width / 12.0 : (double)rFrame.height / 12.0;
        int nOffset = (int)(fThickMax * (double)this.m_nLineThick / 100.0);
        RelativeAxisObj yAxisObj = this.whichAxisForSeries(s, null);
        if (yAxisObj != null) {
            Polygon polySide;
            boolean bDrawSidePolygon;
            boolean bShowLeftSide;
            Polygon polyTop;
            int y3;
            int x3;
            int y2;
            int x2;
            boolean bDrawUnderside;
            double fAngleDeg;
            double fAngleRad;
            int y1;
            int x1;
            int y0;
            int x0;
            RelativeAxisObj axisObj;
            int dy;
            int dx;
            Point ptFrontOffset;
            boolean bNegValue;
            int nZeroCoord = (int)yAxisObj.getValueCoord(0.0);
            boolean bDescending = yAxisObj.isDescending();
            if (this.m_bParetoThresholdEnabled) {
                blackBoxThres1 = this.assignSeriesColor(new IdentObj(491, s, g));
                blackBoxThres2 = this.assignSeriesColor(new IdentObj(492, s, g));
            } else {
                blackBox = this.assignSeriesColor(new IdentObj(473, s, g));
            }
            BlackBoxIF blackBoxNew = this.getMissingDataBlackBox(s, g);
            if (blackBoxNew == null) {
                blackBoxNew = blackBox;
            }
            BlackBoxIF blackBoxNew1 = null;
            BlackBoxIF blackBoxNew2 = null;
            if (this.m_bParetoThresholdEnabled) {
                blackBoxNew1 = this.getMissingDataBlackBox(s, g);
                blackBoxNew2 = this.getMissingDataBlackBox(s, g);
                if (blackBoxNew1 == null) {
                    blackBoxNew1 = blackBoxThres1;
                }
                if (blackBoxNew2 == null) {
                    blackBoxNew2 = blackBoxThres2;
                }
            }
            boolean bl = bDescending ? nValueCoord > nZeroCoord : (bNegValue = nValueCoord < nZeroCoord);
            if (this.wantDepthEffect()) {
                Point ptBackOffset = this.m_seriesBackOffsets[s];
                ptFrontOffset = this.m_seriesFrontOffsets[s];
                dx = ptFrontOffset.x - ptBackOffset.x;
                dy = ptFrontOffset.y - ptBackOffset.y;
            } else {
                ptFrontOffset = new Point();
                dx = 0;
                dy = 0;
            }
            Polygon polyFront = new Polygon();
            p0 = this.getParetoCoords(s, g);
            if (this.m_bParetoThresholdEnabled && this.m_fThreshholdPercent < 1.0 && this.m_bFirstPassWithDepth && this.m_fParetoYCoords[s][g] > this.m_fThresholdValue[s] && (axisObj = this.whichAxisForSeries(s, null)) != null) {
                p0 = new Point();
                p0.y = (int)axisObj.getValueCoord(this.m_fThresholdValue[s]);
                int x = (int)this.calcThresholdXPos(p0.y, s, g);
                p0.x = x + this.m_barThickCoord / 2 + this.m_nConverge;
                this.m_bFirstPassWithDepth = false;
                x0 = p0.x - ptFrontOffset.x;
                y0 = p0.y - ptFrontOffset.y;
                polyFront.addPoint(x0, y0);
                p1 = bForwardGroups ? this.getParetoCoords(s, g) : this.getParetoCoords(s, g);
                x1 = p1.x - ptFrontOffset.x;
                y1 = p1.y - ptFrontOffset.y;
                polyFront.addPoint(x1, y1);
                fAngleRad = Math.atan2(y1 - y0, x1 - x0);
                fAngleDeg = fAngleRad * 57.29577951308232;
                if (this.m_nDepthAngle <= 90) {
                    bDrawUnderside = this.m_bHorz ? fAngleDeg < (double)(this.m_nDepthAngle - 180) : fAngleDeg > (double)this.m_nDepthAngle;
                } else {
                    boolean bl2 = bDrawUnderside = fAngleDeg + 180.0 < (double)this.m_nDepthAngle;
                }
                if (this.m_bHorz) {
                    x2 = x1 - nOffset;
                    y2 = y1;
                    x3 = x0 - nOffset;
                    y3 = y0;
                } else {
                    x2 = x1;
                    y2 = y1 - nOffset;
                    x3 = x0;
                    y3 = y0 - nOffset;
                }
                polyFront.addPoint(x2, y2);
                polyFront.addPoint(x3, y3);
                polyFront.addPoint(x0, y0);
                if (bDrawUnderside) {
                    polyTop = new Polygon();
                    polyTop.addPoint(x2, y2);
                    polyTop.addPoint(x3, y3);
                    polyTop.addPoint(x3 + dx, y3 + dy);
                    polyTop.addPoint(x2 + dx, y2 + dy);
                    polyTop.addPoint(x2, y2);
                } else {
                    polyTop = new Polygon();
                    polyTop.addPoint(x0, y0);
                    polyTop.addPoint(x1, y1);
                    polyTop.addPoint(x1 + dx, y1 + dy);
                    polyTop.addPoint(x0 + dx, y0 + dy);
                    polyTop.addPoint(x0, y0);
                }
                if (this.m_bColorAutoshadeRisers) {
                    fIntensity = this.m_bHorz ? 0.6 : (bDrawUnderside ? 0.4 : 0.8);
                }
                if (g >= this.m_nThreshold[s]) {
                    new DetPolygon(this.m_Detectiv, new IdentObj(496, s, g), polyTop, blackBoxNew2, fIntensity);
                } else {
                    new DetPolygon(this.m_Detectiv, new IdentObj(495, s, g), polyTop, blackBoxNew1, fIntensity);
                }
                if (this.m_bColorAutoshadeRisers) {
                    fIntensity = 1.0;
                }
                if (g >= this.m_nThreshold[s]) {
                    new DetPolygon(this.m_Detectiv, new IdentObj(492, s, g), polyFront, blackBoxNew2, fIntensity);
                } else {
                    new DetPolygon(this.m_Detectiv, new IdentObj(491, s, g), polyFront, blackBoxNew1, fIntensity);
                }
                boolean bl3 = bShowLeftSide = bRightToLeft || this.m_bHorz;
                if (bForwardGroups) {
                    bDrawSidePolygon = bShowLeftSide ? g == gFirst || gPrev != -1 && !this.m_dataOK[s][gPrev] : gNext == gLast || gAfterNext != -1 && !this.m_dataOK[s][gAfterNext];
                } else if (bShowLeftSide) {
                    bDrawSidePolygon = g == gLast || gNext != -1 && !this.m_dataOK[s][gNext];
                } else {
                    boolean bl4 = bDrawSidePolygon = gPrev == gFirst || gBeforePrev != -1 && !this.m_dataOK[s][gBeforePrev];
                }
                if (bDrawSidePolygon) {
                    polySide = new Polygon();
                    if (bShowLeftSide) {
                        polySide.addPoint(x0, y0);
                        polySide.addPoint(x3, y3);
                        polySide.addPoint(x3 + dx, y3 + dy);
                        polySide.addPoint(x0 + dx, y0 + dy);
                        polySide.addPoint(x0, y0);
                    } else {
                        polySide.addPoint(x1, y1);
                        polySide.addPoint(x2, y2);
                        polySide.addPoint(x2 + dx, y2 + dy);
                        polySide.addPoint(x1 + dx, y1 + dy);
                        polySide.addPoint(x1, y1);
                    }
                    if (this.m_bColorAutoshadeRisers) {
                        double d = fIntensity = this.m_bHorz ? 0.8 : 0.6;
                    }
                    if (g >= this.m_nThreshold[s]) {
                        new DetPolygon(this.m_Detectiv, new IdentObj(498, s, g), polySide, blackBoxNew2, fIntensity);
                    } else {
                        new DetPolygon(this.m_Detectiv, new IdentObj(497, s, g), polySide, blackBoxNew1, fIntensity);
                    }
                }
            }
            if (bForwardGroups ? gNext == -1 : gPrev == -1) {
                return;
            }
            p0 = this.getParetoCoords(s, g);
            x0 = p0.x - ptFrontOffset.x;
            y0 = p0.y - ptFrontOffset.y;
            polyFront.addPoint(x0, y0);
            p1 = bForwardGroups ? this.getParetoCoords(s, gNext) : this.getParetoCoords(s, gPrev);
            x1 = p1.x - ptFrontOffset.x;
            y1 = p1.y - ptFrontOffset.y;
            polyFront.addPoint(x1, y1);
            fAngleRad = Math.atan2(y1 - y0, x1 - x0);
            fAngleDeg = fAngleRad * 57.29577951308232;
            if (this.m_nDepthAngle <= 90) {
                bDrawUnderside = this.m_bHorz ? fAngleDeg < (double)(this.m_nDepthAngle - 180) : fAngleDeg > (double)this.m_nDepthAngle;
            } else {
                boolean bl5 = bDrawUnderside = fAngleDeg + 180.0 < (double)this.m_nDepthAngle;
            }
            if (this.m_bHorz) {
                x2 = x1 - nOffset;
                y2 = y1;
                x3 = x0 - nOffset;
                y3 = y0;
            } else {
                x2 = x1;
                y2 = y1 - nOffset;
                x3 = x0;
                y3 = y0 - nOffset;
            }
            polyFront.addPoint(x2, y2);
            polyFront.addPoint(x3, y3);
            polyFront.addPoint(x0, y0);
            if (bDrawUnderside) {
                polyTop = new Polygon();
                polyTop.addPoint(x2, y2);
                polyTop.addPoint(x3, y3);
                polyTop.addPoint(x3 + dx, y3 + dy);
                polyTop.addPoint(x2 + dx, y2 + dy);
                polyTop.addPoint(x2, y2);
            } else {
                polyTop = new Polygon();
                polyTop.addPoint(x0, y0);
                polyTop.addPoint(x1, y1);
                polyTop.addPoint(x1 + dx, y1 + dy);
                polyTop.addPoint(x0 + dx, y0 + dy);
                polyTop.addPoint(x0, y0);
            }
            if (this.m_bColorAutoshadeRisers) {
                fIntensity = this.m_bHorz ? 0.6 : (bDrawUnderside ? 0.4 : 0.8);
            }
            if (this.m_bParetoThresholdEnabled) {
                if (g >= this.m_nThreshold[s]) {
                    new DetPolygon(this.m_Detectiv, new IdentObj(496, s, g), polyTop, blackBoxNew2, fIntensity);
                } else {
                    new DetPolygon(this.m_Detectiv, new IdentObj(495, s, g), polyTop, blackBoxNew1, fIntensity);
                }
            } else {
                new DetPolygon(this.m_Detectiv, new IdentObj(475, s, g), polyTop, blackBoxNew, fIntensity);
            }
            if (this.m_bColorAutoshadeRisers) {
                fIntensity = 1.0;
            }
            if (this.m_bParetoThresholdEnabled) {
                if (g >= this.m_nThreshold[s]) {
                    new DetPolygon(this.m_Detectiv, new IdentObj(492, s, g), polyFront, blackBoxNew2, fIntensity);
                } else {
                    new DetPolygon(this.m_Detectiv, new IdentObj(491, s, g), polyFront, blackBoxNew1, fIntensity);
                }
            } else {
                new DetPolygon(this.m_Detectiv, new IdentObj(473, s, g), polyFront, blackBoxNew, fIntensity);
            }
            boolean bl6 = bShowLeftSide = bRightToLeft || this.m_bHorz;
            if (bForwardGroups) {
                bDrawSidePolygon = bShowLeftSide ? g == gFirst || gPrev != -1 && !this.m_dataOK[s][gPrev] : gNext == gLast || gAfterNext != -1 && !this.m_dataOK[s][gAfterNext];
            } else if (bShowLeftSide) {
                bDrawSidePolygon = g == gLast || gNext != -1 && !this.m_dataOK[s][gNext];
            } else {
                boolean bl7 = bDrawSidePolygon = gPrev == gFirst || gBeforePrev != -1 && !this.m_dataOK[s][gBeforePrev];
            }
            if (bDrawSidePolygon) {
                polySide = new Polygon();
                if (bShowLeftSide) {
                    polySide.addPoint(x0, y0);
                    polySide.addPoint(x3, y3);
                    polySide.addPoint(x3 + dx, y3 + dy);
                    polySide.addPoint(x0 + dx, y0 + dy);
                    polySide.addPoint(x0, y0);
                } else {
                    polySide.addPoint(x1, y1);
                    polySide.addPoint(x2, y2);
                    polySide.addPoint(x2 + dx, y2 + dy);
                    polySide.addPoint(x1 + dx, y1 + dy);
                    polySide.addPoint(x1, y1);
                }
                if (this.m_bColorAutoshadeRisers) {
                    double d = fIntensity = this.m_bHorz ? 0.8 : 0.6;
                }
                if (this.m_bParetoThresholdEnabled) {
                    if (g >= this.m_nThreshold[s]) {
                        new DetPolygon(this.m_Detectiv, new IdentObj(498, s, g), polySide, blackBoxNew2, fIntensity);
                    } else {
                        new DetPolygon(this.m_Detectiv, new IdentObj(497, s, g), polySide, blackBoxNew1, fIntensity);
                    }
                } else {
                    new DetPolygon(this.m_Detectiv, new IdentObj(476, s, g), polySide, blackBoxNew, fIntensity);
                }
            }
        }
    }

    protected Point getCoords(int s, int g) {
        int nCenterOrd = this.m_ordCoords[s][g] + this.m_barThickCoord / 2;
        Point center = this.m_bHorz ? new Point(this.m_numYCoords[s][g], nCenterOrd) : new Point(this.m_nParetoCoordsVC[s][g], this.m_numYCoords[s][g]);
        return center;
    }

    protected Point getVCPositionsXY(int s, double x, double y) throws AssertionException {
        SeriesEnumerator sEnum = this.m_sEnumForward;
        int sFirst = sEnum.getFirstSeries();
        Axis2DObj xAxis = (Axis2DObj)this.m_O1Axis;
        Axis2DObj yAxis = (Axis2DObj)this.whichAxisForSeries(s, null);
        int xCoordLow = (int)xAxis.getLowCoord((double)(s - sFirst), x);
        int xCoord = xCoordLow + this.m_barThickCoord / 2;
        int yCoord = (int)yAxis.getValueCoord(y);
        if (this.wantDepthEffect()) {
            Point frontOffset = this.m_seriesFrontOffsets[s];
            xCoord -= frontOffset.x;
            yCoord -= frontOffset.y;
        }
        if (this.m_bHorz) {
            return new Point(yCoord, xCoord);
        }
        return new Point(xCoord, yCoord);
    }

    public boolean isBottomStackedArea(int s) {
        return this.isVisibleStackedArea(s, false);
    }

    public boolean isTopStackedArea(int s) {
        return this.isVisibleStackedArea(s, true);
    }

    public boolean isVisibleStackedArea(int sCurrent, boolean bTopFace) {
        int axisCurrent = this.getAxisAssignment(sCurrent);
        boolean bForward = !bTopFace;
        boolean bIsTop = true;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator(bForward);
        while (bIsTop && sEnum.hasMoreElements()) {
            boolean bDone;
            int s = sEnum.nextSeries();
            boolean bl = bForward ? s >= sCurrent : (bDone = s <= sCurrent);
            if (bDone) break;
            if (this.m_seriesTypes[s] != 3 || this.getAxisAssignment(s) != axisCurrent) continue;
            bIsTop = false;
        }
        return bIsTop;
    }

    protected String processDataTextTemplate(String[] dataItems, String dataTextTemplate) {
        String ResultString = dataTextTemplate;
        return ResultString;
    }

    protected boolean wantDepthEffect() {
        return this.m_nDepthRadius > 0 && this.m_gt.wantDepthEffect();
    }

    protected boolean wantRisersFromZero(RelativeAxisObj yAxisObj) {
        boolean bFromZero = this.m_bFromZero;
        if (!bFromZero) {
            bFromZero = yAxisObj.hasNegData() && !this.m_bAbsolute && !yAxisObj.isLogScale();
        }
        return bFromZero;
    }

    protected Point getParetoCoords(int s, int g) {
        Point center = new Point(this.m_nParetoCoordsVC[s][g], this.m_nParetoYCoordsVC[s][g]);
        return center;
    }

    protected MinMaxObj findLimits(int axis, int scaling, boolean bMustIncludeZero, MinMaxObj mmZoom) {
        double fEndOfPreviousStack = 0.0;
        double fAccum = 0.0;
        MinMaxObj minMaxObj = new MinMaxObj(bMustIncludeZero);
        DataFormat df = this.m_Access.getDataFormat();
        int nItems = df.getNumDataItems();
        int[] axisAssignments = new int[this.m_nTotalSeries];
        int s = 0;
        while (s < this.m_nTotalSeries) {
            axisAssignments[s] = this.getAxisAssignment(s);
            ++s;
        }
        this.setNonDataLimits(minMaxObj);
        if (scaling == 1) {
            s = 0;
            while (s < this.m_nTotalSeries) {
                if (axis != 0 && axis != 1 && axis != 2 && axis != 3 && axis != 4 || axisAssignments[s] == axis) {
                    fAccum = 0.0;
                    int g = 0;
                    while (g < this.m_nTotalGroups) {
                        int i = 0;
                        while (i < nItems) {
                            DataItem item = df.getDataItem(i);
                            if (!item.ignoreInScaling() && AxisTemplate.isSameType(item.getAssocAxis(), axis)) {
                                DatumObj dObj = this.getDataValue(s, g, item);
                                double fValue = dObj.m_fValue;
                                fAccum += fValue;
                                if (!(!dObj.m_bOK || fValue <= 0.0 && this.isBadValueInLogscale(axis, fValue) || mmZoom != null && (fValue < mmZoom.getAdjMin() || fValue > mmZoom.getAdjMax()))) {
                                    minMaxObj.testRawValue(fAccum);
                                }
                            }
                            ++i;
                        }
                        ++g;
                    }
                }
                ++s;
            }
        } else {
            throw new AssertionException(1, 5, scaling);
        }
        return minMaxObj;
    }

    protected void createY1Axis(boolean bVerticalAxis, boolean bAscending, int nOffset, int nSize) {
        MinMaxObj y1MinMaxZoom;
        boolean bMustIncludeZero = this.m_Perspective.getY1MustIncludeZero() && !this.m_Perspective.getY1LogScale();
        MinMaxObj y1MinMaxObj = this.findLimits(0, this.m_scaling, bMustIncludeZero, null);
        this.m_Y1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.Y1_AXIS, y1MinMaxObj, bVerticalAxis, bAscending, nOffset, nSize);
        this.calcParetoMax(this.m_Y1Axis, AxisTemplate.Y1_AXIS);
        if (this.isZoomingArmed() && (y1MinMaxZoom = this.createMinMaxZoom(this.m_Y1Axis)) != null) {
            this.m_Y1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.Y1_AXIS, y1MinMaxZoom, bVerticalAxis, bAscending, nOffset, nSize);
        }
    }

    protected void calcBarOrdinalCoords() {
        SeriesEnumerator sEnum = this.m_sEnumForward;
        GroupsEnumerator gEnum = this.m_gEnumForward;
        this.m_ordCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_barThickCoord = this.m_Perspective.getConnectParetoBars() ? (int)(this.m_O1Axis.getHighCoord(0, 1) - this.m_O1Axis.getHighCoord(0, 0)) : (int)(this.m_O1Axis.getHighCoord(0, 0) - this.m_O1Axis.getLowCoord(0, 0));
        int sRel = 0;
        while (sRel < this.m_nSeries) {
            int s = sEnum.seriesAt(sRel);
            Assert.assert(s >= 0 && s < this.m_nTotalSeries);
            int axis = this.getAxisAssignment(s);
            int axisOffset = 0;
            if (this.m_gt.isDualY() && this.m_bStacked && axis == 1) {
                axisOffset = 1;
            }
            int gRel = 0;
            while (gRel < this.m_nGroups) {
                int g = gEnum.groupAt(gRel);
                Assert.assert(g >= 0 && g < this.m_nTotalGroups);
                this.m_ordCoords[s][g] = this.m_bAbsolute ? (int)this.m_O1Axis.getLowCoord(sRel, gRel) : (int)this.m_O1Axis.getLowCoord(axisOffset, gRel);
                ++gRel;
            }
            ++sRel;
        }
    }

    protected void createY2Axis(boolean bVerticalAxis, boolean bAscending, int nOffset, int nSize) {
        MinMaxObj y2MinMaxZoom;
        boolean bMustIncludeZero = this.m_Perspective.getY2MustIncludeZero() && !this.m_Perspective.getY2LogScale();
        MinMaxObj y2MinMaxObj = this.findLimits(1, this.m_scaling, bMustIncludeZero, null);
        if (this.m_nDepthRadius > 0 && this.m_nDepthAngle > 90 && !bVerticalAxis) {
            bAscending = !bAscending;
        }
        this.m_Y2Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.Y2_AXIS, y2MinMaxObj, bVerticalAxis, bAscending, nOffset, nSize);
        this.calcParetoMax(this.m_Y2Axis, AxisTemplate.Y2_AXIS);
        if (this.isZoomingArmed() && (y2MinMaxZoom = this.createMinMaxZoom(this.m_Y2Axis)) != null) {
            this.m_Y2Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.Y2_AXIS, y2MinMaxZoom, bVerticalAxis, bAscending, nOffset, nSize);
        }
    }

    protected void drawMarkers() {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        if (!this.m_bMarkerDisplay) {
            return;
        }
        int s = this.m_Perspective.getDisplayParetoSeries();
        Assert.assert(s >= 0 && s < this.m_nTotalSeries);
        IdentObj idSeries = new IdentObj(this.m_Perspective.getParetoLineMarker().getObjectID(), s);
        int nMarkerSeriesID = s % this.m_nSeriesLooping;
        IdentObj idMarkerSeries = new IdentObj(this.m_Perspective.getParetoLineMarker().getObjectID(), nMarkerSeriesID);
        MarkerTemplate markerTemplate = this.getMarkerShape(idMarkerSeries);
        gEnum.reset();
        while (gEnum.hasMoreElements()) {
            int markerSizeY;
            int g = gEnum.nextGroup();
            Assert.assert(g >= 0 && g < this.m_nTotalGroups);
            if (!this.m_dataOK[s][g]) continue;
            Point center = this.getParetoCoords(s, g);
            int markerSizeX = markerSizeY = this.getMarkerSize(s, g);
            if (this.m_bSquareMarkers) {
                double destY;
                double destX = this.m_Perspective.m_VC.virtToDestWidth((double)markerSizeX);
                if (destX > (destY = this.m_Perspective.m_VC.virtToDestHeight((double)markerSizeY))) {
                    markerSizeX = (int)((double)markerSizeX * destY / destX);
                } else {
                    markerSizeY = (int)((double)markerSizeY * destX / destY);
                }
            }
            BlackBoxIF blackBox = this.assignSeriesColor(new IdentObj(474, s, g));
            new MarkerObj(this.m_Detectiv, new IdentObj(474, s, g), markerTemplate, center, markerSizeX, markerSizeY, blackBox, null, true);
        }
    }

    protected void drawLines(boolean bCircular) {
        int nStyle;
        int nWidth;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        int gNext = 0;
        int g = 0;
        Point pt1 = null;
        Point pt2 = null;
        BlackBoxIF blackBox = null;
        BlackBoxIF blackBox2 = null;
        boolean bCloseCircularLines = false;
        boolean bFirst = true;
        pt1 = new Point();
        pt2 = new Point();
        int s = this.m_Perspective.getDisplayParetoSeries();
        Assert.assert(s >= 0 && s < this.m_nTotalSeries);
        IdentObj idSeries = new IdentObj(this.m_Perspective.getParetoLineRiser().getObjectID(), s);
        gEnum.reset();
        if (gEnum.hasMoreElements()) {
            bCloseCircularLines = true;
        }
        while (gEnum.hasMoreElements()) {
            RelativeAxisObj axisObj;
            g = gEnum.nextGroup();
            Assert.assert(g >= 0 && g < this.m_nTotalGroups);
            pt1 = this.getParetoCoords(s, g);
            pt2 = this.getParetoCoords(s, gNext);
            if (!this.m_dataOK[s][g] || !this.m_dataOK[s][gNext]) continue;
            if (this.m_bParetoThresholdEnabled) {
                blackBox2 = this.m_fParetoYCoords[s][g] > this.m_fThresholdValue[s] ? this.assignSeriesColor(new IdentObj(492, s, g)) : this.assignSeriesColor(new IdentObj(491, s, g));
            } else {
                blackBox = this.assignSeriesColor(new IdentObj(473, s, g));
            }
            if (this.m_bParetoThresholdEnabled) {
                blackBox2.setBorderColor(blackBox2.getFillColor());
            } else {
                blackBox.setBorderColor(blackBox.getFillColor());
            }
            if (this.m_bParetoThresholdEnabled && this.m_fThreshholdPercent < 1.0 && bFirst && this.m_fParetoYCoords[s][g] > this.m_fThresholdValue[s] && (axisObj = this.whichAxisForSeries(s, null)) != null) {
                pt1.y = (int)axisObj.getValueCoord(this.m_fThresholdValue[s]);
                int x = (int)this.calcThresholdXPos(pt1.y, s, g);
                pt1.x = x + this.m_barThickCoord / 2 + this.m_nConverge;
                bFirst = false;
                nWidth = this.m_Perspective.getLineWidth(idSeries);
                nStyle = this.m_Perspective.getLineStyle(idSeries);
                new DetLine(this.m_Detectiv, new IdentObj(492, s, g), pt1.x, pt1.y, pt2.x, pt2.y, blackBox2, null, nWidth, nStyle);
            }
            if (!gEnum.hasMoreElements()) continue;
            gNext = gEnum.peekAtNextGroup();
            Assert.assert(gNext >= 0 && gNext < this.m_nTotalGroups);
            pt1 = this.getParetoCoords(s, g);
            pt2 = this.getParetoCoords(s, gNext);
            nWidth = this.m_Perspective.getLineWidth(idSeries);
            nStyle = this.m_Perspective.getLineStyle(idSeries);
            boolean bDrawNormal = true;
            if (this.m_nFillMissingData != 0) {
                boolean bFilledMissingData = this.m_Access.m_DataStorage.isMissingDataFilledIn(s, g);
                int nNumSegments = this.m_Perspective.getNumMissingDataSegments();
                if (bFilledMissingData && nNumSegments != 0) {
                    this.drawMissingLineData(nNumSegments, pt1, pt2, s, g, blackBox, nWidth, nStyle);
                    bDrawNormal = false;
                }
            }
            if (!bDrawNormal) continue;
            if (this.m_bParetoThresholdEnabled) {
                if (this.m_fParetoYCoords[s][g] > this.m_fThresholdValue[s]) {
                    new DetLine(this.m_Detectiv, new IdentObj(492, s, g), pt1.x, pt1.y, pt2.x, pt2.y, blackBox2, null, nWidth, nStyle);
                    continue;
                }
                new DetLine(this.m_Detectiv, new IdentObj(491, s, g), pt1.x, pt1.y, pt2.x, pt2.y, blackBox2, null, nWidth, nStyle);
                continue;
            }
            new DetLine(this.m_Detectiv, new IdentObj(473, s, g), pt1.x, pt1.y, pt2.x, pt2.y, blackBox, null, nWidth, nStyle);
        }
        if (bCircular && this.m_dataOK[s][0] && this.m_dataOK[s][g] && bCloseCircularLines) {
            pt1 = this.getParetoCoords(s, g);
            pt2 = this.getParetoCoords(s, 0);
            blackBox = this.assignSeriesColor(new IdentObj(473, s, g));
            blackBox.setBorderColor(blackBox.getFillColor());
            nWidth = this.m_Perspective.getLineWidth(idSeries);
            nStyle = this.m_Perspective.getLineStyle(idSeries);
            new DetLine(this.m_Detectiv, new IdentObj(473, s, g), pt1.x, pt1.y, pt2.x, pt2.y, blackBox, null, nWidth, nStyle);
        }
    }

    private void drawMissingLineData(int nNumMissingSegments, Point ptIn1, Point ptIn2, int nSeries, int nGroup, BlackBoxIF blackBox, int nLineWidth, int nLineStyle) {
        Line theLine = new Line(ptIn1, ptIn2);
        int nDenominator = nNumMissingSegments * 2 + 1;
        int nIdx = 1;
        while (nIdx < nDenominator) {
            Point ptOne = theLine.fractionalPoint(nIdx, nDenominator);
            Point ptTwo = theLine.fractionalPoint(nIdx + 1, nDenominator);
            IdentObj idObj = new IdentObj(258, nSeries, nGroup);
            new DetLine(this.m_Detectiv, idObj, ptOne.x, ptOne.y, ptTwo.x, ptTwo.y, blackBox, null, nLineWidth, nLineStyle);
            ++nIdx;
            ++nIdx;
        }
    }

    protected void drawMarkersWithDepth(int s) {
        int nYDepth;
        int nXDepth;
        Point ptBackOffset;
        Point ptFrontOffset;
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        Point ptFront = new Point();
        if (!this.m_bMarkerDisplay) {
            return;
        }
        if (this.m_nDepthRadius <= 0) {
            throw new AssertionException("Can't draw 2.5D markers without positive DepthRadius");
        }
        if (this.m_Frame == null) {
            throw new AssertionException("Can't draw 2.5D markers without m_Frame");
        }
        Assert.assert(s >= 0 && s < this.m_nTotalSeries);
        int nMarkerSeriesID = s % this.m_nSeriesLooping;
        IdentObj idMarkerSeries = new IdentObj(this.m_Perspective.getParetoLineMarker().getObjectID(), nMarkerSeriesID);
        MarkerTemplate markerTemplate = this.getMarkerShape(idMarkerSeries);
        if (markerTemplate.m_markerType == 2) {
            markerTemplate = MarkerTemplateArray.PRESET_DEPTHCIRCLE;
        }
        if (this.m_nDepthRadius > 0 && this.m_nDepthPlanes > 0) {
            double fFrontOffset = this.calcFrontOffset(this.m_seriesPlanes[s], this.m_nDepthPlanes);
            ptFrontOffset = this.m_Frame.getDepthOffset(fFrontOffset);
            double fBackOffset = this.calcBackOffset(this.m_seriesPlanes[s], this.m_nDepthPlanes);
            ptBackOffset = this.m_Frame.getDepthOffset(fBackOffset);
            nXDepth = ptFrontOffset.x - ptBackOffset.x;
            nYDepth = ptFrontOffset.y - ptBackOffset.y;
            nXDepth = 3 * nXDepth;
            nYDepth = 3 * nYDepth;
        } else {
            ptFrontOffset = new Point();
            ptBackOffset = new Point();
            nXDepth = 0;
            nYDepth = 0;
        }
        gEnum.reset();
        while (gEnum.hasMoreElements()) {
            int markerSizeY;
            int g = gEnum.nextGroup();
            Assert.assert(g >= 0 && g < this.m_nTotalGroups);
            if (!this.m_dataOK[s][g]) continue;
            Point ptCenter = this.getParetoCoords(s, g);
            ptFront.x = ptCenter.x - ptFrontOffset.x;
            ptFront.y = ptCenter.y - ptFrontOffset.y;
            int markerSizeX = markerSizeY = this.getMarkerSize(s, g);
            if (this.m_bSquareMarkers) {
                double destY;
                double destX = this.m_Perspective.m_VC.virtToDestWidth((double)markerSizeX);
                if (destX > (destY = this.m_Perspective.m_VC.virtToDestHeight((double)markerSizeY))) {
                    markerSizeX = (int)((double)markerSizeX * destY / destX);
                } else {
                    markerSizeY = (int)((double)markerSizeY * destX / destY);
                }
            }
            BlackBoxIF blackBox = this.assignSeriesColor(new IdentObj(474, s, g));
            IdentObj identObjLineMarker = new IdentObj(474, s, g);
            identObjLineMarker.setMiscID(0);
            new MarkerObj(this.m_Detectiv, identObjLineMarker, markerTemplate, ptFront, markerSizeX, markerSizeY, blackBox, null, true, true, nXDepth, nYDepth, this.m_nDepthAngle);
        }
    }

    protected void calcParetoMax(RelativeAxisObj axisObj, AxisTemplate id) {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        double fAccum = 0.0;
        double fValue = 0.0;
        double fMin = Double.MAX_VALUE;
        this.m_fMaxParetoActuals = new double[this.m_nTotalSeries];
        this.m_fMinParetoActuals = new double[this.m_nTotalSeries];
        this.m_nThreshold = new int[this.m_nTotalSeries];
        this.m_fThresholdValue = new double[this.m_nTotalSeries];
        sEnum.reset();
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            Assert.assert(s >= 0 && s < this.m_nTotalSeries);
            this.m_fMaxParetoActuals[s] = 0.0;
            fAccum = 0.0;
            fMin = Double.MAX_VALUE;
            this.m_fMinParetoActuals[s] = Double.MAX_VALUE;
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                int g = gEnum.nextGroup();
                Assert.assert(g >= 0 && g < this.m_nTotalGroups);
                DatumObj dObj = this.getDataValue(s, g, DataItem.DI_GENERAL);
                fValue = dObj.m_fValue;
                this.m_fMaxParetoActuals[s] = fAccum += Math.abs(fValue);
                if (!(Math.abs(fValue) < fMin)) continue;
                this.m_fMinParetoActuals[s] = fMin = Math.abs(fValue);
            }
            axisObj.setParetoSeriesMaximum(s, this.m_fMaxParetoActuals[s]);
            axisObj.setParetoSeriesMinimum(s, this.m_fMinParetoActuals[s]);
        }
    }

    protected void findThresholdValues() {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        double fThresh = this.m_fThreshholdPercent;
        sEnum.reset();
        block0: while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            double dTargetValue = this.m_fParetoYCoords[s][0] + (this.m_fParetoYCoords[s][this.m_nTotalGroups - 1] - this.m_fParetoYCoords[s][0]) * fThresh;
            double fAccum = 0.0;
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                int g = gEnum.nextGroup();
                DatumObj dObj = this.getDataValue(s, g, DataItem.DI_GENERAL);
                double fValue = dObj.m_fValue;
                if (!((fAccum += Math.abs(fValue)) > dTargetValue)) continue;
                this.m_nThreshold[s] = g;
                this.m_fThresholdValue[s] = dTargetValue;
                if (!this.m_bDebugPrint) continue block0;
                System.out.println(" value " + dTargetValue + " for series " + s + "  " + this.m_nParetoCoordsVC[s][g - 1]);
                continue block0;
            }
        }
    }

    protected void makeRects() {
        RelativeAxisObj axisObj;
        Rectangle rFrame = this.m_Perspective.getRect(this.m_Perspective.getFrame());
        Rectangle rParetoFrame1 = new Rectangle(rFrame);
        Rectangle rParetoFrame2 = new Rectangle(rFrame);
        int nSection = rFrame.width / this.m_nGroups;
        int nSeries = this.m_Perspective.getDisplayParetoSeries();
        int nGroup = this.m_nThreshold[nSeries];
        if (this.m_bDebugPrint) {
            System.out.println(" value " + this.m_nParetoYCoordsVC[nSeries][0] + " for series " + nSeries + "  " + this.m_fThresholdValue[nSeries] + " " + this.m_nParetoYCoordsVC[nSeries][1] + " group " + nGroup);
        }
        if ((axisObj = this.whichAxisForSeries(nSeries, null)) != null) {
            int y = (int)axisObj.getValueCoord(this.m_fMaxParetoActuals[nSeries] * this.m_fThreshholdPercent);
            if (this.m_fThreshholdPercent < 1.0) {
                double x = this.calcThresholdXPos(y, nSeries, nGroup);
                rParetoFrame2.x = (int)x + this.m_barThickCoord / 2 + this.m_nConverge;
                rParetoFrame2.y = rFrame.y;
                rParetoFrame2.height = rFrame.height;
                int offset = Math.abs(rFrame.x) + rParetoFrame2.x;
                rParetoFrame2.width = rFrame.width - offset;
                this.m_Perspective.setRect(this.m_Perspective.getParetoChartFrame2(), rParetoFrame2);
                rParetoFrame1.x = rFrame.x;
                rParetoFrame1.y = rFrame.y;
                rParetoFrame1.height = rFrame.height;
                rParetoFrame1.width = rFrame.width - rParetoFrame2.width;
                this.m_Perspective.setRect(this.m_Perspective.getParetoChartFrame1(), rParetoFrame1);
                ((ParetoFrameObj)this.m_Frame).drawFrameSections();
                ((ParetoFrameObj)this.m_Frame).drawMajorGrids(this.m_O1Axis, AxisTemplate.X1_AXIS);
                ((ParetoFrameObj)this.m_Frame).drawMajorGrids(this.m_Y1Axis, AxisTemplate.Y1_AXIS);
            }
        }
    }

    public boolean wantLegend() {
        return false;
    }

    public void createFrame() {
        this.m_Frame = new ParetoFrameObj(this.m_Perspective);
    }

    private double calcThresholdXPos(int y, int nSeries, int nGroup) {
        Rectangle rFrame = this.m_Perspective.getRect(this.m_Perspective.getFrame());
        int nSection = rFrame.width / this.m_nGroups;
        int nThick = this.m_barThickCoord / 2;
        int endGroup = nGroup > 0 ? nGroup - 1 : nGroup + 1;
        double dx2 = endGroup;
        double dx1 = nGroup;
        double dy1 = this.m_fParetoYCoords[nSeries][nGroup];
        double dy2 = this.m_fParetoYCoords[nSeries][endGroup];
        double a1 = (dy1 - dy2) / (dx1 - dx2);
        double a0 = dy1 - dx1 * a1;
        double x11 = (this.m_fThresholdValue[nSeries] - a0) / a1;
        double xVD = (double)rFrame.x + (double)nSection * x11;
        if (this.m_bDebugPrint) {
            System.out.println(" Group No  " + x11);
        }
        if (this.m_bDebugPrint) {
            System.out.println("xVD = " + xVD);
        }
        if (this.m_bParetoPlotFromLeft) {
            nThick = this.m_barThickCoord;
        }
        return xVD + (double)nThick;
    }
}

