/*
 * Decompiled with CFR 0.152.
 */
package tdg;

import java.awt.Polygon;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Vector;
import tdg.Perspective;
import tdg.TDGImageMap;
import tdg.TDGPolyCoordsHRef;
import tdg.draw.DetObj;

public class ImageMap
implements Serializable {
    private Vector m_vDetList = null;
    private Perspective m_Perspective = null;

    public ImageMap(Perspective perspective, Vector vDetList) {
        this.m_Perspective = perspective;
        this.m_vDetList = vDetList;
    }

    public void sendToStream(PrintWriter outWriter, String mapName, String pathName, boolean bPage) {
        if (bPage) {
            outWriter.println("<HTML><BODY>");
        }
        outWriter.println("<MAP NAME=" + mapName + ">");
        int i = this.m_vDetList.size() - 1;
        while (i >= 0) {
            try {
                DetObj detObj = (DetObj)this.m_vDetList.elementAt(i);
                String strDetURL = this.m_Perspective.getURL(detObj.getIdentID());
                int nStrLength = strDetURL.length();
                if (strDetURL != null && nStrLength > 0) {
                    Polygon polyVirt = detObj.getShape(this.m_Perspective.getVC());
                    Polygon polyDest = this.m_Perspective.getVC().virtToDest(polyVirt);
                    StringBuffer strCoords = new StringBuffer();
                    int j = 0;
                    while (j < polyDest.npoints) {
                        strCoords.append(polyDest.xpoints[j]);
                        strCoords.append(",");
                        strCoords.append(polyDest.ypoints[j]);
                        if (j < polyDest.npoints - 1) {
                            strCoords.append(",");
                        }
                        ++j;
                    }
                    outWriter.println("<AREA SHAPE=POLYGON COORDS=\"" + strCoords + "\"");
                    outWriter.println("   TITLE=\"" + strDetURL + "\"");
                    outWriter.println("   HREF=\"" + strDetURL + "\"");
                    outWriter.println("   ALT=\"" + strDetURL + "\">");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            --i;
        }
        outWriter.println("<AREA SHAPE=default NOHREF>");
        outWriter.println("</MAP>");
        outWriter.println("<IMG SRC=\"" + pathName + mapName + ".gif\" USEMAP=\"#" + mapName + "\" BORDER=0>");
        if (bPage) {
            outWriter.println("</BODY></HTML>");
        }
    }

    public TDGImageMap copyToTDGImageMap() {
        TDGImageMap imageMap = new TDGImageMap();
        imageMap.vectPolyCoordsHRef = new Vector();
        int i = this.m_vDetList.size() - 1;
        while (i >= 0) {
            try {
                DetObj detObj = (DetObj)this.m_vDetList.elementAt(i);
                String strDetURL = this.m_Perspective.getURL(detObj.getIdentID());
                int nStrLength = strDetURL.length();
                if (strDetURL != null && nStrLength > 0) {
                    String strObjName;
                    Polygon polyVirt = detObj.getShape(this.m_Perspective.getVC());
                    Polygon polyDest = this.m_Perspective.getVC().virtToDest(polyVirt);
                    StringBuffer strCoords = new StringBuffer();
                    int j = 0;
                    while (j < polyDest.npoints) {
                        strCoords.append(polyDest.xpoints[j]);
                        strCoords.append(",");
                        strCoords.append(polyDest.ypoints[j]);
                        if (j < polyDest.npoints - 1) {
                            strCoords.append(",");
                        }
                        ++j;
                    }
                    TDGPolyCoordsHRef item = new TDGPolyCoordsHRef();
                    item.strPolyCoords = strCoords.toString();
                    item.strHRef = strObjName = strDetURL;
                    imageMap.vectPolyCoordsHRef.addElement(item);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            --i;
        }
        return imageMap;
    }

    public void releaseReferences() {
        this.m_vDetList = null;
        this.m_Perspective = null;
    }
}

