/*
 * Decompiled with CFR 0.152.
 */
package tdg;

import java.io.Serializable;
import tdg.CategoryIF;
import tdg.Perspective;

public class DataChunk
implements Serializable {
    static final CategoryIF LOG = Perspective.getInstance("DATA.DataChunk");
    public static final int ROWS_PER_CHUNK = 16;
    public static final int COLS_PER_CHUNK = 16;
    private int m_page;
    private int m_rowStart;
    private int m_colStart;
    private Object[][] m_cells;

    public DataChunk(int p, int r, int c) {
        int rowStart = r / 16 * 16;
        int colStart = c / 16 * 16;
        this.m_page = p;
        this.m_rowStart = rowStart;
        this.m_colStart = colStart;
        this.m_cells = new Object[16][16];
    }

    public DataChunk(DataChunk srcChunk) {
        this.m_page = srcChunk.m_page;
        this.m_rowStart = srcChunk.m_rowStart;
        this.m_colStart = srcChunk.m_colStart;
        this.m_cells = new Object[16][16];
        int ir = 0;
        while (ir < 16) {
            int ic = 0;
            while (ic < 16) {
                Object obj = srcChunk.m_cells[ir][ic];
                if (obj != null) {
                    if (obj instanceof Number) {
                        this.m_cells[ir][ic] = new Double(((Number)obj).doubleValue());
                    } else if (obj instanceof String) {
                        this.m_cells[ir][ic] = (String)obj;
                    }
                }
                ++ic;
            }
            ++ir;
        }
    }

    public boolean contains(int p, int r, int c) {
        boolean b = p == this.m_page && r >= this.m_rowStart && r < this.m_rowStart + 16 && c >= this.m_colStart && c < this.m_colStart + 16;
        return b;
    }

    public void dumpChunk() {
        int ir = 0;
        while (ir < 16) {
            int ic = 0;
            while (ic < 16) {
                if (this.m_cells[ir][ic] != null) {
                    LOG.info("(" + this.m_page + "," + (ir + this.m_rowStart) + "," + (ic + this.m_colStart) + "): " + this.m_cells[ir][ic].toString());
                }
                ++ic;
            }
            ++ir;
        }
    }

    public Object getData(int r, int c) {
        return this.m_cells[r - this.m_rowStart][c - this.m_colStart];
    }

    public boolean isOnPage(int p) {
        return p == this.m_page;
    }

    public void setData(int r, int c, Object obj) {
        this.m_cells[r - this.m_rowStart][c - this.m_colStart] = obj;
    }

    public String toString() {
        return "Chunk(" + this.m_page + "," + this.m_rowStart + "," + this.m_colStart + ")";
    }
}

