/*
 * Decompiled with CFR 0.152.
 */
package tdg;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import tdg.Access;
import tdg.Assert;
import tdg.AssertionException;
import tdg.AxisTemplate;
import tdg.DataRange;
import tdg.GroupsEnumerator;
import tdg.MinMaxObj;
import tdg.Perspective;
import tdg.RelativeAxisObj;
import tdg.VC;
import tdg.draw.BlackBoxIF;
import tdg.draw.BlackBoxObj;
import tdg.draw.DetLine;
import tdg.draw.DetOval;
import tdg.draw.IdentObj;
import tdg.draw.TextStyleObj;

public class CircularAxisObj
extends RelativeAxisObj {
    private static final int TICKSIZE = 250;
    private static final double TICK_RADIUS_LENGTH = 0.05;
    protected static final double RELATIVE_Y1AXIS_BODY_ANGLE = 0.75;
    protected static final double RELATIVE_Y2AXIS_BODY_ANGLE = 0.0;
    protected static final double MAJOR_GRID_ANCOR = 0.33;
    protected static final double MINOR_GRID_ANCOR = 0.66;
    protected boolean m_bRadiusAxis;
    protected Dimension m_frameDimVC;
    protected Point m_centerFramePosVC;
    protected boolean m_bVertScale;

    public CircularAxisObj(Perspective perspective, Access access, AxisTemplate id, MinMaxObj minMax, boolean bAscending, boolean bVertical, int nAxisOffset, int nAxisSize, boolean bRadius) {
        super(perspective, access, id, minMax, bAscending, nAxisOffset, nAxisSize);
        this.m_bRadiusAxis = bRadius;
        this.m_bVertScale = bVertical;
        this.initVariables();
    }

    public CircularAxisObj(Perspective perspective, Access access, AxisTemplate id, boolean bAscending, int nAxisOffset, int nAxisSize, boolean bRadius) {
        super(perspective, access, id, 9, bAscending);
        this.m_bRadiusAxis = bRadius;
        this.m_bVertScale = false;
        this.initVariables();
    }

    protected void adjustTitlePosPass1(int nSide, Vector rLabels, Rectangle rTitle) {
        if (rTitle != null) {
            Rectangle r = rLabels.size() == 1 ? (Rectangle)rLabels.elementAt(0) : (Rectangle)rLabels.elementAt(1);
            if (this.m_bVertScale) {
                if (nSide == 0) {
                    rTitle.width = r.x - rTitle.x;
                    rTitle.x = r.x - rTitle.width - 50;
                } else {
                    rTitle.width = rTitle.width + rTitle.x - (r.x + r.width);
                    rTitle.x = r.x + r.width + 50;
                }
            } else {
                rTitle.y = nSide == 0 ? r.y - rTitle.height : r.y + r.height;
            }
        }
    }

    protected void adjustTitlePosPass2(IdentObj id, int nSide, Rectangle rTitle, Dimension labelDim) {
        if (this.m_bVertScale) {
            if (nSide == 0) {
                int nRight = rTitle.x + rTitle.width;
                rTitle.width = Math.min(rTitle.width, labelDim.width);
                rTitle.x = nRight - rTitle.width;
            } else {
                rTitle.width = Math.min(rTitle.width, labelDim.width);
            }
        } else if (nSide == 0) {
            int nTop = rTitle.y + rTitle.height;
            rTitle.height = Math.min(rTitle.height, labelDim.height);
            rTitle.y = nTop - rTitle.height;
        } else {
            rTitle.height = Math.min(rTitle.height, labelDim.height);
        }
    }

    public void calc() {
        this.initAxis();
        super.calc();
        if (this.m_bNumericAxis && this.m_Perspective.getDisplay(this.m_template.getZeroLine()) && this.isZeroInRange()) {
            this.calcZeroLine();
        }
    }

    public void calcAxisBody() {
        if (!this.m_Perspective.getDisplay(this.m_template.getBody())) {
            return;
        }
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, this.m_template.getBody());
        if (this.m_bRadiusAxis) {
            Point pt1 = new Point(0, 0);
            Point pt2 = new Point(0, 0);
            double relAxisBodyAngle = this.m_template.getAxis().getObjectID() == this.m_Perspective.getY1Axis().getObjectID() ? 0.75 : 0.0;
            CircularAxisObj.polarToCartesian(pt1, this.getAngleFromRelAngle(relAxisBodyAngle), 0.0, this.m_frameDimVC, this.m_centerFramePosVC, this.m_Perspective.m_VC);
            CircularAxisObj.polarToCartesian(pt2, this.getAngleFromRelAngle(relAxisBodyAngle), 1.0, this.m_frameDimVC, this.m_centerFramePosVC, this.m_Perspective.m_VC);
            new DetLine(this.m_Perspective.getDetectiv(), this.m_template.getZeroLine(), pt1.x, pt1.y, pt2.x, pt2.y, (BlackBoxIF)blackBox, null, this.m_Perspective.getLineWidth(this.m_template.getBody()), this.m_Perspective.getLineStyle(this.m_template.getBody()));
        } else {
            new DetOval(this.m_Perspective.getDetectiv(), this.m_template.getZeroLine(), this.m_centerFramePosVC.x - this.m_frameDimVC.width / 2, this.m_centerFramePosVC.y - this.m_frameDimVC.height / 2, this.m_frameDimVC.width, this.m_frameDimVC.height, blackBox, null, false, true, true);
        }
    }

    protected void calcMajorGridLine(IdentObj id, double fRelPos, BlackBoxIF blackBox) {
        this.calcLineOnFrame(this.m_Perspective.getGridStyle(this.m_template.getMajor()), fRelPos, id, blackBox, this.m_Perspective.getLineWidth(this.m_template.getMajor()), this.m_Perspective.getLineStyle(this.m_template.getMajor()), 0.33);
    }

    protected void calcMinorGridLine(IdentObj id, double fRelPos, BlackBoxIF blackBox) {
        this.calcLineOnFrame(this.m_Perspective.getGridStyle(this.m_template.getMinor()), fRelPos, id, blackBox, this.m_Perspective.getLineWidth(this.m_template.getMinor()), this.m_Perspective.getLineStyle(this.m_template.getMajor()), 0.66);
    }

    protected void calcZeroLine() {
        if (this.m_bNumericAxis) {
            BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, this.m_template.getZeroLine());
            if (this.m_bRadiusAxis) {
                Rectangle rOval = this.getValueOval(this.getValueRelCoord(0.0));
                new DetOval(this.m_Perspective.getDetectiv(), this.m_template.getZeroLine(), rOval.x, rOval.y, rOval.width, rOval.height, blackBox, null, false, true, true);
            } else {
                Point pt2 = new Point(0, 0);
                double angle = this.getValueCoord(0.0);
                CircularAxisObj.polarToCartesian(pt2, angle, 1.0, this.m_frameDimVC, this.m_centerFramePosVC, this.m_Perspective.m_VC);
                new DetLine(this.m_Perspective.getDetectiv(), this.m_template.getZeroLine(), this.m_centerFramePosVC.x, this.m_centerFramePosVC.y, pt2.x, pt2.y, (BlackBoxIF)blackBox, null, this.m_Perspective.getLineWidth(this.m_template.getZeroLine()), this.m_Perspective.getLineStyle(this.m_template.getBody()));
            }
        } else {
            throw new AssertionException("Numerical method called by ordinal axis");
        }
    }

    public static void cartesianToPolar(Point pt, Double angle, Double relRadius) {
    }

    protected boolean doDisplayOnCalc() {
        return true;
    }

    protected boolean isVertical() {
        return this.m_bVertScale;
    }

    private double getAngleFromRelAngle(double fRelAngle) {
        double angle = fRelAngle * 360.0 + 90.0 + (double)this.m_Perspective.getPieRotate();
        if (angle > 360.0) {
            angle -= 360.0;
        }
        return angle;
    }

    protected int getAxisSide() {
        return this.m_Perspective.getAxisSide(this.m_template.getAxis());
    }

    protected boolean isAxisLabelVisible(int nSide) {
        return true;
    }

    public double getBaseCoord() {
        if (this.m_bNumericAxis) {
            if (this.m_bRadiusAxis) {
                return this.getBaseRelCoord();
            }
            return this.getAngleFromRelAngle(this.getBaseRelCoord());
        }
        throw new AssertionException("Numerical method called by ordinal axis");
    }

    public double getCenterCoord(int g) {
        if (!this.m_bNumericAxis) {
            if (this.m_bRadiusAxis) {
                return this.getCenterRelCoord(g);
            }
            if (this.m_numGroups > 1) {
                return this.getAngleFromRelAngle(this.getCenterRelCoord(g));
            }
            return this.getAngleFromRelAngle(0.0);
        }
        throw new AssertionException("Ordinal method called by numerical axis");
    }

    public int getGroupAboveCoord(int nCoord) {
        if (!this.m_bNumericAxis) {
            return 0;
        }
        throw new AssertionException("Ordinal Axis method call on numerical axis");
    }

    public int getGroupBelowCoord(int nCoord) {
        if (!this.m_bNumericAxis) {
            return 0;
        }
        throw new AssertionException("Ordinal Axis method call on numerical axis");
    }

    public double getHighCoord(int s, int g) {
        if (!this.m_bNumericAxis) {
            if (this.m_bRadiusAxis) {
                return this.getHighRelCoord(s, g);
            }
            if (this.m_numGroups > 1) {
                return this.getAngleFromRelAngle((double)g / (double)this.m_numGroups);
            }
            return this.getAngleFromRelAngle(0.0);
        }
        throw new AssertionException("Ordinal method called by numerical axis");
    }

    protected void getLabelAndTitlePos(int nSide, int nLabels, Vector rLabels, Vector fRelPos, Vector align, Rectangle rTitle, boolean bRotate, int nAutoSkip, int nLabelBegin, int nSkipFactor, TextStyleObj textStyleLabel) {
        Integer nAlign = null;
        Rectangle rSpace = this.getSpaceAvailable(nSide, this.m_Perspective.m_VC);
        int[] nPos = new int[nLabels];
        int titleHeight = 0;
        if (this.m_bRadiusAxis) {
            titleHeight = rTitle != null ? (this.m_bVertScale ? Math.min(rSpace.width / 3, 2300) : Math.min(rSpace.height / 3, 2300)) : 0;
        } else {
            rTitle = null;
        }
        if (this.m_bRadiusAxis) {
            int i = 0;
            while (i < nLabels) {
                Point pt = new Point(0, 0);
                double radius = (Double)fRelPos.elementAt(i);
                if (this.m_bVertScale) {
                    CircularAxisObj.polarToCartesian(pt, 90.0, radius, this.m_frameDimVC, this.m_centerFramePosVC, this.m_Perspective.m_VC);
                    nPos[i] = pt.y;
                } else {
                    CircularAxisObj.polarToCartesian(pt, 0.0, radius, this.m_frameDimVC, this.m_centerFramePosVC, this.m_Perspective.m_VC);
                    nPos[i] = pt.x;
                }
                ++i;
            }
            int nMaxDim = Math.abs(nPos[1] - nPos[0]);
            nAlign = nSide == 0 ? (this.m_bVertScale ? new Integer(5) : new Integer(3)) : (this.m_bVertScale ? new Integer(1) : new Integer(7));
            int i2 = 0;
            while (i2 < nLabels) {
                align.insertElementAt(nAlign, i2);
                ++i2;
            }
            int i3 = 0;
            while (i3 < nLabels) {
                Rectangle r = this.m_bVertScale ? new Rectangle(rSpace.x, nPos[i3] - nMaxDim / 2, rSpace.width, nMaxDim) : new Rectangle(nPos[i3] - nMaxDim / 2, rSpace.y, nMaxDim, rSpace.height);
                rLabels.insertElementAt(r, i3);
                ++i3;
            }
        } else {
            Dimension dim = this.m_Perspective.m_VC.getVirtDimension();
            Point pt = new Point(0, 0);
            int i = 0;
            while (i < nLabels) {
                int maxHalfWidth;
                Rectangle r;
                int maxHalfHeight;
                double angle = this.getAngleFromRelAngle((Double)fRelPos.elementAt(i));
                CircularAxisObj.polarToCartesian(pt, angle, 1.0, this.m_frameDimVC, this.m_centerFramePosVC, this.m_Perspective.m_VC);
                if (angle > 355.0 && angle < 5.0) {
                    maxHalfHeight = Math.min(dim.height / 2 - pt.y, pt.y + dim.height / 2);
                    r = new Rectangle(pt.x, pt.y - maxHalfHeight, dim.width / 2 - pt.x, 2 * maxHalfHeight);
                    nAlign = new Integer(1);
                } else if (angle < 80.0) {
                    r = new Rectangle(pt.x, pt.y, dim.width / 2 - pt.x, dim.height / 2 - pt.y);
                    nAlign = new Integer(8);
                } else if (angle < 100.0) {
                    maxHalfWidth = Math.min(dim.width / 2 - pt.x, pt.x + dim.width / 2);
                    r = new Rectangle(pt.x - maxHalfWidth, pt.y, maxHalfWidth * 2, dim.height / 2 - pt.y);
                    nAlign = new Integer(7);
                } else if (angle < 175.0) {
                    r = new Rectangle(-dim.width / 2, pt.y, pt.x + dim.width / 2, dim.height / 2 - pt.y);
                    nAlign = new Integer(6);
                } else if (angle < 185.0) {
                    maxHalfHeight = Math.min(dim.height / 2 - pt.y, pt.y + dim.height / 2);
                    r = new Rectangle(-dim.width / 2, pt.y - maxHalfHeight, pt.x + dim.width / 2, 2 * maxHalfHeight);
                    nAlign = new Integer(5);
                } else if (angle < 260.0) {
                    r = new Rectangle(-dim.width / 2, -dim.height / 2, pt.x + dim.width / 2, dim.height / 2 + pt.y);
                    nAlign = new Integer(4);
                } else if (angle < 280.0) {
                    maxHalfWidth = Math.min(dim.width / 2 - pt.x, pt.x + dim.width / 2);
                    r = new Rectangle(pt.x - maxHalfWidth, -dim.height / 2, maxHalfWidth * 2, dim.height / 2 + pt.y);
                    nAlign = new Integer(3);
                } else {
                    r = new Rectangle(pt.x, -dim.height / 2, dim.width / 2 - pt.x, pt.y + dim.height / 2);
                    nAlign = new Integer(2);
                }
                align.insertElementAt(nAlign, i);
                rLabels.insertElementAt(r, i);
                ++i;
            }
        }
        if (rTitle != null) {
            int nMaxDim = Math.abs(nPos[1] - nPos[0]);
            if (this.m_bVertScale) {
                rTitle.y = Math.min(nPos[0], nPos[nLabels - 1]) - nMaxDim / 2;
                rTitle.height = nMaxDim * nLabels;
                rTitle.width = rSpace.width;
                rTitle.x = nSide == 0 ? rSpace.x : rSpace.x + rSpace.width - titleHeight;
            } else {
                rTitle.x = Math.min(nPos[0], nPos[nLabels - 1]) - nMaxDim / 2;
                rTitle.width = nMaxDim * nLabels;
                rTitle.height = rSpace.height;
                rTitle.y = nSide == 0 ? rSpace.y : rSpace.y + rSpace.height - titleHeight;
            }
        }
    }

    protected Vector getLabels() {
        if (this.m_bNumericAxis) {
            return this.getNumericLabels();
        }
        int nLabels = this.getNumLabels();
        Vector<String> szLabels = new Vector<String>(nLabels);
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        while (gEnum.hasMoreElements()) {
            int g = gEnum.nextGroup();
            Assert.assert(g >= 0 && g < this.m_Access.getNumTotalGroups());
            String szLabel = this.m_Perspective.getGroupLabel(g);
            szLabels.addElement(szLabel);
        }
        return szLabels;
    }

    protected Vector getLabelIdents() {
        if (this.m_bNumericAxis) {
            return null;
        }
        Vector<IdentObj> idents = new Vector<IdentObj>(this.getNumLabels());
        DataRange drViewSG = this.m_Perspective.getViewableDataRangeSG();
        int nViewGroupStart = drViewSG.getColStart();
        int nViewGroupStop = drViewSG.getColStop();
        int g = nViewGroupStart;
        while (g <= nViewGroupStop) {
            idents.addElement(new IdentObj(-3, -3, g));
            ++g;
        }
        return idents;
    }

    public double getLowCoord(int s, int g) {
        if (!this.m_bNumericAxis) {
            if (this.m_bRadiusAxis) {
                return this.getLowRelCoord(s, g);
            }
            if (this.m_numGroups > 1) {
                return this.getAngleFromRelAngle((double)g / (double)this.m_numGroups);
            }
            return this.getAngleFromRelAngle(0.0);
        }
        throw new AssertionException("Ordinal method called by numerical axis");
    }

    protected boolean getMajorGridDisplay(AxisTemplate axisID) {
        return this.m_Perspective.getDisplay(axisID.getMajor());
    }

    protected boolean getMinorGridDisplay(AxisTemplate axisID) {
        return this.m_Perspective.getDisplay(axisID.getMinor());
    }

    private Rectangle getSpaceAvailable(int nSide, VC vc) {
        Rectangle[] rect = new Rectangle[1];
        Dimension dim = vc.getVirtDimension();
        Rectangle rSpace = this.m_bRadiusAxis ? (nSide == 0 ? (this.m_bVertScale ? new Rectangle(this.m_centerFramePosVC.x - this.m_frameDimVC.width / 2, this.m_centerFramePosVC.y, this.m_frameDimVC.width / 2, this.m_frameDimVC.height / 2) : new Rectangle(this.m_centerFramePosVC.x, this.m_centerFramePosVC.y - this.m_frameDimVC.height / 2, this.m_frameDimVC.width / 2, this.m_frameDimVC.height / 2)) : (this.m_bVertScale ? new Rectangle(this.m_centerFramePosVC.x, this.m_centerFramePosVC.y, this.m_frameDimVC.width / 2, this.m_frameDimVC.height / 2) : new Rectangle(this.m_centerFramePosVC.x, this.m_centerFramePosVC.y, this.m_frameDimVC.width / 2, this.m_frameDimVC.height / 2))) : new Rectangle(0, 0, 0, 0);
        return rSpace;
    }

    protected int getTitleRotation(AxisTemplate template, int nSide) {
        int nRotation = this.m_Perspective.getMoveAxisTitles() ? this.m_Perspective.getTextRotation(template.getTitle()) : (this.m_bRadiusAxis ? (nSide == 0 && this.m_bVertScale ? (this.m_Perspective.getTextRotation(template.getTitle()) == 2 ? 2 : 1) : (nSide == 1 && this.m_bVertScale ? (this.m_Perspective.getTextRotation(template.getTitle()) == 1 ? 1 : 2) : 0)) : 0);
        return nRotation;
    }

    public double getValueCoord(double fValue) {
        if (this.m_bRadiusAxis) {
            return this.getValueRelCoord(fValue);
        }
        return this.getAngleFromRelAngle(this.getValueRelCoord(fValue));
    }

    public double getValueFromCoord(int nCoord) {
        return 0.0;
    }

    public Rectangle getValueOval(double fRelValue) {
        if (this.m_bRadiusAxis) {
            return new Rectangle((int)((double)this.m_centerFramePosVC.x - (double)(this.m_frameDimVC.width / 2) * fRelValue), (int)((double)this.m_centerFramePosVC.y - (double)(this.m_frameDimVC.height / 2) * fRelValue), (int)((double)(2 * this.m_frameDimVC.width / 2) * fRelValue), (int)((double)(2 * this.m_frameDimVC.height / 2) * fRelValue));
        }
        throw new AssertionException("Radius method called by non Radius axis");
    }

    private void initAxis() {
        Rectangle rFrame = this.m_Perspective.getFrameRect(false);
        this.m_frameDimVC.width = rFrame.width;
        this.m_frameDimVC.height = rFrame.height;
        this.m_centerFramePosVC.x = rFrame.x + rFrame.width / 2;
        this.m_centerFramePosVC.y = rFrame.y + rFrame.height / 2;
    }

    private void initVariables() {
        this.m_frameDimVC = new Dimension(0, 0);
        this.m_centerFramePosVC = new Point(0, 0);
    }

    public boolean isO1WithNestedLabels() {
        return false;
    }

    protected boolean isPolarAxis() {
        return !this.m_bRadiusAxis;
    }

    public static void polarToCartesian(Point pt, double fAngleInDeg, double relRadius, Dimension frameDim, Point origin, VC vc) {
        Dimension dcFrameDim = vc.virtToDest(frameDim);
        Point dcOrigin = vc.virtToDest(origin);
        double radius = (double)(dcFrameDim.width / 2) * relRadius;
        double fX = radius * Math.cos(fAngleInDeg * (Math.PI / 180));
        double fY = radius * Math.sin(fAngleInDeg * (Math.PI / 180));
        Point ptTemp = new Point(dcOrigin.x + (int)fX, dcOrigin.y + (int)fY);
        ptTemp = vc.destToVirt(ptTemp);
        pt.x = ptTemp.x;
        pt.y = ptTemp.y;
    }

    protected void adjustLabelPos(int nSide, int nLabels, Vector rLabels) {
    }

    private void calcLineOnFrame(int nStyle, double fRelPos, IdentObj id, BlackBoxIF blackBox, int nLineWidth, int nLineStyle, double ancor) {
        Point pt1 = new Point(0, 0);
        Point pt2 = new Point(0, 0);
        if (this.m_bRadiusAxis) {
            if (nStyle == 0 || nStyle == 1) {
                Rectangle rOval = this.getValueOval(fRelPos);
                new DetOval(this.m_Perspective.getDetectiv(), id, rOval.x, rOval.y, rOval.width, rOval.height, blackBox, null, false, true, true);
            } else {
                int nSide = this.getAxisSide();
                if (this.m_bVertScale) {
                    pt1.y = pt2.y = (int)((double)this.m_centerFramePosVC.y + (double)(this.m_frameDimVC.height / 2) * fRelPos + 0.5);
                    pt1.x = this.m_centerFramePosVC.x;
                    if (nSide == 0 && nStyle == 3 || nSide == 1 && nStyle == 2 || nSide == 2 || nStyle == 4) {
                        pt1.x -= 250;
                    }
                    pt2.x = this.m_centerFramePosVC.x;
                    if (nSide == 1 && nStyle == 3 || nSide == 0 && nStyle == 2 || nSide == 2 || nStyle == 4) {
                        pt2.x += 250;
                    }
                } else {
                    pt1.x = pt2.x = (int)((double)this.m_centerFramePosVC.x + (double)(this.m_frameDimVC.width / 2) * fRelPos + 0.5);
                    pt1.y = this.m_centerFramePosVC.y;
                    if (nSide == 0 && nStyle == 2 || nSide == 1 && nStyle == 3 || nSide == 2 || nStyle == 4) {
                        pt1.y += 250;
                    }
                    pt2.y = this.m_centerFramePosVC.y;
                    if (nSide == 1 && nStyle == 2 || nSide == 0 && nStyle == 3 || nSide == 2 || nStyle == 4) {
                        pt2.y -= 250;
                    }
                }
                new DetLine(this.m_Perspective.getDetectiv(), id, pt1.x, pt1.y, pt2.x, pt2.y, blackBox, null, nLineWidth, nLineStyle);
            }
        } else {
            double fPosOut;
            double fPosIn;
            switch (nStyle) {
                case 1: {
                    fPosIn = ancor;
                    fPosOut = 1.05;
                    break;
                }
                case 2: {
                    fPosIn = 0.95;
                    fPosOut = 1.0;
                    break;
                }
                case 3: {
                    fPosIn = 1.0;
                    fPosOut = 1.05;
                    break;
                }
                case 4: {
                    fPosIn = 0.95;
                    fPosOut = 1.05;
                    break;
                }
                default: {
                    fPosIn = ancor;
                    fPosOut = 1.0;
                }
            }
            double angle = this.getAngleFromRelAngle(fRelPos);
            CircularAxisObj.polarToCartesian(pt1, angle, fPosIn, this.m_frameDimVC, this.m_centerFramePosVC, this.m_Perspective.m_VC);
            CircularAxisObj.polarToCartesian(pt2, angle, fPosOut, this.m_frameDimVC, this.m_centerFramePosVC, this.m_Perspective.m_VC);
            new DetLine(this.m_Perspective.getDetectiv(), this.m_template.getMajor(), pt1.x, pt1.y, pt2.x, pt2.y, blackBox, null, this.m_Perspective.getLineWidth(this.m_template.getMajor()), this.m_Perspective.getLineStyle(this.m_template.getMajor()));
        }
    }

    protected int getTitleJustVert(IdentObj id, int nSide) {
        return this.m_Perspective.getTextJustVert(id);
    }

    protected int getTitleJustHoriz(IdentObj id, int nSide) {
        return this.m_Perspective.getTextJustHoriz(id);
    }
}

