/*
 * Decompiled with CFR 0.152.
 */
package tdg;

import java.awt.Rectangle;
import java.io.Serializable;
import tdg.Assert;
import tdg.AxisDescriptor;
import tdg.JChart_2D_BLA;
import tdg.JChart_2D_Scat;
import tdg.JChart_2D_Spec;
import tdg.JChart_2D_Standard;
import tdg.JChart_Base;
import tdg.JGraphType;
import tdg.Perspective;
import tdg.ZoomState;

public class ChartFrameZoom
implements Serializable {
    protected Perspective m_Perspective;
    protected JChart_Base m_Chart;

    public ChartFrameZoom(Perspective perspective, JChart_Base chart) {
        this.m_Perspective = perspective;
        this.m_Chart = chart;
    }

    public void doZoomIn(ZoomState zoomState, Rectangle rZoom) {
        JGraphType gt = this.m_Perspective.getJGraphType();
        double fMin_X1 = 0.0;
        double fMin_Y1 = 0.0;
        double fMin_Y2 = 0.0;
        double fMax_X1 = 0.0;
        double fMax_Y1 = 0.0;
        double fMax_Y2 = 0.0;
        int nViewableGroups = this.m_Perspective.getEffectiveViewableGroups();
        int nViewableSeries = this.m_Perspective.getEffectiveViewableSeries();
        int nScrollOffsetGroup = this.m_Perspective.getEffectiveGroupOffset();
        int nScrollOffsetSeries = this.m_Perspective.getEffectiveSeriesOffset();
        if (this.m_Chart != null && this.m_Chart instanceof JChart_2D_BLA || this.m_Chart instanceof JChart_2D_Scat) {
            int nYMaxCoord;
            int nYMinCoord;
            JChart_2D_Standard ch = (JChart_2D_Standard)this.m_Chart;
            AxisDescriptor ad = gt.getAxisDescriptor();
            if (ch.m_X1Axis != null) {
                int nXMaxCoord;
                int nXMinCoord;
                if (gt.isOrientHorz()) {
                    nXMinCoord = rZoom.y;
                    nXMaxCoord = rZoom.y + rZoom.height;
                } else {
                    nXMinCoord = rZoom.x;
                    nXMaxCoord = rZoom.x + rZoom.width;
                }
                fMin_X1 = (double)nXMinCoord <= ch.m_X1Axis.getMinCoord() ? ch.m_X1Axis.getMinValue() : ch.m_X1Axis.getValueFromCoord(nXMinCoord);
                fMax_X1 = (double)nXMaxCoord >= ch.m_X1Axis.getMaxCoord() ? ch.m_X1Axis.getMaxValue() : ch.m_X1Axis.getValueFromCoord(nXMaxCoord);
            }
            if (gt.isOrientHorz()) {
                nYMinCoord = rZoom.x;
                nYMaxCoord = rZoom.x + rZoom.width;
            } else {
                nYMinCoord = rZoom.y;
                nYMaxCoord = rZoom.y + rZoom.height;
            }
            if (ch.m_Y1Axis != null) {
                fMin_Y1 = (double)nYMinCoord <= ch.m_Y1Axis.getMinCoord() ? ch.m_Y1Axis.getMinValue() : ch.m_Y1Axis.getValueFromCoord(nYMinCoord);
                fMax_Y1 = (double)nYMaxCoord <= ch.m_Y1Axis.getMinCoord() ? ch.m_Y1Axis.getMinValue() : ((double)nYMaxCoord >= ch.m_Y1Axis.getMaxCoord() ? ch.m_Y1Axis.getMaxValue() : ch.m_Y1Axis.getValueFromCoord(nYMaxCoord));
            }
            if (ch.m_Y2Axis != null) {
                fMin_Y2 = (double)nYMinCoord <= ch.m_Y2Axis.getMinCoord() ? ch.m_Y2Axis.getMinValue() : ch.m_Y2Axis.getValueFromCoord(nYMinCoord);
                fMax_Y2 = (double)nYMaxCoord <= ch.m_Y2Axis.getMinCoord() ? ch.m_Y2Axis.getMinValue() : ((double)nYMaxCoord >= ch.m_Y2Axis.getMaxCoord() ? ch.m_Y2Axis.getMaxValue() : ch.m_Y2Axis.getValueFromCoord(nYMaxCoord));
            }
            if (ch.m_O1Axis != null) {
                int nLastGroup;
                int nFirstGroup;
                if (gt.isOrientHorz()) {
                    nFirstGroup = ch.m_O1Axis.getGroupBelowCoord(rZoom.y + rZoom.height);
                    nLastGroup = ch.m_O1Axis.getGroupAboveCoord(rZoom.y);
                } else {
                    nFirstGroup = ch.m_O1Axis.getGroupAboveCoord(rZoom.x);
                    nLastGroup = ch.m_O1Axis.getGroupBelowCoord(rZoom.x + rZoom.width);
                }
                if ((nLastGroup += nScrollOffsetGroup) < (nFirstGroup += nScrollOffsetGroup)) {
                    nLastGroup = nFirstGroup;
                }
                nViewableGroups = nLastGroup - nFirstGroup + 1;
                nScrollOffsetGroup = nFirstGroup;
                this.m_Perspective.setViewableGroups(nViewableGroups);
                this.m_Perspective.setScrollOffsetGroup(nScrollOffsetGroup);
            }
            if (ch instanceof JChart_2D_Spec) {
                JChart_2D_Spec chSpec = (JChart_2D_Spec)ch;
                if (chSpec.m_O2Axis != null) {
                    int nFirstSeries = chSpec.m_O2Axis.getGroupAboveCoord(rZoom.y);
                    int nLastSeries = chSpec.m_O2Axis.getGroupBelowCoord(rZoom.y + rZoom.height);
                    if ((nLastSeries += nScrollOffsetSeries) < (nFirstSeries += nScrollOffsetSeries)) {
                        nLastSeries = nFirstSeries;
                    }
                    nViewableSeries = nLastSeries - nFirstSeries + 1;
                    nScrollOffsetSeries = nFirstSeries;
                    this.m_Perspective.setViewableSeries(nViewableSeries);
                    this.m_Perspective.setScrollOffsetSeries(nScrollOffsetSeries);
                }
            }
            zoomState.ChartFrame(fMin_X1, fMax_X1, fMin_Y1, fMax_Y1, fMin_Y2, fMax_Y2, nViewableGroups, nScrollOffsetGroup, nViewableSeries, nScrollOffsetSeries, ad);
        }
    }

    public void doZoomOut(ZoomState zoomState, int x, int y) {
        JGraphType gt = this.m_Perspective.getJGraphType();
        Rectangle rFrame = this.m_Perspective.getFrameRect(false);
        double zpct = this.m_Perspective.getZoomPercentage();
        Assert.assert(zpct >= 20.0 && zpct <= 100.0);
        int newWidth = (int)((double)rFrame.width * 100.0 / zpct);
        int newHeight = (int)((double)rFrame.height * 100.0 / zpct);
        int newX = x - newWidth / 2;
        int newY = y - newHeight / 2;
        Rectangle rZoom = new Rectangle(newX, newY, newWidth, newHeight);
        double fMin_X1 = 0.0;
        double fMin_Y1 = 0.0;
        double fMin_Y2 = 0.0;
        double fMax_X1 = 0.0;
        double fMax_Y1 = 0.0;
        double fMax_Y2 = 0.0;
        int nViewableGroups = this.m_Perspective.getEffectiveViewableGroups();
        int nViewableSeries = this.m_Perspective.getEffectiveViewableSeries();
        int nScrollOffsetGroup = this.m_Perspective.getEffectiveGroupOffset();
        int nScrollOffsetSeries = this.m_Perspective.getEffectiveSeriesOffset();
        if (this.m_Chart != null && this.m_Chart instanceof JChart_2D_BLA || this.m_Chart instanceof JChart_2D_Scat) {
            int nYMaxCoord;
            int nYMinCoord;
            JChart_2D_Standard ch = (JChart_2D_Standard)this.m_Chart;
            AxisDescriptor ad = gt.getAxisDescriptor();
            if (ch.m_X1Axis != null) {
                int nXMaxCoord;
                int nXMinCoord;
                if (gt.isOrientHorz()) {
                    nXMinCoord = rZoom.y;
                    nXMaxCoord = rZoom.y + rZoom.height;
                } else {
                    nXMinCoord = rZoom.x;
                    nXMaxCoord = rZoom.x + rZoom.width;
                }
                fMin_X1 = (double)nXMinCoord <= ch.m_X1Axis.getMinCoord() ? ch.m_X1Axis.getMinValue() : ch.m_X1Axis.getValueFromCoord(nXMinCoord);
                fMax_X1 = (double)nXMaxCoord >= ch.m_X1Axis.getMaxCoord() ? ch.m_X1Axis.getMaxValue() : ch.m_X1Axis.getValueFromCoord(nXMaxCoord);
            }
            if (gt.isOrientHorz()) {
                nYMinCoord = rZoom.x;
                nYMaxCoord = rZoom.x + rZoom.width;
            } else {
                nYMinCoord = rZoom.y;
                nYMaxCoord = rZoom.y + rZoom.height;
            }
            if (ch.m_Y1Axis != null) {
                fMin_Y1 = (double)nYMinCoord <= ch.m_Y1Axis.getMinCoord() ? ch.m_Y1Axis.getMinValue() : ch.m_Y1Axis.getValueFromCoord(nYMinCoord);
                fMax_Y1 = (double)nYMaxCoord >= ch.m_Y1Axis.getMaxCoord() ? ch.m_Y1Axis.getMaxValue() : ch.m_Y1Axis.getValueFromCoord(nYMaxCoord);
            }
            if (ch.m_Y2Axis != null) {
                fMin_Y2 = (double)rZoom.y <= ch.m_Y2Axis.getMinCoord() ? ch.m_Y2Axis.getMinValue() : ch.m_Y2Axis.getValueFromCoord(nYMinCoord);
                fMax_Y2 = (double)nYMaxCoord >= ch.m_Y2Axis.getMaxCoord() ? ch.m_Y2Axis.getMaxValue() : ch.m_Y2Axis.getValueFromCoord(nYMaxCoord);
            }
            if (ch.m_O1Axis != null) {
                int nLastGroup;
                int nFirstGroup;
                if (gt.isOrientHorz()) {
                    nFirstGroup = ch.m_O1Axis.getGroupAboveCoord(rZoom.y);
                    nLastGroup = ch.m_O1Axis.getGroupBelowCoord(rZoom.y + rZoom.height);
                } else {
                    nFirstGroup = ch.m_O1Axis.getGroupAboveCoord(rZoom.x);
                    nLastGroup = ch.m_O1Axis.getGroupBelowCoord(rZoom.x + rZoom.width);
                }
                if ((nLastGroup += nScrollOffsetGroup) < (nFirstGroup += nScrollOffsetGroup)) {
                    nLastGroup = nFirstGroup;
                }
                nViewableGroups = nLastGroup - nFirstGroup + 1;
                nScrollOffsetGroup = nFirstGroup;
                this.m_Perspective.setViewableGroups(nViewableGroups);
                this.m_Perspective.setScrollOffsetGroup(nScrollOffsetGroup);
            }
            if (ch instanceof JChart_2D_Spec) {
                JChart_2D_Spec chSpec = (JChart_2D_Spec)ch;
                if (chSpec.m_O2Axis != null) {
                    int nFirstSeries = chSpec.m_O2Axis.getGroupAboveCoord(rZoom.y);
                    int nLastSeries = chSpec.m_O2Axis.getGroupBelowCoord(rZoom.y + rZoom.height);
                    if ((nLastSeries += nScrollOffsetSeries) < (nFirstSeries += nScrollOffsetSeries)) {
                        nLastSeries = nFirstSeries;
                    }
                    nViewableSeries = nLastSeries - nFirstSeries + 1;
                    nScrollOffsetSeries = nFirstSeries;
                    this.m_Perspective.setViewableSeries(nViewableSeries);
                    this.m_Perspective.setScrollOffsetSeries(nScrollOffsetSeries);
                }
            }
            zoomState.ChartFrame(fMin_X1, fMax_X1, fMin_Y1, fMax_Y1, fMin_Y2, fMax_Y2, nViewableGroups, nScrollOffsetGroup, nViewableSeries, nScrollOffsetSeries, ad);
        }
    }

    public void releaseReferences() {
        this.m_Perspective = null;
    }
}

