/*
 * Decompiled with CFR 0.152.
 */
package com.threedgraphics.png;

import com.threedgraphics.png.PNGChunk;
import com.threedgraphics.png.PNGInfo;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

class PNGTimeChunk
extends PNGChunk {
    PNGTimeChunk() {
    }

    int getDataLength() {
        return 7;
    }

    String getChunkType() {
        return "tIME";
    }

    byte[] getData() {
        PNGInfo info = this.getPNGInfo();
        Date date = info.getCreationDate();
        if (date == null) {
            return new byte[0];
        }
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        Calendar calendar = Calendar.getInstance(gmt);
        calendar.setTime(date);
        byte[] data = new byte[7];
        short year = (short)calendar.get(1);
        data[0] = (byte)(year >> 8);
        data[1] = (byte)year;
        data[2] = (byte)(calendar.get(2) + 1);
        data[3] = (byte)calendar.get(5);
        data[4] = (byte)calendar.get(11);
        data[5] = (byte)calendar.get(12);
        data[6] = (byte)calendar.get(13);
        return data;
    }

    boolean isCriticalChunk() {
        return false;
    }
}

