/*
 * Decompiled with CFR 0.152.
 */
package com.threedgraphics.png;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.util.Hashtable;
import java.util.zip.DeflaterOutputStream;

public class PNGDataWriter
implements ImageConsumer {
    private ImageProducer m_producer;
    private DeflaterOutputStream m_stream;
    private int m_bytesPerPixel;
    private int m_nWidth = -1;
    private int m_nHeight = -1;
    private int m_nHintflags = 0;
    private boolean m_bStarted = false;
    private boolean m_bEncoding;
    private IOException m_iox;
    private byte[] m_xPNGValues;
    private boolean m_bAccumulate = false;
    private int[] m_intAccumulator;
    private static final ColorModel m_rgbModel = ColorModel.getRGBdefault();
    private int m_nNextLine = 0;
    int[] m_nRGBPixels = null;

    public PNGDataWriter(Image img, DeflaterOutputStream stream, byte type) {
        this.m_producer = img.getSource();
        this.m_stream = stream;
        this.m_bytesPerPixel = 4;
        if (type == 2) {
            this.m_bytesPerPixel = 3;
        }
    }

    public synchronized void encode() throws IOException {
        this.m_bEncoding = true;
        this.m_iox = null;
        this.m_producer.startProduction(this);
        while (this.m_bEncoding) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.m_iox != null) {
            throw this.m_iox;
        }
    }

    private void encodePixelsWrapper(int x, int y, int w, int h, int[] rgbPixels, int off, int scansize) throws IOException {
        if (!this.m_bStarted) {
            this.m_bStarted = true;
            this.m_xPNGValues = new byte[this.m_nWidth * this.m_bytesPerPixel + 1];
        }
        if (!(this.m_bAccumulate || (this.m_nHintflags & 2) != 0 && (this.m_nHintflags & 4) != 0 || x == 0 && y == this.m_nNextLine && scansize == this.m_nWidth)) {
            this.m_bAccumulate = true;
            this.m_intAccumulator = new int[this.m_nWidth * (this.m_nHeight - this.m_nNextLine)];
        }
        if (this.m_bAccumulate) {
            int row = 0;
            while (row < h) {
                System.arraycopy(rgbPixels, row * scansize + off, this.m_intAccumulator, (y + row - this.m_nNextLine) * this.m_nWidth + x, w);
                ++row;
            }
        } else {
            this.writePixels(w, h, rgbPixels, off);
            ++this.m_nNextLine;
        }
    }

    private void encodeFinish() throws IOException {
        if (this.m_bAccumulate) {
            this.writePixels(this.m_nWidth, this.m_nHeight - this.m_nNextLine, this.m_intAccumulator, 0);
        }
    }

    private void writePixels(int w, int h, int[] rgbPixels, int off) throws IOException {
        int row = 0;
        while (row < h) {
            int row_off = row * w + off;
            int col = 0;
            while (col < w) {
                int rgb = rgbPixels[row_off + col];
                int col_off = col * this.m_bytesPerPixel;
                this.m_xPNGValues[col_off + 1] = (byte)(rgb >> 16);
                this.m_xPNGValues[col_off + 2] = (byte)(rgb >> 8);
                this.m_xPNGValues[col_off + 3] = (byte)rgb;
                if (this.m_bytesPerPixel > 3) {
                    this.m_xPNGValues[col_off + 4] = (byte)(rgb >> 24);
                }
                ++col;
            }
            this.m_stream.write(this.m_xPNGValues);
            ++row;
        }
    }

    private synchronized void stop() {
        this.m_bEncoding = false;
        this.notifyAll();
    }

    public void setDimensions(int width, int height) {
        this.m_nWidth = width;
        this.m_nHeight = height;
    }

    public void setProperties(Hashtable props) {
    }

    public void setColorModel(ColorModel model) {
    }

    public void setHints(int hintflags) {
        this.m_nHintflags = hintflags;
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        if (this.m_nRGBPixels == null) {
            this.m_nRGBPixels = new int[this.m_nWidth];
        }
        int row = 0;
        while (row < h) {
            int rowOff = off + row * scansize;
            int col = 0;
            while (col < w) {
                this.m_nRGBPixels[col] = model.getRGB(pixels[rowOff + col] & 0xFF);
                ++col;
            }
            try {
                this.encodePixelsWrapper(x, y + row, w, 1, this.m_nRGBPixels, 0, w);
            }
            catch (IOException e) {
                this.m_iox = e;
                this.stop();
                return;
            }
            ++row;
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        if (model == m_rgbModel) {
            try {
                this.encodePixelsWrapper(x, y, w, h, pixels, off, scansize);
            }
            catch (IOException e) {
                this.m_iox = e;
                this.stop();
                return;
            }
        }
        if (this.m_nRGBPixels == null) {
            this.m_nRGBPixels = new int[this.m_nWidth];
        }
        int row = 0;
        while (row < h) {
            int rowOff = off + row * scansize;
            int col = 0;
            while (col < w) {
                this.m_nRGBPixels[col] = model.getRGB(pixels[rowOff + col]);
                ++col;
            }
            try {
                this.encodePixelsWrapper(x, y + row, w, 1, this.m_nRGBPixels, 0, w);
            }
            catch (IOException e) {
                this.m_iox = e;
                this.stop();
                return;
            }
            ++row;
        }
    }

    public void imageComplete(int status) {
        this.m_producer.removeConsumer(this);
        if (status == 4) {
            this.m_iox = new IOException("image aborted");
        } else {
            try {
                this.encodeFinish();
            }
            catch (IOException e) {
                this.m_iox = e;
            }
        }
        this.stop();
    }
}

