/*
 * Decompiled with CFR 0.152.
 */
package com.threedgraphics.png;

import com.threedgraphics.png.PNGException;
import com.threedgraphics.png.PNGInfo;
import com.threedgraphics.png.PNGInvalidParameterException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;

abstract class PNGChunk {
    private PNGInfo pngInfo;

    PNGChunk() {
    }

    abstract int getDataLength() throws PNGException;

    abstract String getChunkType();

    abstract byte[] getData() throws PNGException;

    abstract boolean isCriticalChunk();

    final void setPNGInfo(PNGInfo info) throws PNGInvalidParameterException {
        if (info == null) {
            throw new PNGInvalidParameterException(this, 0, "setInfo(PNGInfo)", "null parameter");
        }
        this.pngInfo = info;
    }

    final PNGInfo getPNGInfo() {
        return (PNGInfo)this.pngInfo.clone();
    }

    final void write(OutputStream pngStream) throws PNGException {
        if (this.pngInfo == null) {
            throw new PNGException(this, 5, "write()", "Unable to write; coding error; PNGInfo object not set with setPNGInfo()");
        }
        int dataLen = this.getDataLength();
        if (dataLen < 0) {
            throw new PNGException(this, 4, "write(OutputStream)", "chunk data length < 0");
        }
        byte[] lengthBytes = this.toByteArray(dataLen);
        String chunkType = this.getChunkType();
        if (chunkType == null) {
            throw new PNGException(this, 4, "write(OutputStream)", "chunk type == null");
        }
        if (chunkType.length() != 4) {
            throw new PNGException(this, 4, "write(OutputStream)", "chunk type string != 4 characters");
        }
        byte[] asciiChunkTypeStr = this.toAsciiArray(chunkType);
        byte[] data = this.getData();
        if (data == null) {
            throw new PNGException(this, 4, "write(OutputStream)", "chunk data == null");
        }
        if (data.length != dataLen) {
            throw new PNGException(this, 4, "write(OutputStream)", "chunk data array length != getDataLength() value");
        }
        CRC32 crc = new CRC32();
        crc.update(asciiChunkTypeStr);
        crc.update(data);
        byte[] crcVal = this.toByteArray((int)crc.getValue());
        try {
            pngStream.write(lengthBytes);
            pngStream.write(asciiChunkTypeStr);
            pngStream.write(data);
            pngStream.write(crcVal);
        }
        catch (IOException err) {
            throw new PNGException(this, 4, "write(OutputStream)", "error writing to stream", err);
        }
    }

    final byte[] toByteArray(int param) {
        return this.toByteArray(new int[]{param});
    }

    final byte[] toByteArray(int[] param) {
        int numInts = param.length;
        byte[] bytes = new byte[numInts * 4];
        this.toByteArray(param, 0, numInts, bytes, 0, false);
        return bytes;
    }

    final void toByteArray(int[] src, int intOffset, int numInts, byte[] dest, int byteOffset, boolean isPixelData) {
        if (isPixelData) {
            int i = 0;
            while (i < numInts) {
                dest[byteOffset + i * 4 + 0] = (byte)(src[intOffset + i] >> 16);
                dest[byteOffset + i * 4 + 1] = (byte)(src[intOffset + i] >> 8);
                dest[byteOffset + i * 4 + 2] = (byte)src[intOffset + i];
                dest[byteOffset + i * 4 + 3] = (byte)(src[intOffset + i] >> 24);
                ++i;
            }
        } else {
            int i = 0;
            while (i < numInts) {
                int q = 3;
                while (q > -1) {
                    dest[byteOffset + i * 4 + (3 - q)] = (byte)(src[intOffset + i] >> 8 * q);
                    --q;
                }
                ++i;
            }
        }
    }

    final byte[] toAsciiArray(String param) {
        if (param == null) {
            return new byte[0];
        }
        char[] unicodeStr = param.toCharArray();
        int strLen = param.length();
        byte[] asciiStr = new byte[strLen];
        int i = 0;
        while (i < strLen) {
            asciiStr[i] = (byte)unicodeStr[i];
            ++i;
        }
        return asciiStr;
    }
}

