/*
 * Decompiled with CFR 0.152.
 */
package com.threedgraphics.math;

import com.threedgraphics.math.CurveFitIF;
import tdg.Assert;
import tdg.AssertionException;

public class FitGeometric
implements CurveFitIF {
    private static int NUM_COEFFS = 2;

    public double compute(double x, double[] a) throws AssertionException {
        Assert.assert(a.length >= NUM_COEFFS + 1);
        double y = a[1] * Math.pow(x, a[2]);
        return y;
    }

    public void eval(double x, double[] a) throws AssertionException {
        Assert.assert(a.length >= NUM_COEFFS + 1);
        Assert.assert(x > 0.0);
        a[1] = 1.0;
        a[2] = Math.log(x);
    }

    public int numCoeffs() {
        return NUM_COEFFS;
    }

    public double transformY(double y) throws AssertionException {
        Assert.assert(y > 0.0);
        return Math.log(y);
    }

    public double invTransformCoeff(int ia, double a) {
        if (ia == 1) {
            return Math.exp(a);
        }
        return a;
    }

    public String createEquation(String[] strCoeffs, boolean bHighOrderFirst) throws AssertionException {
        Assert.assert(strCoeffs.length >= NUM_COEFFS + 1);
        String strTerm1 = strCoeffs[1];
        String strTerm2 = "x^" + strCoeffs[2];
        return "y = " + strTerm1 + " * " + strTerm2;
    }
}

