/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.groupv2;

import oracle.ias.cache.groupv2.MemberID;

class SequenceToken
implements Cloneable {
    static final long DEFAULT_TTL = 3000000L;
    private boolean available_ = true;
    private long sequence_ = 0L;
    private MemberID owner_;
    private long ttl_ = 3000000L;
    private long expiredTime_;

    SequenceToken() {
    }

    public Object clone() throws CloneNotSupportedException {
        return (SequenceToken)super.clone();
    }

    synchronized void setTtl(long l) {
        this.ttl_ = l;
    }

    synchronized void releaseIfExpired() {
        if (!this.available_ && this.isExpired()) {
            this.release();
        }
    }

    synchronized boolean isExpired() {
        if (this.available_) {
            return false;
        }
        return this.expiredTime_ < System.currentTimeMillis();
    }

    synchronized boolean acquiredBy(MemberID memberID) {
        if (!this.available_) {
            return false;
        }
        this.expiredTime_ = System.currentTimeMillis() + this.ttl_;
        this.available_ = false;
        this.owner_ = memberID;
        ++this.sequence_;
        return true;
    }

    synchronized long getSequence() {
        return this.sequence_;
    }

    synchronized void release() {
        this.available_ = true;
        this.owner_ = null;
        this.expiredTime_ = 0L;
    }

    synchronized MemberID getOwner() {
        return this.owner_;
    }

    synchronized void update(MemberID memberID, long l) {
        this.owner_ = memberID;
        this.sequence_ = l;
        this.available_ = false;
        this.expiredTime_ = System.currentTimeMillis() + this.ttl_;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Available=");
        stringBuffer.append(this.available_);
        stringBuffer.append(", seq=");
        stringBuffer.append(this.sequence_);
        stringBuffer.append(", owner=");
        stringBuffer.append(this.owner_);
        stringBuffer.append(", isExpired=");
        stringBuffer.append(this.isExpired());
        stringBuffer.append(", ttl=");
        stringBuffer.append(this.ttl_);
        return stringBuffer.toString();
    }
}

