/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.groupv2;

import java.util.Arrays;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.groupv2.ConnectionOwner;
import oracle.ias.cache.groupv2.GcommException;
import oracle.ias.cache.groupv2.MemberID;
import oracle.ias.cache.groupv2.Packet;
import oracle.ias.cache.groupv2.PacketHolder;

abstract class ReceiptHolder {
    static final String LOGGER_NAME = "oracle.ias.cache.groupv2.ReceiptHolder";
    protected ConnectionOwner parent_;
    protected long tag_;
    protected boolean[] bs_;
    protected Packet terminatorPacket_;
    protected int totalArrival_;
    protected int totalExpected_;
    protected long birthtime_;
    protected Vector replies_ = new Vector(1);
    protected boolean alreadyNotifiedWaiter_;
    private Logger logger_ = Logger.getLogger("oracle.ias.cache.groupv2.ReceiptHolder");

    abstract int addReceipt(Packet var1);

    abstract void removeMember(MemberID var1);

    abstract int removeDistributor(MemberID var1);

    abstract void logExpiredRecipients();

    abstract MemberID[] getPendingMembers();

    ReceiptHolder(ConnectionOwner connectionOwner, Packet packet) throws GroupException {
        this.parent_ = connectionOwner;
        this.tag_ = packet.getSequence();
        try {
            this.terminatorPacket_ = (Packet)packet.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new GcommException(cloneNotSupportedException);
        }
        this.terminatorPacket_.setDestination(this.terminatorPacket_.getOrigin());
        this.terminatorPacket_.setAsReply();
        this.terminatorPacket_.setAck(packet.getSequence());
        this.totalArrival_ = 0;
        this.birthtime_ = System.currentTimeMillis();
    }

    synchronized void notifyWaiters() {
        block4: {
            if (this.alreadyNotifiedWaiter_) {
                return;
            }
            PacketHolder packetHolder = PacketHolder.wrap(this.terminatorPacket_, null);
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "Processing replies directly sq=" + this.terminatorPacket_.getSequence());
            }
            try {
                this.parent_.getPacketProcessor().process(packetHolder);
                this.alreadyNotifiedWaiter_ = true;
            }
            catch (Exception exception) {
                if (!this.logger_.isLoggable(Level.SEVERE)) break block4;
                this.logger_.log(Level.SEVERE, "Unable to handle reply directly sq=" + this.terminatorPacket_.getSequence(), exception);
            }
        }
    }

    synchronized boolean isFilledUp() {
        return this.getTotalPending() == 0;
    }

    synchronized void clear() {
        Arrays.fill(this.bs_, false);
    }

    synchronized boolean isExpired(long l) {
        boolean bl = false;
        if (System.currentTimeMillis() - this.birthtime_ > l) {
            bl = true;
            this.logExpiredRecipients();
        }
        return bl;
    }

    synchronized Packet[] getReplies() {
        int n = this.replies_.size();
        if (n <= 0) {
            return null;
        }
        Packet[] packetArray = new Packet[n];
        this.replies_.toArray(packetArray);
        return packetArray;
    }

    int getTotalPending() {
        int n = 0;
        for (int i = 0; i < this.bs_.length; ++i) {
            if (!this.bs_[i]) continue;
            ++n;
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("sq=");
        stringBuffer.append(this.tag_);
        stringBuffer.append(", total arrived=");
        stringBuffer.append(this.totalArrival_);
        stringBuffer.append(", total expected=");
        stringBuffer.append(this.totalExpected_);
        stringBuffer.append(", birth time=");
        stringBuffer.append(this.birthtime_);
        stringBuffer.append(", expected=");
        stringBuffer.append(this.terminatorPacket_);
        stringBuffer.append(", totalPending=");
        stringBuffer.append(this.getTotalPending());
        if (this.replies_ != null) {
            stringBuffer.append(", total replies=");
            stringBuffer.append(this.replies_.size());
        }
        if (this.alreadyNotifiedWaiter_) {
            stringBuffer.append(", already notified waiter");
        }
        return stringBuffer.toString();
    }
}

