/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.groupv2;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.groupv2.ConnectionOwner;
import oracle.ias.cache.groupv2.EndPointConnection;
import oracle.ias.cache.groupv2.Packet;
import oracle.ias.cache.groupv2.PacketHolder;

abstract class PacketProcessor
extends Thread {
    static final String LOGGER_NAME = "oracle.ias.cache.groupv2.PacketProcessor";
    private static final long RECEIVE_Q_WAIT = 500L;
    private static final String THREAD_NAME = "Packet Processor";
    private boolean isShuttingDown_;
    private Logger logger_ = Logger.getLogger("oracle.ias.cache.groupv2.PacketProcessor");
    protected ConnectionOwner parent_;

    abstract void process(Packet var1, EndPointConnection var2) throws GroupException;

    PacketProcessor(ConnectionOwner connectionOwner) {
        this.setDaemon(true);
        this.isShuttingDown_ = false;
        this.parent_ = connectionOwner;
        this.setName(THREAD_NAME);
    }

    public void run() {
        if (this.logger_.isLoggable(Level.INFO)) {
            this.logger_.log(Level.FINE, this.getName() + " is started.");
        }
        while (!this.isShuttingDown_) {
            PacketHolder packetHolder = this.parent_.dequeue(1, 500L);
            if (packetHolder == null) continue;
            try {
                this.process(packetHolder);
            }
            catch (Exception exception) {
                if (!this.logger_.isLoggable(Level.SEVERE)) continue;
                this.logger_.log(Level.SEVERE, "Unable to process " + packetHolder.getPacket(), exception);
            }
        }
        if (this.logger_.isLoggable(Level.INFO)) {
            this.logger_.log(Level.INFO, this.getName() + " is terminated.");
        }
    }

    void shutdown() {
        if (this.logger_.isLoggable(Level.FINE)) {
            this.logger_.log(Level.FINE, "Shutting down " + this.getName());
        }
        this.isShuttingDown_ = true;
    }

    void process(PacketHolder packetHolder) throws GroupException {
        this.process(packetHolder.getPacket(), packetHolder.getOrigin());
    }
}

