/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.groupv2;

import java.text.NumberFormat;
import java.util.Arrays;

class PacketFlag
implements Cloneable {
    static final int P_REPLY = 1;
    static final int P_CLIENT_DISTRIBUTOR = 2;
    static final int P_COORDINATOR = 3;
    static final int P_ROUTER = 4;
    static final int P_ERRORSTATUS = 5;
    static final int P_REGISTER = 6;
    static final int P_BLOCKRECV = 7;
    static final int P_CARRYSET = 9;
    static final int P_TOTALORDER = 10;
    static final int P_JAVASERIALIZABLE = 11;
    static final int P_LOOPBACK = 12;
    private static final int BIT_PER_BYTE = 8;
    private static NumberFormat binaryFormat = NumberFormat.getInstance();
    static final int FLAGSIZE = 4;
    private byte[] buffer_;
    private int size_;

    PacketFlag(int n) {
        this.buffer_ = new byte[n];
    }

    PacketFlag(byte[] byArray) {
        this(byArray.length);
        System.arraycopy(byArray, 0, this.buffer_, 0, byArray.length);
    }

    boolean contains(int n) {
        int n2 = n / 8;
        int n3 = n % 8;
        byte by = (byte)(1 << n3 - 1);
        return (this.buffer_[n2] & by) == by;
    }

    void unset(int n) {
        int n2 = n / 8;
        int n3 = n % 8;
        byte by = (byte)(0x7F ^ 1 << n3 - 1);
        int n4 = n2;
        this.buffer_[n4] = (byte)(this.buffer_[n4] & by);
    }

    void set(int n) {
        int n2 = n / 8;
        int n3 = n % 8;
        int n4 = n2;
        this.buffer_[n4] = (byte)(this.buffer_[n4] | 1 << n3 - 1);
    }

    void setAsClient() {
        this.unset(3);
        this.unset(2);
    }

    void setAsCoordinator() {
        this.set(3);
    }

    boolean containsCoordinator() {
        return this.contains(3);
    }

    void setAsRouter() {
        this.set(4);
    }

    boolean containsRouter() {
        return this.contains(4);
    }

    void setAsDistributor() {
        this.set(2);
    }

    boolean containsDistributor() {
        return this.contains(2);
    }

    void setAsLoopback() {
        this.set(12);
    }

    boolean isLoopBack() {
        return this.contains(12);
    }

    void setAsReply() {
        this.set(1);
    }

    byte[] toBytes() {
        return this.buffer_;
    }

    void parseFrom(byte[] byArray) {
        this.buffer_ = byArray;
    }

    void clear() {
        Arrays.fill(this.buffer_, (byte)0);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.buffer_.length;
        for (int i = 0; i < n; ++i) {
            String string = Integer.toBinaryString(this.buffer_[n - i - 1]);
            for (int j = 0; j < 8 - string.length(); ++j) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object object) {
        if (object instanceof PacketFlag) {
            return Arrays.equals(this.buffer_, ((PacketFlag)object).toBytes());
        }
        return super.equals(object);
    }

    public Object clone() throws CloneNotSupportedException {
        return new PacketFlag(this.buffer_);
    }

    static {
        binaryFormat.setMaximumIntegerDigits(8);
        binaryFormat.setMinimumIntegerDigits(8);
        binaryFormat.setGroupingUsed(false);
    }
}

