/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.groupv2;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.groupv2.Address;
import oracle.ias.cache.groupv2.Distributor;
import oracle.ias.cache.groupv2.EndPointConnection;
import oracle.ias.cache.groupv2.GcommException;

class Listener
extends Thread {
    static final String LOGGER_NAME = "oracle.ias.cache.groupv2.Listener";
    private Logger logger_ = Logger.getLogger("oracle.ias.cache.groupv2.Listener");
    private ServerSocket listener_;
    boolean terminate_;
    private Distributor parent_;
    private int networkId_;

    Listener(Address address, int n, Distributor distributor) throws GroupException {
        this.setDaemon(true);
        this.parent_ = distributor;
        this.terminate_ = false;
        InetAddress inetAddress = null;
        this.networkId_ = address.getNetworkId();
        try {
            if (address.getHostName() != null) {
                inetAddress = InetAddress.getByName(address.getHostName());
            }
            if (!address.isUsingSSL()) {
                this.listener_ = inetAddress == null ? (this.parent_.getConfig().isSSLEnabled() ? this.parent_.getSSLManager().createSSLServerSocket(address.getPort(), n) : new ServerSocket(address.getPort(), n)) : (this.parent_.getConfig().isSSLEnabled() ? this.parent_.getSSLManager().createSSLServerSocket(address.getPort(), n, inetAddress) : new ServerSocket(address.getPort(), n, inetAddress));
            }
            this.listener_.setSoTimeout(0);
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "Create ServerSocket " + this.listener_);
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw new GcommException(unknownHostException);
        }
        catch (IOException iOException) {
            throw new GcommException(iOException);
        }
    }

    void shutdown() {
        this.terminate_ = true;
        try {
            this.listener_.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.setThreadName();
        if (this.logger_.isLoggable(Level.INFO)) {
            this.logger_.log(Level.INFO, "" + this.getName() + " is started");
        }
        while (!this.terminate_) {
            try {
                Socket socket = this.listener_.accept();
                EndPointConnection endPointConnection = new EndPointConnection(this.parent_.getEpThreadGroup(), socket, this.networkId_, this.parent_);
                endPointConnection.start();
            }
            catch (GroupException groupException) {
                if (!this.logger_.isLoggable(Level.WARNING)) continue;
                this.logger_.log(Level.WARNING, "Failure during accepting new connection", groupException);
            }
            catch (IOException iOException) {
                if (this.terminate_) break;
                if (!this.logger_.isLoggable(Level.WARNING)) continue;
                this.logger_.log(Level.WARNING, "Listener Accept error", iOException);
            }
        }
        if (this.logger_.isLoggable(Level.INFO)) {
            this.logger_.log(Level.INFO, this.getName() + " is terminated");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.listener_ != null) {
            stringBuffer.append(this.listener_.toString());
        }
        stringBuffer.append(", nId=");
        stringBuffer.append(this.networkId_);
        if (this.terminate_) {
            stringBuffer.append(", is terminated");
        }
        return stringBuffer.toString();
    }

    ServerSocket getServerSocket() {
        return this.listener_;
    }

    private void setThreadName() {
        this.setName(this.parent_.getPrefix() + " Listener at [" + this.listener_.getInetAddress().getHostAddress() + ":" + this.listener_.getLocalPort() + "]");
    }
}

