/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.groupv2;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import oracle.ias.cache.groupv2.Packet;

class HttpPacket {
    static final String CRLF_ = "\r\n";
    static final String SEPARATOR_ = ": ";
    static final int SEPARATOR_length_ = 2;
    static final String REQUEST_LN_ = "POST /cache HTTP/1.1";
    static final String VERSION_HEADER_ = "Version";
    static final String CONTENT_LEN_HEADER_ = "Content-Length";
    static final String PACKET_LEN_HEADER_ = "Packet-Length";
    static final String FILE_LEN_HEADER_ = "File-Length";
    private Packet p_;
    private File attachedFile_;
    private InputStream inStream_;
    private byte[] buffer_;
    private long size_ = 0L;
    private long fileSize_ = 0L;
    private long streamSize_ = 0L;

    HttpPacket(Packet packet) throws IOException {
        this.p_ = packet;
        String string = packet.getAttachedFilename();
        if (string != null) {
            this.attachedFile_ = new File(string);
            this.fileSize_ = this.attachedFile_.length();
        } else {
            this.attachedFile_ = null;
        }
        this.buffer_ = packet.toBytes();
        this.size_ = this.buffer_.length;
        this.inStream_ = packet.getInputStream();
        this.streamSize_ = packet.getInputStreamSize();
    }

    byte[] getPacketBuffer() {
        return this.buffer_;
    }

    Packet getSubPacket() {
        return this.p_;
    }

    boolean hasAttachedFile() {
        return this.attachedFile_ != null;
    }

    File getAttachedFile() {
        return this.attachedFile_;
    }

    boolean hasInputStream() {
        return this.inStream_ != null;
    }

    InputStream getInputStream() {
        return this.inStream_;
    }

    long getStreamSize() {
        return this.streamSize_;
    }

    String getHeaders() {
        StringBuffer stringBuffer = new StringBuffer(REQUEST_LN_);
        stringBuffer.append(CRLF_);
        stringBuffer.append(VERSION_HEADER_);
        stringBuffer.append(SEPARATOR_);
        stringBuffer.append(Packet.VERSION);
        stringBuffer.append(CRLF_);
        stringBuffer.append(CONTENT_LEN_HEADER_);
        stringBuffer.append(SEPARATOR_);
        if (this.fileSize_ != 0L) {
            stringBuffer.append(this.size_ + this.fileSize_);
        } else if (this.streamSize_ != 0L) {
            stringBuffer.append(this.size_ + this.streamSize_);
        } else {
            stringBuffer.append(this.size_);
        }
        stringBuffer.append(CRLF_);
        stringBuffer.append(PACKET_LEN_HEADER_);
        stringBuffer.append(SEPARATOR_);
        stringBuffer.append(this.size_);
        stringBuffer.append(CRLF_);
        stringBuffer.append(FILE_LEN_HEADER_);
        stringBuffer.append(SEPARATOR_);
        if (this.fileSize_ != 0L) {
            stringBuffer.append(this.fileSize_);
        } else if (this.streamSize_ != 0L) {
            stringBuffer.append(this.streamSize_);
        } else {
            stringBuffer.append(0);
        }
        stringBuffer.append(CRLF_);
        stringBuffer.append(CRLF_);
        return stringBuffer.toString();
    }
}

