/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.groupv2;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.groupv2.ConnectionOwner;
import oracle.ias.cache.groupv2.GcommException;
import oracle.ias.cache.groupv2.HttpPacket;
import oracle.ias.cache.groupv2.Packet;

class HttpHandler {
    static final String LOGGER_NAME = "oracle.ias.cache.groupv2.HttpHandler";
    static final int COPY_BUFFER_SIZE = 65536;
    static final int RCV_BUFFER_SIZE = 65536;
    private ConnectionOwner owner_;
    private byte[] recvBuffer_;
    private byte[] headerBuffer_;
    private int position_;
    private int headerPosition_;
    private int bytesRead_;
    private HashMap header_;
    private OutputStream outStream_;
    private InputStream inStream_;
    private Logger logger_ = Logger.getLogger("oracle.ias.cache.groupv2.HttpHandler");

    HttpHandler(ConnectionOwner connectionOwner, InputStream inputStream, OutputStream outputStream) throws IOException, GroupException {
        if (outputStream == null || inputStream == null) {
            throw new GcommException("Invalid stream");
        }
        this.owner_ = connectionOwner;
        this.outStream_ = outputStream;
        this.inStream_ = inputStream;
        this.position_ = 0;
        this.headerPosition_ = 0;
        this.recvBuffer_ = new byte[65536];
        this.headerBuffer_ = new byte[65536];
        this.bytesRead_ = 0;
        this.header_ = new HashMap();
    }

    void send(HttpPacket httpPacket) throws IOException, GroupException {
        InputStream inputStream = null;
        byte[] byArray = httpPacket.getHeaders().getBytes();
        this.outStream_.write(byArray, 0, byArray.length);
        byArray = httpPacket.getPacketBuffer();
        if (this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, "Send " + httpPacket.getSubPacket().toString(true));
        }
        this.outStream_.write(byArray, 0, byArray.length);
        if (httpPacket.hasAttachedFile() || httpPacket.hasInputStream()) {
            if (httpPacket.hasAttachedFile()) {
                FileInputStream fileInputStream = new FileInputStream(httpPacket.getAttachedFile());
                inputStream = fileInputStream;
            } else if (httpPacket.hasInputStream()) {
                inputStream = httpPacket.getInputStream();
            }
            byArray = new byte[65536];
            while (!this.owner_.isTerminating()) {
                if (inputStream == null) {
                    if (!this.logger_.isLoggable(Level.FINEST)) break;
                    this.logger_.log(Level.FINEST, "Internal error: InputStream is null");
                    break;
                }
                int n = inputStream.read(byArray);
                if (n == -1) break;
                this.outStream_.write(byArray, 0, n);
            }
            inputStream.close();
        }
        this.outStream_.flush();
    }

    Packet read() throws IOException, GroupException {
        byte[] byArray;
        Packet packet = null;
        this.header_.clear();
        this.headerPosition_ = 0;
        while (this.headerPosition_ < this.headerBuffer_.length && (this.headerPosition_ < 4 || this.headerBuffer_[this.headerPosition_ - 4] != 13 || this.headerBuffer_[this.headerPosition_ - 3] != 10 || this.headerBuffer_[this.headerPosition_ - 2] != 13 || this.headerBuffer_[this.headerPosition_ - 1] != 10)) {
            int n = this.inStream_.read();
            if (n == -1) {
                throw new GcommException(GcommException.EOF);
            }
            this.headerBuffer_[this.headerPosition_] = (byte)n;
            ++this.headerPosition_;
        }
        if (this.headerPosition_ == 65536) {
            throw new GcommException("Invalid stream");
        }
        this.parseHeaders();
        String string = (String)this.header_.get("Packet-Length");
        if (string != null) {
            int n = new Integer(string);
            byArray = new byte[n];
            this.bytesRead_ = 0;
            while (this.bytesRead_ != n) {
                int n2 = this.inStream_.read(byArray, this.bytesRead_, n - this.bytesRead_);
                if (n2 == -1) {
                    throw new GcommException("Invalid Stream");
                }
                this.bytesRead_ += n2;
            }
        } else {
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "Packet length header not found.");
            }
            throw new GcommException("Invalid Stream");
        }
        packet = Packet.parse(byArray);
        String string2 = (String)this.header_.get("File-Length");
        int n = 0;
        if (string2 != null) {
            n = new Integer(string2);
        }
        if (n != 0) {
            String string3 = this.owner_.getUniqueTempFilePath();
            FileOutputStream fileOutputStream = new FileOutputStream(string3);
            while (n > 0) {
                this.bytesRead_ = n >= this.recvBuffer_.length ? this.inStream_.read(this.recvBuffer_) : this.inStream_.read(this.recvBuffer_, 0, n);
                if (this.bytesRead_ == -1) {
                    throw new GcommException("Invalid Stream");
                }
                n -= this.bytesRead_;
                fileOutputStream.write(this.recvBuffer_, 0, this.bytesRead_);
            }
            fileOutputStream.close();
            if (n > 0) {
                throw new GcommException("Invalid Stream");
            }
            packet.setAttachedFilename(string3);
        }
        if (this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, "Receive " + packet.toString(true));
        }
        return packet;
    }

    private void parseHeaders() throws IOException, GroupException {
        int n = this.position_;
        byte[] byArray = new byte[this.headerPosition_];
        System.arraycopy(this.headerBuffer_, 0, byArray, 0, this.headerPosition_);
        String string = new String(byArray);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        String string2 = stringTokenizer.nextToken();
        if (!string2.equals("POST /cache HTTP/1.1")) {
            if (this.logger_.isLoggable(Level.SEVERE)) {
                this.logger_.log(Level.SEVERE, "Invalid HTTP request information: " + string2);
            }
            throw new GcommException("Invalid HTTP");
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, ": ");
            if (!stringTokenizer2.hasMoreTokens()) continue;
            String string4 = stringTokenizer2.nextToken();
            String string5 = string3.substring(string4.length() + 2);
            this.header_.put(string4, string5);
        }
    }
}

