/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.groupv2;

import java.io.File;
import java.io.IOException;
import java.rmi.server.UID;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.groupv2.Address;
import oracle.ias.cache.groupv2.ClientReceiptHolder;
import oracle.ias.cache.groupv2.Configuration;
import oracle.ias.cache.groupv2.EndPointConnection;
import oracle.ias.cache.groupv2.GcommException;
import oracle.ias.cache.groupv2.MemberID;
import oracle.ias.cache.groupv2.Packet;
import oracle.ias.cache.groupv2.PacketHolder;
import oracle.ias.cache.groupv2.PacketProcessor;
import oracle.ias.cache.groupv2.PacketSender;
import oracle.ias.cache.groupv2.ReceiptHolder;
import oracle.ias.cache.groupv2.SSLManager;
import oracle.ias.cache.groupv2.SequenceToken;
import oracle.ias.cache.groupv2.SingleReceiptHolder;
import oracle.ias.cache.groupv2.View;
import oracle.ias.cache.groupv2.ViewManager;

abstract class ConnectionOwner {
    static final String LOGGER_NAME = "oracle.ias.cache.groupv2.ConnectionOwner";
    static final int SEND_QUEUE = 0;
    static final int RECEIVE_QUEUE = 1;
    static final int DELIVERY_QUEUE = 2;
    static final int RESOLUTION_QUEUE = 3;
    static final int TOTALORDER_QUEUE = 4;
    static final int ONHOLD_QUEUE = 5;
    static final int TOTAL_QUEUE = 6;
    static final String[] QUEUE_TYPE_NAMES = new String[]{"Send Q", "Receive Q", "Delivery Q", "Resolution Q", "TotalOrder Q", "OnHold Q"};
    static final String ENDPOINT_THREADGROUP = "Connection EndPoints";
    private static final String JVM_ID_KEY = "oracle.ias.gcomm.vmid";
    private static final int WAIT_ACK_PAUSE = 100;
    private static final int WAIT_ACK_LOG_INTERVAL = 600;
    private Vector[] queues_;
    private boolean[] queueStatus_;
    private MemberID id_;
    private Logger logger_ = Logger.getLogger("oracle.ias.cache.groupv2.ConnectionOwner");
    private Configuration config_;
    private String prefix_ = "";
    private int idIndex_ = -1;
    private PacketSender[] senders_;
    private HashMap allReceipts_;
    private boolean terminating_;
    private ViewManager vmgr_;
    private Hashtable myPublicAddresses_;
    private ThreadGroup epThGroup_;
    private SSLManager sslMgr_;
    private SequenceToken seqToken_;
    PacketProcessor packetProcessor_;

    abstract void disposeConnection(EndPointConnection var1) throws GroupException, CloneNotSupportedException, IOException;

    abstract void addClient(MemberID var1, EndPointConnection var2) throws GroupException;

    abstract void enqueue(int var1, PacketHolder var2);

    abstract PacketHolder dequeue(int var1, long var2);

    static String getVMId() {
        return System.getProperty(JVM_ID_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionOwner(Configuration configuration, String string) throws GroupException {
        int n;
        this.config_ = configuration;
        this.prefix_ = string;
        if (this.config_.isSSLEnabled()) {
            this.sslMgr_ = SSLManager.getInstance(this);
        }
        this.queues_ = new Vector[6];
        this.queueStatus_ = new boolean[6];
        this.epThGroup_ = new ThreadGroup(ENDPOINT_THREADGROUP);
        this.epThGroup_.setDaemon(true);
        for (n = 0; n < this.queues_.length; ++n) {
            this.queues_[n] = new Vector(0);
            this.queueStatus_[n] = true;
        }
        this.senders_ = new PacketSender[configuration.getMaxSenderThreads()];
        for (n = 0; n < this.senders_.length; ++n) {
            this.senders_[n] = new PacketSender(this);
            PacketSender packetSender = this.senders_[n];
            synchronized (packetSender) {
                this.senders_[n].start();
                try {
                    this.senders_[n].wait(configuration.getInitTimeout());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        this.allReceipts_ = new HashMap();
        this.myPublicAddresses_ = new Hashtable(0);
        this.seqToken_ = new SequenceToken();
    }

    Vector getQueue(int n) {
        return this.queues_[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanQueue(int n) {
        Vector vector = this.queues_[n];
        synchronized (vector) {
            this.queues_[n].clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setEnableQueue(int n, boolean bl) {
        Vector vector = this.queues_[n];
        synchronized (vector) {
            this.queueStatus_[n] = bl;
        }
    }

    boolean getQueueStatus(int n) {
        return this.queueStatus_[n];
    }

    ThreadGroup getEpThreadGroup() {
        return this.epThGroup_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForEmptyQueue(int n, long l) {
        Vector vector;
        Vector vector2 = vector = this.getQueue(n);
        synchronized (vector2) {
            if (vector.size() != 0) {
                try {
                    vector.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notify(int n) {
        Vector vector;
        Vector vector2 = vector = this.getQueue(n);
        synchronized (vector2) {
            vector.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanup() {
        for (int i = 0; i < this.queues_.length; ++i) {
            Vector vector = this.queues_[i];
            synchronized (vector) {
                this.queues_[i].clear();
                this.queues_[i].notifyAll();
                this.queueStatus_[i] = true;
                continue;
            }
        }
        HashMap hashMap = this.allReceipts_;
        synchronized (hashMap) {
            this.allReceipts_.clear();
            this.allReceipts_.notifyAll();
        }
        for (int i = 0; i < this.senders_.length; ++i) {
            this.senders_[i].shutdown();
        }
    }

    public MemberID getID() {
        return this.id_;
    }

    void setID(MemberID memberID) {
        this.id_ = memberID;
    }

    void setIndex(int n) {
        this.idIndex_ = n;
        this.setPrefix(this.prefix_ + " " + this.idIndex_);
    }

    void setPrefix(String string) {
        this.prefix_ = string;
    }

    String getPrefix() {
        return this.prefix_;
    }

    Configuration getConfig() {
        return this.config_;
    }

    void createViewManager() {
        this.vmgr_ = new ViewManager(this, this.getMyPublicAddresses());
    }

    void createViewManager(View view) {
        this.vmgr_ = new ViewManager(this, view);
    }

    ViewManager getViewManager() {
        return this.vmgr_;
    }

    Address getMyAddressOn(int n) {
        Address address = (Address)this.myPublicAddresses_.get(new Integer(n));
        if (address == null) {
            Address[] addressArray = this.getMyPublicAddresses();
            for (int i = 0; i < addressArray.length; ++i) {
                if (addressArray[i].getNetworkId() == 0) continue;
                try {
                    address = (Address)addressArray[i].clone();
                    address.setNetworkId(n);
                    continue;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
            }
        }
        return address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Address[] getMyPublicAddresses() {
        Address[] addressArray;
        Hashtable hashtable = this.myPublicAddresses_;
        synchronized (hashtable) {
            Collection collection = this.myPublicAddresses_.values();
            int n = this.myPublicAddresses_.size();
            addressArray = new Address[n];
            collection.toArray(addressArray);
        }
        return addressArray;
    }

    void addPublicAddress(Address address) {
        this.myPublicAddresses_.put(new Integer(address.getNetworkId()), address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReceiptHolder addReciptHolder(View view, Packet packet, HashSet hashSet, HashSet hashSet2) throws GroupException {
        Long l = new Long(packet.getSequence());
        ReceiptHolder receiptHolder = null;
        HashMap hashMap = this.allReceipts_;
        synchronized (hashMap) {
            if (!this.allReceipts_.containsKey(l)) {
                MemberID[] memberIDArray = null;
                MemberID[] memberIDArray2 = null;
                if (hashSet != null) {
                    memberIDArray = new MemberID[hashSet.size()];
                    hashSet.toArray(memberIDArray);
                    if (this.logger_.isLoggable(Level.FINEST)) {
                        this.logger_.log(Level.FINEST, "Exclude " + memberIDArray.length + " members for sq=" + l);
                    }
                }
                if (hashSet2 != null) {
                    memberIDArray2 = new MemberID[hashSet2.size()];
                    hashSet2.toArray(memberIDArray2);
                    if (this.logger_.isLoggable(Level.FINEST)) {
                        this.logger_.log(Level.FINEST, "Exclude " + memberIDArray2.length + " distributors for sq=" + l);
                    }
                }
                receiptHolder = new ClientReceiptHolder(this, view, memberIDArray, memberIDArray2, packet);
                this.allReceipts_.put(l, receiptHolder);
                this.allReceipts_.notifyAll();
            } else {
                receiptHolder = (ReceiptHolder)this.allReceipts_.get(l);
            }
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "Create receipt holder for sq=" + l + ", size=" + receiptHolder.getTotalPending());
            }
        }
        return receiptHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReceiptHolder addReciptHolder(Packet packet) throws GroupException {
        Long l = new Long(packet.getSequence());
        ReceiptHolder receiptHolder = null;
        HashMap hashMap = this.allReceipts_;
        synchronized (hashMap) {
            if (!this.allReceipts_.containsKey(l)) {
                receiptHolder = new SingleReceiptHolder(this, packet);
                this.allReceipts_.put(l, receiptHolder);
                this.allReceipts_.notifyAll();
            } else {
                receiptHolder = (ReceiptHolder)this.allReceipts_.get(l);
            }
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "Create receipt holder for sq=" + l + ", size=" + receiptHolder.getTotalPending());
            }
        }
        return receiptHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRecipient(Packet packet) {
        if (!packet.isRegistered() || packet.isARequest() || packet.getDestination() == null || !this.id_.equals(MemberID.parse(packet.getDestination()))) {
            return;
        }
        Long l = new Long(packet.getAck());
        ReceiptHolder receiptHolder = null;
        int n = 0;
        HashMap hashMap = this.allReceipts_;
        synchronized (hashMap) {
            receiptHolder = (ReceiptHolder)this.allReceipts_.get(l);
            if (receiptHolder == null) {
                if (this.logger_.isLoggable(Level.WARNING)) {
                    this.logger_.log(Level.WARNING, "Found no receipt for ack=" + l + ". Ignore packet=" + packet.toString(true));
                }
                return;
            }
            n = receiptHolder.addReceipt(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRecipient(EndPointConnection endPointConnection) throws GroupException {
        HashMap hashMap = this.allReceipts_;
        synchronized (hashMap) {
            Set set = this.allReceipts_.keySet();
            if (set == null) {
                return;
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                MemberID memberID;
                Long l = (Long)iterator.next();
                ReceiptHolder receiptHolder = (ReceiptHolder)this.allReceipts_.get(l);
                if (receiptHolder == null || (memberID = endPointConnection.getRemoteMemberID()) == null) continue;
                if (endPointConnection.getType() == 2) {
                    receiptHolder.removeMember(memberID);
                    continue;
                }
                if (endPointConnection.getType() != 1) continue;
                if (this.logger_.isLoggable(Level.FINE)) {
                    this.logger_.log(Level.FINE, "Remove all receipts for distributor: " + memberID);
                }
                receiptHolder.removeDistributor(memberID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRecipient(MemberID memberID) throws GroupException {
        HashMap hashMap = this.allReceipts_;
        synchronized (hashMap) {
            Iterator iterator;
            Set set = this.allReceipts_.keySet();
            if (set == null) {
                return;
            }
            Iterator iterator2 = iterator = set.iterator();
            synchronized (iterator2) {
                while (iterator.hasNext()) {
                    Long l = (Long)iterator.next();
                    ReceiptHolder receiptHolder = (ReceiptHolder)this.allReceipts_.get(l);
                    if (receiptHolder == null) continue;
                    receiptHolder.removeMember(memberID);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasAll(long l) {
        boolean bl = false;
        Long l2 = new Long(l);
        ReceiptHolder receiptHolder = null;
        HashMap hashMap = this.allReceipts_;
        synchronized (hashMap) {
            receiptHolder = (ReceiptHolder)this.allReceipts_.get(l2);
            if (receiptHolder != null) {
                bl = receiptHolder.isFilledUp();
                if (bl) {
                    this.allReceipts_.remove(l2);
                }
            } else if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "Receipt has already removed ack=" + l);
            }
        }
        if (bl && this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, "Completed ack=" + l);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearReciptHolder(long l) {
        HashMap hashMap = this.allReceipts_;
        synchronized (hashMap) {
            this.allReceipts_.remove(new Long(l));
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "Clear all receipts for sq=" + l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearExpiredReceipts(long l) {
        HashMap hashMap = this.allReceipts_;
        synchronized (hashMap) {
            Set set = this.allReceipts_.keySet();
            if (set == null) {
                if (this.logger_.isLoggable(Level.FINEST)) {
                    this.logger_.log(Level.FINEST, "No receipt to check for expiration");
                }
                return;
            }
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "Check expired items from " + this.allReceipts_.size() + " receipt holders");
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Long l2 = (Long)iterator.next();
                ReceiptHolder receiptHolder = (ReceiptHolder)this.allReceipts_.get(l2);
                if (receiptHolder == null || !receiptHolder.isExpired(l)) continue;
                if (this.logger_.isLoggable(Level.SEVERE)) {
                    this.logger_.log(Level.SEVERE, "Clear " + receiptHolder.getTotalPending() + " expired receipts for sq=" + l2);
                }
                receiptHolder.clear();
                receiptHolder.notifyWaiters();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Packet[] waitForReply(long l, long l2) throws GroupException {
        Object object;
        Packet[] packetArray = null;
        ReceiptHolder receiptHolder = null;
        Long l3 = new Long(l);
        long l4 = System.currentTimeMillis();
        if (this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, "Wait for replies of sq=" + l3);
        }
        HashMap hashMap = this.allReceipts_;
        synchronized (hashMap) {
            receiptHolder = (ReceiptHolder)this.allReceipts_.get(l3);
            while (System.currentTimeMillis() - l4 < l2 && receiptHolder == null) {
                try {
                    this.allReceipts_.wait(100L);
                    receiptHolder = (ReceiptHolder)this.allReceipts_.get(l3);
                }
                catch (InterruptedException interruptedException) {
                    throw new GcommException(GcommException.LOCKINTERRUPT, (Throwable)interruptedException);
                }
            }
        }
        if (receiptHolder == null) {
            if (this.logger_.isLoggable(Level.WARNING)) {
                this.logger_.log(Level.WARNING, "Timeout " + l2 + " while waiting for replies of" + " sq=" + l3 + " ReceiptHolder=" + receiptHolder);
            }
            throw new GcommException(GcommException.REPLYTIMEOUT);
        }
        boolean bl = false;
        long l5 = 0L;
        while (!bl) {
            View view;
            object = receiptHolder;
            synchronized (object) {
                if (receiptHolder.isFilledUp()) {
                    break;
                }
                try {
                    receiptHolder.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++l5;
            if (System.currentTimeMillis() - l4 > l2) {
                bl = true;
                continue;
            }
            if (l5 % 600L != 0L) continue;
            if (this.logger_.isLoggable(Level.INFO)) {
                this.logger_.log(Level.INFO, "Still waiting for replies of sq=" + l3 + " ReceiptHolder=" + receiptHolder);
            }
            if (receiptHolder instanceof ClientReceiptHolder) {
                object = (ClientReceiptHolder)receiptHolder;
                view = this.getViewManager().getCurrentView();
                ((ClientReceiptHolder)object).removeNonExistMembersFrom(view);
                continue;
            }
            if (!(receiptHolder instanceof SingleReceiptHolder)) continue;
            object = (SingleReceiptHolder)receiptHolder;
            view = this.getViewManager().getCurrentView();
            if (view.contains(((SingleReceiptHolder)object).getRecipient())) continue;
            ((SingleReceiptHolder)object).removeMember(((SingleReceiptHolder)object).getRecipient());
            bl = true;
        }
        if (!receiptHolder.isFilledUp()) {
            if (this.logger_.isLoggable(Level.WARNING)) {
                this.logger_.log(Level.WARNING, "Timeout " + l2 + ". Did not get replies of sq=" + l3 + " ReceiptHolder=" + receiptHolder);
            }
            throw new GcommException(GcommException.REPLYTIMEOUT);
        }
        object = this.allReceipts_;
        synchronized (object) {
            this.allReceipts_.remove(l3);
        }
        packetArray = receiptHolder.getReplies();
        receiptHolder.clear();
        return packetArray;
    }

    void processPacket(Packet packet, EndPointConnection endPointConnection) throws GroupException {
        this.packetProcessor_.process(packet, endPointConnection);
    }

    synchronized void shutdown() throws GroupException {
        this.terminating_ = true;
        if (this.vmgr_ != null) {
            this.vmgr_.shutdown();
        }
    }

    boolean isTerminating() {
        return this.terminating_;
    }

    String getUniqueTempFilePath() {
        UID uID = new UID();
        String string = this.config_.getTempPath() + File.separator + uID.toString().replace(':', '_');
        return string;
    }

    abstract void sendTo(View var1, Packet var2, HashSet var3, HashSet var4) throws GroupException, IOException, CloneNotSupportedException;

    void replyToSender(EndPointConnection endPointConnection, Packet packet, byte[] byArray) throws GroupException, IOException {
        packet.setAsReply();
        packet.setDestination(packet.getOrigin());
        packet.setOrigin(this.getID());
        packet.setAck(packet.getSequence());
        packet.setData(null);
        endPointConnection.send(packet);
    }

    PacketProcessor getPacketProcessor() {
        return this.packetProcessor_;
    }

    SSLManager getSSLManager() {
        return this.sslMgr_;
    }

    void setSequenceToken(SequenceToken sequenceToken) throws CloneNotSupportedException {
        this.seqToken_ = (SequenceToken)sequenceToken.clone();
    }

    SequenceToken getSequenceToken() {
        return this.seqToken_;
    }

    void releaseToken() {
        this.releaseToken(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseToken(MemberID memberID) {
        SequenceToken sequenceToken;
        SequenceToken sequenceToken2 = sequenceToken = this.getSequenceToken();
        synchronized (sequenceToken2) {
            if (memberID != null && !sequenceToken.getOwner().equals(memberID)) {
                return;
            }
            sequenceToken.release();
            PacketHolder packetHolder = this.dequeue(4, 1L);
            if (packetHolder != null) {
                this.enqueue(1, packetHolder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.id_ != null) {
            stringBuffer.append(", ID=");
            stringBuffer.append(this.id_);
        }
        stringBuffer.append("Index=");
        stringBuffer.append(this.idIndex_);
        stringBuffer.append("\r\nSequenceToken=");
        stringBuffer.append(this.seqToken_);
        HashMap hashMap = this.allReceipts_;
        synchronized (hashMap) {
            if (this.allReceipts_ != null && this.allReceipts_.size() > 0) {
                stringBuffer.append("\r\nTotal pending recipients=");
                stringBuffer.append(this.allReceipts_.size());
                stringBuffer.append("\r\n");
            }
        }
        stringBuffer.append("\r\nView Manager:");
        stringBuffer.append(this.vmgr_);
        stringBuffer.append("\r\nTotal EndPoint connection threads:");
        stringBuffer.append(this.epThGroup_.activeCount());
        stringBuffer.append("\r\n");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Runtime runtime = Runtime.getRuntime();
        synchronized (runtime) {
            if (System.getProperty(JVM_ID_KEY) == null) {
                UID uID = new UID();
                System.setProperty(JVM_ID_KEY, uID.toString());
            }
        }
    }
}

