/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.groupv2;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.groupv2.Client;
import oracle.ias.cache.groupv2.ConnectionOwner;
import oracle.ias.cache.groupv2.EndPointConnection;
import oracle.ias.cache.groupv2.GcommException;
import oracle.ias.cache.groupv2.MemberID;
import oracle.ias.cache.groupv2.Packet;
import oracle.ias.cache.groupv2.PacketHolder;
import oracle.ias.cache.groupv2.PacketProcessor;
import oracle.ias.cache.groupv2.View;

class ClientPacketProcessor
extends PacketProcessor {
    static final String LOGGER_NAME = "oracle.ias.cache.groupv2.ClientPacketProcessor";
    private ConnectionOwner parent_;
    private Logger logger_;

    ClientPacketProcessor(ConnectionOwner connectionOwner) {
        super(connectionOwner);
        this.parent_ = connectionOwner;
        this.logger_ = Logger.getLogger(LOGGER_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void process(Packet packet, EndPointConnection endPointConnection) throws GroupException {
        if (this.logger_.isLoggable(Level.FINER)) {
            this.logger_.log(Level.FINER, "Process " + packet.toString(true));
        }
        try {
            switch (packet.getType()) {
                case 2: {
                    endPointConnection.close();
                    break;
                }
                case 5: 
                case 6: {
                    this.parent_.getViewManager().lock(0, 0);
                    try {
                        long l;
                        View view = this.parent_.getViewManager().getCurrentView();
                        if (packet.getViewId() > view.getViewID()) {
                            if (this.logger_.isLoggable(Level.FINEST)) {
                                this.logger_.log(Level.FINEST, "View too old: " + view.getViewID());
                            }
                            PacketHolder packetHolder = PacketHolder.wrap(packet, endPointConnection);
                            this.parent_.enqueue(1, packetHolder);
                            return;
                        }
                        if (packet.getFlag().contains(10) && (l = this.parent_.getSequenceToken().getSequence()) < packet.getTotalSequence()) {
                            if (this.logger_.isLoggable(Level.FINEST)) {
                                this.logger_.log(Level.FINEST, "My TotalSequence=" + l + ", packet TotalSequence=" + packet.getTotalSequence());
                            }
                            PacketHolder packetHolder = PacketHolder.wrap(packet, endPointConnection);
                            this.parent_.enqueue(1, packetHolder);
                            return;
                        }
                    }
                    finally {
                        this.parent_.getViewManager().unlock(0, 0);
                    }
                    if (packet.isARequest()) {
                        this.parent_.enqueue(2, PacketHolder.wrap(packet, endPointConnection));
                        break;
                    }
                    this.parent_.removeRecipient(packet);
                    break;
                }
                case 1: {
                    MemberID[] memberIDArray;
                    View view = this.parent_.getViewManager().getCurrentView();
                    View view2 = View.parse(packet.getData());
                    if (endPointConnection.getRemoteMemberID().equals(view2.getCoordinatorID())) {
                        endPointConnection.setType(0);
                    } else {
                        endPointConnection.setType(1);
                    }
                    this.parent_.getViewManager().addView(view2);
                    MemberID memberID = view2.getCoordinatorID();
                    MemberID memberID2 = endPointConnection.getRemoteMemberID();
                    if (this.parent_ instanceof Client) {
                        MemberID[] memberIDArray2 = memberIDArray = this.parent_.getQueue(5);
                        synchronized (memberIDArray) {
                            this.parent_.getViewManager().updateToLatest(true);
                            ((Client)this.parent_).enqueueViewChangeEvent(view, view2);
                            // ** MonitorExit[var8_14] (shouldn't be in output)
                        }
                    } else {
                        this.parent_.getViewManager().updateToLatest(true);
                    }
                    {
                        memberIDArray = view.getNonExistMembersOf(view2);
                        if (memberIDArray == null) break;
                        for (int i = 0; i < memberIDArray.length; ++i) {
                            this.parent_.removeRecipient(memberIDArray[i]);
                        }
                        break;
                    }
                }
                case 19: {
                    this.parent_.removeRecipient(packet);
                    break;
                }
                case 21: {
                    if (packet.getOrigin() != null && packet.getTotalSequence() == 0L) {
                        this.parent_.getSequenceToken().release();
                        break;
                    }
                    this.parent_.getSequenceToken().update(MemberID.parse(packet.getOrigin()), packet.getTotalSequence());
                    break;
                }
            }
            {
            }
        }
        catch (Exception exception) {
            throw new GcommException(exception);
        }
    }
}

