/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.net.ConnectException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.group.Address;
import oracle.ias.cache.group.ElectionNotification;
import oracle.ias.cache.group.GrpCommunication;
import oracle.ias.cache.group.Transport;

class Unicaster
extends Thread {
    static final String LOGGER_NAME = "oracle.ias.cache.group.Unicaster";
    static final String THREAD_NAME = "Unicast";
    static final int GET_COORDINATOR = 1;
    static final int SEND_VOTE = 2;
    private Address nlAddr_ = null;
    private Address coordinator_ = null;
    private Vector parent_ = null;
    private ElectionNotification vote_ = null;
    private int command_ = 0;
    private GrpCommunication gcomm_;
    private Transport trans_;
    private Logger logger_;

    Unicaster(GrpCommunication grpCommunication, Transport transport, Address address, Vector vector) {
        this.gcomm_ = grpCommunication;
        this.trans_ = transport;
        this.nlAddr_ = address;
        this.parent_ = vector;
        this.command_ = 1;
        this.setDaemon(true);
        this.setName("Unicast to " + this.nlAddr_.toString(true));
        this.logger_ = Logger.getLogger(LOGGER_NAME);
    }

    Unicaster(GrpCommunication grpCommunication, Transport transport, Address address, Vector vector, ElectionNotification electionNotification) {
        this.gcomm_ = grpCommunication;
        this.trans_ = transport;
        this.nlAddr_ = address;
        this.parent_ = vector;
        this.command_ = 2;
        this.vote_ = electionNotification;
        this.setDaemon(true);
        this.setName("Unicast to " + this.nlAddr_.toString(true));
        this.logger_ = Logger.getLogger(LOGGER_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                switch (this.command_) {
                    case 1: {
                        this.coordinator_ = this.trans_.getCoordinatorFromANodeListener(this.nlAddr_);
                        if (this.logger_.isLoggable(Level.INFO)) {
                            this.logger_.log(Level.INFO, "Found coordinator: " + this.coordinator_ + " from Node Listener at " + this.nlAddr_.toString(true));
                        }
                        break;
                    }
                    case 2: {
                        this.trans_.sendElectionVoteTo(this.nlAddr_, this.vote_);
                        break;
                    }
                }
            }
            catch (GroupException groupException) {
                block30: {
                    block29: {
                        Exception exception;
                        if (this.command_ != 1) break block29;
                        if (this.logger_.isLoggable(Level.INFO)) {
                            this.logger_.log(Level.INFO, "Node Listener at " + this.nlAddr_.toString(true) + " is not reachable.");
                            break block30;
                        } else if (this.logger_.isLoggable(Level.SEVERE) && (exception = groupException.getBaseException()) != null && !(exception instanceof ConnectException)) {
                            this.logger_.log(Level.SEVERE, "No response from Node Listener at " + this.nlAddr_.toString(true) + ". Possible port conflict with " + "non-Javacache processes.", exception);
                        }
                        break block30;
                    }
                    if (this.logger_.isLoggable(Level.FINEST)) {
                        this.logger_.log(Level.FINEST, "Node Listener at " + this.nlAddr_.toString(true) + " is not reachable.");
                    }
                }
                Object var4_2 = null;
                Vector vector3 = this.parent_;
                synchronized (vector3) {
                    switch (this.command_) {
                        case 1: {
                            this.parent_.addElement(this);
                            break;
                        }
                        case 2: {
                            this.parent_.removeElement(this.nlAddr_);
                            break;
                        }
                    }
                    this.parent_.notifyAll();
                    return;
                }
            }
            {
            }
            Object var4_1 = null;
            Vector vector = this.parent_;
            synchronized (vector) {
                switch (this.command_) {
                    case 1: {
                        this.parent_.addElement(this);
                        break;
                    }
                    case 2: {
                        this.parent_.removeElement(this.nlAddr_);
                        break;
                    }
                }
                this.parent_.notifyAll();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            Vector vector2 = this.parent_;
            synchronized (vector2) {
                switch (this.command_) {
                    case 1: {
                        this.parent_.addElement(this);
                        break;
                    }
                    case 2: {
                        this.parent_.removeElement(this.nlAddr_);
                        break;
                    }
                }
                this.parent_.notifyAll();
                throw throwable;
            }
        }
    }

    Address getCoordinator() {
        return this.coordinator_;
    }

    Address getNodeListener() {
        return this.nlAddr_;
    }
}

